/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomTableProfileImage {
    private Item parentItem;
    private int columnIndex;
    private boolean isHidden;
    private boolean isSelected;
    private Package.ProfileType profileType;
    private Image normalImage;
    private Image selectedImage;
    private Image hoverImage;
    private Image changeImage;
    private Enum<ImageState> state;
    private Point oldPoint;
    private ArrayList<IClickEventListener> clickListenerList;
    private ArrayList<IChangeStateEventListener> changeStateListenerList;
    private WizardUIResourceHandler uiRrcHandler = WizardUIResourceHandler.getInstance();

    public CustomTableProfileImage(Item treeItem, int columnIndex1, Package.ProfileType profileType, Enum<WizardUIResourceHandler.UIImage> normal, Enum<WizardUIResourceHandler.UIImage> selected, Enum<WizardUIResourceHandler.UIImage> hover, Enum<WizardUIResourceHandler.UIImage> change) {
        this.profileType = profileType;
        this.parentItem = treeItem;
        this.columnIndex = columnIndex1;
        if (normal != null) {
            this.normalImage = this.uiRrcHandler.getImage(normal);
        }
        if (selected != null) {
            this.selectedImage = this.uiRrcHandler.getImage(selected);
        }
        if (hover != null) {
            this.hoverImage = this.uiRrcHandler.getImage(hover);
        }
        if (change != null) {
            this.changeImage = this.uiRrcHandler.getImage(change);
        }
        this.state = ImageState.ICON_IMG_NORMAL;
        this.isHidden = false;
        this.clickListenerList = new ArrayList();
        this.changeStateListenerList = new ArrayList();
    }

    public void handleEvent(Enum<CustomMouseEvent> event) {
        if (this.parentItem == null || this.parentItem.isDisposed()) {
            return;
        }
        if (event == CustomMouseEvent.ICON_MOUSE_OVER) {
            if (this.state == ImageState.ICON_IMG_SELECTED) {
                return;
            }
            if (this.state == ImageState.ICON_IMG_HOVER) {
                return;
            }
            if (this.state == ImageState.ICON_IMG_CHANGE) {
                return;
            }
            this.state = ImageState.ICON_IMG_HOVER;
        } else if (event == CustomMouseEvent.ICON_MOUSE_DOWN) {
            this.state = ImageState.ICON_IMG_SELECTED;
        } else if (event == CustomMouseEvent.ICON_MOUSE_UP) {
            this.state = ImageState.ICON_IMG_SELECTED;
        } else if (event == CustomMouseEvent.ICON_MOUSE_EXIT) {
            if (this.state == ImageState.ICON_IMG_SELECTED) {
                return;
            }
            if (this.state == ImageState.ICON_IMG_CHANGE) {
                return;
            }
            this.state = ImageState.ICON_IMG_NORMAL;
        } else {
            this.state = ImageState.ICON_IMG_NORMAL;
        }
        this.show();
    }

    private void show() {
        if (this.parentItem instanceof TreeItem) {
            Rectangle bound = this.getBounds();
            ((TreeItem)this.parentItem).getParent().redraw(bound.x, bound.y, bound.width, bound.height, true);
        } else if (this.parentItem instanceof TableItem) {
            Rectangle bound = this.getBounds();
            ((TableItem)this.parentItem).getParent().redraw(bound.x, bound.y, bound.width, bound.height, true);
        }
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Image getImage() {
        if (this.isHidden) {
            return null;
        }
        if (this.state == ImageState.ICON_IMG_HOVER && this.hoverImage != null) {
            return this.hoverImage;
        }
        if (this.state == ImageState.ICON_IMG_NORMAL && this.normalImage != null) {
            return this.normalImage;
        }
        if (this.state == ImageState.ICON_IMG_SELECTED && this.selectedImage != null) {
            return this.selectedImage;
        }
        if (this.state == ImageState.ICON_IMG_CHANGE && this.changeImage != null) {
            return this.changeImage;
        }
        return this.normalImage;
    }

    private void hide() {
        if (this.parentItem instanceof TreeItem) {
            ((TreeItem)this.parentItem).setImage(this.columnIndex, null);
        } else if (this.parentItem instanceof TableItem) {
            ((TableItem)this.parentItem).setImage(this.columnIndex, null);
        }
    }

    public void setSelect(boolean select) {
        this.isSelected = select;
        this.state = this.isSelected ? ImageState.ICON_IMG_SELECTED : ImageState.ICON_IMG_NORMAL;
    }

    public void setHidden(boolean val) {
        if (this.isHidden != val) {
            this.isHidden = val;
            if (!val) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public Package.ProfileType getProfileType() {
        return this.profileType;
    }

    public void setIcons(Enum<WizardUIResourceHandler.UIImage> normal, Enum<WizardUIResourceHandler.UIImage> hover, Enum<WizardUIResourceHandler.UIImage> selected, Enum<WizardUIResourceHandler.UIImage> change) {
        if (normal != null) {
            this.normalImage = this.uiRrcHandler.getImage(normal);
        }
        if (hover != null) {
            this.hoverImage = this.uiRrcHandler.getImage(hover);
        }
        if (selected != null) {
            this.selectedImage = this.uiRrcHandler.getImage(selected);
        }
        if (change != null) {
            this.changeImage = this.uiRrcHandler.getImage(change);
        }
    }

    public Enum<ImageState> getState() {
        return this.state;
    }

    public void handleMouseMoveEvent(Point pt) {
        Rectangle bounds = this.getBounds();
        if (bounds != null && bounds.contains(pt)) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_OVER);
        } else if (bounds != null && this.oldPoint != null && bounds.contains(this.oldPoint) && !bounds.contains(pt)) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_EXIT);
        }
        this.oldPoint = pt;
    }

    public void handleMouseUpEvent(MouseEvent event) {
        if (this.parentItem != null) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_UP);
        }
    }

    public void handleMouseDownEvent(MouseEvent event) {
        if (this.parentItem != null) {
            this.handleEvent(CustomMouseEvent.ICON_MOUSE_DOWN);
        }
    }

    public void addMouseClickEventListener(IClickEventListener listener) {
        this.clickListenerList.add(listener);
    }

    public void removeAllMouseClickEventListeners() {
        this.clickListenerList = new ArrayList();
    }

    public void addChangeStateEventListener(IChangeStateEventListener listener) {
        this.changeStateListenerList.add(listener);
    }

    public void removeAllChangeStateEventListeners() {
        this.changeStateListenerList = new ArrayList();
    }

    public Component getComponentItem() {
        return (Component)this.parentItem.getData();
    }

    public Item getParentItem() {
        return this.parentItem;
    }

    public Rectangle getBounds() {
        if (this.parentItem != null && this.parentItem instanceof TableItem) {
            TableItem tabItem = (TableItem)this.parentItem;
            return tabItem.getBounds(this.columnIndex);
        }
        if (this.parentItem != null && this.parentItem instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)this.parentItem;
            Rectangle bound = treeItem.getBounds(this.columnIndex);
            if (this.normalImage == null) {
                return new Rectangle(bound.x, bound.y, 20, 20);
            }
            return bound;
        }
        return null;
    }

    public boolean isDisposed() {
        if (this.parentItem != null && this.parentItem instanceof TableItem) {
            TableItem tableItem = (TableItem)this.parentItem;
            return tableItem.isDisposed();
        }
        if (this.parentItem != null && this.parentItem instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)this.parentItem;
            return treeItem.isDisposed();
        }
        return true;
    }

    public static interface IChangeStateEventListener {
        public void onChangeState(CustomTableProfileImage var1, boolean var2);
    }

    public static interface IClickEventListener {
        public void onClick(CustomTableProfileImage var1);
    }

    public static enum CustomMouseEvent {
        ICON_MOUSE_OVER,
        ICON_MOUSE_DOWN,
        ICON_MOUSE_UP,
        ICON_MOUSE_EXIT;

    }

    private static enum ImageState {
        ICON_IMG_NORMAL,
        ICON_IMG_SELECTED,
        ICON_IMG_HOVER,
        ICON_IMG_CHANGE;

    }
}

