/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ProxyConfigFile;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.configuration.ConfigurationDialog;
import org.tizen.packagemanager.ui.page.custom.CustomCheckBoxButton;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class ProxyConfigView
extends Dialog {
    private Button btnConfirm;
    private Button btnCancel;
    private CustomCheckBoxButton directProxyRadioButton;
    private CustomCheckBoxButton automaticProxyRadioButton;
    private CustomCheckBoxButton manualProxyRadioButton;
    private Label httpProxyLabel;
    private StyledText httpAddressText;
    private Label httpPortLabel;
    private StyledText httpPortText;
    private Image checkedImage;
    private Image unCheckedImage;
    private ConfigurationDialog configDialog;
    private Display display;
    private WizardUIResourceHandler uiRsrcHandler;
    private ProxyConfigFile.ProxyType proxyType = ProxyConfigFile.ProxyType.AUTOMATIC;
    private String proxyHost = "";
    private String proxyPort = "";
    private int buttonBarHeight;
    private Shell parentShell;
    private static final Logger logger = Log.getLogger(ProxyConfigView.class);

    public ProxyConfigView(Shell parentShell, ConfigurationDialog parent) {
        super(parentShell);
        this.setShellStyle(67680);
        this.configDialog = parent;
        this.parentShell = parentShell;
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
    }

    @Override
    protected Point getInitialSize() {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_PROXY_DIALOG_SIZE);
        return new Point(rect.width, rect.height + this.buttonBarHeight);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.buttonBarHeight += parent.getShell().getBounds().height - (parent.getShell().getClientArea().height - parent.getShell().getBorderWidth());
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 0;
        formLayout.marginRight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginBottom = 0;
        container.setLayout(formLayout);
        this.setContentComposite(container);
        this.setBottomComposite(container);
        ProxyConfigFile configFile = Config.getInstance().getProxyConfig();
        if (configFile != null) {
            this.setProxySettings(configFile.getProxyType(), configFile.getProxyHost(), configFile.getProxyPort());
        }
        this.setWidgetStatus();
        return container;
    }

    @Override
    protected void configureShell(Shell newShell) {
        newShell.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        newShell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        newShell.setText("Proxy Settings");
        super.configureShell(newShell);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    @Override
    protected void okPressed() {
        super.okPressed();
    }

    @Override
    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void setContentComposite(Composite container) {
        Composite contentComposite = new Composite(container, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_PROXY_DIALOG_CONTENT_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, rect.x);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        contentComposite.setLayoutData(formData);
        Rectangle rectMargin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_AREA_MARGIN);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = rectMargin.y;
        gridLayout.marginBottom = rectMargin.height;
        gridLayout.marginLeft = rectMargin.x;
        gridLayout.marginRight = rectMargin.width;
        gridLayout.horizontalSpacing = 0;
        Rectangle rectGrid = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_AREA_GRID);
        gridLayout.verticalSpacing = rectGrid.height;
        contentComposite.setLayout(gridLayout);
        this.initProxySetting(contentComposite);
        contentComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
    }

    private void initProxySetting(Composite parent) {
        Composite component = new Composite(parent, 2048);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_AREA);
        gd.widthHint = rect.width - (PlatformUtil.isWindows() ? 10 : 0);
        component.setLayoutData(gd);
        component.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, true);
        Rectangle areaMarginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_GROUP_MARGIN);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = areaMarginRect.y;
        gridLayout.marginBottom = areaMarginRect.height;
        gridLayout.marginLeft = areaMarginRect.x;
        gridLayout.marginRight = areaMarginRect.width;
        component.setLayout(gridLayout);
        this.setRadioButton(component);
        this.createManualProxyInfomationComposites(component);
        this.initEvent();
    }

    private void initEvent() {
        this.directProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ProxyConfigView.this.httpAddressText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                ProxyConfigView.this.httpPortText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                ProxyConfigView.this.httpAddressText.setSelection(0);
                ProxyConfigView.this.httpPortText.setSelection(0);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.automaticProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ProxyConfigView.this.httpAddressText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                ProxyConfigView.this.httpPortText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                ProxyConfigView.this.httpAddressText.setSelection(0);
                ProxyConfigView.this.httpPortText.setSelection(0);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.manualProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ProxyConfigView.this.httpAddressText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
                ProxyConfigView.this.httpPortText.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.httpAddressText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ProxyConfigView.this.httpAddressText.setSelection(0);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
        this.httpPortText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ProxyConfigView.this.httpPortText.setSelection(0);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
    }

    private void setRadioButton(Composite parent) {
        Composite radioComponent = new Composite(parent, 0);
        radioComponent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_RADIO);
        GridData gd = new GridData(16384, 4, false, false);
        gd.widthHint = rect.width;
        radioComponent.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.verticalSpacing = rect.y;
        radioComponent.setLayout(gridLayout);
        this.checkedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_RADIO_SEL);
        this.unCheckedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_RADIO_NORMAL);
        this.createBtnDirectProxyRadioButton(radioComponent, rect);
        this.createBtnAutomaticProxyRadioButton(radioComponent, rect);
        this.createBtnManualProxyRadioButton(radioComponent, rect);
    }

    private void setProxySettings(String type, String proxyHost, int port) {
        this.proxyType = this.findProxyType(type);
        this.proxyHost = proxyHost;
        if (port < 0) {
            this.proxyPort = "";
        } else {
            try {
                this.proxyPort = Integer.toString(port);
            }
            catch (NumberFormatException e) {
                this.proxyPort = "";
            }
        }
    }

    private ProxyConfigFile.ProxyType findProxyType(String type) {
        ProxyConfigFile.ProxyType[] proxyType = ProxyConfigFile.ProxyType.values();
        for (int i = 0; i < proxyType.length; ++i) {
            if (!proxyType[i].toString().equals(type)) continue;
            return proxyType[i];
        }
        return ProxyConfigFile.ProxyType.AUTOMATIC;
    }

    private void setWidgetStatus() {
        this.setManualProxyConfiguration();
        this.setRadioButtonStatus();
    }

    private void setManualProxyConfiguration() {
        this.httpAddressText.setText(this.proxyHost);
        this.httpPortText.setText(this.proxyPort);
    }

    private void setRadioButtonStatus() {
        if (this.proxyType == ProxyConfigFile.ProxyType.DIRECT) {
            this.directProxyRadioButton.setSelection(true);
            this.automaticProxyRadioButton.setSelection(false);
            this.manualProxyRadioButton.setSelection(false);
            this.enabledManualConfiguration(false);
        } else if (this.proxyType == ProxyConfigFile.ProxyType.AUTOMATIC) {
            this.automaticProxyRadioButton.setEnabled(true);
            this.directProxyRadioButton.setSelection(false);
            this.automaticProxyRadioButton.setSelection(true);
            this.manualProxyRadioButton.setSelection(false);
            this.enabledManualConfiguration(false);
        } else if (this.proxyType == ProxyConfigFile.ProxyType.MANUAL) {
            this.directProxyRadioButton.setSelection(false);
            this.automaticProxyRadioButton.setSelection(false);
            this.manualProxyRadioButton.setSelection(true);
            this.enabledManualConfiguration(true);
        } else {
            this.directProxyRadioButton.setSelection(false);
            this.automaticProxyRadioButton.setSelection(true);
            this.manualProxyRadioButton.setSelection(false);
            this.enabledManualConfiguration(false);
        }
    }

    private void createBtnDirectProxyRadioButton(Composite parent, Rectangle rect) {
        this.directProxyRadioButton = new CustomCheckBoxButton(parent, 0x20000000, false, this.checkedImage, this.unCheckedImage, "No proxy", rect.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = rect.height;
        this.directProxyRadioButton.setLayoutData(gd);
        this.directProxyRadioButton.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.directProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                ProxyConfigView.this.proxyType = ProxyConfigFile.ProxyType.DIRECT;
                ProxyConfigView.this.enabledManualConfiguration(false);
                ProxyConfigView.this.btnConfirm.setEnabled(true);
                ProxyConfigView.this.directProxyRadioButton.setSelection(true);
                ProxyConfigView.this.automaticProxyRadioButton.setSelection(false);
                ProxyConfigView.this.manualProxyRadioButton.setSelection(false);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createBtnAutomaticProxyRadioButton(Composite parent, Rectangle rect) {
        this.automaticProxyRadioButton = new CustomCheckBoxButton(parent, 0x20000000, false, this.checkedImage, this.unCheckedImage, "System proxy settings", rect.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = rect.height;
        this.automaticProxyRadioButton.setLayoutData(gd);
        this.automaticProxyRadioButton.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.automaticProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                ProxyConfigView.this.proxyType = ProxyConfigFile.ProxyType.AUTOMATIC;
                ProxyConfigView.this.enabledManualConfiguration(false);
                logger.trace("\tAutomatic proxy setting => proxyHost : " + ProxyConfigView.this.proxyHost + "proxyPort : " + ProxyConfigView.this.proxyPort);
                ProxyConfigView.this.btnConfirm.setEnabled(true);
                ProxyConfigView.this.directProxyRadioButton.setSelection(false);
                ProxyConfigView.this.automaticProxyRadioButton.setSelection(true);
                ProxyConfigView.this.manualProxyRadioButton.setSelection(false);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createBtnManualProxyRadioButton(Composite parent, Rectangle rect) {
        this.manualProxyRadioButton = new CustomCheckBoxButton(parent, 0x20000000, false, this.checkedImage, this.unCheckedImage, "Manual proxy settings", rect.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = rect.height;
        this.manualProxyRadioButton.setLayoutData(gd);
        this.manualProxyRadioButton.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.manualProxyRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                ProxyConfigView.this.proxyType = ProxyConfigFile.ProxyType.MANUAL;
                ProxyConfigView.this.enabledManualConfiguration(true);
                if (ProxyConfigView.this.proxyHost.isEmpty() || ProxyConfigView.this.proxyPort.isEmpty()) {
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                } else {
                    logger.trace("\tManual proxy setting => proxyHost : " + ProxyConfigView.this.proxyHost + "proxyPort : " + ProxyConfigView.this.proxyPort);
                    ProxyConfigView.this.btnConfirm.setEnabled(true);
                }
                ProxyConfigView.this.directProxyRadioButton.setSelection(false);
                ProxyConfigView.this.automaticProxyRadioButton.setSelection(false);
                ProxyConfigView.this.manualProxyRadioButton.setSelection(true);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createManualProxyInfomationComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent = 5;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_MANUAL_INPUT);
        Rectangle rectWidth = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_MANUAL_INPUT_WIDTH);
        Rectangle rectInnerMargin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_NETWORK_MANUAL_INPUT_INNER_MARGIN);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = rect.x;
        gridLayout.horizontalSpacing = rect.width;
        gridLayout.verticalSpacing = 0;
        container.setLayout(gridLayout);
        this.httpProxyLabel = new Label(container, 0);
        gd = new GridData(16384, 0x1000000, false, false);
        this.httpProxyLabel.setLayoutData(gd);
        this.httpProxyLabel.setText("IP");
        this.httpProxyLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.httpProxyLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.httpProxyLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.httpAddressText = new StyledText(container, 2052);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rectWidth.x;
        gd.heightHint = rect.height - 5;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = false;
        this.httpAddressText.setLayoutData(gd);
        this.httpAddressText.setText("");
        this.httpAddressText.setMargins(rectInnerMargin.x, rectInnerMargin.y, 0, 0);
        this.httpAddressText.setAlignment(16384);
        this.httpAddressText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.httpAddressText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
        this.httpProxyLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.httpAddressText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg) {
                ProxyConfigView.this.proxyHost = ProxyConfigView.this.httpAddressText.getText();
                if (ProxyConfigView.this.proxyPort.isEmpty()) {
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                } else if (ProxyConfigView.this.proxyHost.isEmpty()) {
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                } else {
                    ProxyConfigView.this.btnConfirm.setEnabled(true);
                }
            }
        });
        Label dummy = new Label(container, 0);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = 0;
        dummy.setLayoutData(gd);
        this.httpPortLabel = new Label(container, 0);
        gd = new GridData(16384, 0x1000000, false, false);
        this.httpPortLabel.setLayoutData(gd);
        this.httpPortLabel.setText("Port");
        this.httpPortLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.httpPortLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.httpPortLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.httpPortText = new StyledText(container, 2052);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = rectWidth.width;
        gd.heightHint = rect.height - 5;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = false;
        this.httpPortText.setLayoutData(gd);
        this.httpPortText.setMargins(rectInnerMargin.x, rectInnerMargin.y, 0, 0);
        this.httpPortText.setText("");
        this.httpPortText.setAlignment(16384);
        this.httpPortText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.httpPortText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
        this.httpPortText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.httpPortText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg) {
                ProxyConfigView.this.proxyPort = ProxyConfigView.this.httpPortText.getText();
                try {
                    Integer.parseInt(ProxyConfigView.this.proxyPort);
                }
                catch (NumberFormatException e) {
                    ProxyConfigView.this.httpPortText.setText("");
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                    return;
                }
                if (ProxyConfigView.this.proxyHost.isEmpty()) {
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                } else if (ProxyConfigView.this.proxyPort.isEmpty() || ProxyConfigView.this.proxyPort.equals("")) {
                    ProxyConfigView.this.btnConfirm.setEnabled(false);
                } else {
                    ProxyConfigView.this.btnConfirm.setEnabled(true);
                }
            }
        });
    }

    private void setBottomComposite(Composite container) {
        Composite bottomComposite = new Composite(container, 0);
        final Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_PROXY_DIALOG_BOTTOM_AREA);
        FormData formData = new FormData();
        formData.left = new FormAttachment(container, 0);
        formData.top = new FormAttachment(container, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        bottomComposite.setLayoutData(formData);
        bottomComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        bottomComposite.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ProxyConfigView.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                e.gc.drawLine(0, 0, rect.width, 0);
            }
        });
        this.setBottomButton(bottomComposite);
    }

    private void setBottomButton(Composite container) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_PROXY_BUTTON_SIZE);
        Label dummy = new Label(container, 64);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.x;
        gd.verticalIndent = 3;
        FormData parentForm = (FormData)container.getLayoutData();
        gd.heightHint = parentForm.height;
        dummy.setLayoutData(gd);
        dummy.setText("");
        dummy.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        dummy.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        dummy.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnConfirm = new Button(container, 8);
        gd = new GridData(131072, 0x1000000, true, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnConfirm.setLayoutData(gd);
        this.btnConfirm.setText("Apply");
        this.btnConfirm.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnConfirm.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (ProxyConfigView.this.proxyType == ProxyConfigFile.ProxyType.MANUAL) {
                    int port = 0;
                    try {
                        port = Integer.parseInt(ProxyConfigView.this.proxyPort);
                    }
                    catch (NumberFormatException e) {
                        logger.throwing(e);
                        CustomMessageDialog.showDlg(ProxyConfigView.this.parentShell, "Proxy Settings", ErrorController.ErrorCode.INVALID_PORT_NUMBER.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
                        return;
                    }
                    if (!NetworkUtil.isAvailableURL(ProxyConfigView.this.proxyHost, port)) {
                        CustomMessageDialog.showDlg(ProxyConfigView.this.parentShell, "Proxy Settings", ErrorController.ErrorCode.UNAVAILABLE_INPUT_URL.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
                        return;
                    }
                } else {
                    ProxyConfigView.this.proxyHost = "";
                    ProxyConfigView.this.proxyPort = "";
                }
                Config.getInstance().saveProxySettings(ProxyConfigView.this.proxyType, ProxyConfigView.this.proxyHost, ProxyConfigView.this.proxyPort);
                try {
                    Config.getInstance().saveProxyConfig();
                }
                catch (UMException e) {
                    logger.throwing(e);
                }
                logger.trace("\tProxy environment setting => " + ProxyConfigView.this.proxyHost + ":" + ProxyConfigView.this.proxyPort);
                logger.trace("\tProxy environment setting is successful. InstallManager will be refreshed");
                ProxyConfigView.this.okPressed();
                ProxyConfigView.this.configDialog.refreshInstallOption();
                ProxyConfigView.this.configDialog.setRefreshNeeded(true);
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.btnCancel = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = rect.height;
        gd.widthHint = rect.width;
        this.btnCancel.setLayoutData(gd);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnCancel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.btnCancel.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                ProxyConfigView.this.cancelPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void enabledManualConfiguration(boolean status) {
        this.httpProxyLabel.setEnabled(status);
        this.httpAddressText.setEnabled(status);
        this.httpPortLabel.setEnabled(status);
        this.httpPortText.setEnabled(status);
        if (status) {
            this.httpAddressText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
            this.httpPortText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        } else {
            this.httpAddressText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
            this.httpPortText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
        }
    }
}

