/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.Install.InstallProcess;
import org.tizen.manager.core.Install.UninstallProcess;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.util.Log;
import org.tizen.packagemanager.ui.dialog.CustomComponentDisplayDialog;
import org.tizen.packagemanager.ui.page.CommonTabView;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ProgressTableView;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.monitor.InstallProgressMonitor;
import org.tizen.packagemanager.ui.page.monitor.TotalProgressMonitor;
import org.tizen.packagemanager.ui.page.monitor.UninstallProgressMonitor;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressTabView
extends CommonTabView {
    private static final Logger logger = Log.getLogger(ProgressTabView.class);
    private ProgressTableView componentTableView;
    private HashMap<Component, ICommonProgressMonitor> workingMonitors;
    private ArrayList<ICommonProgressMonitor> doneMonitors;
    private TotalProgressMonitor totalMonitor = TotalProgressMonitor.getInstance(this);
    private StyledText remainingTimeText;
    PackageManagerMainWindow mainPage;

    ProgressTabView(PackageManagerMainWindow mainPage, Composite parentComposite, int swtOption, ViewController pageMaster) {
        super(parentComposite, swtOption, mainPage);
        this.workingMonitors = new HashMap();
        this.doneMonitors = new ArrayList();
        this.mainPage = mainPage;
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout(gridLayout);
        this.createTopComposites();
        this.createMainComposites();
    }

    private void createTopComposites() {
        Composite viewContainer = new Composite(this, 0);
        GridData gridData = new GridData(4, 4, true, false);
        Rectangle topBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_TOP);
        gridData.heightHint = topBounds.height;
        viewContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        Rectangle topMarginBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MARGIN_TOP);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = topMarginBounds.width;
        gridLayout.marginRight = topMarginBounds.width;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        viewContainer.setLayout(gridLayout);
        viewContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Rectangle topTimeBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_TOP_TIME);
        Label remainTime = new Label(viewContainer, 0);
        remainTime.setText("Total remaining time : ");
        remainTime.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        remainTime.setBackground(this.uiRsrcHandler.getBackGroundColor());
        remainTime.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = topTimeBounds.y;
        gridData.heightHint = topTimeBounds.height;
        remainTime.setLayoutData(gridData);
        this.remainingTimeText = new StyledText(viewContainer, 0x20000000);
        this.remainingTimeText.setText("0:00:00");
        this.remainingTimeText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.remainingTimeText.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.remainingTimeText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.remainingTimeText.setEnabled(false);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = topTimeBounds.y;
        gridData.heightHint = topTimeBounds.height;
        this.remainingTimeText.setLayoutData(gridData);
    }

    private void createMainComposites() {
        Composite viewContainer = new Composite(this, 0);
        GridData gridData = new GridData(4, 4, true, false);
        Rectangle mainBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN);
        gridData.heightHint = mainBounds.height;
        viewContainer.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        Rectangle mainMarginBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MARGIN_MAIN);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = mainMarginBounds.y;
        gridLayout.marginLeft = mainMarginBounds.width;
        gridLayout.marginRight = mainMarginBounds.height;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        viewContainer.setLayout(gridLayout);
        viewContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.componentTableView = new ProgressTableView(viewContainer);
        GridData gd = new GridData(4, 4, true, true);
        this.componentTableView.setLayoutData(gd);
    }

    public void refresh() {
        if (InstallController.getInstance().existsWorkingProcesses()) {
            PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(false);
        } else {
            PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(true);
        }
    }

    @Override
    public void reload(boolean isInit) {
        this.refresh();
        if (isInit) {
            this.totalMonitor.refresh();
            this.componentTableView.refresh(true);
        } else {
            this.componentTableView.refresh(false);
        }
    }

    public void setRemainTimeText(String timeStr) {
        this.remainingTimeText.setText(timeStr);
    }

    public void addComponentToInstall(Component targetComponent) {
        ViewController.getInstance().getMainTabView().refresh(false);
        ViewController.getInstance().getExtendedTabView().refresh(false);
        if (this.totalMonitor.isDone()) {
            this.refreshBeforeWork();
        }
        ArrayList<Component> sortedDepComps = ComponentManager.getSortedComponentsByInstallOrder(targetComponent.getDependentComponents());
        ArrayList<TableItem> newTableItems = new ArrayList<TableItem>();
        for (Component depComp : sortedDepComps) {
            newTableItems.add(this.addNewTableItem(depComp));
        }
        newTableItems.add(this.addNewTableItem(targetComponent));
        ArrayList<ICommonProgressMonitor> monitorGroup = new ArrayList<ICommonProgressMonitor>();
        ArrayList<InstallProcess> installProcesses = new ArrayList<InstallProcess>();
        for (TableItem tableItem : newTableItems) {
            ProgressItem progressItem = (ProgressItem)tableItem.getData();
            Component component = progressItem.getComponent();
            ICommonProgressMonitor.ProgressMonitorType progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.NONE;
            if (component.getInstallState() == Component.InstallState.UPDATING) {
                progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.UPDATE;
            } else if (component.getInstallState() == Component.InstallState.INSTALLING) {
                progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.INSTALL;
            }
            InstallProgressMonitor monitor = new InstallProgressMonitor(progressItem, this, progressMonitorType);
            monitorGroup.add(monitor);
            component.setError(null);
            this.workingMonitors.put(component, monitor);
            progressItem.setMonitor(monitor);
            monitor.worked(0);
            InstallProcess process = InstallController.createInstallProcess(component, monitor);
            installProcesses.add(process);
        }
        this.totalMonitor.refreshTotalSize();
        for (ICommonProgressMonitor monitor : monitorGroup) {
            monitor.setMonitorGroup(monitorGroup);
        }
        this.totalMonitor.begin(System.currentTimeMillis());
        PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(false);
        for (InstallProcess process : installProcesses) {
            InstallController.getInstance().submitInstallProcess(process);
        }
    }

    private TableItem addNewTableItem(Component depComp) {
        return this.componentTableView.addNewTableItem(depComp);
    }

    public ProgressTableView getProgressTableView() {
        return this.componentTableView;
    }

    public void addComponentToUninstall(Component targetComponent) {
        ViewController.getInstance().getMainTabView().refresh(false);
        ViewController.getInstance().getExtendedTabView().refresh(false);
        if (this.totalMonitor.isDone()) {
            this.refreshBeforeWork();
        }
        ArrayList<Component> sortedDepComps = ComponentManager.getSortedComponentsByInstallOrder(targetComponent.getDependentComponents());
        Collections.reverse(sortedDepComps);
        ArrayList<TableItem> newTableItems = new ArrayList<TableItem>();
        for (Component depComp : sortedDepComps) {
            newTableItems.add(this.addNewTableItem(depComp));
        }
        newTableItems.add(this.addNewTableItem(targetComponent));
        ArrayList<ICommonProgressMonitor> monitorGroup = new ArrayList<ICommonProgressMonitor>();
        ArrayList<UninstallProcess> uninstallProcesses = new ArrayList<UninstallProcess>();
        for (TableItem tableItem : newTableItems) {
            ProgressItem progressItem = (ProgressItem)tableItem.getData();
            UninstallProgressMonitor monitor = new UninstallProgressMonitor(progressItem, this, false);
            monitorGroup.add(monitor);
            Component component = progressItem.getComponent();
            component.setError(null);
            this.workingMonitors.put(component, monitor);
            progressItem.setMonitor(monitor);
            monitor.worked(0);
            UninstallProcess process = InstallController.createUninstallProcess(component, monitor);
            uninstallProcesses.add(process);
        }
        this.totalMonitor.refreshTotalSize();
        for (ICommonProgressMonitor monitor : monitorGroup) {
            monitor.setMonitorGroup(monitorGroup);
        }
        this.totalMonitor.begin(System.currentTimeMillis());
        PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(false);
        for (UninstallProcess process : uninstallProcesses) {
            InstallController.getInstance().submitUninstallProcess(process);
        }
    }

    public void addGroupComponentsToUninstall(ArrayList<Component> targetComponents) {
        ViewController.getInstance().getMainTabView().refresh(false);
        ViewController.getInstance().getExtendedTabView().refresh(false);
        if (this.totalMonitor.isDone()) {
            this.refreshBeforeWork();
        }
        ArrayList<TableItem> newTableItems = new ArrayList<TableItem>();
        for (Component component : targetComponents) {
            newTableItems.add(this.addNewTableItem(component));
        }
        ArrayList<ICommonProgressMonitor> monitorGroup = new ArrayList<ICommonProgressMonitor>();
        ArrayList<UninstallProcess> uninstallProcesses = new ArrayList<UninstallProcess>();
        for (TableItem tableItem : newTableItems) {
            ProgressItem progressItem = (ProgressItem)tableItem.getData();
            UninstallProgressMonitor monitor = new UninstallProgressMonitor(progressItem, this, false);
            monitorGroup.add(monitor);
            Component component = progressItem.getComponent();
            component.setError(null);
            this.workingMonitors.put(component, monitor);
            progressItem.setMonitor(monitor);
            monitor.worked(0);
            UninstallProcess process = InstallController.createUninstallProcess(component, monitor);
            uninstallProcesses.add(process);
        }
        this.totalMonitor.refreshTotalSize();
        for (ICommonProgressMonitor monitor : monitorGroup) {
            monitor.setMonitorGroup(monitorGroup);
        }
        this.totalMonitor.begin(System.currentTimeMillis());
        PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(false);
        for (UninstallProcess process : uninstallProcesses) {
            InstallController.getInstance().submitUninstallProcess(process);
        }
    }

    public void addGroupComponentsToInstall(ArrayList<Component> targetComponents) {
        ViewController.getInstance().getMainTabView().refresh(false);
        ViewController.getInstance().getExtendedTabView().refresh(false);
        if (this.totalMonitor.isDone()) {
            this.refreshBeforeWork();
        }
        ArrayList<TableItem> newTableItems = new ArrayList<TableItem>();
        for (Component component : targetComponents) {
            newTableItems.add(this.addNewTableItem(component));
        }
        ArrayList<ICommonProgressMonitor> monitorGroup = new ArrayList<ICommonProgressMonitor>();
        ArrayList<InstallProcess> installProcesses = new ArrayList<InstallProcess>();
        for (TableItem tableItem : newTableItems) {
            ProgressItem progressItem = (ProgressItem)tableItem.getData();
            Component component = progressItem.getComponent();
            ICommonProgressMonitor.ProgressMonitorType progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.NONE;
            if (component.getInstallState() == Component.InstallState.UPDATING) {
                progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.UPDATE;
            } else if (component.getInstallState() == Component.InstallState.INSTALLING) {
                progressMonitorType = ICommonProgressMonitor.ProgressMonitorType.INSTALL;
            }
            InstallProgressMonitor monitor = new InstallProgressMonitor(progressItem, this, progressMonitorType);
            monitorGroup.add(monitor);
            component.setError(null);
            this.workingMonitors.put(component, monitor);
            progressItem.setMonitor(monitor);
            monitor.worked(0);
            InstallProcess process = InstallController.createInstallProcess(component, monitor);
            installProcesses.add(process);
        }
        this.totalMonitor.refreshTotalSize();
        for (ICommonProgressMonitor monitor : monitorGroup) {
            monitor.setMonitorGroup(monitorGroup);
        }
        this.totalMonitor.begin(System.currentTimeMillis());
        PackageManagerMainWindow.getPackageManagerWindow().topMenuButtonSetEnable(false);
        for (InstallProcess process : installProcesses) {
            InstallController.getInstance().submitInstallProcess(process);
        }
    }

    private void refreshBeforeWork() {
        this.totalMonitor.refresh();
        this.componentTableView.setAllProgressItemsInactive();
    }

    public void setCanceled(Component component) {
        ICommonProgressMonitor iCommonProgressMonitor = this.workingMonitors.get(component);
        if (iCommonProgressMonitor != null) {
            try {
                ArrayList<Object> compList = new ArrayList();
                if (component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING) {
                    compList = InstallController.getInstance().getCancelComponentListFromInstalling(component.getPackageName(), iCommonProgressMonitor);
                } else if (component.getInstallState() == Component.InstallState.UNINSTALLING) {
                    compList = InstallController.getInstance().getCancelComponentListFromUninstalling(component.getPackageName(), iCommonProgressMonitor);
                }
                if (compList != null && !compList.isEmpty()) {
                    iCommonProgressMonitor.setPause(true);
                    CustomComponentDisplayDialog ccdd = new CustomComponentDisplayDialog(this.getShell(), "The following dependent packages will be canceled due to dependencies.\nDo you want to continue?", compList);
                    int result = ccdd.open();
                    if (result == 0) {
                        iCommonProgressMonitor.setCanceled(true);
                    } else {
                        iCommonProgressMonitor.setPause(false);
                    }
                } else {
                    iCommonProgressMonitor.setCanceled(true);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public ArrayList<ICommonProgressMonitor> getWorkingMonitors() {
        ArrayList<ICommonProgressMonitor> currentMonitors = new ArrayList<ICommonProgressMonitor>();
        Collection<ICommonProgressMonitor> values = this.workingMonitors.values();
        for (ICommonProgressMonitor monitor : values) {
            currentMonitors.add(monitor);
        }
        return currentMonitors;
    }

    public ArrayList<ICommonProgressMonitor> getDoneMonitors() {
        return this.doneMonitors;
    }

    public TotalProgressMonitor getTotalMonitor() {
        return this.totalMonitor;
    }

    @Override
    public CommonTreeView getTreeView() {
        return null;
    }

    @Override
    public void refresh(boolean isInit) {
    }

    @Override
    public void runUpdateAll() {
    }
}

