/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.core.AlternativeManager;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.ManagerConstants;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.RepositoryUtil;
import org.tizen.manager.core.SnapshotLog;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.model.AlternativeInformation;
import org.tizen.manager.core.model.Distribution;
import org.tizen.manager.core.model.ImageInformation;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.core.model.SnapshotList;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ZipLibrary;
import org.tizen.packagemanager.ui.configuration.ConfigurationDialog;
import org.tizen.packagemanager.ui.configuration.ExtensionConfigView;
import org.tizen.packagemanager.ui.configuration.SnapshotChangeLogDialog;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomCheckBoxButton;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class InstallOptionConfigView
extends Composite {
    private final String SDK_IMAGE_ZIP_EXTENSION = ".zip";
    private final int IMAGE_FILE = 0;
    private final int PATCH_FILE = 1;
    private Display display;
    private WizardUIResourceHandler uiRsrcHandler;
    private CustomCheckBoxButton packageServerRadioButton;
    private CustomCheckBoxButton sdkImageRadioButton;
    private Composite stackContainerComposites;
    private StackLayout stackLayout;
    private ExtensionConfigView extConfigView;
    private Composite remoteServerComposites;
    private Combo comboPackageServer;
    private Button btnRefresh;
    private Label labelDistribution;
    private Combo comboDistribution;
    private CustomCheckBoxButton btnShowAll;
    private CustomCheckBoxButton btnAutoUpdate;
    private Table snapshotTable;
    private Composite localImageComposites;
    private StyledText imageFilePathText;
    private Button selectImageBtn;
    private Label labelError;
    private Label labelImageInfoDistText;
    private Label labelImageInfoRepoText;
    private Label labelImageInfoDistIdText;
    private Label labelImageInfoDistContent;
    private Label labelImageInfoRepoContent;
    private Label labelImageInfoDistIdContent;
    private Composite imageInfoComp;
    private Button btnConfirm;
    private static final Logger logger = Log.getLogger(InstallOptionConfigView.class);
    private RepositoryManager repositoryController = null;
    private Config.ServerType currentServerType;
    private List<String> distributionList;
    private String currentDistribution = null;
    private String currentRepository;
    private String currentDistirbutionId = "";
    private String installedRepository;
    private String installedDistribution;
    private String installedDistirbutionId = "";
    private Config.ConfDialog installedFromWhere;
    private List<AlternativeInformation> alterativeInfos;
    private List<String> repositoryHistoryList;
    private String snapshotPath = "";
    private String snapshotName = "";
    private SnapshotChangeLogDialog snapshotDialog = null;
    private ConfigurationDialog configDialog;
    private static final int TABLE_STATUS = 0;
    private static final int TABLE_NAME = 1;
    private static final int TABLE_DATE = 2;
    private static final String STATUS_LATEST = "Latest";
    private static final Color RGB_RED = new Color(null, new RGB(255, 0, 0));
    private Color oldColor = null;
    private File imageFile;
    private String localRepoPath;
    private ImageInformation imgInfo;
    private Composite parent;
    private Composite thisView;
    private boolean isNetworkOK = false;
    private final String SEP_STRING_01 = "- Alternative locations -";
    private final String SEP_STRING_02 = "- Previous locations -";
    private TableViewer snapshotTableViewer;
    private Composite contentComposite;
    boolean isServerRefreshedByComboServerType = false;
    private Composite extensionComposite;
    private ScrolledComposite scrolledComposite;

    InstallOptionConfigView(Composite parent, WizardUIResourceHandler uiRsrcHandler, ConfigurationDialog configDialog) {
        super(parent, 0);
        this.setLayout(new FillLayout(512));
        this.scrolledComposite = new ScrolledComposite(this, 512);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.contentComposite = new Composite(this.scrolledComposite, 0);
        this.parent = parent;
        this.uiRsrcHandler = uiRsrcHandler;
        this.display = parent.getDisplay();
        this.configDialog = configDialog;
        this.thisView = this;
        this.repositoryController = RepositoryManager.getInstance();
        this.initData(Config.getInstance(), Config.getInstance().getRepoHistory());
        this.contentComposite.setBackground(uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Rectangle rectMargin = uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_AREA_MARGIN);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = rectMargin.y;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = rectMargin.x;
        gridLayout.marginRight = rectMargin.width;
        gridLayout.verticalSpacing = 0;
        this.contentComposite.setLayout(gridLayout);
        this.setRedraw(false);
        this.createInstallOptionView(this.contentComposite);
        Image checkedImage = uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_SEL);
        Image unCheckedImage = uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_NORMAL);
        Rectangle rectExtArrow = uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ARROW_BUTTON);
        Composite extButtonComposite = new Composite(this.contentComposite, 0);
        extButtonComposite.setBackground(uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = rectExtArrow.width;
        extButtonComposite.setLayoutData(gd);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 15;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.verticalSpacing = 0;
        extButtonComposite.setLayout(gridLayout);
        CustomCheckBoxButton ext = new CustomCheckBoxButton(extButtonComposite, 0x20000000, false, checkedImage, unCheckedImage, "Extension SDK", 7, uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1), uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58), uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        ext.setSelectedColor(uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        ext.setBoldFont(uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        gd = new GridData(16384, 0x1000000, false, false);
        gd.heightHint = rectExtArrow.height;
        ext.setLayoutData(gd);
        ext.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                InstallOptionConfigView.this.thisView.setRedraw(false);
                if (InstallOptionConfigView.this.extensionComposite == null) {
                    InstallOptionConfigView.this.createExtensionConfigView(InstallOptionConfigView.this.contentComposite);
                    InstallOptionConfigView.this.scrolledComposite.setFocus();
                } else {
                    InstallOptionConfigView.this.extensionComposite.dispose();
                    InstallOptionConfigView.this.extConfigView.dispose();
                    InstallOptionConfigView.this.extConfigView = null;
                    InstallOptionConfigView.this.extensionComposite = null;
                }
                InstallOptionConfigView.this.scrolledComposite.setContent(InstallOptionConfigView.this.contentComposite);
                InstallOptionConfigView.this.contentComposite.setSize(InstallOptionConfigView.this.contentComposite.computeSize(-1, -1));
                InstallOptionConfigView.this.scrolledComposite.setMinSize(InstallOptionConfigView.this.contentComposite.computeSize(-1, -1));
                InstallOptionConfigView.this.thisView.setRedraw(true);
                if (InstallOptionConfigView.this.extensionComposite != null) {
                    InstallOptionConfigView.this.scrolledComposite.setOrigin(new Point(((InstallOptionConfigView)InstallOptionConfigView.this).scrolledComposite.getOrigin().x, ((InstallOptionConfigView)InstallOptionConfigView.this).scrolledComposite.getOrigin().y + InstallOptionConfigView.this.scrolledComposite.getVerticalBar().getMaximum()));
                }
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.scrolledComposite.setContent(this.contentComposite);
        this.contentComposite.setSize(this.contentComposite.computeSize(-1, -1));
        this.scrolledComposite.setMinSize(this.contentComposite.computeSize(-1, -1));
        this.setRedraw(true);
    }

    private void createInstallOptionView(Composite parent) {
        Composite component = new Composite(parent, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_AREA);
        gd.widthHint = rect.width;
        component.setLayoutData(gd);
        component.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        component.setLayout(gridLayout);
        Label mainSdk = new Label(component, 0x1004000);
        gd = new GridData(4, 0x1000000, false, true);
        Rectangle labelRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_MAINSDK_LABEL);
        gd.heightHint = labelRect.height;
        mainSdk.setLayoutData(gd);
        mainSdk.setText("Main SDK");
        mainSdk.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        mainSdk.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        mainSdk.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.createServerTypeSelectionComposites(component);
        this.createServerInformationComposites(component);
        this.btnConfirm = this.configDialog.getConfirmButton();
        this.handleComboPackageServer(this.uiRsrcHandler);
        this.handleBtnRefresh(this.uiRsrcHandler);
        this.handleComboDistribution(this.uiRsrcHandler);
        this.handleBtnAutoUpdate(this.uiRsrcHandler);
        this.handleBtnShowAll(this.uiRsrcHandler);
        this.handleSnapshotTable(this.uiRsrcHandler);
        this.postInit();
    }

    private void createExtensionConfigView(Composite parent) {
        this.extensionComposite = new Composite(parent, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_AREA);
        gd.widthHint = rect.width;
        this.extensionComposite.setLayoutData(gd);
        this.extensionComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = rect.y - 10;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.extensionComposite.setLayout(gridLayout);
        this.extConfigView = new ExtensionConfigView(this.configDialog, this, this.extensionComposite);
    }

    private void createServerTypeSelectionComposites(Composite parent) {
        Composite radioComponent = new Composite(parent, 0);
        radioComponent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_RADIO);
        GridData gd = new GridData(16384, 0x1000000, true, true);
        gd.widthHint = rect.width;
        radioComponent.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        gridLayout.horizontalSpacing = rect.y;
        gridLayout.marginWidth = 0;
        radioComponent.setLayout(gridLayout);
        Image checkedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_RADIO_SEL);
        Image unCheckedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_RADIO_NORMAL);
        Rectangle buttonRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_RADIO_BUTTON);
        this.packageServerRadioButton = new CustomCheckBoxButton(radioComponent, 0x20000000, false, checkedImage, unCheckedImage, "Package Repository", buttonRect.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = this.packageServerRadioButton.getObjectSize().x;
        gd.heightHint = this.packageServerRadioButton.getObjectSize().y;
        this.packageServerRadioButton.setLayoutData(gd);
        this.packageServerRadioButton.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.packageServerRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                InstallOptionConfigView.this.packageServerRadioButton.setSelection(true);
                InstallOptionConfigView.this.sdkImageRadioButton.setSelection(false);
                if (!InstallOptionConfigView.this.isServerRefreshedByComboServerType) {
                    String changeServerUrl = InstallOptionConfigView.this.comboPackageServer.getText();
                    for (AlternativeInformation alterInfo : InstallOptionConfigView.this.alterativeInfos) {
                        String diff = alterInfo.getName() + " - " + PathUtil.get(alterInfo.getRepository());
                        if (!diff.equals(changeServerUrl)) continue;
                        InstallOptionConfigView.this.onChangeServerBaseURL(true, alterInfo.getRepository(), alterInfo);
                    }
                    InstallOptionConfigView.this.isServerRefreshedByComboServerType = true;
                }
                InstallOptionConfigView.this.onSelectNetworkInstallationOption();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.sdkImageRadioButton = new CustomCheckBoxButton(radioComponent, 0x20000000, false, checkedImage, unCheckedImage, "SDK Image", buttonRect.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = this.sdkImageRadioButton.getObjectSize().x;
        gd.heightHint = this.sdkImageRadioButton.getObjectSize().y;
        this.sdkImageRadioButton.setLayoutData(gd);
        this.sdkImageRadioButton.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.sdkImageRadioButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                InstallOptionConfigView.this.sdkImageRadioButton.setSelection(true);
                InstallOptionConfigView.this.packageServerRadioButton.setSelection(false);
                InstallOptionConfigView.this.onSelectImageInstallationOption();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void onSelectNetworkInstallationOption() {
        this.stackLayout.topControl = this.remoteServerComposites;
        this.stackContainerComposites.layout();
        this.currentServerType = Config.ServerType.SNAPSHOT;
        this.btnConfirm.setEnabled(true);
        this.labelError.setVisible(true);
    }

    private void onSelectImageInstallationOption() {
        this.stackLayout.topControl = this.localImageComposites;
        this.stackContainerComposites.layout();
        this.currentServerType = Config.ServerType.LOCAL;
        Config config = Config.getInstance();
        if (config.getImageFileInfo() != null && config.getImageFileInfo().getImageFilePath() != null && !config.getImageFileInfo().getImageFilePath().isEmpty()) {
            this.imageFilePathText.setText(config.getImageFileInfo().getImageFilePath());
            this.imgInfo = config.getImageFileInfo().getImageInformation();
            this.setImageInfoLabel(this.imgInfo.getSDKImageOrigin(), this.imgInfo.getSDKImageDistribution(), this.imgInfo.getSDKImageDistributionID());
        }
        if (this.imageFilePathText.getText().isEmpty() || this.imageFile == null || config != null && config.getImageFileInfo() != null && config.getImageFileInfo().getImageFilePath().equals(this.imageFile.getAbsolutePath())) {
            this.btnConfirm.setEnabled(false);
        } else {
            this.btnConfirm.setEnabled(true);
        }
        this.labelError.setVisible(false);
    }

    private void createServerInformationComposites(Composite parent) {
        this.stackContainerComposites = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.stackContainerComposites.setLayoutData(gd);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stackContainerComposites.setLayout(this.stackLayout);
        this.createRemoteServerComposites(this.stackContainerComposites);
        this.createLocalImageComposites(this.stackContainerComposites);
    }

    private void createRemoteServerComposites(Composite parent) {
        this.remoteServerComposites = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.remoteServerComposites.setLayout(gridLayout);
        this.remoteServerComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.createChangeServerComposites(this.remoteServerComposites);
        this.labelError = new Label(this.remoteServerComposites, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_ERROR_LABEL);
        gd.heightHint = rect.height;
        this.labelError.setLayoutData(gd);
        this.labelError.setText("");
        this.labelError.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.labelError.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_READYPAGE_DIRECTORY_ERROR));
        this.labelError.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.createDistributionControlComposites(this.remoteServerComposites);
        this.createSnapshotInfoTableComposites(this.remoteServerComposites);
    }

    private void createChangeServerComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_LABEL);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = rect.y;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = rect.x;
        gridLayout.verticalSpacing = rect.height;
        gridLayout.horizontalSpacing = rect.width;
        container.setLayout(gridLayout);
        Label packageServer = new Label(container, 16384);
        gd = new GridData(4, 0x1000000, false, true);
        gd.horizontalSpan = 2;
        packageServer.setLayoutData(gd);
        packageServer.setText("Package Repository");
        packageServer.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        packageServer.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        packageServer.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.comboPackageServer = new Combo(container, 4);
        Rectangle rectCombo = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_COMBO);
        gd = new GridData(4, 0x1000000, true, true);
        gd.widthHint = rectCombo.width;
        gd.heightHint = rectCombo.height;
        this.comboPackageServer.setLayoutData(gd);
        this.comboPackageServer.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.comboPackageServer.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.comboPackageServer.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_LICENSE_TEXT));
        this.btnRefresh = new Button(container, 8);
        Rectangle rectApply = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_APPLY);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = rectApply.width;
        gd.heightHint = rectApply.height;
        this.btnRefresh.setLayoutData(gd);
        this.btnRefresh.setText("Apply");
        this.btnRefresh.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.btnRefresh.setEnabled(true);
    }

    private void createDistributionControlComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_GRID);
        GridData gd = new GridData(4, 4, true, false);
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        gd.heightHint = rect.height;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginBottom = rect.x;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = rect.width;
        container.setLayout(gridLayout);
        this.labelDistribution = new Label(container, 16384);
        gd = new GridData(16384, 0x1000000, false, true);
        this.labelDistribution.setLayoutData(gd);
        this.labelDistribution.setText("Distribution");
        this.labelDistribution.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.labelDistribution.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.labelDistribution.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.comboDistribution = new Combo(container, 12);
        gd = new GridData(16384, 0x1000000, false, true);
        Rectangle rectCombo = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_COMBO);
        gd.widthHint = rectCombo.width;
        this.comboDistribution.setLayoutData(gd);
        this.comboDistribution.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.comboDistribution.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_46));
        this.comboDistribution.setEnabled(true);
        Rectangle rectCheck = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_CHECKBOX);
        Image onImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_ON);
        Image offImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF);
        this.btnAutoUpdate = new CustomCheckBoxButton(container, 0x20000000, true, onImage, offImage, "Auto Update", rectCheck.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8), true);
        this.btnAutoUpdate.setDisableImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ACTIVE_OFF));
        this.btnAutoUpdate.setDisableColor(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
        this.btnAutoUpdate.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        gd = new GridData(131072, 0x1000000, true, true);
        gd.heightHint = rectCheck.height;
        gd.widthHint = this.btnAutoUpdate.getObjectSize().x;
        this.btnAutoUpdate.setLayoutData(gd);
    }

    private void createSnapshotInfoTableComposites(Composite parent) {
        Composite container = new Composite(parent, 2048);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT);
        Rectangle rectCheck = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT_CHECKBOX);
        GridData gd = new GridData(4, 4, true, false);
        gd.verticalIndent = 0;
        gd.heightHint = rect.height + rectCheck.height - 30;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = rectCheck.y;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        container.setLayout(gridLayout);
        Image checkedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_SEL);
        Image unCheckedImage = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_NORMAL);
        this.btnShowAll = new CustomCheckBoxButton(container, 0x20000000, false, checkedImage, unCheckedImage, "Show all snapshots", rectCheck.x, this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.btnShowAll.setDisableImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_SEL_DISABLE), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CHECK_NORMAL_DISABLE));
        this.btnShowAll.setDisableColor(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
        this.btnShowAll.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        gd = new GridData(131072, 0x1000000, true, true);
        gd.heightHint = rectCheck.height;
        gd.widthHint = this.btnShowAll.getObjectSize().x + 10;
        this.btnShowAll.setLayoutData(gd);
        Label lineLabel = new Label(container, 258);
        gd = new GridData(768);
        gd.heightHint = 1;
        lineLabel.setLayoutData(gd);
        lineLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_GRAY_D1));
        this.createSnapshotTableComposites(container);
    }

    private void createSnapshotTableComposites(Composite parent) {
        Composite snapshotTableRow = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT);
        gd.heightHint = rect.height - 10;
        snapshotTableRow.setLayoutData(gd);
        snapshotTableRow.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.snapshotTableViewer = new TableViewer(snapshotTableRow, 65544);
        this.snapshotTableViewer.setUseHashlookup(true);
        this.snapshotTable = this.snapshotTableViewer.getTable();
        Rectangle rectColumn = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_DIST_SNAPSHOT_COLUMN);
        int firstColumnWidth = rectColumn.x;
        int secondColumnWidth = rectColumn.y;
        int thirdColumnWidth = rectColumn.width;
        gd = new GridData(4, 4, true, true);
        this.snapshotTable.setLayoutData(gd);
        this.snapshotTable.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.snapshotTable.setHeaderVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        snapshotTableRow.setLayout(columnLayout);
        TableViewerColumn statusClmn = new TableViewerColumn(this.snapshotTableViewer, 16384);
        statusClmn.getColumn().setWidth(firstColumnWidth);
        statusClmn.getColumn().setText("Status");
        statusClmn.getColumn().setResizable(false);
        columnLayout.setColumnData(statusClmn.getColumn(), new ColumnPixelData(firstColumnWidth));
        TableViewerColumn labelClmn = new TableViewerColumn(this.snapshotTableViewer, 16384);
        labelClmn.getColumn().setWidth(firstColumnWidth);
        labelClmn.getColumn().setText("Name");
        labelClmn.getColumn().setResizable(false);
        columnLayout.setColumnData(labelClmn.getColumn(), new ColumnWeightData(secondColumnWidth));
        TableViewerColumn dateClmn = new TableViewerColumn(this.snapshotTableViewer, 16384);
        dateClmn.getColumn().setWidth(firstColumnWidth);
        dateClmn.getColumn().setText("Date");
        dateClmn.getColumn().setResizable(false);
        columnLayout.setColumnData(dateClmn.getColumn(), new ColumnPixelData(thirdColumnWidth));
    }

    private void createLocalImageComposites(Composite parent) {
        this.localImageComposites = new Composite(parent, 0);
        this.localImageComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        GridLayout gridLayout = new GridLayout(1, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = rect.y;
        this.localImageComposites.setLayout(gridLayout);
        this.createUseLocaImageComposites(this.localImageComposites);
        this.createImageInfoComposites(this.localImageComposites);
    }

    private void createUseLocaImageComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        container.setLayoutData(gd);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_LABEL);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = rect.y;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = rect.height;
        gridLayout.horizontalSpacing = rect.width;
        container.setLayout(gridLayout);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        Label sdkImage = new Label(container, 16384);
        gd = new GridData(4, 0x1000000, false, true);
        gd.horizontalSpan = 2;
        sdkImage.setLayoutData(gd);
        sdkImage.setText("SDK Image");
        sdkImage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        sdkImage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        sdkImage.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.imageFilePathText = new StyledText(container, 2052);
        Rectangle rectCombo = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INPUT);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = rectCombo.width;
        gd.heightHint = rectCombo.height - 5;
        this.imageFilePathText.setLayoutData(gd);
        this.imageFilePathText.setText("");
        rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INPUT_INNER_MARGIN);
        this.imageFilePathText.setMargins(rect.width, rect.y, 0, 0);
        this.imageFilePathText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.imageFilePathText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.imageFilePathText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_LICENSE_TEXT));
        this.selectImageBtn = new Button(container, 8);
        Rectangle rectSelect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_BROWSE);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = rectSelect.width;
        gd.heightHint = rectSelect.height;
        this.selectImageBtn.setLayoutData(gd);
        this.selectImageBtn.setText("Browse");
        this.selectImageBtn.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.selectImageBtn.setEnabled(true);
        this.selectImageBtn.addSelectionListener(new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void widgetSelected(SelectionEvent e) {
                boolean isExtUpdateRemote = true;
                InstallOptionConfigView.this.setClearImageInfoLabel();
                String strDir = InstallOptionConfigView.this.showSettingInstallpathDlg();
                if (strDir != null) {
                    logger.info("Success to open SDK image selection file dialog.");
                    logger.trace("\tSDK image File selection => " + strDir);
                    if (strDir.endsWith(".zip")) {
                        InstallOptionConfigView.this.imageFile = new File(strDir);
                        if (InstallOptionConfigView.this.validation(strDir, 0)) {
                            logger.trace("\tPackage list file found in SDK image => " + strDir);
                            InstallOptionConfigView.this.imageFilePathText.setText(strDir);
                            String unzipTargetDir = PathUtil.get(Config.getManagerConfigHome(), "image-cache", InstallOptionConfigView.this.imageFile.getName());
                            ZipLibrary zlpLibrary = null;
                            try {
                                zlpLibrary = new ZipLibrary(InstallOptionConfigView.this.imageFile.getAbsolutePath(), null);
                                ArrayList<String> fileNames = new ArrayList<String>();
                                fileNames.add("image.info");
                                fileNames.add(PackageManager.getPackageListFileName());
                                zlpLibrary.unzipSelectedList(unzipTargetDir, fileNames);
                            }
                            catch (Exception ex) {
                                logger.warn(e);
                                CustomMessageDialog.showDlg(InstallOptionConfigView.this.thisView.getShell(), "Error", ErrorController.ErrorCode.FAIL_TO_EXTRACT_SDK_IMAGE_FILE.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
                                InstallOptionConfigView.this.btnConfirm.setEnabled(true);
                            }
                            finally {
                                if (zlpLibrary != null) {
                                    zlpLibrary.close();
                                }
                            }
                            InstallOptionConfigView.this.localRepoPath = unzipTargetDir;
                            RepositoryManager.getInstance().setImageFileName(InstallOptionConfigView.this.imageFile.getAbsolutePath());
                            InstallOptionConfigView.this.imgInfo = new ImageInformation(InstallOptionConfigView.this.localRepoPath);
                            InstallOptionConfigView.this.imgInfo.loadImageInfo();
                            String repoURL = NetworkUtil.normalizeURL(InstallOptionConfigView.this.imgInfo.getValue("origin"));
                            String distName = InstallOptionConfigView.this.imgInfo.getValue("distribution");
                            String distributionID = InstallOptionConfigView.this.imgInfo.getValue("distribution_id");
                            InstallOptionConfigView.this.setImageInfoLabel(repoURL, distName, distributionID);
                            if (InstallOptionConfigView.this.currentDistirbutionId != null && InstallOptionConfigView.this.currentDistirbutionId.length() > 0 && InstallOptionConfigView.this.currentDistirbutionId.equals(distributionID)) {
                                isExtUpdateRemote = false;
                            }
                            InstallOptionConfigView.this.currentRepository = repoURL;
                            InstallOptionConfigView.this.currentDistribution = distName;
                            InstallOptionConfigView.this.currentDistirbutionId = distributionID;
                            Config.fromWhere = Config.ConfDialog.LOCAL_IMAGE;
                            Config.getInstance().getConfigFile().setRepository(InstallOptionConfigView.this.currentRepository);
                            Config.getInstance().getConfigFile().setDistribution(InstallOptionConfigView.this.currentDistribution);
                            InstallOptionConfigView.this.onChangeServerBaseURL(true, InstallOptionConfigView.this.installedRepository, null);
                            InstallOptionConfigView.this.reloadExtension(isExtUpdateRemote, true);
                            if (InstallOptionConfigView.this.extConfigView != null) {
                                InstallOptionConfigView.this.extConfigView.initializeData();
                            }
                            InstallOptionConfigView.this.btnConfirm.setEnabled(true);
                            return;
                        }
                        logger.error("Package list file not found is SDK image => " + strDir);
                        CustomMessageDialog.showDlg(InstallOptionConfigView.this.thisView.getShell(), "Error", ErrorController.ErrorCode.INVALID_IMAGE_FILE.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
                        return;
                    }
                    CustomMessageDialog.showDlg(InstallOptionConfigView.this.thisView.getShell(), "Error", ErrorController.ErrorCode.INVALID_IMAGE_FILE_EXTENSION.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
                    return;
                }
                logger.error("Fail to open SDK image selection file dialog.");
            }
        });
    }

    private void createImageInfoComposites(Composite parent) {
        this.imageInfoComp = new Composite(parent, 2048);
        Rectangle infoBox = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INFO);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = infoBox.height;
        this.imageInfoComp.setLayoutData(gd);
        this.imageInfoComp.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Rectangle infoBoxMargin = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_PKGSERVER_SDKIMAGE_INFO_MARGIN);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = infoBoxMargin.x;
        gridLayout.marginTop = infoBoxMargin.y;
        gridLayout.marginBottom = infoBoxMargin.height;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.imageInfoComp.setLayout(gridLayout);
        this.labelImageInfoRepoText = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.x;
        this.labelImageInfoRepoText.setLayoutData(gd);
        this.labelImageInfoRepoText.setText("Repository");
        this.labelImageInfoRepoText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoRepoText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.labelImageInfoRepoText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.labelImageInfoRepoContent = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.width;
        this.labelImageInfoRepoContent.setLayoutData(gd);
        this.labelImageInfoRepoContent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoRepoContent.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.labelImageInfoRepoContent.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.labelImageInfoDistText = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.x;
        this.labelImageInfoDistText.setLayoutData(gd);
        this.labelImageInfoDistText.setText("Distribution");
        this.labelImageInfoDistText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoDistText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.labelImageInfoDistText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.labelImageInfoDistContent = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.width;
        this.labelImageInfoDistContent.setLayoutData(gd);
        this.labelImageInfoDistContent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoDistContent.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.labelImageInfoDistContent.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.labelImageInfoDistIdText = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.x;
        this.labelImageInfoDistIdText.setLayoutData(gd);
        this.labelImageInfoDistIdText.setText("Distribution ID");
        this.labelImageInfoDistIdText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoDistIdText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.labelImageInfoDistIdText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.labelImageInfoDistIdContent = new Label(this.imageInfoComp, 0);
        gd = new GridData(16384, 0x1000000, false, true);
        gd.widthHint = infoBox.width;
        this.labelImageInfoDistIdContent.setLayoutData(gd);
        this.labelImageInfoDistIdContent.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.labelImageInfoDistIdContent.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.labelImageInfoDistIdContent.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.imageInfoComp.setVisible(true);
    }

    private void setClearImageInfoLabel() {
        this.labelImageInfoRepoContent.setText("");
        this.labelImageInfoDistContent.setText("");
        this.labelImageInfoDistIdContent.setText("");
        this.imageInfoComp.setVisible(true);
    }

    private void setImageInfoLabel(String repoURL, String distName, String distributonID) {
        if (repoURL != null && !repoURL.isEmpty()) {
            this.labelImageInfoRepoText.setText("Repository");
            this.labelImageInfoRepoContent.setText(repoURL);
        }
        if (distName != null && !distName.isEmpty()) {
            this.labelImageInfoDistText.setText("Distribution");
            this.labelImageInfoDistContent.setText(distName);
        }
        if (distributonID != null && !distributonID.isEmpty()) {
            this.labelImageInfoDistIdText.setText("Distribution ID");
            this.labelImageInfoDistIdContent.setText(distributonID);
        }
        this.imageInfoComp.setVisible(true);
    }

    private void postInit() {
        if (Config.getInstance().getServerType() == Config.ServerType.SNAPSHOT) {
            this.packageServerRadioButton.setSelection(true);
            this.sdkImageRadioButton.setSelection(false);
            this.onSelectNetworkInstallationOption();
        } else {
            this.packageServerRadioButton.setSelection(false);
            this.sdkImageRadioButton.setSelection(true);
            this.onSelectImageInstallationOption();
        }
        this.initComboBoxData();
        if (Config.getInstance().isAutoUpdate()) {
            this.btnAutoUpdate.setSelection(true);
            this.btnShowAll.setEnabled(false);
            this.snapshotTable.setEnabled(false);
        } else {
            this.btnAutoUpdate.setSelection(false);
            this.btnShowAll.setEnabled(true);
            this.snapshotTable.setEnabled(true);
        }
        if (this.distributionList != null && this.distributionList.size() > 0) {
            this.addItemToCombo(this.comboDistribution, this.distributionList);
            this.isNetworkOK = true;
        } else if (this.distributionList == null && this.currentDistribution != null && !this.currentDistribution.isEmpty()) {
            this.labelError.setText(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY.getErrorMessage());
            this.isNetworkOK = false;
            this.btnAutoUpdate.setEnabled(false);
            this.btnShowAll.setEnabled(false);
        }
        if (this.currentDistribution != null && !this.currentDistribution.isEmpty()) {
            this.comboDistribution.setText(this.currentDistribution);
        }
        if (this.currentDistribution != null && !this.currentDistribution.isEmpty()) {
            this.showSnapshotTable(this.currentDistribution);
        }
    }

    private void initComboBoxData() {
        if (this.alterativeInfos != null && !this.alterativeInfos.isEmpty()) {
            this.comboPackageServer.add("- Alternative locations -");
            for (AlternativeInformation alterInfo : this.alterativeInfos) {
                this.comboPackageServer.add(alterInfo.getName() + " - " + PathUtil.get(alterInfo.getRepository()));
            }
        }
        if (this.repositoryHistoryList != null && !this.repositoryHistoryList.isEmpty()) {
            this.comboPackageServer.add("- Previous locations -");
            for (String url : this.repositoryHistoryList) {
                this.comboPackageServer.add(url);
            }
        }
        if (this.currentRepository != null && !this.currentRepository.isEmpty()) {
            this.comboPackageServer.setText(this.currentRepository);
        } else {
            this.comboPackageServer.setText("http://");
        }
    }

    private void initData(Config config, ArrayList<String> repoHistory) {
        this.alterativeInfos = AlternativeManager.getInstance().getAlternatives();
        this.repositoryHistoryList = repoHistory == null ? new ArrayList<String>() : repoHistory;
        if (config != null) {
            this.initNetwork(config);
            this.currentServerType = config.getServerType() != null ? config.getServerType() : Config.ServerType.SNAPSHOT;
        }
    }

    private void initNetwork(Config config) {
        ConfigFile configFile = config.getConfigFile();
        if (configFile != null) {
            this.installedRepository = this.currentRepository = configFile.getRepository();
            this.currentDistribution = configFile.getDistribution();
            this.currentDistirbutionId = configFile.getDistributionId();
            this.installedDistribution = this.currentDistribution;
            this.installedDistirbutionId = this.currentDistirbutionId;
            this.installedFromWhere = Config.fromWhere;
            List<String> listDistribution = this.repositoryController.getDistributionList();
            if (listDistribution != null && !listDistribution.isEmpty()) {
                this.distributionList = listDistribution;
            }
            this.snapshotPath = configFile.getSnapshotPath();
        }
    }

    private void handleSnapshotTable(WizardUIResourceHandler uiRsrcHandler) {
        this.snapshotTable.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                InstallOptionConfigView.this.snapshotTable.setEnabled(!InstallOptionConfigView.this.btnAutoUpdate.getSelection());
                InstallOptionConfigView.this.btnShowAll.setEnabled(true);
                InstallOptionConfigView.this.comboDistribution.setEnabled(true);
                InstallOptionConfigView.this.setSnapshotPathByName(InstallOptionConfigView.this.snapshotTable.getSelection()[0].getText(1));
                Config.fromWhere = Config.ConfDialog.SNAPSHOT;
            }
        });
        this.snapshotTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                Point point = new Point(e.x, e.y);
                String repo = Config.getInstance().getConfigFile().getRepository();
                String dist = InstallOptionConfigView.this.comboDistribution.getItem(InstallOptionConfigView.this.comboDistribution.getSelectionIndex());
                SnapshotLog snapshotLog = new SnapshotLog(NetworkUtil.getURL(repo, dist));
                TableItem item = InstallOptionConfigView.this.snapshotTable.getItem(point);
                if (item == null) {
                    return;
                }
                String snapshot = item.getText(1);
                String log = null;
                if (snapshot != null) {
                    try {
                        log = snapshotLog.getSnapshotLog(item.getText(1));
                    }
                    catch (UMException e1) {
                        logger.throwing(e1);
                    }
                }
                if (log == null) {
                    CustomMessageDialog.showDlg(InstallOptionConfigView.this.getShell(), "Info", "There is no change log in snapshot.", CustomMessageDialog.DialogType.INFO, true);
                } else {
                    InstallOptionConfigView.this.snapshotDialog = new SnapshotChangeLogDialog(InstallOptionConfigView.this.getShell(), log, item.getText(1));
                    int ret = InstallOptionConfigView.this.snapshotDialog.open();
                    if (ret == 0) {
                        logger.trace("\tSuccess to open snapshot log dialog");
                    } else {
                        logger.error("Fail to open snapshot log dialog");
                    }
                }
            }
        });
        this.snapshotTable.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                InstallOptionConfigView.this.snapshotTable.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                InstallOptionConfigView.this.thisView.setFocus();
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                InstallOptionConfigView.this.snapshotTable.setFocus();
            }
        });
    }

    private void showSnapshotTable(String distName) {
        block6: {
            this.snapshotTable.removeAll();
            this.snapshotTable.setHeaderVisible(true);
            Snapshot latestSnapshot = this.repositoryController.getLatestSnapshot(distName);
            if (latestSnapshot == null) break block6;
            this.addLatestItemToSnapshotTable(latestSnapshot);
            if (this.btnShowAll.getSelection()) {
                SnapshotList allSnapshots = this.repositoryController.getSnapshotList(distName);
                if (allSnapshots == null) {
                    logger.trace("\tSelected distribution(" + distName + ") does not exist in repository");
                    return;
                }
                for (Snapshot snapshot : allSnapshots) {
                    if (latestSnapshot.equals(snapshot)) continue;
                    this.addItemToSnapshotTable(snapshot);
                }
            } else {
                SnapshotList snapshots = this.repositoryController.getManualSnapshotList(distName);
                if (snapshots == null) {
                    logger.trace("\tSelected distribution(" + distName + ") does not exist in repository");
                    return;
                }
                for (Snapshot snapshot : snapshots) {
                    if (latestSnapshot.equals(snapshot)) continue;
                    this.addItemToSnapshotTable(snapshot);
                }
            }
        }
    }

    private void addItemToSnapshotTable(Snapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        this.addItemToSnapshotTable(snapshot.getName(), snapshot.getTime());
    }

    private void addLatestItemToSnapshotTable(Snapshot snapshot) {
        this.addItemToSnapshotTable(STATUS_LATEST, snapshot.getName(), snapshot.getTime());
    }

    private void addItemToSnapshotTable(String name, Date date) {
        this.addItemToSnapshotTable("", name, date);
    }

    private void addItemToSnapshotTable(String status, String name, Date date) {
        TableItem item = new TableItem(this.snapshotTable, 0);
        item.setText(0, status);
        item.setText(1, name);
        if (date != null) {
            item.setText(2, date.toString());
        } else {
            logger.warn("Date is null");
            item.setText(2, "");
        }
    }

    private void handleBtnShowAll(WizardUIResourceHandler uiRsrcHandler) {
        this.btnShowAll.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                logger.trace("btnShowAll : " + InstallOptionConfigView.this.btnShowAll.getSelection());
                InstallOptionConfigView.this.showSnapshotTable(InstallOptionConfigView.this.currentDistribution);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void handleBtnAutoUpdate(WizardUIResourceHandler uiRsrcHandler) {
        this.btnAutoUpdate.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                logger.trace("btnAutoUpdate : " + InstallOptionConfigView.this.btnAutoUpdate.getSelection());
                if (InstallOptionConfigView.this.btnAutoUpdate.getSelection()) {
                    if (InstallOptionConfigView.this.snapshotTable.getItemCount() > 0) {
                        InstallOptionConfigView.this.snapshotTable.select(0);
                    } else {
                        InstallOptionConfigView.this.snapshotTable.deselectAll();
                    }
                    InstallOptionConfigView.this.snapshotTable.setEnabled(false);
                    InstallOptionConfigView.this.btnShowAll.setEnabled(false);
                    InstallOptionConfigView.this.snapshotPath = "";
                } else {
                    InstallOptionConfigView.this.snapshotTable.setEnabled(true);
                    InstallOptionConfigView.this.btnShowAll.setEnabled(true);
                    if (InstallOptionConfigView.this.snapshotTable.getItemCount() > 0) {
                        InstallOptionConfigView.this.snapshotTable.select(0);
                        InstallOptionConfigView.this.setSnapshotPathByName(InstallOptionConfigView.this.snapshotTable.getSelection()[0].getText(1));
                    } else {
                        InstallOptionConfigView.this.snapshotTable.deselectAll();
                    }
                }
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    public void setSnapshotPathByName(String name) {
        SnapshotList snapshotSet = this.repositoryController.getSnapshotList(this.currentDistribution);
        if (snapshotSet == null) {
            logger.warn(ErrorController.ErrorCode.DISTRIBUTION_NOT_FOUND.getErrorMessage());
            return;
        }
        Snapshot currentSnapshot = snapshotSet.getSnapshotByName(name);
        if (currentSnapshot != null) {
            this.snapshotPath = currentSnapshot.getPath();
            this.snapshotName = name;
        } else {
            this.snapshotPath = "";
        }
    }

    private void handleComboDistribution(WizardUIResourceHandler uiRsrcHandler) {
        this.comboDistribution.addListener(37, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                arg0.doit = false;
            }
        });
        this.comboDistribution.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String distribution = InstallOptionConfigView.this.comboDistribution.getText();
                if (InstallOptionConfigView.this.currentDistribution.equals(distribution)) {
                    return;
                }
                boolean isExtUpdateRemote = true;
                InstallOptionConfigView.this.showSnapshotTable(distribution);
                if (InstallOptionConfigView.this.snapshotTable.getItemCount() > 0) {
                    if (InstallOptionConfigView.this.btnAutoUpdate.getSelection()) {
                        InstallOptionConfigView.this.snapshotTable.select(0);
                    } else {
                        InstallOptionConfigView.this.snapshotTable.select(0);
                        InstallOptionConfigView.this.setSnapshotPathByName(InstallOptionConfigView.this.snapshotTable.getSelection()[0].getText(1));
                    }
                    Distribution distributionByName = InstallOptionConfigView.this.repositoryController.getDistributionByName(distribution);
                    if (InstallOptionConfigView.this.currentDistirbutionId != null && InstallOptionConfigView.this.currentDistirbutionId.length() > 0 && InstallOptionConfigView.this.currentDistirbutionId.equals(distributionByName.getID())) {
                        isExtUpdateRemote = false;
                    }
                    InstallOptionConfigView.this.currentDistribution = distribution;
                    InstallOptionConfigView.this.currentDistirbutionId = distributionByName.getID();
                    Config.fromWhere = Config.ConfDialog.SNAPSHOT;
                    Config.getInstance().getConfigFile().setDistribution(InstallOptionConfigView.this.currentDistribution);
                    InstallOptionConfigView.this.reloadExtension(isExtUpdateRemote, true);
                    if (InstallOptionConfigView.this.extConfigView != null) {
                        InstallOptionConfigView.this.extConfigView.initializeData();
                    }
                } else {
                    InstallOptionConfigView.this.snapshotTable.deselectAll();
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void addItemToCombo(Combo combo, Collection<String> list) {
        if (combo == null || list == null) {
            return;
        }
        for (String dist : list) {
            if (dist == null) continue;
            combo.add(dist);
        }
    }

    private void handleBtnRefresh(WizardUIResourceHandler uiRsrcHandler) {
        this.btnRefresh.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                InstallOptionConfigView.this.setNormalColor();
                String changeServerUrl = InstallOptionConfigView.this.comboPackageServer.getText();
                if (!changeServerUrl.equals("- Alternative locations -") && !changeServerUrl.equals("- Previous locations -")) {
                    InstallOptionConfigView.this.onChangeServerBaseURL(true, changeServerUrl, null);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void onChangeServerBaseURL(boolean isForceUpdate, final String changeServerUrl, final AlternativeInformation alterInfo) {
        if (!isForceUpdate && this.currentRepository != null && this.currentRepository.equals(changeServerUrl)) {
            return;
        }
        try {
            CustomProgressDialog progressbar = new CustomProgressDialog(this.getShell(), null);
            progressbar.run(new CallableWithMonitor<Void>(){

                @Override
                public Void call(IProgressMonitor monitor) throws Exception {
                    try {
                        monitor.beginTask("Connecting...", -1);
                        InstallOptionConfigView.this.serverChangeAction(changeServerUrl, alterInfo);
                    }
                    finally {
                        monitor.done();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.throwing(e);
        }
    }

    private void serverChangeAction(final String changeServerUrl, final AlternativeInformation alterInfo) {
        try {
            this.refreshDistribution(changeServerUrl);
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    InstallOptionConfigView.this.comboPackageServer.setText(changeServerUrl);
                    InstallOptionConfigView.this.addToRepositoryHistory(changeServerUrl, alterInfo);
                    InstallOptionConfigView.this.setServerChange(changeServerUrl, alterInfo);
                }
            });
            this.currentRepository = changeServerUrl;
        }
        catch (UMException e) {
            this.currentDistribution = "";
            this.currentRepository = "";
            final String errMsg = e.getMessage();
            this.reloadExtension(true, false);
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    InstallOptionConfigView.this.labelError.setText(errMsg);
                    InstallOptionConfigView.this.isNetworkOK = false;
                    InstallOptionConfigView.this.repositoryController.clearData();
                    InstallOptionConfigView.this.comboDistribution.removeAll();
                    InstallOptionConfigView.this.comboDistribution.clearSelection();
                    InstallOptionConfigView.this.snapshotTable.clearAll();
                    InstallOptionConfigView.this.btnAutoUpdate.setEnabled(false);
                    InstallOptionConfigView.this.btnShowAll.setEnabled(false);
                    if (InstallOptionConfigView.this.extConfigView != null) {
                        InstallOptionConfigView.this.extConfigView.initializeData();
                    }
                }
            });
        }
    }

    private void addToRepositoryHistory(String targetURL, AlternativeInformation alterInfo) {
        if (targetURL == null) {
            return;
        }
        boolean found = false;
        for (String historyURL : this.repositoryHistoryList) {
            if (!historyURL.equals(targetURL)) continue;
            found = true;
            break;
        }
        if (!found && alterInfo == null) {
            this.repositoryHistoryList.add(targetURL);
            this.comboPackageServer.add(targetURL);
        }
    }

    private void setServerChange(String changeServerUrl, AlternativeInformation alterInfo) {
        logger.trace("setServerChange start.");
        if (this.setPackageServerEnv(changeServerUrl, alterInfo) && alterInfo == null) {
            Config.getInstance().addRepoHistory(changeServerUrl);
        }
        logger.trace("setServerChange end.");
    }

    private void setErrorColor() {
        if (this.oldColor == null) {
            this.oldColor = this.comboPackageServer.getForeground();
        }
        this.comboPackageServer.setForeground(RGB_RED);
    }

    private void setNormalColor() {
        if (this.oldColor != null) {
            this.comboPackageServer.setForeground(this.oldColor);
        } else {
            this.comboPackageServer.setForeground(new Color(null, new RGB(0, 0, 0)));
        }
    }

    private boolean setPackageServerEnv(String packageServerPath, AlternativeInformation alterInfo) {
        this.comboPackageServer.setText(packageServerPath);
        boolean isExtUpdateRemote = true;
        String tmpDistirbutionId = "";
        this.comboDistribution.removeAll();
        List<String> distributions = this.repositoryController.getDistributionList();
        this.addItemToCombo(this.comboDistribution, distributions);
        if (packageServerPath != null && packageServerPath.equalsIgnoreCase(this.currentRepository)) {
            if (distributions.size() > 0) {
                int indexOf = distributions.indexOf(this.currentDistribution);
                this.comboDistribution.select(indexOf);
                this.labelError.setText("");
                this.isNetworkOK = true;
                isExtUpdateRemote = false;
            }
        } else if (distributions.size() > 0) {
            if (alterInfo == null) {
                int indexOf = distributions.indexOf(this.currentDistribution);
                if (indexOf == -1) {
                    indexOf = 0;
                } else {
                    isExtUpdateRemote = false;
                }
                this.currentDistribution = distributions.get(indexOf);
                this.comboDistribution.select(indexOf);
                this.comboDistribution.setText(this.comboDistribution.getItem(indexOf));
                tmpDistirbutionId = this.repositoryController.getDistributionByName(this.currentDistribution).getID();
                if (this.currentDistirbutionId != null && this.currentDistirbutionId.length() > 0 && this.currentDistirbutionId.equals(tmpDistirbutionId)) {
                    isExtUpdateRemote = false;
                }
                this.currentDistirbutionId = tmpDistirbutionId;
                this.labelError.setText("");
                this.isNetworkOK = true;
            } else {
                int indexOf = distributions.indexOf(alterInfo.getDistribution());
                this.currentDistribution = distributions.get(indexOf);
                this.comboDistribution.select(indexOf);
                this.comboDistribution.setText(this.comboDistribution.getItem(indexOf));
                tmpDistirbutionId = this.repositoryController.getDistributionByName(this.currentDistribution).getID();
                if (this.currentDistirbutionId != null && this.currentDistirbutionId.length() > 0 && this.currentDistirbutionId.equals(tmpDistirbutionId)) {
                    isExtUpdateRemote = false;
                }
                this.currentDistirbutionId = tmpDistirbutionId;
                this.labelError.setText("");
                this.isNetworkOK = true;
            }
        }
        this.reloadExtension(isExtUpdateRemote, false);
        if (this.extConfigView != null) {
            this.extConfigView.initializeData();
        }
        this.snapshotTable.clearAll();
        this.showSnapshotTable(this.comboDistribution.getText());
        if (this.snapshotTable.getItems().length > 0) {
            this.snapshotTable.setSelection(0);
        }
        this.btnAutoUpdate.setEnabled(true);
        return true;
    }

    private void refreshDistribution(String newRepoURL) throws UMException {
        RepositoryUtil.readDistributionListFromRepository(newRepoURL);
        try {
            Config.getInstance().getConfigFile().setRepository(newRepoURL);
            boolean initDistribution = RepositoryManager.getInstance().refresh();
            if (!initDistribution) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_REPOSITORY);
            }
        }
        catch (UMException e) {
            Config.getInstance().getConfigFile().setRepository(this.installedRepository);
            throw e;
        }
        this.repositoryController = RepositoryManager.getInstance();
    }

    private void handleComboPackageServer(WizardUIResourceHandler uiRsrcHandler2) {
        this.comboPackageServer.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                InstallOptionConfigView.this.setNormalColor();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.comboPackageServer.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                InstallOptionConfigView.this.setNormalColor();
                if (arg0.keyCode == 0x1000050 || arg0.keyCode == 13) {
                    String changeServerUrl = InstallOptionConfigView.this.comboPackageServer.getText();
                    InstallOptionConfigView.this.onChangeServerBaseURL(true, changeServerUrl, null);
                } else if (!InstallOptionConfigView.this.comboPackageServer.getText().startsWith("h")) {
                    InstallOptionConfigView.this.setErrorColor();
                    InstallOptionConfigView.this.comboPackageServer.setText("Please start with http://");
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                InstallOptionConfigView.this.setNormalColor();
                if (!InstallOptionConfigView.this.comboPackageServer.getText().startsWith("h")) {
                    InstallOptionConfigView.this.setErrorColor();
                    InstallOptionConfigView.this.comboPackageServer.setText("");
                    InstallOptionConfigView.this.setNormalColor();
                }
            }
        });
        this.comboPackageServer.addSelectionListener(new SelectionListener(){
            private boolean comboPackageServerFirstSelection = false;

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (!PlatformUtil.isWindows()) {
                    this.comboPackageServerFirstSelection = true;
                }
                if (this.comboPackageServerFirstSelection) {
                    boolean isAlter = false;
                    String changeServerUrl = InstallOptionConfigView.this.comboPackageServer.getText();
                    for (AlternativeInformation alterInfo : InstallOptionConfigView.this.alterativeInfos) {
                        String diff = alterInfo.getName() + " - " + PathUtil.get(alterInfo.getRepository());
                        if (!diff.equals(changeServerUrl)) continue;
                        isAlter = true;
                        InstallOptionConfigView.this.onChangeServerBaseURL(true, alterInfo.getRepository(), alterInfo);
                    }
                    if (!(isAlter || changeServerUrl.equals("- Alternative locations -") || changeServerUrl.equals("- Previous locations -"))) {
                        InstallOptionConfigView.this.onChangeServerBaseURL(true, changeServerUrl, null);
                    }
                } else {
                    this.comboPackageServerFirstSelection = true;
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private boolean validation(String strDir, int fileStyle) {
        ZipFile zipFile = null;
        ZipEntry entry = null;
        try {
            zipFile = new ZipFile(strDir);
        }
        catch (IOException e) {
            logger.throwing(e);
            return false;
        }
        if (fileStyle == 0) {
            String packageList = PackageManager.getPackageListFileName();
            logger.info("This platform must have package list file as '" + packageList + "'");
            entry = zipFile.getEntry(packageList);
        } else if (fileStyle == 1) {
            String scriptFile = ManagerConstants.SDK_PATCH_SCRIPT;
            logger.trace("\tPatch must have execute script file as '" + scriptFile + "'");
            entry = zipFile.getEntry(scriptFile);
        } else {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                logger.throwing(e);
            }
            return false;
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            logger.throwing(e);
        }
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String showSettingInstallpathDlg() {
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setFilterExtensions(new String[]{"*.zip"});
        dlg.setText("Select a SDK image file.");
        String strDir = null;
        try {
            this.parent.setEnabled(false);
            this.getShell().setEnabled(false);
            this.configDialog.setFileDialogOpened(true);
            strDir = dlg.open();
        }
        catch (SWTException e) {
            logger.throwing(e);
        }
        finally {
            this.getShell().setEnabled(true);
            if (!this.parent.isDisposed()) {
                this.parent.setEnabled(true);
                this.configDialog.setFileDialogOpened(false);
            }
        }
        return strDir;
    }

    private void onClickConfirmButtonForNetworkInstall() {
        if (this.currentDistribution == null || this.currentRepository == null || this.currentDistribution.isEmpty() || this.currentRepository.isEmpty()) {
            return;
        }
        Distribution distributionByName = this.repositoryController.getDistributionByName(this.currentDistribution);
        if (distributionByName == null) {
            return;
        }
        this.currentDistirbutionId = distributionByName.getID();
        Config config = Config.getInstance();
        if (config.getImageFileInfo() != null) {
            config.setImageFileInfo(null);
        }
        config.setServerType(Config.ServerType.SNAPSHOT);
        if (this.installedDistribution.equals(this.currentDistribution) && this.installedRepository.equals(this.currentRepository)) {
            String addURLPath;
            SnapshotList snapshotSet = this.repositoryController.getSnapshotList(this.currentDistribution);
            if (snapshotSet == null) {
                logger.warn(ErrorController.ErrorCode.DISTRIBUTION_NOT_FOUND.getErrorMessage());
                return;
            }
            Snapshot snapshotByName = snapshotSet.getSnapshotByName(this.snapshotName);
            if (snapshotByName == null) {
                snapshotByName = snapshotSet.getSnapshotByPath(this.snapshotName);
            }
            if (snapshotByName == null) {
                logger.warn("Snapshot is not exists.");
                snapshotByName = this.repositoryController.getLatestSnapshot(this.currentDistribution);
            }
            if (this.repositoryController.isOutdatedSnapshotURL(addURLPath = NetworkUtil.getURL(this.currentRepository, this.currentDistribution), snapshotByName.getPath())) {
                logger.trace("Selected snapshot is need to uninstall all installed packages.");
                boolean deleteConfirm = this.checkUninstallSDK("The version of target packages are older than those of the installed.\nThe Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
                if (!deleteConfirm) {
                    Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                    return;
                }
                this.configDialog.setServerChanged(true);
                Config.getInstance().setSnapshotPath(snapshotByName.getPath());
                this.setRemoteServerInfo();
                this.configDialog.okPressed();
            } else {
                logger.trace("Selected snapshot is only need refresh information.");
                Config.getInstance().setSnapshotPath(snapshotByName.getPath());
                this.configDialog.setRefreshNeeded(true);
                this.setRemoteServerInfo();
                this.configDialog.okPressed();
            }
        } else if (this.currentDistirbutionId != null && !this.currentDistirbutionId.isEmpty()) {
            if (this.installedDistirbutionId != null && !this.installedDistirbutionId.isEmpty() && this.currentDistirbutionId.equals(this.installedDistirbutionId)) {
                String addURLPath;
                SnapshotList snapshotSet = this.repositoryController.getSnapshotList(this.currentDistribution);
                if (snapshotSet == null) {
                    logger.warn(ErrorController.ErrorCode.DISTRIBUTION_NOT_FOUND.getErrorMessage());
                    return;
                }
                Snapshot snapshotByName = snapshotSet.getSnapshotByName(this.snapshotName);
                if (snapshotByName == null) {
                    snapshotByName = snapshotSet.getSnapshotByPath(this.snapshotName);
                }
                if (snapshotByName == null) {
                    logger.warn("Snapshot is not exists.");
                    snapshotByName = this.repositoryController.getLatestSnapshot(this.currentDistribution);
                }
                if (this.repositoryController.isOutdatedSnapshotURL(addURLPath = NetworkUtil.getURL(this.currentRepository, this.currentDistribution), snapshotByName.getPath())) {
                    logger.trace("Selected snapshot is need to uninstall all installed packages.");
                    boolean deleteConfirm = this.checkUninstallSDK("The version of target packages are older than those of the installed.\nThe Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
                    if (!deleteConfirm) {
                        Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                        return;
                    }
                    this.configDialog.setServerChanged(true);
                    Config.getInstance().setSnapshotPath(snapshotByName.getPath());
                    this.setRemoteServerInfo();
                    this.configDialog.okPressed();
                } else {
                    logger.trace("Selected snapshot is only need refresh information.");
                    Config.getInstance().setSnapshotPath(snapshotByName.getPath());
                    this.configDialog.setRefreshNeeded(true);
                    this.setRemoteServerInfo();
                    this.configDialog.okPressed();
                }
            } else {
                boolean deleteConfirm = this.checkUninstallSDK("The server URL or distribution is changed.\n Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
                if (!deleteConfirm) {
                    Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                    return;
                }
                this.doActionDeleteOldSDK();
            }
        } else {
            boolean deleteConfirm = this.checkUninstallSDK("The server URL or distribution is changed.\n Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
            if (!deleteConfirm) {
                Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                return;
            }
            this.doActionDeleteOldSDK();
        }
    }

    private void doActionDeleteOldSDK() {
        if (this.btnAutoUpdate.getSelection()) {
            try {
                Snapshot latestSnapshot = this.repositoryController.getLatestSnapshot(this.currentDistribution);
                this.snapshotPath = latestSnapshot != null ? latestSnapshot.getPath() : "";
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
                this.snapshotPath = "";
            }
        }
        Config.getInstance().setSnapshotPath(this.snapshotPath);
        Config.getInstance().setInstalledSnapshot("");
        this.configDialog.setServerChanged(true);
        this.setRemoteServerInfo();
        this.configDialog.okPressed();
    }

    private void setRemoteServerInfo() {
        this.configDialog.setSelectedDistribution(this.currentDistribution);
        this.configDialog.setSelectedRepository(this.currentRepository);
        this.configDialog.setDistributionId(this.currentDistirbutionId);
        this.configDialog.setAutoUpdate(this.btnAutoUpdate.getSelection());
        this.configDialog.setSelectedSnapshotPath(this.snapshotPath);
        this.configDialog.setSelectedServerType(Config.ServerType.SNAPSHOT);
        this.repositoryController.setCurrentDistribution(this.currentDistribution);
        this.repositoryController.setServerType(Config.ServerType.SNAPSHOT);
    }

    public void onClickConfirm() {
        if (this.currentServerType == Config.ServerType.SNAPSHOT) {
            this.onClickConfirmButtonForNetworkInstall();
            if (this.isNetworkOK) {
                RepositoryManager.getInstance().setNetworkOK(true);
            } else {
                RepositoryManager.getInstance().setNetworkOK(false);
            }
            if (!RepositoryManager.getInstance().ispNetworkOK() && RepositoryManager.getInstance().isNetworkOK()) {
                this.configDialog.setRefreshNeeded(true);
            }
        } else if (this.currentServerType == Config.ServerType.LOCAL) {
            this.onClickConfirmButtonForImageInstall();
        }
        if (this.extConfigView != null) {
            this.extConfigView.onClickConfirmButton();
        }
    }

    public void onClickCancel() {
        if (!this.isSameDistribution()) {
            Config.getInstance().getConfigFile().setRepository(this.installedRepository);
            Config.getInstance().getConfigFile().setDistribution(this.installedDistribution);
            Config.fromWhere = this.installedFromWhere;
            if (!this.currentRepository.equals(this.installedRepository)) {
                this.onChangeServerBaseURL(true, this.installedRepository, null);
            }
            if (this.extConfigView != null) {
                this.extConfigView.onClickCancleButton();
            }
        }
    }

    private void onClickConfirmButtonForImageInstall() {
        if (this.imageFile == null) {
            return;
        }
        Config config = Config.getInstance();
        if (config.getImageFileInfo() != null && config.getImageFileInfo().getImageFilePath().equals(this.imageFile.getAbsolutePath())) {
            return;
        }
        this.btnConfirm.setEnabled(false);
        if (!this.workOnClickConfirmButtonForImageInstall()) {
            this.btnConfirm.setEnabled(true);
            return;
        }
        this.configDialog.okPressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean workOnClickConfirmButtonForImageInstall() {
        String unzipTargetDir = PathUtil.get(Config.getManagerConfigHome(), "image-cache", this.imageFile.getName());
        ZipLibrary zlpLibrary = null;
        try {
            zlpLibrary = new ZipLibrary(this.imageFile.getAbsolutePath(), null);
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add("image.info");
            fileNames.add(PackageManager.getPackageListFileName());
            zlpLibrary.unzipSelectedList(unzipTargetDir, fileNames);
        }
        catch (Exception e) {
            logger.warn(e);
            CustomMessageDialog.showDlg(this.thisView.getShell(), "Error", ErrorController.ErrorCode.FAIL_TO_EXTRACT_SDK_IMAGE_FILE.getErrorMessage(), CustomMessageDialog.DialogType.ERROR, true);
            this.btnConfirm.setEnabled(true);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zlpLibrary != null) {
                zlpLibrary.close();
            }
        }
        this.localRepoPath = unzipTargetDir;
        RepositoryManager.getInstance().setImageFileName(this.imageFile.getAbsolutePath());
        this.imgInfo = new ImageInformation(this.localRepoPath);
        this.imgInfo.loadImageInfo();
        String repoURL = NetworkUtil.normalizeURL(this.imgInfo.getValue("origin"));
        String distName = this.imgInfo.getValue("distribution");
        String sdkImageDistributionID = this.imgInfo.getSDKImageDistributionID();
        if (distName != null && !distName.isEmpty() && this.installedDistribution != null && !this.installedDistribution.equals(distName) || repoURL != null && !repoURL.isEmpty() && this.installedRepository != null && !this.installedRepository.equals(repoURL)) {
            if (this.installedDistirbutionId != null && !this.installedDistirbutionId.isEmpty() && sdkImageDistributionID != null && !sdkImageDistributionID.isEmpty() && sdkImageDistributionID.equals(this.installedDistirbutionId)) {
                if (this.repositoryController.isOutdatedSnapshotURL(NetworkUtil.getFileURL(unzipTargetDir))) {
                    boolean deleteConfirm = this.checkUninstallSDK("The version of target packages are older than those of the installed.\nThe Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
                    if (!deleteConfirm) {
                        Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                        return false;
                    }
                    this.configDialog.setServerChanged(true);
                    this.setLocalServerInfo(repoURL, distName, sdkImageDistributionID);
                } else {
                    this.configDialog.setServerChanged(false);
                    this.configDialog.setRefreshNeeded(true);
                    this.configDialog.setSelectedRepository(this.localRepoPath);
                    this.configDialog.setSelectedServerType(Config.ServerType.LOCAL);
                    this.setLocalServerInfo(repoURL, distName, sdkImageDistributionID);
                }
            } else {
                boolean deleteConfirm = this.checkUninstallSDK("The server URL or distribution is changed.\n Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
                if (!deleteConfirm) {
                    Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                    return false;
                }
                this.configDialog.setServerChanged(true);
                this.setLocalServerInfo(repoURL, distName, sdkImageDistributionID);
            }
        } else if (this.repositoryController.isOutdatedSnapshotURL(NetworkUtil.getFileURL(unzipTargetDir))) {
            boolean deleteConfirm = this.checkUninstallSDK("The version of target packages are older than those of the installed.\nThe Package Manager is supposed to uninstall all installed packages.\nDo you want to continue?");
            if (!deleteConfirm) {
                Config.getInstance().getConfigFile().setRepository(this.installedRepository);
                return false;
            }
            this.configDialog.setServerChanged(true);
            this.setLocalServerInfo(repoURL, distName, sdkImageDistributionID);
        } else {
            this.configDialog.setServerChanged(false);
            this.configDialog.setRefreshNeeded(true);
            this.configDialog.setSelectedRepository(this.localRepoPath);
            this.configDialog.setSelectedServerType(Config.ServerType.LOCAL);
            this.setLocalServerInfo(repoURL, distName, sdkImageDistributionID);
        }
        return true;
    }

    private void setLocalServerInfo(String repoURL, String distName, String distributionId) {
        this.configDialog.setSelectedRepository(this.localRepoPath);
        this.configDialog.setOriginRepo(repoURL);
        this.configDialog.setDistributionId(distributionId);
        this.configDialog.setSelectedServerType(Config.ServerType.LOCAL);
        this.configDialog.setAutoUpdate(true);
        this.configDialog.setSelectedSnapshotPath("");
        this.configDialog.setSelectedDistribution(distName);
        this.repositoryController.setCurrentDistribution(distName);
        this.repositoryController.setServerType(Config.ServerType.LOCAL);
    }

    private boolean checkUninstallSDK(String msg) {
        int confirm;
        boolean deleteConfirm = true;
        PackageSet installedPackages = PackageManager.getInstance().getInstalledPackages();
        if (installedPackages != null && !installedPackages.isEmpty() && (deleteConfirm = (confirm = CustomMessageDialog.showDlg(this.getShell(), "Warn of uninstalling SDK", msg, CustomMessageDialog.DialogType.WARNING, false)) == 64)) {
            this.configDialog.setUninstallation();
        }
        return deleteConfirm;
    }

    public String getImageFilePath() {
        String path = "";
        if (!this.imageFilePathText.isDisposed()) {
            path = this.imageFilePathText.getText();
        }
        return path;
    }

    public ImageInformation getImgInfo() {
        return this.imgInfo;
    }

    public boolean isSameDistribution() {
        boolean isSame = false;
        if (!this.currentDistribution.equals(this.installedDistribution) || !this.currentRepository.equals(this.installedRepository)) {
            isSame = false;
        } else if (this.currentDistirbutionId != null && !this.currentDistirbutionId.isEmpty() && this.installedDistribution != null && !this.installedDistribution.isEmpty() && this.currentRepository.equals(this.installedRepository) && this.currentDistirbutionId.equals(this.installedDistirbutionId)) {
            isSame = true;
        }
        return isSame;
    }

    public void refreshRepository() {
        String changeServerUrl = this.comboPackageServer.getText();
        this.onChangeServerBaseURL(true, changeServerUrl, null);
    }

    public void reloadExtension(final boolean onlyRemote, boolean isProgress) {
        if (!this.isSameDistribution()) {
            if (isProgress) {
                try {
                    CustomProgressDialog progressbar = new CustomProgressDialog(this.thisView.getShell(), null);
                    progressbar.run(new CallableWithMonitor<Void>(){

                        @Override
                        public Void call(IProgressMonitor monitor) throws Exception {
                            try {
                                monitor.beginTask("Connecting...", -1);
                                ExtRepositoryManager.getInstance().initOption(true, onlyRemote);
                            }
                            catch (UMException e) {
                                e.printStackTrace();
                            }
                            finally {
                                monitor.done();
                            }
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    logger.throwing(ex);
                }
            } else {
                try {
                    ExtRepositoryManager.getInstance().initOption(true, onlyRemote);
                }
                catch (UMException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

