/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class InformationDialog
extends Dialog {
    private static int INFO_LEN = 9;
    private WizardUIResourceHandler uiRsrcHandler;
    private StyledText[] distIDTextList = new StyledText[INFO_LEN];

    public InformationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        container.setLayout(gridLayout);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.createTopComposites(container);
        this.createMiddleComposites(container);
        Label lineLabel = new Label(container, 258);
        GridData gd = new GridData(768);
        gd.heightHint = PlatformUtil.isMacOS() ? 2 : 1;
        lineLabel.setLayoutData(gd);
        lineLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_AD));
        this.createBottomComposites(container);
        return container;
    }

    private void createTopComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(16384, 0x1000000, true, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_TOP_SIZE);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        container.setLayoutData(gd);
        container.setBackgroundImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_INFO_TITLE_BACKGROUND));
        container.setBackgroundMode(2);
        GridLayout gridLayout = new GridLayout(1, false);
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_TOP_MARGIN);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = marginRect.x;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        container.setLayout(gridLayout);
        Label title = new Label(container, 0);
        title.setText("TIZEN STUDIO");
        title.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        title.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_15PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_MEDIUM, 0));
        gd = new GridData(16384, 1024, true, true);
        Rectangle titleRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_TITLE);
        gd.widthHint = titleRect.width;
        gd.heightHint = titleRect.height;
        title.setLayoutData(gd);
        Label subTitle = new Label(container, 0);
        subTitle.setText("Package Manager");
        subTitle.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        subTitle.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_30PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_BOLD, 1));
        gd = new GridData(16384, 128, true, true);
        Rectangle subTitleRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_SUB_TITLE);
        gd.widthHint = subTitleRect.width;
        gd.heightHint = subTitleRect.height + 5;
        subTitle.setLayoutData(gd);
    }

    private void createMiddleComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_MID_SIZE);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        container.setLayout(gridLayout);
        this.createInformationContentComposites(container);
    }

    private void createBottomComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_BOTTOM_SIZE);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, false);
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_BOTTOM_MARGIN);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = marginRect.width;
        gridLayout.marginBottom = 0;
        container.setLayout(gridLayout);
        Button btnOK = new Button(container, 8);
        gd = new GridData(131072, 0x1000000, true, true);
        Rectangle buttonRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_BUTTON);
        gd.widthHint = buttonRect.width;
        gd.heightHint = buttonRect.height;
        btnOK.setLayoutData(gd);
        btnOK.setText("Close");
        btnOK.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        btnOK.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InformationDialog.this.okPressed();
            }
        });
    }

    private void createInformationContentComposites(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 528);
        GridData gd = new GridData(4, 0x1000000, true, true);
        scrolledComposite.setLayoutData(gd);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite container = new Composite(scrolledComposite, 0);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(2, false);
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_MID_MARGIN);
        Rectangle gridMarginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_MID_GRID_MARGIN);
        gridLayout.verticalSpacing = gridMarginRect.height;
        gridLayout.horizontalSpacing = gridMarginRect.width;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = marginRect.y;
        gridLayout.marginLeft = marginRect.x;
        gridLayout.marginRight = marginRect.width;
        gridLayout.marginBottom = marginRect.height;
        container.setLayout(gridLayout);
        parent.setRedraw(false);
        this.createInfoContent(0, container, "Version", Config.getInstance().getManagerVersion());
        this.createInfoContent(1, container, "Tizen Studio Path", SDKInfo.getInstalledPath());
        this.createInfoContent(2, container, "Data Path", SDKInfo.getSdkDataPath());
        this.createInfoContent(3, container, "Repository URL", Config.getInstance().getConfigFile().getRepository());
        this.createInfoContent(4, container, "Distribution", Config.getInstance().getConfigFile().getDistribution());
        this.createInfoContent(5, container, "Distribution ID", Config.getInstance().getConfigFile().getDistributionId());
        this.createInfoContent(6, container, "Target Snapshot", Config.getInstance().getSnapshotPath());
        this.createInfoContent(7, container, "Installed Snapshot", Config.getInstance().getInstalledSnapshot());
        this.createInfoContent(8, container, "Auto Update", Config.getInstance().isAutoUpdate() ? "Activated" : "Deactivated");
        scrolledComposite.setContent(container);
        container.setSize(container.computeSize(-1, -1));
        scrolledComposite.setMinSize(container.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    private void createInfoContent(int idx, Composite container, String labelStr, String contentStr) {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_INFO_DAILOG_CONTENT);
        Label distIDLabel = new Label(container, 0x1004000);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = rect.x;
        distIDLabel.setLayoutData(gd);
        distIDLabel.setText(labelStr);
        distIDLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_12PX, false, 1));
        distIDLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        distIDLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.distIDTextList[idx] = new StyledText(container, 16448);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = rect.width;
        this.distIDTextList[idx].setData(idx);
        this.distIDTextList[idx].setLayoutData(gd);
        this.distIDTextList[idx].setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_12PX, false, 0));
        this.distIDTextList[idx].setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.distIDTextList[idx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.distIDTextList[idx].setEditable(false);
        this.distIDTextList[idx].setEnabled(true);
        this.distIDTextList[idx].setCaret(null);
        this.distIDTextList[idx].setText(contentStr);
        if (PlatformUtil.isWindows()) {
            this.distIDTextList[idx].setLineJustify(0, 1, true);
        }
        this.distIDTextList[idx].addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                StyledText text = (StyledText)arg0.getSource();
                int curIdx = (Integer)text.getData();
                for (int i = 0; i < INFO_LEN; ++i) {
                    if (i == curIdx) continue;
                    InformationDialog.this.distIDTextList[i].setSelectionRange(0, 0);
                }
            }
        });
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Information");
        newShell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

