/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.PrerequisitesUtil;
import org.tizen.packagemanager.ui.dialog.CustomComponentDisplayDialog;
import org.tizen.packagemanager.ui.dialog.CustomConfirmDialog;
import org.tizen.packagemanager.ui.dialog.LicenseAgreementDialog;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.page.custom.CustomTableProfileImage;
import org.tizen.packagemanager.ui.provider.common.ComponentNameColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.common.ItemTreeContentProvider;
import org.tizen.packagemanager.ui.provider.maintab.ActionStatusColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.maintab.InstallColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.maintab.LicenseColumnLabelProvider;
import org.tizen.packagemanager.ui.provider.maintab.UpdateStatusColumnLabelProvider;
import org.tizen.packagemanager.ui.util.UIUtil;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CommonTreeView
extends Composite {
    private final int COMPONENT_NAME_COLUMN_INDEX = 0;
    private final int LICENSE_BUTTON_COLUMN_INDEX = 1;
    private final int UPDATABLE_STATUS_COLUMN_INDEX = 2;
    private final int ACTION_BUTTON_COLUMN_INDEX = 4;
    private int TOTAL_SIZE;
    private int SCROLL_SIZE;
    private int COL_LICENSE_WIDTH;
    private int COL_NAME_WIDTH;
    private int COL_UPDATABLE_WIDTH;
    private int COL_ACTION_STATUS_WIDTH;
    private int COL_ACTION_BUTTON_WIDTH;
    private static final String EXTRAS_TREE_ITEM = "EXTRAS";
    protected TreeViewer treeViewer;
    protected Tree tree;
    private TreeItem selectedItem = null;
    private DefaultToolTip toolTip;
    private WizardUIResourceHandler uiRrcHandler = WizardUIResourceHandler.getInstance();
    private List<Component> customTreeItems;
    protected TreeItem oldItem;
    protected HashMap<Item, CustomTableIconButton> licenseButtons;
    protected HashMap<Item, CustomTableIconButton> updateButtons;
    protected HashMap<Item, CustomTableIconButton> installButtons;
    protected HashMap<Item, CustomTableIconButton> uninstallButtons;
    protected HashMap<Item, CustomTableProfileImage> profileImages;
    private Logger logger;

    public CommonTreeView(Composite arg0, int arg1, Logger logger) {
        super(arg0, arg1);
        this.logger = logger;
        this.licenseButtons = new HashMap();
        this.updateButtons = new HashMap();
        this.installButtons = new HashMap();
        this.uninstallButtons = new HashMap();
        this.profileImages = new HashMap();
        this.customTreeItems = new ArrayList<Component>();
        this.initSizes();
        this.setBackground(this.uiRrcHandler.getBackGroundColor());
        this.setTreeViewer();
        this.setButtonEventListener();
    }

    private void initSizes() {
        this.TOTAL_SIZE = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_VIEW_WIDTH);
        this.SCROLL_SIZE = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_SCROLLBAR_WIDTH);
        this.COL_LICENSE_WIDTH = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_LICENSE_WIDTH);
        this.COL_UPDATABLE_WIDTH = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_UPDATABLE_WIDTH);
        this.COL_ACTION_STATUS_WIDTH = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_STATUS_WIDTH);
        this.COL_ACTION_BUTTON_WIDTH = this.uiRrcHandler.getSingleSize(WizardUIResourceHandler.UISingleSize.WIZARD_SINGLE_SIZE_TREE_COLUMN_ACTION_BUTTON_WIDTH);
        this.COL_NAME_WIDTH = this.TOTAL_SIZE - this.SCROLL_SIZE - this.COL_LICENSE_WIDTH - this.COL_UPDATABLE_WIDTH - this.COL_ACTION_BUTTON_WIDTH - this.COL_ACTION_STATUS_WIDTH;
    }

    private void setTreeViewer() {
        int style = 66064;
        this.treeViewer = new TreeViewer(this, style);
        this.treeViewer.setContentProvider(new ItemTreeContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput(this.customTreeItems);
        this.toolTip = new DefaultToolTip(this.treeViewer.getControl());
        this.toolTip.setBackgroundColor(new Color(this.getDisplay(), 255, 255, 225));
        this.toolTip.setForegroundColor(new Color(this.getDisplay(), 0, 0, 0));
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(false);
        this.tree.setLinesVisible(false);
        this.tree.setVisible(true);
        this.tree.setEnabled(true);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        TreeViewerColumn componentClmn = new TreeViewerColumn(this.treeViewer, 0);
        componentClmn.setLabelProvider(new ComponentNameColumnLabelProvider(this));
        componentClmn.getColumn().setWidth(this.COL_NAME_WIDTH);
        columnLayout.setColumnData(componentClmn.getColumn(), new ColumnPixelData(this.COL_NAME_WIDTH));
        TreeViewerColumn licenseClmn = new TreeViewerColumn(this.treeViewer, 0);
        licenseClmn.setLabelProvider(new LicenseColumnLabelProvider(this, this.COL_LICENSE_WIDTH));
        licenseClmn.getColumn().setWidth(this.COL_LICENSE_WIDTH);
        columnLayout.setColumnData(licenseClmn.getColumn(), new ColumnPixelData(this.COL_LICENSE_WIDTH));
        TreeViewerColumn updatableClmn = new TreeViewerColumn(this.treeViewer, 0);
        updatableClmn.setLabelProvider(new UpdateStatusColumnLabelProvider(this, this.COL_UPDATABLE_WIDTH));
        updatableClmn.getColumn().setWidth(this.COL_UPDATABLE_WIDTH);
        columnLayout.setColumnData(updatableClmn.getColumn(), new ColumnPixelData(this.COL_UPDATABLE_WIDTH));
        TreeViewerColumn actionStatusColumn = new TreeViewerColumn(this.treeViewer, 0);
        actionStatusColumn.setLabelProvider(new ActionStatusColumnLabelProvider(this, this.COL_ACTION_STATUS_WIDTH));
        actionStatusColumn.getColumn().setWidth(this.COL_ACTION_STATUS_WIDTH);
        columnLayout.setColumnData(actionStatusColumn.getColumn(), new ColumnPixelData(this.COL_ACTION_STATUS_WIDTH));
        TreeViewerColumn actionButtonColumn = new TreeViewerColumn(this.treeViewer, 0);
        actionButtonColumn.setLabelProvider(new InstallColumnLabelProvider(this, this.COL_ACTION_BUTTON_WIDTH));
        actionButtonColumn.getColumn().setWidth(this.COL_ACTION_BUTTON_WIDTH + 20);
        columnLayout.setColumnData(actionButtonColumn.getColumn(), new ColumnWeightData(100, this.COL_ACTION_BUTTON_WIDTH + 20));
        this.setLayout(columnLayout);
        this.tree.addListener(17, new Listener(){

            @Override
            public void handleEvent(final Event event) {
                CommonTreeView.this.tree.setRedraw(false);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Component item = (Component)((TreeItem)event.item).getData();
                        TreeItem treeItem = (TreeItem)event.item;
                        CommonTreeView.this.tree.setSelection(treeItem);
                        if (CommonTreeView.this.selectedItem != null) {
                            CommonTreeView.this.profilSelectToParent(CommonTreeView.this.selectedItem, false);
                            CommonTreeView.this.tableButtonSelectToParent(CommonTreeView.this.selectedItem, false);
                        }
                        CommonTreeView.this.profilSelectToParent(treeItem, true);
                        CommonTreeView.this.tableButtonSelectToParent(treeItem, true);
                        CommonTreeView.this.selectedItem = treeItem;
                        ArrayList<Component> children = item.getChildren();
                        if (!children.isEmpty()) {
                            CommonTreeView.this.logger.trace(children);
                            CommonTreeView.this.logger.trace("expaned");
                            treeItem.setExpanded(true);
                            CommonTreeView.this.tree.setRedraw(true);
                            return;
                        }
                    }
                });
            }
        });
        this.tree.addListener(18, new Listener(){

            @Override
            public void handleEvent(final Event event) {
                CommonTreeView.this.tree.setRedraw(false);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Component item = (Component)((TreeItem)event.item).getData();
                        TreeItem treeItem = (TreeItem)event.item;
                        CommonTreeView.this.tree.setSelection(treeItem);
                        if (CommonTreeView.this.selectedItem != null) {
                            CommonTreeView.this.profilSelectToParent(CommonTreeView.this.selectedItem, false);
                            CommonTreeView.this.tableButtonSelectToParent(CommonTreeView.this.selectedItem, false);
                        }
                        CommonTreeView.this.profilSelectToParent(treeItem, true);
                        CommonTreeView.this.tableButtonSelectToParent(treeItem, true);
                        CommonTreeView.this.selectedItem = treeItem;
                        ArrayList<Component> children = item.getChildren();
                        if (!children.isEmpty()) {
                            CommonTreeView.this.logger.trace(children);
                            CommonTreeView.this.logger.trace("collapse");
                            treeItem.setExpanded(false);
                            CommonTreeView.this.tree.setRedraw(true);
                            return;
                        }
                    }
                });
            }
        });
        this.tree.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent e) {
                CommonTreeView.this.tree.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent e) {
                CommonTreeView.this.emitMouseExitForAllButtons();
                if (!PlatformUtil.isMacOS()) {
                    CommonTreeView.this.handleMouseMoveEvent(null);
                }
            }

            @Override
            public void mouseEnter(MouseEvent e) {
                CommonTreeView.this.tree.setFocus();
            }
        });
        this.tree.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                TreeItem[] select = CommonTreeView.this.tree.getSelection();
                if (select.length > 0) {
                    if (CommonTreeView.this.selectedItem != null) {
                        CommonTreeView.this.profilSelectToParent(CommonTreeView.this.selectedItem, false);
                        CommonTreeView.this.tableButtonSelectToParent(CommonTreeView.this.selectedItem, false);
                    }
                    CommonTreeView.this.profilSelectToParent(select[0], true);
                    CommonTreeView.this.tableButtonSelectToParent(select[0], true);
                    CommonTreeView.this.selectedItem = select[0];
                    CommonTreeView.this.tree.redraw();
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.tree.pack();
    }

    public void profilSelectToParent(TreeItem item, boolean isSelect) {
        if (item != null && !item.isDisposed()) {
            TreeItem parent = item.getParentItem();
            if (parent != null) {
                this.getProfileIconImage(parent).setSelect(isSelect);
                item.getParent().redraw();
                this.profilSelectToParent(parent, isSelect);
            }
            this.getProfileIconImage(item).setSelect(isSelect);
        }
    }

    public void tableButtonSelectToParent(TreeItem item, boolean isSelect) {
        if (item != null && !item.isDisposed()) {
            this.getUpdateButton(item).setSelect(isSelect);
            this.getLicenseButton(item).setSelect(isSelect);
        }
    }

    private void loadPackagesToTreeViewer() {
        this.customTreeItems.addAll(ComponentManager.getInstance().getComponentList());
    }

    private void setButtonEventListener() {
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : CommonTreeView.this.getAllTableIconButtons()) {
                    Rectangle bounds;
                    if (button.isDisposed() || (bounds = button.getBounds()) == null || !bounds.contains(pt)) continue;
                    button.handleMouseUpEvent(event);
                }
            }

            @Override
            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : CommonTreeView.this.getAllTableIconButtons()) {
                    Rectangle bounds;
                    if (button.isDisposed() || (bounds = button.getBounds()) == null || !bounds.contains(pt)) continue;
                    button.handleMouseDownEvent(event);
                }
            }

            @Override
            public void mouseDoubleClick(MouseEvent event) {
                CommonTreeView.this.tree.setRedraw(false);
                Point pt = new Point(event.x, event.y);
                TreeItem treeItem = CommonTreeView.this.tree.getItem(pt);
                if (treeItem != null && !treeItem.isDisposed()) {
                    Component item = (Component)treeItem.getData();
                    if (!treeItem.getExpanded()) {
                        CommonTreeView.this.expandTreeItemsByComponent(item, 1);
                        treeItem.setExpanded(true);
                    } else {
                        treeItem.setExpanded(false);
                    }
                }
                CommonTreeView.this.tree.setRedraw(true);
            }
        });
        this.tree.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                for (CustomTableIconButton button : CommonTreeView.this.getAllTableIconButtons()) {
                    if (button.isDisposed()) continue;
                    button.handleMouseMoveEvent(pt);
                }
                for (CustomTableProfileImage image : CommonTreeView.this.getAllTableProfileImages()) {
                    if (!image.isDisposed()) continue;
                }
                CommonTreeView.this.handleMouseMoveEvent(pt);
            }
        });
    }

    private void handleMouseMoveEvent(Point pt) {
        if (pt == null) {
            return;
        }
        TreeItem treeItem = this.tree.getItem(pt);
        if (treeItem == null || treeItem.getData() == null) {
            this.toolTip.deactivate();
            return;
        }
        Component component = (Component)treeItem.getData();
        Rectangle licenseRect = treeItem.getBounds(1);
        if (licenseRect.contains(pt) && component.hasLicense() && !component.isLicenseAgreed()) {
            this.toolTip.activate();
            this.toolTip.setText("License agreement");
        } else {
            this.toolTip.deactivate();
        }
        this.oldItem = treeItem;
    }

    private void emitMouseExitForAllButtons() {
        if (this.oldItem != null && !this.oldItem.isDisposed()) {
            this.getLicenseButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getUpdateButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getInstallButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
            this.getUninstallButton(this.oldItem).handleEvent(CustomTableIconButton.CustomMouseEvent.ICON_MOUSE_EXIT);
        }
    }

    void addComponentChangeListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    void refresh(boolean isInit) {
        this.customTreeItems.clear();
        try {
            this.loadPackagesToTreeViewer();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (isInit) {
            this.treeViewer.setInput(new ArrayList());
            this.treeViewer.setInput(this.customTreeItems);
        } else {
            this.treeViewer.refresh();
        }
    }

    public void expandFirst() {
        this.treeViewer.expandToLevel(2);
        this.tree.redraw();
    }

    public void expandTreeItemsByComponent(Component component, int level) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        this.treeViewer.expandToLevel(component, level);
        this.setExpandedTreeItems(components);
        this.tree.redraw();
    }

    public void expandTreeItemsByComponent(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        this.expandTreeItemsByComponents(components);
    }

    private void expandTreeItemsByComponents(ArrayList<Component> components) {
        for (Component item : components) {
            this.treeViewer.expandToLevel(item, -1);
        }
        this.setExpandedTreeItems(components);
        this.tree.redraw();
    }

    private void setExpandedTreeItems(ArrayList<Component> components) {
        this.setExpandedTreeItems(this.tree.getItems(), components);
    }

    private boolean setExpandedTreeItems(TreeItem[] treeItems, ArrayList<Component> components) {
        boolean result = false;
        for (TreeItem item : treeItems) {
            if (item.getItems().length > 0) {
                if (!this.setExpandedTreeItems(item.getItems(), components)) continue;
                item.setExpanded(true);
                result = true;
                continue;
            }
            Component component = (Component)item.getData();
            if (component == null || !components.contains(component)) continue;
            result = true;
        }
        return result;
    }

    public Tree getTree() {
        return this.tree;
    }

    public CustomTableIconButton getLicenseButton(Item treeItem) {
        CustomTableIconButton button = this.licenseButtons.get(treeItem);
        if (button == null) {
            button = new CustomTableIconButton(treeItem, 1, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_LICENSE_NORMAL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_LICENSE_HOVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_LICENSE_SEL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_LICENSE_NORMAL);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    CommonTreeView.this.onClickLicenseButton((TreeItem)parentBtn.getParentItem());
                }
            });
            this.licenseButtons.put(treeItem, button);
        }
        return button;
    }

    public CustomTableIconButton getUpdateButton(Item treeItem) {
        CustomTableIconButton button = this.updateButtons.get(treeItem);
        if (button == null) {
            button = new CustomTableIconButton(treeItem, 2, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_UPDATE_NORMAL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_UPDATE_HOVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_UPDATE_SEL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_ICON_UPDATE_NORMAL);
            button.removeAllMouseClickEventListeners();
            this.updateButtons.put(treeItem, button);
        }
        return button;
    }

    public void onClickLicenseButton(TreeItem treeItem) {
        Component component = (Component)treeItem.getData();
        if (component.hasLicense()) {
            LicenseAgreementDialog dialog = new LicenseAgreementDialog(this.getShell(), component, 32);
            int n = dialog.open();
        }
    }

    public void onClickAcceptLicenseButton(TreeItem treeItem, boolean state) {
        Component component = (Component)treeItem.getData();
        component.setLicenseAgreed(state);
        this.getInstallButton(treeItem).setDisabled(!state);
    }

    public CustomTableIconButton getInstallButton(Item treeItem) {
        CustomTableIconButton button = this.installButtons.get(treeItem);
        if (button == null) {
            button = new CustomTableIconButton(treeItem, 4, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_NOR, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_SEL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_DIS);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    Component component = (Component)((TreeItem)parentBtn.getParentItem()).getData();
                    CommonTreeView.this.onClickInstallButton(component);
                }
            });
            this.installButtons.put(treeItem, button);
        }
        return button;
    }

    public CustomTableIconButton getUninstallButton(Item treeItem) {
        CustomTableIconButton button = this.uninstallButtons.get(treeItem);
        if (button == null) {
            button = new CustomTableIconButton(treeItem, 4, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_NOR, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_OVER, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_REMOVE_SEL, WizardUIResourceHandler.UIIcon.WIZARD_IMAGE_MANAGER_BUTTON_INSATLL_DIS);
            button.removeAllMouseClickEventListeners();
            button.addMouseClickEventListener(new CustomTableIconButton.IClickEventListener(){

                @Override
                public void onClick(CustomTableIconButton parentBtn) {
                    try {
                        Component component = (Component)((TreeItem)parentBtn.getParentItem()).getData();
                        CommonTreeView.this.onClickUninstallButton(component);
                    }
                    catch (Exception e) {
                        CommonTreeView.this.logger.throwing(e);
                    }
                }
            });
            this.uninstallButtons.put(treeItem, button);
            button.setHidden(false);
        }
        return button;
    }

    public CustomTableProfileImage getProfileIconImage(Item treeItem) {
        CustomTableProfileImage profileImage = this.profileImages.get(treeItem);
        if (profileImage == null) {
            Component comp = (Component)treeItem.getData();
            Package.ProfileType type = Package.ProfileType.NONE;
            WizardUIResourceHandler.UIImage norImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_NORMAL;
            WizardUIResourceHandler.UIImage selectedImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_SELECT;
            WizardUIResourceHandler.UIImage overImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_OVER;
            WizardUIResourceHandler.UIImage changeImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TOOL_NORMAL;
            if (comp.getProfileType() == Package.ProfileType.MOBILE) {
                type = Package.ProfileType.MOBILE;
                norImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_NORMAL;
                selectedImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_SELECT;
                overImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_MOBILE_OVER;
                changeImage = norImage;
            } else if (comp.getProfileType() == Package.ProfileType.WEARABLE) {
                type = Package.ProfileType.WEARABLE;
                norImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_NORMAL;
                selectedImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_SELECT;
                overImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_WEARABLE_OVER;
                changeImage = norImage;
            } else if (comp.getProfileType() == Package.ProfileType.TV) {
                type = Package.ProfileType.TV;
                norImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_NORMAL;
                selectedImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_SELECT;
                overImage = WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_TYPE_TV_OVER;
                changeImage = norImage;
            }
            profileImage = new CustomTableProfileImage(treeItem, 0, type, norImage, selectedImage, overImage, changeImage);
            this.profileImages.put(treeItem, profileImage);
        }
        return profileImage;
    }

    public void onClickUninstallButton(Component component) {
        if (!UIUtil.findRunningProcess(this.getShell()).isEmpty()) {
            return;
        }
        if (this.existsInstallingComponent()) {
            CustomMessageDialog.showDlg(this.getShell(), "Warning", "You cannot uninstall packages while the Package Manager is installing or updating.", CustomMessageDialog.DialogType.ERROR, true);
            return;
        }
        if (!component.hasChildren()) {
            this.startToUninstallSingleTreeItem(component);
        } else {
            this.startToUninstallAllSubTreeItem(component);
        }
    }

    private boolean existsInstallingComponent() {
        for (Component comp : this.customTreeItems) {
            if (comp.getInstallState() != Component.InstallState.INSTALLING && comp.getInstallState() != Component.InstallState.UPDATING) continue;
            return true;
        }
        return false;
    }

    private void startToUninstallSingleTreeItem(Component component) {
        CustomComponentDisplayDialog ccdd;
        int result;
        ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToUninstall(component);
        if (!selGroupComps.isEmpty() && (result = (ccdd = new CustomComponentDisplayDialog(this.getShell(), "This package depends on the following packages.\nClick Yes to remove the related packages.", selGroupComps)).open()) != 0) {
            return;
        }
        TreeItem treeItem = this.getTreeItemByComponent(component);
        if (treeItem != null) {
            this.getUninstallButton(treeItem).setDisabled(true);
        }
        this.createUninstallProcess(component, selGroupComps);
    }

    private void startToUninstallAllSubTreeItem(Component component) {
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component component2 : component.getLeafDecendents()) {
            if (targetComponents.contains(component2) || component2.getInstallState() != Component.InstallState.UNINSTALL && component2.getInstallState() != Component.InstallState.UPDATE) continue;
            targetComponents.add(component2);
        }
        if (targetComponents.isEmpty()) {
            return;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        tempComponents = new ArrayList();
        for (Component comp : targetComponents) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToUninstall(comp);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(comp)) continue;
            tempComponents.add(comp);
        }
        ArrayList<Component> arrayList = ComponentManager.getSortedComponentsByInstallOrder(tempComponents);
        Collections.reverse(arrayList);
        this.expandTreeItemsByComponents(arrayList);
        TreeItem treeItem = this.getTreeItemByComponent(component);
        if (treeItem != null) {
            this.getUninstallButton(treeItem).setDisabled(true);
        }
        this.createGroupunInstallProcess(arrayList);
    }

    private void createGroupunInstallProcess(ArrayList<Component> components) {
        for (Component comp : components) {
            comp.setInstallState(Component.InstallState.UNINSTALLING);
        }
        ViewController.getInstance().getProgressView().addGroupComponentsToUninstall(components);
    }

    private void createUninstallProcess(Component component, ArrayList<Component> selGroupComps) {
        ArrayList<Component> dependentComps = new ArrayList<Component>();
        dependentComps.addAll(selGroupComps);
        component.setDependentComponents(dependentComps);
        this.expandTreeItemsByComponents(dependentComps);
        for (Component depComp : component.getDependentComponents()) {
            depComp.setInstallState(Component.InstallState.UNINSTALLING);
        }
        component.setInstallState(Component.InstallState.UNINSTALLING);
        ViewController.getInstance().getProgressView().addComponentToUninstall(component);
    }

    public void onClickInstallButton(Component component) {
        if (!UIUtil.findRunningProcess(this.getShell()).isEmpty() || !UIUtil.checkIfRepositoryIsOutdated(this.getShell())) {
            return;
        }
        if (!UIUtil.checkExtensionStatusOfInstallable(this.getShell(), component)) {
            return;
        }
        if (component.getInstallState() == Component.InstallState.INSTALL) {
            if (this.existsUninstallingComponent()) {
                CustomMessageDialog.showDlg(this.getShell(), "Warning", "You cannot install packages  while the Package Manager is uninstalling.", CustomMessageDialog.DialogType.ERROR, true);
                return;
            }
            if (!component.hasChildren()) {
                this.startToInstallSingleTreeItem(component, false);
            } else {
                this.startToInstallAllSubTreeItem(component);
            }
        } else if (component.getInstallState() == Component.InstallState.UPDATE && component.hasChildren()) {
            if (this.existsUninstallingComponent()) {
                CustomMessageDialog.showDlg(this.getShell(), "Warning", "You cannot install packages  while the Package Manager is uninstalling.", CustomMessageDialog.DialogType.ERROR, true);
                return;
            }
            this.startToInstallAllSubTreeItem(component);
        }
    }

    private ArrayList<Component> getAllUpdatableLeafComponents(Component component) {
        ComponentManager compMgr;
        ArrayList<Component> updatableComps = new ArrayList<Component>();
        if ((component.getRecentPackage().getPackageName().equals(EXTRAS_TREE_ITEM) || component.getRecentPackage().isExtensionPackage()) && !(compMgr = ComponentManager.getInstance()).existsMainComponentsBySelectedGroup(component) && !compMgr.existsRepoPackagesToInstallByDependency(component)) {
            return updatableComps;
        }
        for (Component comp : this.getAllComponents()) {
            if (comp.getRecentPackage().isExtensionPackage() || !comp.getChildren().isEmpty() || comp.getInstallState() != Component.InstallState.UPDATE) continue;
            updatableComps.add(comp);
        }
        return updatableComps;
    }

    private boolean checkUpdateUpdatableComponents(ArrayList<Component> updatableComps) {
        if (updatableComps == null || updatableComps.isEmpty()) {
            return true;
        }
        CustomComponentDisplayDialog ccdd = new CustomComponentDisplayDialog(this.getShell(), "To install the selected packages, the current packages should be updated according to SDK compatability.", updatableComps);
        int result = ccdd.open();
        return result == 0;
    }

    private void startToInstallSingleTreeItem(Component component, boolean skipConfirm) {
        ArrayList<Object> updatableComps = new ArrayList();
        if (!(skipConfirm || (updatableComps = this.getAllUpdatableLeafComponents(component)).isEmpty() || this.checkUpdateUpdatableComponents(updatableComps))) {
            return;
        }
        ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component);
        if (!(selGroupComps.isEmpty() || skipConfirm || this.checkInstallSelectedGroup(selGroupComps))) {
            return;
        }
        if (!skipConfirm && !this.checkAgreeEULA(component)) {
            return;
        }
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        targetComponents.add(component);
        for (Component selCompo : selGroupComps) {
            if (targetComponents.contains(selCompo)) continue;
            targetComponents.add(selCompo);
        }
        if (!skipConfirm && PlatformUtil.isLinux() && !this.checkPrerequsites(targetComponents)) {
            return;
        }
        TreeItem treeItem = this.getTreeItemByComponent(component);
        if (treeItem != null) {
            this.getInstallButton(treeItem).setDisabled(true);
        }
        this.createInstallProcesses(component, updatableComps, selGroupComps);
    }

    private boolean checkInstallSelectedGroup(ArrayList<Component> selGroupComps) {
        CustomComponentDisplayDialog ccdd = new CustomComponentDisplayDialog(this.getShell(), "This package depends on the following packages.\nClick Yes to install the required additional packages.", selGroupComps);
        int result = ccdd.open();
        return result == 0;
    }

    private boolean checkAgreeEULA(Component component) {
        ArrayList<Component> comps = new ArrayList<Component>();
        comps.add(component);
        return this.checkAgreeEULA(comps);
    }

    private boolean checkPopup(ArrayList<Component> components) {
        ArrayList<Component> needConfirmPopupComps = new ArrayList<Component>();
        for (Component component : components) {
            if (component.hasPopup() && !needConfirmPopupComps.contains(component)) {
                needConfirmPopupComps.add(component);
            }
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component);
            for (Component selGroupComp : selGroupComps) {
                if (!selGroupComp.hasPopup() || needConfirmPopupComps.contains(selGroupComp)) continue;
                needConfirmPopupComps.add(selGroupComp);
            }
        }
        String strConfirmPopupCompName = "";
        for (Component comp : needConfirmPopupComps) {
            if (!strConfirmPopupCompName.isEmpty()) {
                strConfirmPopupCompName = strConfirmPopupCompName + ", ";
            }
            strConfirmPopupCompName = strConfirmPopupCompName + "'" + comp.getDisplayName() + "'";
        }
        if (!needConfirmPopupComps.isEmpty()) {
            String string = ((Component)needConfirmPopupComps.get(0)).getPopupString();
            CustomConfirmDialog dialog = new CustomConfirmDialog(this.getShell(), string, needConfirmPopupComps);
            int result = dialog.open();
            if (result != 0) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAgreeEULA(ArrayList<Component> components) {
        ArrayList<Component> needLicenseComps = new ArrayList<Component>();
        for (Component component : components) {
            if (component.hasLicense() && !component.isLicenseAgreed() && !needLicenseComps.contains(component)) {
                needLicenseComps.add(component);
            }
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component);
            for (Component selGroupComp : selGroupComps) {
                if (!selGroupComp.hasLicense() || selGroupComp.isLicenseAgreed() || needLicenseComps.contains(selGroupComp)) continue;
                needLicenseComps.add(selGroupComp);
            }
        }
        String strNeedLicenseCompNames = "";
        for (Component comp : needLicenseComps) {
            if (!strNeedLicenseCompNames.isEmpty()) {
                strNeedLicenseCompNames = strNeedLicenseCompNames + ", ";
            }
            strNeedLicenseCompNames = strNeedLicenseCompNames + "'" + comp.getDisplayName() + "'";
        }
        if (!needLicenseComps.isEmpty()) {
            void var4_8;
            if (needLicenseComps.size() > 1) {
                LicenseAgreementDialog licenseAgreementDialog = new LicenseAgreementDialog(this.getShell(), needLicenseComps, 0);
            } else {
                LicenseAgreementDialog licenseAgreementDialog = new LicenseAgreementDialog(this.getShell(), needLicenseComps.get(0), 0);
            }
            int result = var4_8.open();
            if (result != 0) {
                return false;
            }
        }
        for (Component comp : needLicenseComps) {
            TreeItem item = this.getTreeItemByComponent(comp);
            if (item != null && !item.isDisposed()) {
                this.onClickAcceptLicenseButton(item, true);
                continue;
            }
            comp.setLicenseAgreed(true);
        }
        return true;
    }

    private boolean checkPrerequsites(ArrayList<Component> componentsList) {
        ArrayList<Component> selgroupList = new ArrayList<Component>();
        for (Component component : componentsList) {
            selgroupList.add(component);
        }
        for (Component comp : componentsList) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(comp);
            for (Component component : selGroupComps) {
                if (selgroupList.contains(component)) continue;
                selgroupList.add(component);
            }
        }
        Map<String, List<String>> checkPrerequisities = PrerequisitesUtil.checkPrerequisities(selgroupList);
        if (checkPrerequisities != null && checkPrerequisities.size() > 0) {
            String msg = "Required prerequisite packages are not installed.\nPlease install the packages using following command(s).\n";
            this.logger.trace("\tUnder libraries are not installed");
            this.logger.trace("\t##############################################");
            Set<String> keySet = checkPrerequisities.keySet();
            Iterator<Object> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key;
                String pkgName = key = (String)iterator.next();
                if (key.endsWith("*")) {
                    pkgName = key.substring(0, key.lastIndexOf("*"));
                }
                String msgValue = " sudo apt-get install " + pkgName;
                msg = msg + msgValue + "\n";
                this.logger.trace("\t" + msgValue);
            }
            this.logger.trace("\t##############################################");
            String title = "Notice";
            CustomMessageDialog.showDlg(this.getShell(), title, msg, CustomMessageDialog.DialogType.INFO, true);
            return false;
        }
        return true;
    }

    private void startToInstallAllSubTreeItem(Component component) {
        ArrayList<Component> updatableComps = this.getAllUpdatableLeafComponents(component);
        if (!updatableComps.isEmpty() && !this.checkUpdateUpdatableComponents(updatableComps)) {
            return;
        }
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component component2 : component.getLeafDecendents()) {
            if (targetComponents.contains(component2) || component2.getInstallState() != Component.InstallState.INSTALL) continue;
            targetComponents.add(component2);
        }
        if (targetComponents.isEmpty()) {
            return;
        }
        ArrayList<Component> tempComponents = new ArrayList<Component>();
        for (Component component3 : updatableComps) {
            ArrayList<Component> arrayList = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component3);
            for (Component selComp : arrayList) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(component3)) continue;
            tempComponents.add(component3);
        }
        ArrayList<Component> arrayList = ComponentManager.getSortedComponentsByInstallOrder(tempComponents);
        tempComponents = new ArrayList();
        for (Component component4 : targetComponents) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(component4);
            for (Component selComp : selGroupComps) {
                if (tempComponents.contains(selComp)) continue;
                tempComponents.add(selComp);
            }
            if (tempComponents.contains(component4)) continue;
            tempComponents.add(component4);
        }
        for (Component component5 : ComponentManager.getSortedComponentsByInstallOrder(tempComponents)) {
            if (arrayList.contains(component5)) continue;
            arrayList.add(component5);
        }
        this.expandTreeItemsByComponents(arrayList);
        if (!this.checkAgreeEULA(arrayList)) {
            return;
        }
        if (PlatformUtil.isLinux() && !this.checkPrerequsites(arrayList)) {
            return;
        }
        TreeItem treeItem = this.getTreeItemByComponent(component);
        if (treeItem != null) {
            this.getInstallButton(treeItem).setDisabled(true);
        }
        this.createGroupInstallProcess(arrayList);
    }

    private void createGroupInstallProcess(ArrayList<Component> components) {
        for (Component comp : components) {
            if (comp.getInstallState() == Component.InstallState.UPDATE) {
                comp.setInstallState(Component.InstallState.UPDATING);
                continue;
            }
            comp.setInstallState(Component.InstallState.INSTALLING);
        }
        ViewController.getInstance().getProgressView().addGroupComponentsToInstall(components);
    }

    public void updateAllUpdatableComponents() {
        if (!UIUtil.findRunningProcess(this.getShell()).isEmpty() || !UIUtil.checkIfRepositoryIsOutdated(this.getShell())) {
            return;
        }
        ArrayList<Component> targetComponents = new ArrayList<Component>();
        for (Component component : this.customTreeItems) {
            if (component.hasChildren() || component.getInstallState() != Component.InstallState.UPDATE) continue;
            targetComponents.add(component);
        }
        if (targetComponents.isEmpty()) {
            return;
        }
        if (!this.checkAgreeEULA(targetComponents)) {
            return;
        }
        if (!this.checkPopup(targetComponents)) {
            return;
        }
        if (PlatformUtil.isLinux() && !this.checkPrerequsites(targetComponents)) {
            return;
        }
        if (!UIUtil.checkExtensionStatusOfInstallable(this.getShell(), targetComponents)) {
            return;
        }
        this.expandTreeItemsByComponents(targetComponents);
        ArrayList<Component> allComponents = new ArrayList<Component>();
        for (Component subComponent : targetComponents) {
            ArrayList<Component> selGroupComps = ComponentManager.getInstance().getSelectGroupComponentsToInstall(subComponent);
            for (Component selComp : selGroupComps) {
                if (allComponents.contains(selComp)) continue;
                allComponents.add(selComp);
            }
            if (allComponents.contains(subComponent)) continue;
            allComponents.add(subComponent);
        }
        ArrayList<Component> arrayList = ComponentManager.getSortedComponentsByInstallOrder(allComponents);
        this.createUpdateAllProcesses(arrayList);
    }

    private void createUpdateAllProcesses(ArrayList<Component> components) {
        for (Component comp : components) {
            comp.setDependentComponents(new ArrayList<Component>());
            if (comp.getInstallState() == Component.InstallState.UPDATE) {
                comp.setInstallState(Component.InstallState.UPDATING);
                this.getUninstallButton(this.getTreeItemByComponent(comp)).setDisabled(true);
                continue;
            }
            comp.setInstallState(Component.InstallState.INSTALLING);
        }
        ViewController.getInstance().getProgressView().addGroupComponentsToInstall(components);
    }

    public ArrayList<CustomTableIconButton> getAllTableIconButtons() {
        ArrayList<CustomTableIconButton> result = new ArrayList<CustomTableIconButton>();
        ArrayList<TreeItem> treeItems = this.getAllTreeItems();
        for (TreeItem treeItem : treeItems) {
            result.add(this.getLicenseButton(treeItem));
            result.add(this.getUpdateButton(treeItem));
            result.add(this.getInstallButton(treeItem));
            result.add(this.getUninstallButton(treeItem));
        }
        return result;
    }

    public ArrayList<CustomTableProfileImage> getAllTableProfileImages() {
        ArrayList<CustomTableProfileImage> result = new ArrayList<CustomTableProfileImage>();
        ArrayList<TreeItem> treeItems = this.getAllTreeItems();
        for (TreeItem treeItem : treeItems) {
            if (treeItem.getData() == null) continue;
            result.add(this.getProfileIconImage(treeItem));
        }
        return result;
    }

    public TreeItem getTreeItemByComponent(Component component) {
        for (TreeItem item : this.getAllTreeItems()) {
            if (item.isDisposed() || (Component)item.getData() == null || (Component)item.getData() != component) continue;
            return item;
        }
        return null;
    }

    private ArrayList<TreeItem> getAllTreeItems() {
        return this.getAllTreeItems(this.treeViewer.getTree().getItems());
    }

    private ArrayList<TreeItem> getAllTreeItems(TreeItem[] items) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        for (int i = 0; i < items.length; ++i) {
            TreeItem treeItem = items[i];
            result.add(treeItem);
            if (treeItem.getItemCount() <= 0) continue;
            result.addAll(this.getAllTreeItems(treeItem.getItems()));
        }
        return result;
    }

    public boolean existsUninstallingComponent() {
        for (Component comp : this.getAllComponents()) {
            if (comp.getInstallState() != Component.InstallState.UNINSTALLING) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Component> getAllComponents() {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component comp : this.customTreeItems) {
            for (Component subComp : this.getAllSubComponents(comp)) {
                if (result.contains(subComp)) continue;
                result.add(subComp);
            }
            if (result.contains(comp)) continue;
            result.add(comp);
        }
        return result;
    }

    private ArrayList<Component> getAllSubComponents(Component comp) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component subComp : comp.getChildren()) {
            if (!result.contains(subComp)) {
                result.add(subComp);
            }
            for (Component subComp1 : this.getAllSubComponents(subComp)) {
                if (result.contains(subComp1)) continue;
                result.add(subComp1);
            }
        }
        return result;
    }

    private void createInstallProcesses(Component component, ArrayList<Component> updatableComps, ArrayList<Component> selGroupComps) {
        ArrayList<Component> dependentComps = new ArrayList<Component>();
        dependentComps.addAll(selGroupComps);
        for (Component updatableComp : updatableComps) {
            if (dependentComps.contains(updatableComp)) continue;
            dependentComps.add(updatableComp);
        }
        component.setDependentComponents(dependentComps);
        this.expandTreeItemsByComponents(dependentComps);
        for (Component depComp : component.getDependentComponents()) {
            if (depComp.getInstallState() == Component.InstallState.UPDATE) {
                depComp.setInstallState(Component.InstallState.UPDATING);
                continue;
            }
            depComp.setInstallState(Component.InstallState.INSTALLING);
        }
        component.setInstallState(Component.InstallState.INSTALLING);
        ViewController.getInstance().getProgressView().addComponentToInstall(component);
    }

    public void showMobileComponents(boolean isShow) {
        this.setDefaultFocusForProfileIcon();
    }

    public void showWearableComponents(boolean isShow) {
        this.setDefaultFocusForProfileIcon();
    }

    public void showTVComponents(boolean isShow) {
        this.setDefaultFocusForProfileIcon();
    }

    public void removeExtraComponents() {
    }

    public void showInstalledComponents(boolean isShow) {
        this.setDefaultFocusForProfileIcon();
    }

    private void setDefaultFocusForProfileIcon() {
        TreeItem[] items;
        this.profileImages.clear();
        if (this.selectedItem != null && !this.selectedItem.isDisposed()) {
            this.profilSelectToParent(this.selectedItem, false);
            this.tableButtonSelectToParent(this.selectedItem, false);
        }
        if ((items = this.tree.getItems()) != null && items.length > 0 && !items[0].isDisposed()) {
            this.tree.setSelection(items[0]);
            this.profilSelectToParent(items[0], true);
            this.tableButtonSelectToParent(items[0], true);
            this.selectedItem = items[0];
        }
        this.treeViewer.refresh();
    }
}

