/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class TopButtonComposite {
    private Composite parent;
    private WizardUIResourceHandler uiRsrcHandler;
    private CommonTreeView componentTreeView;
    private CustomImageButton update;

    public TopButtonComposite(Composite parent, WizardUIResourceHandler uiRsrcHandler, CommonTreeView componentTreeView) {
        this.parent = parent;
        this.uiRsrcHandler = uiRsrcHandler;
        this.componentTreeView = componentTreeView;
    }

    public void createButtons() {
        Rectangle updateButtonBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_UPDATE_BUTTON);
        Rectangle installedBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_MARGIN_INSTALLED_FILTER);
        Composite allFilterComposite = new Composite(this.parent, 0x20000000);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        allFilterComposite.setLayout(gridLayout);
        allFilterComposite.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.createUpdateButton(updateButtonBounds, allFilterComposite);
        Composite dummy = new Composite(allFilterComposite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 17;
        dummy.setLayoutData(gridData);
        dummy.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void createUpdateButton(Rectangle updateButtonBounds, Composite allFilterComposite) {
        this.update = new CustomImageButton(allFilterComposite, 8);
        this.update.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_NORMAL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_UPDATE_BUTTON_DIS));
        GridData gridData = new GridData(4, 4, false, false);
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 1;
        gridData.widthHint = this.update.getImageBound().width;
        gridData.heightHint = this.update.getImageBound().height;
        gridData.verticalIndent = 15;
        this.update.setLayoutData(gridData);
        this.update.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                TopButtonComposite.this.updateAllClicked();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    public void updateAllClicked() {
        this.update.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (TopButtonComposite.this.componentTreeView.existsUninstallingComponent()) {
                    Display default1 = Display.getDefault();
                    Shell shell = new Shell(default1);
                    CustomMessageDialog.showDlg(shell, "Warning", "You cannot update packages while the Package Manager is uninstalling.", CustomMessageDialog.DialogType.ERROR, true);
                    shell.dispose();
                    shell.close();
                    return;
                }
            }
        });
        this.componentTreeView.updateAllUpdatableComponents();
    }

    public void refreshButtonStates(boolean value) {
        this.update.setVisible(value);
    }
}

