/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PlatformUtil;

public class PrerequisitesUtil {
    private static final Logger logger = Log.getLogger(PrerequisitesUtil.class);

    public static Map<String, List<String>> checkPrerequisities(List<Component> componentList) {
        String ubuntuVersion = PlatformUtil.getUbuntuVersion();
        if (ubuntuVersion == null) {
            return null;
        }
        HashMap<String, List<String>> notInstalledPrerequistiesMap = new HashMap<String, List<String>>();
        HashSet<String> alreadyCheckedSet = new HashSet<String>();
        PackageManager instance = PackageManager.getInstance();
        logger.info("Checking prerequisities start ...");
        for (Component component : componentList) {
            Collection<String> dependentPackageNames = component.getRepoPackage().getDependentPackageNames();
            for (String pkgname : dependentPackageNames) {
                PrerequisitesUtil.checkChildPackagePrerequisities(ubuntuVersion, notInstalledPrerequistiesMap, alreadyCheckedSet, instance, instance.getPackageByName(pkgname));
            }
            PrerequisitesUtil.getPrerequisites(ubuntuVersion, notInstalledPrerequistiesMap, alreadyCheckedSet, component.getRepoPackage());
        }
        logger.info("Checking prerequisities end ...");
        return notInstalledPrerequistiesMap;
    }

    private static void checkChildPackagePrerequisities(String ubuntuVersion, Map<String, List<String>> notInstalledPrerequistiesMap, HashSet<String> alreadyCheckedSet, PackageManager instance, Package pkg) {
        if (pkg != null) {
            Collection<String> dependentPackageNames = pkg.getDependentPackageNames();
            if (dependentPackageNames != null) {
                for (String cPkgName : dependentPackageNames) {
                    PrerequisitesUtil.checkChildPackagePrerequisities(ubuntuVersion, notInstalledPrerequistiesMap, alreadyCheckedSet, instance, instance.getPackageByName(cPkgName));
                }
            }
            PrerequisitesUtil.getPrerequisites(ubuntuVersion, notInstalledPrerequistiesMap, alreadyCheckedSet, pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getPrerequisites(String ubuntuVersion, Map<String, List<String>> notInstalledPrerequistiesMap, HashSet<String> alreadyCheckedSet, Package pkg) {
        String prerequisites = pkg.getPrerequisites();
        if (prerequisites != null && prerequisites.length() > 0) {
            prerequisites = prerequisites.trim();
            String[] split = prerequisites.split(",");
            ArrayList<String> notInstalledList = new ArrayList<String>();
            for (String requiredPackage : split) {
                String requiredPkg = requiredPackage.trim();
                if (requiredPkg.contains("[")) {
                    String requiredVersion = requiredPkg.substring(requiredPkg.indexOf("[") + 1, requiredPkg.indexOf("]")).trim();
                    String[] versionSplit = requiredVersion.split(" ");
                    List<String> asList = Arrays.asList(versionSplit);
                    if (!asList.contains(ubuntuVersion)) continue;
                    requiredPkg = requiredPkg.substring(0, requiredPkg.indexOf("[")).trim();
                }
                if (alreadyCheckedSet.contains(requiredPkg)) {
                    if (!notInstalledPrerequistiesMap.containsKey(requiredPkg)) continue;
                    List<String> list = notInstalledPrerequistiesMap.get(requiredPkg);
                    if (!list.contains(pkg.getPackageName())) {
                        list.add(pkg.getPackageName());
                    }
                    notInstalledPrerequistiesMap.put(requiredPkg, list);
                    continue;
                }
                alreadyCheckedSet.add(requiredPkg);
                String cmd = String.format("dpkg -l %s | grep ^ii", requiredPkg);
                ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
                Process proc = null;
                try {
                    proc = pb.start();
                    BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    int count = 0;
                    while ((line = read.readLine()) != null) {
                        if (!line.contains(requiredPkg)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        if (notInstalledPrerequistiesMap.containsKey(requiredPkg)) {
                            List<String> list = notInstalledPrerequistiesMap.get(requiredPkg);
                            list.add(pkg.getPackageName());
                            notInstalledPrerequistiesMap.remove(requiredPkg);
                            notInstalledPrerequistiesMap.put(requiredPkg, list);
                        } else {
                            notInstalledList.add(pkg.getPackageName());
                            notInstalledPrerequistiesMap.put(requiredPkg, notInstalledList);
                            logger.trace("\t[" + pkg.getPackageName() + "] needs these packages : " + prerequisites);
                        }
                    }
                    proc.waitFor();
                    proc.destroy();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                finally {
                    if (proc != null) {
                        proc.destroy();
                    }
                }
            }
        }
    }
}

