/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.layout.Rfc5424Layout;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.EnglishEnums;

@Plugin(name="Syslog", category="Core", elementType="appender", printObject=true)
public class SyslogAppender
extends SocketAppender {
    protected static final String RFC5424 = "RFC5424";

    protected SyslogAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, AbstractSocketManager manager, Advertiser advertiser) {
        super(name, layout, filter, manager, ignoreExceptions, immediateFlush, advertiser);
    }

    @PluginFactory
    public static SyslogAppender createAppender(@PluginAttribute(value="host") String host, @PluginAttribute(value="port", defaultInt=0) int port, @PluginAttribute(value="protocol") String protocolStr, @PluginElement(value="SSL") SslConfiguration sslConfig, @PluginAttribute(value="reconnectionDelay", defaultInt=0) int reconnectionDelay, @PluginAttribute(value="immediateFail", defaultBoolean=true) boolean immediateFail, @PluginAttribute(value="name") String name, @PluginAttribute(value="immediateFlush", defaultBoolean=true) boolean immediateFlush, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions, @PluginAttribute(value="facility", defaultString="LOCAL0") Facility facility, @PluginAttribute(value="id") String id2, @PluginAttribute(value="enterpriseNumber", defaultInt=18060) int enterpriseNumber, @PluginAttribute(value="includeMdc", defaultBoolean=true) boolean includeMdc, @PluginAttribute(value="mdcId") String mdcId, @PluginAttribute(value="mdcPrefix") String mdcPrefix, @PluginAttribute(value="eventPrefix") String eventPrefix, @PluginAttribute(value="newLine", defaultBoolean=false) boolean newLine, @PluginAttribute(value="newLineEscape") String escapeNL, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="messageId") String msgId, @PluginAttribute(value="mdcExcludes") String excludes, @PluginAttribute(value="mdcIncludes") String includes, @PluginAttribute(value="mdcRequired") String required, @PluginAttribute(value="format") String format, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charsetName, @PluginAttribute(value="exceptionPattern") String exceptionPattern, @PluginElement(value="LoggerFields") LoggerFields[] loggerFields, @PluginAttribute(value="advertise", defaultBoolean=false) boolean advertise) {
        SyslogLayout layout;
        Protocol protocol = EnglishEnums.valueOf(Protocol.class, protocolStr);
        boolean useTlsMessageFormat = sslConfig != null || protocol == Protocol.SSL;
        AbstractStringLayout abstractStringLayout = layout = RFC5424.equalsIgnoreCase(format) ? Rfc5424Layout.createLayout(facility, id2, enterpriseNumber, includeMdc, mdcId, mdcPrefix, eventPrefix, newLine, escapeNL, appName, msgId, excludes, includes, required, exceptionPattern, useTlsMessageFormat, loggerFields, config) : SyslogLayout.createLayout(facility, newLine, escapeNL, charsetName);
        if (name == null) {
            LOGGER.error("No name provided for SyslogAppender");
            return null;
        }
        AbstractSocketManager manager = SyslogAppender.createSocketManager(name, protocol, host, port, sslConfig, reconnectionDelay, immediateFail, layout);
        return new SyslogAppender(name, (Layout<? extends Serializable>)layout, filter, ignoreExceptions, immediateFlush, manager, advertise ? config.getAdvertiser() : null);
    }
}

