/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui;

import java.io.File;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.CompatController;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.Performance;
import org.tizen.manager.core.SelfUpdater;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.mac.CocoaUtil;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.packagemanager.ui.UIMainOptions;
import org.tizen.packagemanager.ui.UIProxyAuthenticator;
import org.tizen.packagemanager.ui.exception.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.page.PackageManagerMainWindow;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.util.UIUtil;

public class UIMain {
    private static Logger logger = null;
    private static PackageManagerMainWindow window;
    private static Shell shell;
    private static ContentProvider contentProvider;
    private static boolean isInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
            }
        });
        Performance.setIMStartTime();
        Log.open();
        Log.logTitle("Package Manager start");
        Log.logInfo(PlatformUtil.getPlatformInfo());
        Log.logInfo("Directory of running Installer : " + PathUtil.getCurrentDir());
        logger = Log.getLogger(UIMain.class);
        UIMain.initializeDisplay();
        int exitCode = 0;
        try {
            contentProvider = new ContentProvider();
            logger.trace("Command line options => " + Arrays.toString(args));
            UIMainOptions.loadCmdArgs(args);
            if (!UIMainOptions.noJavaVersionCheck && !UIUtil.checkJavaRuntime()) {
                return;
            }
            if (PlatformUtil.isMacOS()) {
                logger.trace("Initializing MAC Application...");
                UIMain.initializeAppForMacOS();
            }
            contentProvider.getSDKInfo().init();
            contentProvider.getSDKInfo().save(true);
            int pmInstances = 0;
            if (!UIMainOptions.noDuplicateCheck) {
                ProgramController controller = ProgramController.createProgramController(contentProvider.getSDKInfo());
                List<String> sdkProcessList = controller.getSDKProcessList();
                String instanceName = "";
                for (String progName : sdkProcessList) {
                    if (!progName.equals(ProgramController.PROG_NAME_MANAGER) && !progName.equals(ProgramController.PROG_NAME_MANAGER_CLI) && !progName.equals(ProgramController.PROG_NAME_UNINSTALLER)) continue;
                    ++pmInstances;
                    if (!progName.equals(ProgramController.PROG_NAME_MANAGER)) {
                        instanceName = progName;
                        continue;
                    }
                    if (!instanceName.equals("")) continue;
                    instanceName = progName;
                }
                if (pmInstances == 2) {
                    int showDlg = 0;
                    do {
                        if ((showDlg = CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Warning", String.format("You cannot launch the Package Manager because the %s is still running.\nTo launch the Package Manager, close first another Package Manager and try it again.\nDo you want check again?", instanceName), CustomMessageDialog.DialogType.WARNING, false)) != 64) continue;
                        pmInstances = 0;
                        sdkProcessList = controller.getSDKProcessList();
                        instanceName = "";
                        for (String progName : sdkProcessList) {
                            if (!progName.equals(ProgramController.PROG_NAME_MANAGER) && !progName.equals(ProgramController.PROG_NAME_MANAGER_CLI) && !progName.equals(ProgramController.PROG_NAME_UNINSTALLER)) continue;
                            ++pmInstances;
                            if (!progName.equals(ProgramController.PROG_NAME_MANAGER)) {
                                instanceName = progName;
                                continue;
                            }
                            if (!instanceName.equals("")) continue;
                            instanceName = progName;
                        }
                    } while (showDlg == 64 && pmInstances > 1);
                    if (showDlg != 64) {
                        return;
                    }
                } else if (pmInstances > 2) {
                    return;
                }
            }
            boolean selfUpdateNeeded = UIMain.initialize();
            isInitialized = true;
            if (selfUpdateNeeded) {
                return;
            }
            if (UIUtil.compatUninstaller(contentProvider)) {
                return;
            }
            window = new PackageManagerMainWindow(contentProvider);
            window.run();
            shell = window.getShell();
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                try {
                    if (shell.getDisplay().readAndDispatch()) continue;
                    shell.getDisplay().sleep();
                }
                catch (Throwable e) {
                    logger.throwing(e);
                }
            }
            logger.info("after install manager window init");
        }
        catch (Throwable e) {
            logger.throwing(e);
            if (e instanceof Exception) {
                InsideTroubleShootingDialog.open(new Shell(Display.getDefault()), (Exception)e);
            } else {
                UIUtil.showErrorMessage(e.getMessage());
            }
            exitCode = 4;
        }
        finally {
            Performance.summarize();
            UIMain.finalizeUIMain();
            try {
                UIUtil.disposeDisplay();
            }
            catch (Exception exception) {}
            Log.logTitle("Package Manager was terminated!");
            System.exit(exitCode);
        }
    }

    private static void initializeDisplay() {
        Display display = new Display();
        display.close();
    }

    private static void initializeAppForMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Package Manager");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new CocoaUtil().hidePreferencesAndAboutMenuItems();
            }
        });
    }

    private static boolean initialize() throws UMException {
        logger.info("Start to initialize Package Manager...");
        boolean isSelfUpdateNeeded = false;
        Shell initShell = new Shell(Display.getDefault());
        try {
            final CustomProgressDialog progressBar = new CustomProgressDialog(initShell, null);
            Authenticator.setDefault(new UIProxyAuthenticator(initShell, "Proxy Authentication is required."));
            isSelfUpdateNeeded = progressBar.run(new CallableWithMonitor<Boolean>(){

                @Override
                public Boolean call(IProgressMonitor monitor) throws Exception {
                    boolean isSelfUpdateNeeded = false;
                    try {
                        monitor.beginTask("Initializing...", -1);
                        logger.trace("Cleaning up temporay files and diretories...");
                        monitor.subTask("Cleaning up temporary files...");
                        PathUtil.cleanUpTempFilesAndDirectory(contentProvider.getSDKInfo());
                        logger.trace("Initializing core controller...");
                        UIMain.initializeCoreControllers(progressBar);
                        logger.trace("Initializing core controller done...");
                        monitor.subTask("Making Package Manager configurations...");
                        logger.trace("\tSetting compatibility, If it is needeed.");
                        CompatController compatController = new CompatController(contentProvider);
                        if (compatController.needCompatibility()) {
                            compatController.compatamize();
                        }
                        compatController.applyPatches();
                        logger.trace("Checking self-update...");
                        monitor.subTask("Checking self-update...");
                        isSelfUpdateNeeded = UIMain.checkSelfUpdate();
                    }
                    catch (UMException e) {
                        throw new UMException(ErrorController.ErrorCode.INITIALIZING_FAILED, (Throwable)e);
                    }
                    finally {
                        monitor.done();
                    }
                    return isSelfUpdateNeeded;
                }
            });
        }
        catch (UMException e) {
            throw e;
        }
        finally {
            initShell.close();
        }
        logger.info("Finished initializing Package Manager.");
        return isSelfUpdateNeeded;
    }

    public static void initializeCoreControllers(IProgressMonitor monitor) throws UMException {
        monitor.subTask("Loading configuration...");
        logger.trace("\tInitializing configuration file.");
        contentProvider.getConfig().init();
        monitor.subTask("Connecting to package server...");
        logger.trace("\tInitializing repository manager.");
        try {
            contentProvider.getRepoMgr().init();
        }
        catch (UMException e) {
            logger.throwing(e);
        }
        monitor.subTask("Loading alternative repositories...");
        logger.trace("\tInitializing alternative manager.");
        contentProvider.getAlterMgr().init(true);
        monitor.subTask("Loading extension repositories...");
        logger.trace("\tInitializing extension repository manager.");
        contentProvider.getExtRepoMgr().init(true);
        monitor.subTask("Removing unused extension caches...");
        logger.trace("\tRemoving unused extension caches.");
        UIMain.cleanUpExtensionCaches(contentProvider.getExtRepoMgr());
        monitor.subTask("Loading package information...");
        logger.trace("\tInitializing package manager.");
        contentProvider.getPkgMgr().init(true);
        logger.trace("\tInitializing component manager.");
        contentProvider.getCompMgr().init();
        logger.trace("\tInitializing install controller.");
        contentProvider.getInstController().init();
    }

    private static void cleanUpExtensionCaches(ExtRepositoryManager extRepoMgr) {
        ArrayList<ExtensionInformation> currentExtensions = extRepoMgr.getCurrentExtensions();
        ArrayList<String> extIds = new ArrayList<String>();
        for (ExtensionInformation extInfo : currentExtensions) {
            if (!extInfo.getRepotype().equalsIgnoreCase("file")) continue;
            extIds.add(extInfo.getId());
        }
        String cachePath = extRepoMgr.getExtCacheDirBySDK();
        File cacheDir = new File(cachePath);
        String[] list = cacheDir.list();
        if (cacheDir.exists() && list != null) {
            for (String id2 : list) {
                if (extIds.contains(id2)) continue;
                extRepoMgr.removeFromCache(id2);
            }
        }
    }

    private static boolean checkSelfUpdate() {
        SelfUpdater selfUpdater = new SelfUpdater(contentProvider);
        if (selfUpdater.canManagerUpdate()) {
            try {
                selfUpdater.updateManager();
                return true;
            }
            catch (Throwable e) {
                logger.throwing(e);
                return false;
            }
        }
        return false;
    }

    private static void finalizeUIMain() {
        if (isInitialized) {
            if (!contentProvider.getExtRepoMgr().getCurrentExtensions().isEmpty() && new File(PathUtil.getFromInstalledPath(contentProvider.getSDKInfo(), ".info")).exists()) {
                contentProvider.getExtRepoMgr().writeToFile();
            }
            PathUtil.cleanUpTempDownloadDirectory(contentProvider.getSDKInfo());
            contentProvider.getInstController().threadForceShutdown();
        }
        Performance.setIMEndTime();
        Performance.printToLogFile();
    }

    static {
        shell = null;
        contentProvider = null;
        isInitialized = false;
    }
}

