/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.packagemanager.ui.dialog.NotifierDialog;
import org.tizen.packagemanager.ui.page.ProgressTabView;
import org.tizen.packagemanager.ui.page.ViewController;

public class TotalProgressMonitor {
    private ProgressTabView parentView;
    private ArrayList<ICommonProgressMonitor> workingMonitors;
    private ArrayList<ICommonProgressMonitor> doneMonitors;
    private int currentPercent = 0;
    private double totalPercent = 0.0;
    private double totalSize = 0.0;
    private double startTime = 0.0;
    private Thread remainTimeThread = null;
    private final int SEC = 1;
    private final int MIN = 60;
    private final int HOUR = 3600;
    private final int TIME_DELAY = 500;
    private double remainTime = 0.0;
    private ContentProvider contentProvider;
    private ViewController viewController;

    public TotalProgressMonitor(ContentProvider contentProvider, ViewController viewController, ProgressTabView parentView) {
        this.contentProvider = contentProvider;
        this.viewController = viewController;
        this.parentView = parentView;
        this.workingMonitors = new ArrayList();
        this.doneMonitors = new ArrayList();
    }

    public void refreshTotalSize() {
        this.totalSize = 0.0;
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            this.totalSize += (double)monitor.getWorkingSize().longValue();
        }
    }

    public void begin(double startTime) {
        if (this.startTime == 0.0) {
            this.startTime = startTime;
        }
    }

    public void setRemainingTime() {
        if (this.remainTimeThread == null) {
            this.remainTimeThread = new Thread(){

                @Override
                public void run() {
                    while (!TotalProgressMonitor.this.isAllMonitorsDone()) {
                        if (Display.getDefault() != null && !Display.getDefault().isDisposed()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TotalProgressMonitor.this.updateRemainingTime();
                                }
                            });
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    TotalProgressMonitor.this.remainTimeThread = null;
                }
            };
            this.remainTimeThread.start();
        }
    }

    private synchronized void updateRemainingTime() {
        double remain = 100.0 - this.totalPercent;
        double past = (double)System.currentTimeMillis() - this.startTime;
        double tickAvg = this.totalPercent / (past / 1000.0);
        double calcTime = remain / tickAvg;
        this.remainTime = calcTime - this.remainTime >= 10.0 ? (this.remainTime += 10.0) : (calcTime - this.remainTime >= 2.0 ? (this.remainTime += 1.0) : (calcTime - this.remainTime <= -10.0 ? (this.remainTime -= 10.0) : (calcTime - this.remainTime <= -2.0 ? (this.remainTime -= 2.0) : calcTime)));
        this.parentView.setRemainTimeText(this.getRemainTimeString());
    }

    public synchronized void updateTotalWorked() {
        this.totalPercent = 0.0;
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            double ratePercent = (double)monitor.getWorkingSize().longValue() / this.totalSize * (double)monitor.getWorked();
            this.totalPercent += ratePercent;
        }
        NotifierDialog notiDlg = new NotifierDialog(this.viewController, this.parentView.getShell());
        if (this.isAllMonitorsDone()) {
            String msg = "";
            HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> failMap = this.getFailedMapFromAllMonitors();
            if (failMap != null && !failMap.isEmpty()) {
                HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> map = failMap;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry == null) continue;
                    ICommonProgressMonitor.ProgressMonitorType type = (ICommonProgressMonitor.ProgressMonitorType)((Object)entry.getKey());
                    ArrayList failList = (ArrayList)entry.getValue();
                    if (type == null || type == ICommonProgressMonitor.ProgressMonitorType.NONE || failList == null || failList.size() <= 0) continue;
                    msg = "The installation/update has been failed,\nClick here to check the installation/update status.";
                    notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.FAIL);
                }
            } else {
                ArrayList<ICommonProgressMonitor.ProgressMonitorType> cancelTypeList = this.getCancelProgressTypeList();
                if (cancelTypeList != null && !cancelTypeList.isEmpty()) {
                    for (int i = 0; i < cancelTypeList.size(); ++i) {
                        String cancelMsg = cancelTypeList.get(i).getMessageIng();
                        if (cancelMsg.equals("Updating")) {
                            cancelMsg = "update";
                        }
                        if (cancelMsg.equals("Installing")) {
                            cancelMsg = "installation";
                        }
                        if (cancelMsg.equals("Removing")) {
                            cancelMsg = "removal";
                        }
                        msg = String.format("The %s has been canceled,\nClick here to check the %s status.", cancelMsg, cancelMsg);
                        notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.CANCEL);
                    }
                } else {
                    ArrayList<ICommonProgressMonitor.ProgressMonitorType> successTypeList = this.getSuccessProgressTypeList();
                    if (successTypeList != null && !successTypeList.isEmpty()) {
                        for (int i = 0; i < successTypeList.size(); ++i) {
                            String successMsg = successTypeList.get(i).getMessageIng();
                            if (successMsg.equals("Updating")) {
                                successMsg = "update";
                            }
                            if (successMsg.equals("Installing")) {
                                successMsg = "installation";
                            }
                            if (successMsg.equals("Removing")) {
                                successMsg = "removal";
                            }
                            msg = String.format("The %s has been completed successfully.", successMsg);
                            notiDlg.notify("Package Manager", msg, NotifierDialog.NotiType.SUCCESS);
                        }
                    }
                }
            }
            this.totalWorked(100);
            this.refresh();
            this.contentProvider.getInstController().getDownloadMgr().clearMap();
            if (!this.contentProvider.getPkgMgr().getInstalledPackages().isEmpty() && !this.contentProvider.getPkgMgr().getRepoPackages().isEmpty()) {
                PackageInfoJSON.savePackageInfoToFile(this.contentProvider.getSDKInfo(), this.contentProvider.getPkgMgr());
            }
        } else {
            this.totalWorked((int)this.totalPercent);
        }
    }

    private String getRemainTimeString() {
        String remainTimeStr = "";
        int remainTimeInt = (int)Math.ceil(this.remainTime);
        int hour = remainTimeInt / 3600;
        int min = (remainTimeInt - hour * 3600) / 60;
        int sec = (remainTimeInt - hour * 3600 - min * 60) / 1;
        remainTimeStr = String.format("%02d:%02d:%02d", hour, min, sec);
        return remainTimeStr;
    }

    public void totalWorked(int percent) {
        this.currentPercent = percent;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TotalProgressMonitor.this.parentView.getMainWindow().getProgressBar().setProgress(TotalProgressMonitor.this.currentPercent);
            }
        });
    }

    public void addWorkingMonitor(ICommonProgressMonitor monitor) {
        this.workingMonitors.add(monitor);
    }

    public void addDoneMonitor(ICommonProgressMonitor monitor) {
        this.doneMonitors.add(monitor);
    }

    private boolean isAllMonitorsDone() {
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (monitor.isDone()) continue;
            return false;
        }
        return true;
    }

    private HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> getFailedMapFromAllMonitors() {
        HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>> failMap = new HashMap<ICommonProgressMonitor.ProgressMonitorType, ArrayList<Component>>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (!monitor.isFailed()) continue;
            Component component = monitor.getComponent();
            ICommonProgressMonitor.ProgressMonitorType type = monitor.getProgressMonitorType();
            if (component == null || type == ICommonProgressMonitor.ProgressMonitorType.NONE) continue;
            ArrayList<Object> failList = null;
            failList = failMap.containsKey((Object)type) ? failMap.get((Object)type) : new ArrayList();
            failList.add(component);
            failMap.put(type, failList);
        }
        return failMap;
    }

    private ArrayList<ICommonProgressMonitor.ProgressMonitorType> getCancelProgressTypeList() {
        ArrayList<ICommonProgressMonitor.ProgressMonitorType> cancelTypeList = new ArrayList<ICommonProgressMonitor.ProgressMonitorType>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (!monitor.isCanceled() || cancelTypeList.contains((Object)monitor.getProgressMonitorType())) continue;
            cancelTypeList.add(monitor.getProgressMonitorType());
        }
        return cancelTypeList;
    }

    private ArrayList<ICommonProgressMonitor.ProgressMonitorType> getSuccessProgressTypeList() {
        ArrayList<ICommonProgressMonitor.ProgressMonitorType> successTypeList = new ArrayList<ICommonProgressMonitor.ProgressMonitorType>();
        for (ICommonProgressMonitor monitor : this.workingMonitors) {
            if (monitor.isCanceled() || monitor.isFailed() || successTypeList.contains((Object)monitor.getProgressMonitorType())) continue;
            successTypeList.add(monitor.getProgressMonitorType());
        }
        return successTypeList;
    }

    public void refresh() {
        this.workingMonitors.clear();
        this.totalSize = 0.0;
        this.startTime = 0.0;
        this.totalPercent = 0.0;
        this.remainTime = 0.0;
        this.parentView.setRemainTimeText("00:00:00");
    }

    public boolean isDone() {
        return this.isAllMonitorsDone();
    }
}

