/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventProperty;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk.XVisibilityEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    int[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    int fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    int eventProc;
    int filterProc;
    int windowProc2;
    int windowProc3;
    int windowProc4;
    int windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    int[] closures;
    int[] signalIds;
    int shellMapProcClosure;
    int[] indexTable;
    int freeSlot;
    int lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Control imControl;
    int preeditWindow;
    int preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    int caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    int mouseHoverHandle;
    int mouseHoverProc;
    Callback mouseHoverCallback;
    int menuPositionProc;
    Callback menuPositionCallback;
    int sizeAllocateProc;
    Callback sizeAllocateCallback;
    int sizeRequestProc;
    Callback sizeRequestCallback;
    int shellMapProc;
    Callback shellMapCallback;
    int idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    int cellDataProc;
    Callback cellDataCallback;
    int setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    int emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    int allChildrenProc;
    int allChildren;
    Callback allChildrenCallback;
    int signalProc;
    Callback signalCallback;
    int shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_SET = 1;
    static final int PROPERTY_NOTIFY = 2;
    boolean entrySelectOnFocus;
    Control currentControl;
    int checkIfEventProc;
    Callback checkIfEventCallback;
    int flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    XVisibilityEvent visibilityEvent = new XVisibilityEvent();
    int[] flushData = new int[1];
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    int pangoLayoutNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static int fixed_type;
    static int fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static Callback fixedSizeAllocateCallback;
    static int fixedClassInitProc;
    static int fixedMapProc;
    static int fixedSizeAllocateProc;
    static int oldFixedSizeAllocateProc;
    static int text_renderer_type;
    static int pixbuf_renderer_type;
    static int toggle_renderer_type;
    static int text_renderer_info_ptr;
    static int pixbuf_renderer_info_ptr;
    static int toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererGetSizeCallback;
    static int rendererClassInitProc;
    static int rendererRenderProc;
    static int rendererGetSizeProc;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int MAJOR = 2;
    static final int MINOR = 2;
    static final int MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int resizeTrimWidth = 6;
    int resizeTrimHeight = 6;
    int titleBorderTrimWidth = 5;
    int titleBorderTrimHeight = 28;
    int titleResizeTrimWidth = 6;
    int titleResizeTrimHeight = 29;
    int titleTrimWidth = 0;
    int titleTrimHeight = 23;
    boolean ignoreTrim;
    String windowManager;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(byArray);
        byArray = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(byArray);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    void addGdkEvent(int n) {
        int n2;
        if (this.gdkEvents == null) {
            n2 = 1024;
            this.gdkEvents = new int[n2];
            this.gdkEventWidgets = new Widget[n2];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            n2 = this.gdkEventCount + 1024;
            int[] nArray = new int[n2];
            System.arraycopy(this.gdkEvents, 0, nArray, 0, this.gdkEventCount);
            this.gdkEvents = nArray;
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.gdkEventWidgets, 0, widgetArray, 0, this.gdkEventCount);
            this.gdkEventWidgets = widgetArray;
        }
        Widget widget = null;
        int n3 = OS.gtk_get_event_widget(n);
        if (n3 != 0) {
            while ((widget = this.getWidget(n3)) == null && (n3 = OS.gtk_widget_get_parent(n3)) != 0) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = n;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = OS.g_idle_add(this.idleProc, 0);
            }
        }
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    int allChildrenProc(int n, int n2) {
        this.allChildren = OS.g_list_append(this.allChildren, n);
        if (n2 != 0 && OS.GTK_IS_CONTAINER(n)) {
            OS.gtk_container_forall(n, this.allChildrenProc, n2);
        }
        return 0;
    }

    void addMouseHoverTimeout(int n) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = OS.g_timeout_add(400, this.mouseHoverProc, n);
        this.mouseHoverHandle = n;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(int n, Widget widget) {
        int n2;
        if (n == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            int n3 = this.freeSlot;
            while (n3 < n2 - 1) {
                nArray[n3] = n3 + 1;
                ++n3;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        n2 = this.freeSlot + 1;
        OS.g_object_set_qdata(n, SWT_OBJECT_INDEX, n2);
        int n4 = this.freeSlot;
        this.freeSlot = this.indexTable[n4];
        this.indexTable[n4] = -2;
        this.widgetTable[n4] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0);
                }
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        if (!OS.GDK_WINDOWING_X11()) {
            OS.gdk_flush();
        } else {
            int n = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            OS.XFlush(n);
        }
    }

    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n5);
        if (widget == null) {
            return 0;
        }
        return widget.cellDataProc(n, n2, n3, n4, n5);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] != null) {
                    if (!bl) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[n].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int checkIfEventProc(int n, int n2, int n3) {
        int n4;
        int n5 = OS.X_EVENT_TYPE(n2);
        switch (n5) {
            case 15: {
                if (OS.GTK_VERSION < OS.VERSION(2, 17, 11)) break;
                return 0;
            }
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0;
            }
        }
        int n6 = 0;
        n6 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), OS.X_EVENT_WINDOW(n2)) : OS.gdk_window_lookup(OS.X_EVENT_WINDOW(n2));
        if (n6 == 0) {
            return 0;
        }
        if (this.flushWindow != 0) {
            if (this.flushAll) {
                n4 = n6;
                while (n4 != this.flushWindow && (n4 = OS.gdk_window_get_parent(n4)) != 0) {
                }
                if (n4 != this.flushWindow) {
                    return 0;
                }
            } else if (n6 != this.flushWindow) {
                return 0;
            }
        }
        OS.memmove(this.exposeEvent, n2, XExposeEvent.sizeof);
        switch (n5) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = this.exposeEvent.width;
                this.flushRect.height = this.exposeEvent.height;
                OS.gdk_window_invalidate_rect(n6, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(n2, this.exposeEvent, XExposeEvent.sizeof);
                break;
            }
            case 15: {
                Control control;
                Widget widget;
                OS.memmove(this.visibilityEvent, n2, XVisibilityEvent.sizeof);
                OS.gdk_window_get_user_data(n6, this.flushData);
                n4 = this.flushData[0];
                Widget widget2 = widget = n4 != 0 ? this.getWidget(n4) : null;
                if (widget == null || !(widget instanceof Control) || n6 != (control = (Control)widget).paintWindow()) break;
                if (this.visibilityEvent.state == 2) {
                    control.state |= 0x40;
                    break;
                }
                control.state &= 0xFFFFFFBF;
            }
        }
        return 0;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) break;
            if (this.modalShells[n] == null) {
                return;
            }
            ++n;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        int n;
        int n2;
        Object object;
        int n3;
        if (!OS.g_thread_supported()) {
            OS.g_thread_init(0);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 24, 0)) {
            OS.gtk_set_locale();
        }
        if (!OS.gtk_init_check(new int[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if (OS.GDK_WINDOWING_X11()) {
            this.xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        }
        if ((n3 = OS.gtk_check_version(2, 2, 0)) != 0) {
            int n4 = OS.strlen(n3);
            object = new byte[n4];
            OS.memmove(object, n3, n4);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(null, object)));
            System.out.println("***WARNING: SWT requires GTK 2.2.0");
            n2 = OS.gtk_major_version();
            int n5 = OS.gtk_minor_version();
            n = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + n2 + "." + n5 + "." + n);
        }
        if (fixed_type == 0) {
            byte[] byArray = Converter.wcsToMbcs(null, "SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0) {
                this.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0) {
                this.error(3);
            }
            if ((fixedSizeAllocateProc = (fixedSizeAllocateCallback = new Callback(this.getClass(), "fixedSizeAllocateProc", 2)).getAddress()) == 0) {
                this.error(3);
            }
            object = new GTypeInfo();
            object.class_size = (short)OS.GtkFixedClass_sizeof();
            object.class_init = fixedClassInitProc;
            object.instance_size = (short)OS.GtkFixed_sizeof();
            fixed_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(fixed_info_ptr, (GTypeInfo)object, GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static(OS.GTK_TYPE_FIXED(), byArray, fixed_info_ptr, 0);
        }
        if (rendererClassInitProc == 0 && (rendererClassInitProc = (rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2)).getAddress()) == 0) {
            this.error(3);
        }
        if (rendererRenderProc == 0 && (rendererRenderProc = (rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", 7)).getAddress()) == 0) {
            this.error(3);
        }
        if (rendererGetSizeProc == 0 && (rendererGetSizeProc = (rendererGetSizeCallback = new Callback(this.getClass(), "rendererGetSizeProc", 7)).getAddress()) == 0) {
            this.error(3);
        }
        if (text_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererTextClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            object = Converter.wcsToMbcs(null, "SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TEXT(), object, text_renderer_info_ptr, 0);
        }
        if (pixbuf_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererPixbufClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererPixbuf_sizeof();
            pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(pixbuf_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            object = Converter.wcsToMbcs(null, "SwtPixbufRenderer", true);
            pixbuf_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_PIXBUF(), object, pixbuf_renderer_info_ptr, 0);
        }
        if (toggle_renderer_type == 0) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)OS.GtkCellRendererToggleClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)OS.GtkCellRendererToggle_sizeof();
            toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(toggle_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            object = Converter.wcsToMbcs(null, "SwtToggleRenderer", true);
            toggle_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TOGGLE(), object, toggle_renderer_info_ptr, 0);
        }
        OS.gtk_widget_set_default_direction(1);
        byte[] byArray = Converter.wcsToMbcs(null, APP_NAME, true);
        OS.g_set_prgname(byArray);
        OS.gdk_set_program_class(byArray);
        object = Converter.wcsToMbcs(null, "style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*.swt-toolbar-flat\" style : highest \"swt-flat\"", true);
        OS.gtk_rc_parse_string(object);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0) {
            this.error(3);
        }
        OS.gdk_event_handler_set(this.eventProc, 0, 0);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0) {
            this.error(3);
        }
        OS.gdk_window_add_filter(0, this.filterProc, 0);
        if (OS.GDK_WINDOWING_X11()) {
            n2 = OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(this.shellHandle));
            byte[] byArray2 = Converter.wcsToMbcs(null, "SWT_Window_" + APP_NAME, true);
            n = OS.XInternAtom(this.xDisplay, byArray2, false);
            OS.XSetSelectionOwner(this.xDisplay, n, n2, 0);
            OS.XGetSelectionOwner(this.xDisplay, n);
        }
        this.signalCallback = new Callback(this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (this.signalProc == 0) {
            this.error(3);
        }
        OS.gtk_widget_add_events(this.shellHandle, 65536);
        OS.g_signal_connect(this.shellHandle, OS.property_notify_event, this.signalProc, 2);
    }

    Image createImage(String string) {
        int n = OS.gtk_widget_get_default_style();
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n2 = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default(byArray), n, 0, 0, 6, 0, 0);
        if (n2 == 0) {
            return null;
        }
        int n3 = OS.gdk_pixbuf_get_width(n2);
        int n4 = OS.gdk_pixbuf_get_height(n2);
        int n5 = OS.gdk_pixbuf_get_rowstride(n2);
        boolean bl = OS.gdk_pixbuf_get_has_alpha(n2);
        int n6 = OS.gdk_pixbuf_get_pixels(n2);
        byte[] byArray2 = new byte[n5 * n4];
        OS.memmove(byArray2, n6, byArray2.length);
        OS.g_object_unref(n2);
        ImageData imageData = null;
        if (bl) {
            PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(n3, n4, 32, paletteData);
            byte[] byArray3 = new byte[n5 * n4];
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    byArray3[n7 * n3 + n8] = byArray2[n7 * n5 + n8 * 4 + 3];
                    byArray2[n7 * n5 + n8 * 4 + 3] = 0;
                    ++n8;
                }
                ++n7;
            }
            imageData.setAlphas(0, 0, n3 * n4, byArray3, 0);
        } else {
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(n3, n4, 24, paletteData);
        }
        imageData.data = byArray2;
        imageData.bytesPerLine = n5;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (display == Displays[n]) {
                    Display.Displays[n] = null;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    int emissionProc(int n, int n2, int n3, int n4) {
        if (OS.gtk_widget_get_toplevel(OS.g_value_peek_pointer(n3)) == n4) {
            OS.gtk_widget_set_direction(OS.g_value_peek_pointer(n3), 2);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                Display display = Displays[n];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    int eventProc(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n);
        if (n3 != 0) {
            this.lastEventTime = n3;
        }
        int n4 = OS.GDK_EVENT_TYPE(n);
        switch (n4) {
            case 4: 
            case 8: {
                this.lastUserEventTime = n3;
            }
        }
        boolean bl = true;
        if (this.dispatchEvents != null) {
            bl = false;
            int n5 = 0;
            while (n5 < this.dispatchEvents.length) {
                if (n4 == this.dispatchEvents[n5]) {
                    bl = true;
                    break;
                }
                ++n5;
            }
        }
        if (!bl) {
            this.addGdkEvent(OS.gdk_event_copy(n));
            return 0;
        }
        OS.gtk_main_do_event(n);
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0;
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(int n, int n2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int n) {
        this.checkDevice();
        return null;
    }

    static int fixedClassInitProc(int n, int n2) {
        GtkWidgetClass gtkWidgetClass = new GtkWidgetClass();
        OS.memmove(gtkWidgetClass, n);
        gtkWidgetClass.map = fixedMapProc;
        oldFixedSizeAllocateProc = gtkWidgetClass.size_allocate;
        gtkWidgetClass.size_allocate = fixedSizeAllocateProc;
        OS.memmove(n, gtkWidgetClass);
        return 0;
    }

    static int fixedMapProc(int n) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n);
        if (widget != null) {
            return widget.fixedMapProc(n);
        }
        return 0;
    }

    static int fixedSizeAllocateProc(int n, int n2) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n);
        if (widget != null) {
            return widget.fixedSizeAllocateProc(n, n2);
        }
        return OS.Call(oldFixedSizeAllocateProc, n, n2);
    }

    static int rendererClassInitProc(int n, int n2) {
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n);
        gtkCellRendererClass.render = rendererRenderProc;
        gtkCellRendererClass.get_size = rendererGetSizeProc;
        OS.memmove(n, gtkCellRendererClass);
        return 0;
    }

    static int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n2);
        if (widget != null) {
            return widget.rendererGetSizeProc(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    static int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(n3);
        if (widget != null) {
            return widget.rendererRenderProc(n, n2, n3, n4, n5, n6, n7);
        }
        return 0;
    }

    void flushExposes(int n, boolean bl) {
        OS.gdk_flush();
        OS.gdk_flush();
        if (OS.GDK_WINDOWING_X11()) {
            this.flushWindow = n;
            this.flushAll = bl;
            int n2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n3 = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(n2, n3, this.checkIfEventProc, 0);
            OS.g_free(n3);
            this.flushWindow = 0;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        int n = OS.gtk_settings_get_default();
        if (n == 0) {
            return 500;
        }
        int[] nArray = new int[1];
        OS.g_object_get(n, OS.gtk_cursor_blink, nArray, 0);
        if (nArray[0] == 0) {
            return 0;
        }
        OS.g_object_get(n, OS.gtk_cursor_blink_time, nArray, 0);
        if (nArray[0] == 0) {
            return 500;
        }
        return nArray[0] / 2;
    }

    public Control getCursorControl() {
        Object object;
        Object object2;
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = 0;
        int[] nArray3 = new int[1];
        int n2 = OS.gdk_window_at_pointer(nArray, nArray2);
        if (n2 != 0) {
            OS.gdk_window_get_user_data(n2, nArray3);
            n = nArray3[0];
        } else {
            int n3;
            if (!OS.GDK_WINDOWING_X11()) {
                return null;
            }
            OS.gdk_error_trap_push();
            object2 = new int[1];
            object = new int[1];
            int[] nArray4 = new int[1];
            int n4 = OS.XDefaultRootWindow(this.xDisplay);
            do {
                if (OS.XQueryPointer(this.xDisplay, n4, (int[])object, nArray4, object2, object2, object2, object2, object2) == 0) {
                    n = 0;
                    break;
                }
                n3 = nArray4[0];
                if (n3 == 0) continue;
                n4 = n3;
                int n5 = 0;
                n5 = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_window_lookup_for_display(OS.gdk_display_get_default(), n3) : OS.gdk_window_lookup(n3);
                if (n5 == 0) continue;
                OS.gdk_window_get_user_data(n5, nArray3);
                if (nArray3[0] == 0) continue;
                n = nArray3[0];
            } while (n3 != 0);
            OS.gdk_error_trap_pop();
        }
        if (n == 0) {
            return null;
        }
        do {
            if ((object2 = (Object)this.getWidget(n)) == null || !(object2 instanceof Control) || !((Control)(object = (Object)((Control)object2))).isEnabled()) continue;
            return object;
        } while ((n = OS.gtk_widget_get_parent(n)) != 0);
        return null;
    }

    static GtkBorder getEntryInnerBorder(int n) {
        GtkBorder gtkBorder = new GtkBorder();
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            int n2 = OS.gtk_entry_get_inner_border(n);
            if (n2 != 0) {
                OS.memmove(gtkBorder, n2, GtkBorder.sizeof);
                return gtkBorder;
            }
            int[] nArray = new int[1];
            OS.gtk_widget_style_get(n, OS.inner_border, nArray, 0);
            if (nArray[0] != 0) {
                OS.memmove(gtkBorder, nArray[0], GtkBorder.sizeof);
                OS.gtk_border_free(nArray[0]);
                return gtkBorder;
            }
        }
        gtkBorder.left = 2;
        gtkBorder.top = 2;
        gtkBorder.right = 2;
        gtkBorder.bottom = 2;
        return gtkBorder;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    int filterProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.filterProc(n, n2, n3);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_pointer(0, nArray, nArray2, null);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (string.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (string.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (string.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    int gtk_fixed_get_type() {
        return fixed_type;
    }

    int gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    int gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    int gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] nArray = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            int n = OS.gtk_settings_get_default();
            OS.g_object_get(n, OS.gtk_alternative_button_order, nArray, 0);
        }
        return nArray[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        int n = OS.gtk_settings_get_default();
        int[] nArray = new int[1];
        OS.g_object_get(n, OS.gtk_double_click_time, nArray, 0);
        return nArray[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        int n = this.activeShell.shellHandle;
        int n2 = OS.gtk_window_get_focus(n);
        if (n2 == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(n2)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((n2 = OS.gtk_widget_get_parent(n2)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getDepth() {
        this.checkDevice();
        GdkVisual gdkVisual = new GdkVisual();
        OS.memmove(gdkVisual, OS.gdk_visual_get_system());
        return gdkVisual.depth;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] byArray = Converter.wcsToMbcs(null, "_NET_WORKAREA", true);
        int n = OS.gdk_atom_intern(byArray, true);
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        if (!OS.gdk_property_get(OS.gdk_get_default_root_window(), n, 0, 0, 16, 0, nArray, nArray2, nArray3, nArray4)) {
            return null;
        }
        Rectangle rectangle = null;
        if (nArray4[0] != 0) {
            if (nArray3[0] == 16) {
                int[] nArray5 = new int[4];
                OS.memmove(nArray5, nArray4[0], 16);
                rectangle = new Rectangle(nArray5[0], nArray5[1], nArray5[2], nArray5[3]);
            } else if (nArray3[0] == 32) {
                long[] lArray = new long[4];
                OS.memmove(lArray, nArray4[0], 32);
                rectangle = new Rectangle((int)lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3]);
            }
            OS.g_free(nArray4[0]);
        }
        return rectangle;
    }

    public Monitor[] getMonitors() {
        Object object;
        int n;
        this.checkDevice();
        Monitor[] monitorArray = null;
        Rectangle rectangle = this.getWorkArea();
        int n2 = OS.gdk_screen_get_default();
        if (n2 != 0 && (n = OS.gdk_screen_get_n_monitors(n2)) > 0) {
            monitorArray = new Monitor[n];
            object = new GdkRectangle();
            int n3 = 0;
            while (n3 < n) {
                OS.gdk_screen_get_monitor_geometry(n2, n3, (GdkRectangle)object);
                Monitor monitor = new Monitor();
                monitor.handle = n3;
                monitor.x = ((GdkRectangle)object).x;
                monitor.y = ((GdkRectangle)object).y;
                monitor.width = ((GdkRectangle)object).width;
                monitor.height = ((GdkRectangle)object).height;
                if (n3 == 0 && rectangle != null) {
                    monitor.clientX = rectangle.x;
                    monitor.clientY = rectangle.y;
                    monitor.clientWidth = rectangle.width;
                    monitor.clientHeight = rectangle.height;
                } else {
                    monitor.clientX = monitor.x;
                    monitor.clientY = monitor.y;
                    monitor.clientWidth = monitor.width;
                    monitor.clientHeight = monitor.height;
                }
                monitorArray[n3] = monitor;
                ++n3;
            }
        }
        if (monitorArray == null) {
            Monitor monitor = new Monitor();
            object = this.getBounds();
            monitor.x = ((Rectangle)object).x;
            monitor.y = ((Rectangle)object).y;
            monitor.width = ((Rectangle)object).width;
            monitor.height = ((Rectangle)object).height;
            if (rectangle != null) {
                monitor.clientX = rectangle.x;
                monitor.clientY = rectangle.y;
                monitor.clientWidth = rectangle.width;
                monitor.clientHeight = rectangle.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitorArray = new Monitor[]{monitor};
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitorArray = this.getMonitors();
        return monitorArray[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        int n2 = 0;
        while (n2 < this.widgetTable.length) {
            Widget widget = this.widgetTable[n2];
            if (widget != null && widget instanceof Shell) {
                int n3 = 0;
                while (n3 < n) {
                    if (shellArray[n3] == widget) break;
                    ++n3;
                }
                if (n3 == n) {
                    if (n == shellArray.length) {
                        Shell[] shellArray2 = new Shell[n + 16];
                        System.arraycopy(shellArray, 0, shellArray2, 0, n);
                        shellArray = shellArray2;
                    }
                    shellArray[n++] = (Shell)widget;
                }
            }
            ++n2;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (n) {
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("gtk-dialog-error");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("gtk-dialog-info");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("gtk-dialog-question");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("gtk-dialog-warning");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    void initializeSystemColors() {
        int n = OS.gtk_window_new(1);
        if (n == 0) {
            this.error(2);
        }
        byte[] byArray = Converter.wcsToMbcs(null, "gtk-tooltips", true);
        OS.gtk_widget_set_name(n, byArray);
        OS.gtk_widget_realize(n);
        int n2 = OS.gtk_widget_get_style(n);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n2, 0, gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n2, 0, gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        OS.gtk_widget_destroy(n);
        int n3 = OS.gtk_widget_get_style(this.shellHandle);
        gdkColor = new GdkColor();
        OS.gtk_style_get_black(n3, gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_dark(n3, 0, gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n3, 0, gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n3, 0, gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n3, 0, gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n3, 0, gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(n3, 0, gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(n3, 0, gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(n3, 3, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(n3, 3, gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n3, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n3, 3, gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n3, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(n3, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(n3, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(n3, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
    }

    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        int n = OS.gtk_widget_get_style(this.shellHandle);
        int n2 = OS.pango_font_description_copy(OS.gtk_style_get_font_desc(n));
        this.systemFont = Font.gtk_new(this, n2);
        return this.systemFont;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(int n) {
        if (n == 0) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == n) {
            return this.lastWidget;
        }
        int n2 = OS.g_object_get_qdata(n, SWT_OBJECT_INDEX) - 1;
        if (n2 >= 0 && n2 < this.widgetTable.length) {
            this.lastHandle = n;
            this.lastWidget = this.widgetTable[n2];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int idleProc(int n) {
        boolean bl = this.runAsyncMessages(false);
        if (!bl) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return bl ? 1 : 0;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeWindowManager();
    }

    void initializeCallbacks() {
        this.closures = new int[84];
        this.signalIds = new int[84];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[15] = OS.g_signal_lookup(OS.event, OS.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, OS.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.expose_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, OS.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, OS.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, OS.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, OS.GTK_TYPE_WIDGET());
        this.signalIds[46] = OS.g_signal_lookup(OS.show_help, OS.GTK_TYPE_WIDGET());
        this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, OS.GTK_TYPE_WIDGET());
        this.signalIds[48] = OS.g_signal_lookup(OS.style_set, OS.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, OS.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[58] = OS.g_signal_lookup(OS.visibility_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, OS.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0) {
            this.error(3);
        }
        this.closures[1] = OS.g_cclosure_new(this.windowProc2, 1, 0);
        this.closures[60] = OS.g_cclosure_new(this.windowProc2, 60, 0);
        this.closures[6] = OS.g_cclosure_new(this.windowProc2, 6, 0);
        this.closures[8] = OS.g_cclosure_new(this.windowProc2, 8, 0);
        this.closures[83] = OS.g_cclosure_new(this.windowProc2, 83, 0);
        this.closures[61] = OS.g_cclosure_new(this.windowProc2, 61, 0);
        this.closures[66] = OS.g_cclosure_new(this.windowProc2, 66, 0);
        this.closures[24] = OS.g_cclosure_new(this.windowProc2, 24, 0);
        this.closures[23] = OS.g_cclosure_new(this.windowProc2, 23, 0);
        this.closures[30] = OS.g_cclosure_new(this.windowProc2, 30, 0);
        this.closures[62] = OS.g_cclosure_new(this.windowProc2, 62, 0);
        this.closures[36] = OS.g_cclosure_new(this.windowProc2, 36, 0);
        this.closures[38] = OS.g_cclosure_new(this.windowProc2, 38, 0);
        this.closures[39] = OS.g_cclosure_new(this.windowProc2, 39, 0);
        this.closures[40] = OS.g_cclosure_new(this.windowProc2, 40, 0);
        this.closures[44] = OS.g_cclosure_new(this.windowProc2, 44, 0);
        this.closures[68] = OS.g_cclosure_new(this.windowProc2, 68, 0);
        this.closures[45] = OS.g_cclosure_new(this.windowProc2, 45, 0);
        this.closures[69] = OS.g_cclosure_new(this.windowProc2, 69, 0);
        this.closures[57] = OS.g_cclosure_new(this.windowProc2, 57, 0);
        this.closures[54] = OS.g_cclosure_new(this.windowProc2, 54, 0);
        this.closures[56] = OS.g_cclosure_new(this.windowProc2, 56, 0);
        this.closures[70] = OS.g_cclosure_new(this.windowProc2, 70, 0);
        this.closures[71] = OS.g_cclosure_new(this.windowProc2, 71, 0);
        this.closures[72] = OS.g_cclosure_new(this.windowProc2, 72, 0);
        this.closures[73] = OS.g_cclosure_new(this.windowProc2, 73, 0);
        this.closures[74] = OS.g_cclosure_new(this.windowProc2, 74, 0);
        this.closures[75] = OS.g_cclosure_new(this.windowProc2, 75, 0);
        this.closures[76] = OS.g_cclosure_new(this.windowProc2, 76, 0);
        this.closures[77] = OS.g_cclosure_new(this.windowProc2, 77, 0);
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0) {
            this.error(3);
        }
        this.closures[2] = OS.g_cclosure_new(this.windowProc3, 2, 0);
        this.closures[3] = OS.g_cclosure_new(this.windowProc3, 3, 0);
        this.closures[4] = OS.g_cclosure_new(this.windowProc3, 4, 0);
        this.closures[5] = OS.g_cclosure_new(this.windowProc3, 5, 0);
        this.closures[9] = OS.g_cclosure_new(this.windowProc3, 9, 0);
        this.closures[10] = OS.g_cclosure_new(this.windowProc3, 10, 0);
        this.closures[11] = OS.g_cclosure_new(this.windowProc3, 11, 0);
        this.closures[14] = OS.g_cclosure_new(this.windowProc3, 14, 0);
        this.closures[15] = OS.g_cclosure_new(this.windowProc3, 15, 0);
        this.closures[16] = OS.g_cclosure_new(this.windowProc3, 16, 0);
        this.closures[18] = OS.g_cclosure_new(this.windowProc3, 18, 0);
        this.closures[19] = OS.g_cclosure_new(this.windowProc3, 19, 0);
        this.closures[20] = OS.g_cclosure_new(this.windowProc3, 20, 0);
        this.closures[21] = OS.g_cclosure_new(this.windowProc3, 21, 0);
        this.closures[22] = OS.g_cclosure_new(this.windowProc3, 22, 0);
        this.closures[27] = OS.g_cclosure_new(this.windowProc3, 27, 0);
        this.closures[28] = OS.g_cclosure_new(this.windowProc3, 28, 0);
        this.closures[25] = OS.g_cclosure_new(this.windowProc3, 25, 0);
        this.closures[29] = OS.g_cclosure_new(this.windowProc3, 29, 0);
        this.closures[31] = OS.g_cclosure_new(this.windowProc3, 31, 0);
        this.closures[32] = OS.g_cclosure_new(this.windowProc3, 32, 0);
        this.closures[33] = OS.g_cclosure_new(this.windowProc3, 33, 0);
        this.closures[34] = OS.g_cclosure_new(this.windowProc3, 34, 0);
        this.closures[35] = OS.g_cclosure_new(this.windowProc3, 35, 0);
        this.closures[37] = OS.g_cclosure_new(this.windowProc3, 37, 0);
        this.closures[43] = OS.g_cclosure_new(this.windowProc3, 43, 0);
        this.closures[46] = OS.g_cclosure_new(this.windowProc3, 46, 0);
        this.closures[47] = OS.g_cclosure_new(this.windowProc3, 47, 0);
        this.closures[48] = OS.g_cclosure_new(this.windowProc3, 48, 0);
        this.closures[53] = OS.g_cclosure_new(this.windowProc3, 53, 0);
        this.closures[55] = OS.g_cclosure_new(this.windowProc3, 55, 0);
        this.closures[58] = OS.g_cclosure_new(this.windowProc3, 58, 0);
        this.closures[59] = OS.g_cclosure_new(this.windowProc3, 59, 0);
        this.closures[65] = OS.g_cclosure_new(this.windowProc3, 65, 0);
        this.closures[82] = OS.g_cclosure_new(this.windowProc3, 82, 0);
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0) {
            this.error(3);
        }
        this.closures[12] = OS.g_cclosure_new(this.windowProc4, 12, 0);
        this.closures[13] = OS.g_cclosure_new(this.windowProc4, 13, 0);
        this.closures[67] = OS.g_cclosure_new(this.windowProc4, 67, 0);
        this.closures[41] = OS.g_cclosure_new(this.windowProc4, 41, 0);
        this.closures[42] = OS.g_cclosure_new(this.windowProc4, 42, 0);
        this.closures[63] = OS.g_cclosure_new(this.windowProc4, 63, 0);
        this.closures[49] = OS.g_cclosure_new(this.windowProc4, 49, 0);
        this.closures[50] = OS.g_cclosure_new(this.windowProc4, 50, 0);
        this.closures[51] = OS.g_cclosure_new(this.windowProc4, 51, 0);
        this.closures[64] = OS.g_cclosure_new(this.windowProc4, 64, 0);
        this.closures[78] = OS.g_cclosure_new(this.windowProc4, 78, 0);
        this.closures[79] = OS.g_cclosure_new(this.windowProc4, 79, 0);
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0) {
            this.error(3);
        }
        this.closures[7] = OS.g_cclosure_new(this.windowProc5, 7, 0);
        this.closures[17] = OS.g_cclosure_new(this.windowProc5, 17, 0);
        this.closures[26] = OS.g_cclosure_new(this.windowProc5, 26, 0);
        this.closures[52] = OS.g_cclosure_new(this.windowProc5, 52, 0);
        this.closures[80] = OS.g_cclosure_new(this.windowProc5, 80, 0);
        this.closures[81] = OS.g_cclosure_new(this.windowProc5, 81, 0);
        int n = 0;
        while (n < 84) {
            if (this.closures[n] != 0) {
                OS.g_closure_ref(this.closures[n]);
            }
            ++n;
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.menuPositionCallback = new Callback(this, "menuPositionProc", 5);
        this.menuPositionProc = this.menuPositionCallback.getAddress();
        if (this.menuPositionProc == 0) {
            this.error(3);
        }
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        if (this.sizeAllocateProc == 0) {
            this.error(3);
        }
        this.sizeRequestCallback = new Callback(this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        if (this.sizeRequestProc == 0) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0) {
            this.error(3);
        }
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0, 0);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0) {
            this.error(3);
        }
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        if (this.setDirectionProc == 0) {
            this.error(3);
        }
        this.emissionProcCallback = new Callback(this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        if (this.emissionProc == 0) {
            this.error(3);
        }
        this.allChildrenCallback = new Callback(this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        if (this.allChildrenProc == 0) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0) {
            this.error(3);
        }
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
        if (this.idleProc == 0) {
            this.error(3);
        }
    }

    void initializeSubclasses() {
        int n = OS.PANGO_TYPE_LAYOUT();
        int n2 = OS.g_type_class_ref(n);
        this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(n2);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n2, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
        OS.g_type_class_unref(n2);
    }

    void initializeSystemSettings() {
        OS.g_signal_connect(this.shellHandle, OS.style_set, this.signalProc, 1);
        int n = OS.gtk_entry_new();
        OS.gtk_widget_destroy(n);
        int[] nArray = new int[1];
        int n2 = OS.gtk_settings_get_default();
        OS.g_object_get(n2, OS.gtk_entry_select_on_focus, nArray, 0);
        this.entrySelectOnFocus = nArray[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int n = 0;
        while (n < 1023) {
            this.indexTable[n] = n + 1;
            ++n;
        }
        this.indexTable[1023] = -1;
    }

    void initializeWindowManager() {
        int n;
        int n2;
        this.windowManager = "";
        int n3 = OS.gdk_screen_get_default();
        if (n3 != 0 && (n2 = OS.gdk_x11_screen_get_window_manager_name(n3)) != 0 && (n = OS.strlen(n2)) > 0) {
            byte[] byArray = new byte[n];
            OS.memmove(byArray, n2, n);
            this.windowManager = new String(Converter.mbcsToWcs(null, byArray));
        }
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = n;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(n2);
        } else {
            OS.g_object_unref(n2);
        }
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        if (this.isDisposed()) {
            this.error(45);
        }
        int n2 = OS.gdk_get_default_root_window();
        if (OS.USE_CAIRO) {
            n = OS.gdk_cairo_create(n2);
            if (n == 0) {
                this.error(2);
            }
        } else {
            n = OS.gdk_gc_new(n2);
            if (n == 0) {
                this.error(2);
            }
            OS.gdk_gc_set_subwindow(n, 1);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = n2;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return n;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        int[] nArray;
        int[] nArray2;
        int n3;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(n, n2);
        if (control == control2) {
            return point;
        }
        if (control != null) {
            n3 = control.eventWindow();
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n3, nArray2, nArray);
            if ((control.style & 0x8000000) != 0) {
                point.x = control.getClientWidth() - point.x;
            }
            point.x += nArray2[0];
            point.y += nArray[0];
        }
        if (control2 != null) {
            n3 = control2.eventWindow();
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n3, nArray2, nArray);
            point.x -= nArray2[0];
            point.y -= nArray[0];
            if ((control2.style & 0x8000000) != 0) {
                point.x = control2.getClientWidth() - point.x;
            }
        }
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static char mbcsToWcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = n <= 255 ? new byte[]{(byte)n} : new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        if (cArray.length == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    int menuPositionProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.menuPositionProc(n, n2, n3, n4, n5);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        int[] nArray;
        int[] nArray2;
        int n5;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            n5 = control.eventWindow();
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n5, nArray2, nArray);
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = control.getClientWidth() - rectangle.x;
            }
            rectangle.x += nArray2[0];
            rectangle.y += nArray[0];
        }
        if (control2 != null) {
            n5 = control2.eventWindow();
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n5, nArray2, nArray);
            rectangle.x -= nArray2[0];
            rectangle.y -= nArray[0];
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = control2.getClientWidth() - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    int mouseHoverProc(int n) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(n);
    }

    /*
     * Exception decompiling
     */
    public boolean post(Event var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            int n = 0;
            while (n < this.gdkEventCount) {
                int n2 = this.gdkEvents[n];
                Widget widget = this.gdkEventWidgets[n];
                if (widget == null || !widget.isDisposed()) {
                    OS.gdk_event_put(n2);
                }
                OS.gdk_event_free(n2);
                this.gdkEvents[n] = 0;
                this.gdkEventWidgets[n] = null;
                ++n;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean bl = false;
        bl |= this.runSettings();
        bl |= this.runPopups();
        OS.gdk_threads_leave();
        if (bl |= OS.g_main_context_iteration(0, false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] == null) {
                    Display.Displays[n] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.windowProc5 = 0;
        this.windowProc4 = 0;
        this.windowProc3 = 0;
        this.windowProc2 = 0;
        if (this.filterProc != 0) {
            OS.gdk_window_remove_filter(0, this.filterProc, 0);
        }
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0;
        if (this.preeditWindow != 0) {
            OS.gtk_widget_destroy(this.preeditWindow);
        }
        this.imControl = null;
        this.menuPositionCallback.dispose();
        this.menuPositionCallback = null;
        this.menuPositionProc = 0;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        int n = 0;
        while (n < 84) {
            if (this.closures[n] != 0) {
                OS.g_closure_unref(this.closures[n]);
            }
            ++n;
        }
        if (this.shellMapProcClosure != 0) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            n = 0;
            while (n < this.timerIds.length) {
                if (this.timerIds[n] != 0) {
                    OS.g_source_remove(this.timerIds[n]);
                }
                ++n;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        n = 0;
        while (n < this.cursors.length) {
            if (this.cursors[n] != null) {
                this.cursors[n].dispose();
            }
            ++n;
        }
        this.cursors = null;
        if (this.resources != null) {
            n = 0;
            while (n < this.resources.length) {
                if (this.resources[n] != null) {
                    this.resources[n].dispose();
                }
                ++n;
            }
            this.resources = null;
        }
        this.COLOR_INFO_FOREGROUND = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT = null;
        this.COLOR_TITLE_BACKGROUND = null;
        this.COLOR_TITLE_FOREGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        OS.gdk_event_handler_set(0, 0, 0);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0;
        n = OS.PANGO_TYPE_LAYOUT();
        int n2 = OS.g_type_class_ref(n);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(n2, this.pangoLayoutNewProc);
        OS.g_type_class_unref(n2);
        this.pangoLayoutNewProc = 0;
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0) {
            OS.g_free(this.fds);
        }
        this.fds = 0;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.windowManager = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.visibilityEvent = null;
        this.idleLock = null;
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    int removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0;
        }
        int n = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeMouseHoverTimeout(int n) {
        if (n != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    Widget removeWidget(int n) {
        if (n == 0) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        int n2 = OS.g_object_get_qdata(n, SWT_OBJECT_INDEX) - 1;
        if (n2 >= 0 && n2 < this.widgetTable.length) {
            widget = this.widgetTable[n2];
            this.widgetTable[n2] = null;
            this.indexTable[n2] = this.freeSlot;
            this.freeSlot = n2;
            OS.g_object_set_qdata(n, SWT_OBJECT_INDEX, 0);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        boolean bl = false;
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int n2 = 0;
            while (n2 < n) {
                Composite composite = compositeArray[n2];
                if (!composite.isDisposed()) {
                    composite.setLayoutDeferred(false);
                }
                ++n2;
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.fixStyle();
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++n;
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int n2 = 0;
                while (n2 < n) {
                    Widget widget = widgetArray[n2];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFEFFFFFF;
                        widgetArray[n2] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        if (OS.GDK_WINDOWING_X11()) {
            int n3 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n4 = OS.XDefaultRootWindow(n3);
            OS.XWarpPointer(n3, 0, n4, 0, 0, 0, 0, n, n2);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        Object[] objectArray;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY) && (object == null || object instanceof int[])) {
            this.dispatchEvents = (int[])object;
            if (object == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)object);
            return;
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray2 = (Object[])object;
            int n = ((LONG)objectArray2[0]).value;
            objectArray = (Object[])objectArray2[1];
            if (objectArray != null) {
                this.addWidget(n, (Widget)objectArray);
            } else {
                this.removeWidget(n);
            }
        }
        if (string.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (string.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray3 = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray3, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray3[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray3;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    int setDirectionProc(int n, int n2) {
        int n3;
        OS.gtk_widget_set_direction(n, n2);
        if (OS.GTK_IS_MENU_ITEM(n) && (n3 = OS.gtk_menu_item_get_submenu(n)) != 0) {
            OS.gtk_widget_set_direction(n3, n2);
            OS.gtk_container_forall(n3, this.setDirectionProc, n2);
        }
        if (OS.GTK_IS_CONTAINER(n)) {
            OS.gtk_container_forall(n, this.setDirectionProc, n2);
        }
        return 0;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].updateModal();
            ++n;
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
            ++n;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.runAsyncMessages(true);
            }
            return;
        }
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0) {
            this.preeditWindow = OS.gtk_window_new(1);
            if (this.preeditWindow == 0) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.preeditWindow, this.preeditLabel);
            OS.gtk_widget_show(this.preeditLabel);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = control.imHandle();
        OS.gtk_im_context_get_preedit_string(n, nArray, nArray2, null);
        if (nArray[0] != 0 && OS.strlen(nArray[0]) > 0) {
            Control control2 = control.findBackgroundControl();
            if (control2 == null) {
                control2 = control;
            }
            OS.gtk_widget_modify_bg(this.preeditWindow, 0, control2.getBackgroundColor());
            control2.setForegroundColor(this.preeditLabel, control.getForegroundColor());
            OS.gtk_widget_modify_font(this.preeditLabel, control.getFontDescription());
            if (nArray2[0] != 0) {
                OS.gtk_label_set_attributes(this.preeditLabel, nArray2[0]);
            }
            OS.gtk_label_set_text(this.preeditLabel, nArray[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            OS.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.preeditLabel, gtkRequisition);
            OS.gtk_window_resize(this.preeditWindow, gtkRequisition.width, gtkRequisition.height);
            OS.gtk_widget_show(this.preeditWindow);
        } else {
            OS.gtk_widget_hide(this.preeditWindow);
        }
        if (nArray[0] != 0) {
            OS.g_free(nArray[0]);
        }
        if (nArray2[0] != 0) {
            OS.pango_attr_list_unref(nArray2[0]);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        if (this.fds == 0) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        var1_1 = OS.g_main_context_default();
        var2_2 = false;
        do {
            block17: {
                if (!OS.g_main_context_acquire(var1_1)) continue;
                var2_2 = OS.g_main_context_prepare(var1_1, this.max_priority);
                while (true) {
                    if ((var3_3 = OS.g_main_context_query(var1_1, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) <= this.allocated_nfds) {
                        var4_4 = OS.g_main_context_get_poll_func(var1_1);
                        if (var4_4 == 0 || var3_3 <= 0 && this.timeout[0] == 0) break block17;
                        if (this.timeout[0] < 0) {
                            this.timeout[0] = 50;
                        }
                        break;
                    }
                    OS.g_free(this.fds);
                    this.allocated_nfds = var3_3;
                    this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
                }
                var5_5 = OS.lock;
                var6_6 = var5_5.lock();
                var7_8 = 0;
                while (true) {
                    if (var7_8 >= var6_6) {
                        ** try [egrp 0[TRYBLOCK] [0 : 247->272)] { 
lbl39:
                        // 1 sources

                        break;
                    }
                    var5_5.unlock();
                    ++var7_8;
                }
                {
                    this.wake = false;
                    OS.Call(var4_4, this.fds, var3_3, this.timeout[0]);
                    ** GOTO lbl-1000
                }
lbl47:
                // 1 sources

                catch (Throwable var8_11) {
                    var7_9 = null;
                    var9_10 = 0;
                }
                while (true) {
                    if (var9_10 >= var6_6) {
                        var5_5.unlock();
                        throw var8_11;
                    }
                    var5_5.lock();
                    ++var9_10;
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = null;
                    var9_10 = 0;
                }
                while (true) {
                    if (var9_10 >= var6_6) {
                        var5_5.unlock();
                        break;
                    }
                    var5_5.lock();
                    ++var9_10;
                }
            }
            OS.g_main_context_check(var1_1, this.max_priority[0], this.fds, var3_3);
            OS.g_main_context_release(var1_1);
        } while (!var2_2 && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        return true;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int n3 = 0;
        while (n3 < this.timerList.length) {
            if (this.timerList[n3] == runnable) break;
            ++n3;
        }
        if (n3 != this.timerList.length) {
            OS.g_source_remove(this.timerIds[n3]);
            this.timerList[n3] = null;
            this.timerIds[n3] = 0;
            if (n < 0) {
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            n3 = 0;
            while (n3 < this.timerList.length) {
                if (this.timerList[n3] == null) break;
                ++n3;
            }
            if (n3 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n2 = OS.g_timeout_add(n, this.timerProc, n3)) != 0) {
            this.timerIds[n3] = n2;
            this.timerList[n3] = runnable;
        }
    }

    int timerProc(int n) {
        if (this.timerList == null) {
            return 0;
        }
        int n2 = n;
        if (n2 >= 0 && n2 < this.timerList.length) {
            Runnable runnable = this.timerList[n2];
            this.timerList[n2] = null;
            this.timerIds[n2] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    int caretProc(int n) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int n2 = this.currentCaret.blinkRate;
            if (n2 == 0) {
                return 0;
            }
            this.caretId = OS.g_timeout_add(n2, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int sizeAllocateProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.sizeAllocateProc(n, n2, n3);
    }

    int sizeRequestProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return 0;
        }
        return widget.sizeRequestProc(n, n2, n3);
    }

    void saveResources() {
        int n = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n = this.resources.length;
            Resource[] resourceArray = new Resource[n + 27];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
        if (this.systemFont != null) {
            this.resources[n++] = this.systemFont;
            this.systemFont = null;
        }
        if (this.errorImage != null) {
            this.resources[n++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[n++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int n2 = 0;
        while (n2 < this.cursors.length) {
            if (this.cursors[n2] != null) {
                this.resources[n++] = this.cursors[n2];
            }
            this.cursors[n2] = null;
            ++n2;
        }
        if (n < 27) {
            Resource[] resourceArray = new Resource[n];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int n = this.currentCaret.blinkRate;
        this.caretId = OS.g_timeout_add(n, this.caretProc, 0);
    }

    int shellMapProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.shellMapProc(n, n2, n3);
    }

    int signalProc(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.settingsChanged = true;
                break;
            }
            case 2: {
                byte[] byArray;
                int n4;
                GdkEventProperty gdkEventProperty = new GdkEventProperty();
                OS.memmove(gdkEventProperty, n2);
                if (gdkEventProperty.type != 16 || (n4 = OS.gdk_x11_atom_to_xatom(OS.gdk_atom_intern(byArray = Converter.wcsToMbcs(null, "org.eclipse.swt.filePath.message", true), true))) != OS.gdk_x11_atom_to_xatom(gdkEventProperty.atom)) break;
                int n5 = OS.gdk_x11_drawable_get_xid(OS.GTK_WIDGET_WINDOW(this.shellHandle));
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                int[] nArray5 = new int[1];
                OS.XGetWindowProperty(OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default()), n5, n4, 0, -1, true, 0, nArray, nArray2, nArray3, nArray4, nArray5);
                if (nArray3[0] <= 0) break;
                byte[] byArray2 = new byte[nArray3[0]];
                OS.memmove(byArray2, nArray5[0], byArray2.length);
                OS.XFree(nArray5[0]);
                char[] cArray = Converter.mbcsToWcs(null, byArray2);
                String string = new String(cArray);
                int n6 = 0;
                int n7 = string.indexOf(58);
                while (n7 != -1) {
                    String string2 = string.substring(n6, n7);
                    Event event = new Event();
                    event.text = string2;
                    this.sendEvent(46, event);
                    n6 = n7 + 1;
                    n7 = string.indexOf(58, n6);
                }
                break;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = OS._g_idle_add(this.idleProc, 0);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0, true);
        OS.gdk_window_process_all_updates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0);
        this.wake = true;
    }

    static char wcsToMbcs(char c) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(null, new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return '\u0000';
    }

    int windowProc(int n, int n2) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2);
    }

    int windowProc(int n, int n2, int n3) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3);
    }

    int windowProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3, n4);
    }

    int windowProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3, n4, n5);
    }

    int windowTimerProc(int n) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(n);
    }
}

