/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.IDownloadProgressMonitor;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ResourceUtil;

public class Downloader {
    private static Logger logger = null;
    private static final int BUF_SIZE = 65536;
    private URL targetURL = null;
    private int retryCount = 0;
    private URLConnection connection = null;
    private long totalDownloadSize = 0L;
    private long downloadRate = 0L;
    private Config config;

    public Downloader(Config config, URL targetURL) {
        this.config = config;
        this.targetURL = targetURL;
        if (logger == null) {
            logger = Log.getLogger(Downloader.class);
        }
    }

    public Downloader(Config config, URL targetURL, int retryCnt) {
        this.config = config;
        this.targetURL = targetURL;
        this.retryCount = retryCnt;
        if (logger == null) {
            logger = Log.getLogger(Downloader.class);
        }
    }

    public long download(String localPath, IDownloadProgressMonitor monitor) throws UMException {
        return this.download(localPath, 0L, -1L, monitor);
    }

    public long download(String localPath, long skipBytes, long maxDownloadSize, IDownloadProgressMonitor monitor) throws UMException {
        logger.info(String.format("[%d] %s", this.hashCode(), "Downloading: " + this.targetURL + " -> " + localPath));
        if (localPath == null || localPath.isEmpty()) {
            logger.error("Downloaded local path is null.");
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
        }
        File localFile = new File(localPath);
        if (localFile.exists() && localFile.length() != 0L) {
            localFile.delete();
        }
        long downloadSize = 0L;
        for (int i = 0; i < this.retryCount + 1; ++i) {
            File outputFile;
            try {
                if (monitor != null) {
                    monitor.downloadStatus(IDownloadProgressMonitor.Status.CONNECTING);
                }
                this.connect(this.targetURL, skipBytes, i);
                this.checkConnectionStatus();
                if (monitor != null) {
                    monitor.downloadStatus(IDownloadProgressMonitor.Status.DOWNLOADING);
                }
                downloadSize = this.downloadFile(localPath, maxDownloadSize, monitor, i);
                break;
            }
            catch (Exception e) {
                if (!(i >= this.retryCount || e instanceof UMException && ((UMException)e).getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE)) {
                    outputFile = new File(localPath);
                    if (!outputFile.exists() || outputFile.length() == 0L) continue;
                    PathUtil.remove(outputFile);
                    continue;
                }
                if (e instanceof UMException) {
                    throw (UMException)e;
                }
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, (Throwable)e);
            }
            catch (Throwable e) {
                if (i < this.retryCount) {
                    outputFile = new File(localPath);
                    if (!outputFile.exists() || outputFile.length() == 0L) continue;
                    PathUtil.remove(outputFile);
                    continue;
                }
                if (e instanceof UMException) {
                    throw (UMException)e;
                }
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, e);
            }
        }
        if (monitor != null) {
            monitor.downloadDone();
        }
        return downloadSize;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long downloadFile(String localPath, long maxDownloadSize, IDownloadProgressMonitor monitor, int retryCount) throws UMException {
        logger.trace(String.format("[%d] %s", this.hashCode(), "File download start => " + localPath));
        InputStream input = null;
        RandomAccessFile output = null;
        long downloadSize = 0L;
        try {
            long startTime;
            output = this.createOutputFile(localPath);
            input = this.connection.getInputStream();
            if (input == null) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, "Getting connection input stream failed! " + this.targetURL.toString());
            }
            byte[] buf = new byte[65536];
            this.totalDownloadSize = this.connection.getContentLength();
            if (maxDownloadSize > 0L && this.totalDownloadSize > maxDownloadSize) {
                this.totalDownloadSize = maxDownloadSize;
            }
            if (monitor != null) {
                monitor.downloadBegin(this.totalDownloadSize);
            }
            long latestReadTime = startTime = System.currentTimeMillis();
            long tickTime = startTime;
            long currentTime = startTime;
            long readTimeout = (retryCount + 1) * 20000;
            logger.trace(String.format("[%d] %s", this.hashCode(), "Current readTimeOut : " + readTimeout));
            while (downloadSize < this.totalDownloadSize) {
                if (input.available() > 0) {
                    if (monitor.isCanceled()) {
                        throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE, this.connection.getURL().toString());
                    }
                    int inputReadSize = input.read(buf);
                    if (maxDownloadSize > 0L && (long)inputReadSize + downloadSize > this.totalDownloadSize) {
                        inputReadSize = (int)(this.totalDownloadSize - downloadSize);
                    }
                    output.write(buf, 0, inputReadSize);
                    downloadSize += (long)inputReadSize;
                    if (monitor != null) {
                        monitor.downloaded(downloadSize, this.downloadRate);
                    }
                    latestReadTime = currentTime = System.currentTimeMillis();
                } else {
                    Thread.sleep(0L);
                    currentTime = System.currentTimeMillis();
                }
                if (currentTime > tickTime + 1000L || downloadSize >= this.totalDownloadSize) {
                    tickTime += 1000L;
                    if (downloadSize >= this.totalDownloadSize) {
                        this.downloadRate = currentTime - startTime > 0L ? downloadSize * 1000L / (currentTime - startTime) : downloadSize * 1000L;
                    }
                    if (monitor != null) {
                        monitor.downloaded(downloadSize, this.downloadRate);
                    }
                }
                if (currentTime <= latestReadTime + readTimeout) continue;
                logger.error(String.format("[%d] %s", this.hashCode(), String.format("Can not be read during %d mili-seconds", readTimeout)));
                throw new UMException(ErrorController.ErrorCode.DOWNLOAD_CONNECTION_TIMEOUT, this.targetURL.toString());
            }
            if (downloadSize != this.totalDownloadSize) {
                logger.error(String.format("[%d] %s", this.hashCode(), "File size error occurs during the download"));
                logger.error(String.format("[%d] %s", this.hashCode(), "Expected file size => " + this.totalDownloadSize));
                logger.error(String.format("[%d] %s", this.hashCode(), "Downloaded file size => " + downloadSize));
                throw new UMException(ErrorController.ErrorCode.DOWNLOAD_FILE_SIZE_MISMATCH, String.format("%d bytes / %d bytes", downloadSize, this.totalDownloadSize));
            }
        }
        catch (UMException e) {
            try {
                logger.throwing(e);
                throw e;
                catch (Exception e2) {
                    logger.throwing(e2);
                    throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                ResourceUtil.closeObjectSilently(input);
                ResourceUtil.closeObjectSilently(output);
                throw throwable;
            }
        }
        ResourceUtil.closeObjectSilently(input);
        ResourceUtil.closeObjectSilently(output);
        logger.trace(String.format("[%d] %s", this.hashCode(), "Download Size: " + downloadSize));
        logger.trace(String.format("[%d] %s", this.hashCode(), "Download Rate: " + this.downloadRate + " Bytes/sec"));
        logger.info(String.format("[%d] %s", this.hashCode(), "Download completed"));
        return downloadSize;
    }

    private RandomAccessFile createOutputFile(String localPath) throws UMException {
        File destFile = new File(localPath);
        if (!destFile.isAbsolute()) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE, "Local file does not use a absolute path - " + destFile.getPath());
        }
        File parentDir = destFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            logger.warn(String.format("[%d] %s", this.hashCode(), "Fail to create directory ==> " + parentDir));
        }
        RandomAccessFile raFile = null;
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            } else {
                destFile.delete();
                destFile.createNewFile();
            }
            raFile = new RandomAccessFile(destFile, "rw");
        }
        catch (FileNotFoundException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_DOWNLOAD_FILE, (Throwable)e);
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_DOWNLOAD_FILE, (Throwable)e);
        }
        return raFile;
    }

    private void connect(URL aUrl, long skipBytes, int retryCount) throws UMException {
        logger.trace(String.format("[%d] %s", this.hashCode(), "Connect to " + aUrl));
        if (!NetworkUtil.isAvailableURL(aUrl)) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_TO_DOWNLOAD_URL, "The target URL is not available!");
        }
        int readTimeout = (retryCount + 1) * 20000;
        int connectTimeout = (retryCount + 1) * 15000;
        this.connection = this.config.getProxyConfig().connectWithConfiguration(aUrl, skipBytes, connectTimeout, readTimeout);
    }

    private void checkConnectionStatus() throws UMException {
        String protocol = this.connection.getURL().getProtocol();
        if (protocol.equalsIgnoreCase("http")) {
            this.checkHttpConnectionStatus();
        }
    }

    private void checkHttpConnectionStatus() throws UMException {
        HttpURLConnection httpCon = (HttpURLConnection)this.connection;
        try {
            int responseCode = httpCon.getResponseCode();
            String responseMessage = httpCon.getResponseMessage();
            if (responseCode == 200 || responseCode == 206) {
                return;
            }
            logger.trace(String.format("[%d] %s", this.hashCode(), Integer.toString(responseCode)));
            logger.trace(String.format("[%d] %s", this.hashCode(), responseMessage));
            throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_TO_DOWNLOAD_URL, String.format("%d:%s", responseCode, responseMessage));
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CONNECT_TO_DOWNLOAD_URL, (Throwable)e);
        }
    }

    public URLConnection getURLConnection() {
        return this.connection;
    }

    public long getDownloadRate() {
        return this.downloadRate;
    }
}

