/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SWTEventObject;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkAttribute;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRange;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextRectangle;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    long handle;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    AccessibleObject[] children;
    boolean isLightweight = false;
    static long actionNamePtr = -1L;
    static long descriptionPtr = -1L;
    static long keybindingPtr = -1L;
    static long namePtr = -1L;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final boolean DEBUG = Device.DEBUG;
    static final int ROW_ROLE = ATK.atk_role_register(Converter.wcsToMbcs(null, "row", true));
    static final int COLUMN_ROLE = ATK.atk_role_register(Converter.wcsToMbcs(null, "column", true));

    AccessibleObject(long l, long l2, Accessible accessible, boolean bl) {
        this.handle = ATK.g_object_new(l, 0L);
        ATK.atk_object_initialize(this.handle, l2);
        this.accessible = accessible;
        this.isLightweight = bl;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            AccessibleObject.print("new AccessibleObject: " + this.handle + " control=" + accessible.control + " lw=" + bl);
        }
    }

    static void print(String string) {
        System.out.println(string);
    }

    static AtkActionIface getActionIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_ACTION())) {
            AtkActionIface atkActionIface = new AtkActionIface();
            ATK.memmove(atkActionIface, ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(l)));
            return atkActionIface;
        }
        return null;
    }

    static long atkAction_do_action(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_do_action");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)vector.elementAt(n2);
                    accessibleActionListener.doAction(accessibleActionEvent);
                    ++n2;
                }
                return "OK".equals(accessibleActionEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.do_action != 0L) {
            l3 = ATK.call(atkActionIface.do_action, l, l2);
        }
        return l3;
    }

    static long atkAction_get_n_actions(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_n_actions");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)vector.elementAt(n2);
                    accessibleActionListener.getActionCount(accessibleActionEvent);
                    ++n2;
                }
                return accessibleActionEvent.count;
            }
        }
        long l2 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_n_actions != 0L) {
            l2 = ATK.call(atkActionIface.get_n_actions, l);
        }
        return l2;
    }

    static long atkAction_get_description(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_description");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(accessible);
                accessibleActionEvent.index = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleActionListener accessibleActionListener = (AccessibleActionListener)vector.elementAt(n2);
                    accessibleActionListener.getDescription(accessibleActionEvent);
                    ++n2;
                }
                if (accessibleActionEvent.result == null) {
                    return 0L;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleActionEvent.result);
                return descriptionPtr;
            }
        }
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_description != 0L) {
            l3 = ATK.call(atkActionIface.get_description, l, l2);
        }
        return l3;
    }

    static long atkAction_get_keybinding(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_keybinding");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_keybinding != 0L) {
            l3 = ATK.call(atkActionIface.get_keybinding, l, l2);
        }
        if (accessibleObject != null) {
            SWTEventListener sWTEventListener;
            int n;
            SWTEventObject sWTEventObject;
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n2 = vector.size();
            if (n2 > 0) {
                sWTEventObject = new AccessibleActionEvent(accessible);
                sWTEventObject.index = (int)l2;
                n = 0;
                while (n < n2) {
                    sWTEventListener = (AccessibleActionListener)vector.elementAt(n);
                    sWTEventListener.getKeyBinding((AccessibleActionEvent)sWTEventObject);
                    ++n;
                }
                if (sWTEventObject.result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(sWTEventObject.result);
                    return keybindingPtr;
                }
            }
            if ((n2 = (vector = accessible.accessibleListeners).size()) > 0) {
                sWTEventObject = new AccessibleEvent(accessible);
                ((AccessibleEvent)sWTEventObject).childID = accessibleObject.id;
                if (l3 != 0L) {
                    ((AccessibleEvent)sWTEventObject).result = AccessibleObject.getString(l3);
                }
                n = 0;
                while (n < n2) {
                    sWTEventListener = (AccessibleListener)vector.elementAt(n);
                    sWTEventListener.getKeyboardShortcut((AccessibleEvent)sWTEventObject);
                    ++n;
                }
                if (((AccessibleEvent)sWTEventObject).result != null) {
                    if (keybindingPtr != -1L) {
                        OS.g_free(keybindingPtr);
                    }
                    keybindingPtr = AccessibleObject.getStringPtr(((AccessibleEvent)sWTEventObject).result);
                    return keybindingPtr;
                }
            }
        }
        return l3;
    }

    static long atkAction_get_name(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkAction_get_name");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkActionIface atkActionIface = AccessibleObject.getActionIface(l);
        if (atkActionIface != null && atkActionIface.get_name != 0L) {
            l3 = ATK.call(atkActionIface.get_name, l, l2);
        }
        if (accessibleObject != null) {
            SWTEventListener sWTEventListener;
            int n;
            SWTEventObject sWTEventObject;
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleActionListeners;
            int n2 = vector.size();
            if (n2 > 0) {
                sWTEventObject = new AccessibleActionEvent(accessible);
                sWTEventObject.index = (int)l2;
                n = 0;
                while (n < n2) {
                    sWTEventListener = (AccessibleActionListener)vector.elementAt(n);
                    sWTEventListener.getName((AccessibleActionEvent)sWTEventObject);
                    ++n;
                }
                if (sWTEventObject.result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(sWTEventObject.result);
                    return actionNamePtr;
                }
            }
            if (l2 == 0L && (n2 = (vector = accessible.accessibleControlListeners).size()) > 0) {
                sWTEventObject = new AccessibleControlEvent(accessible);
                ((AccessibleControlEvent)sWTEventObject).childID = accessibleObject.id;
                if (l3 != 0L) {
                    ((AccessibleControlEvent)sWTEventObject).result = AccessibleObject.getString(l3);
                }
                n = 0;
                while (n < n2) {
                    sWTEventListener = (AccessibleControlListener)vector.elementAt(n);
                    sWTEventListener.getDefaultAction((AccessibleControlEvent)sWTEventObject);
                    ++n;
                }
                if (((AccessibleControlEvent)sWTEventObject).result != null) {
                    if (actionNamePtr != -1L) {
                        OS.g_free(actionNamePtr);
                    }
                    actionNamePtr = AccessibleObject.getStringPtr(((AccessibleControlEvent)sWTEventObject).result);
                    return actionNamePtr;
                }
            }
        }
        return l3;
    }

    static AtkComponentIface getComponentIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_COMPONENT())) {
            AtkComponentIface atkComponentIface = new AtkComponentIface();
            ATK.memmove(atkComponentIface, ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(l)));
            return atkComponentIface;
        }
        return null;
    }

    static long atkComponent_get_extents(long l, long l2, long l3, long l4, long l5, long l6) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_extents: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        OS.memmove(l4, new int[1], 4L);
        OS.memmove(l5, new int[1], 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_extents != 0L) {
            ATK.call(atkComponentIface.get_extents, l, l2, l3, l4, l5, l6);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                OS.memmove(nArray3, l4, 4L);
                OS.memmove(nArray4, l5, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                accessibleControlEvent.width = nArray3[0];
                accessibleControlEvent.height = nArray4[0];
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[1];
                if (l6 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray5, nArray6);
                    accessibleControlEvent.x += nArray5[0];
                    accessibleControlEvent.y += nArray6[0];
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n2;
                }
                if (l6 == 1L) {
                    accessibleControlEvent.x -= nArray5[0];
                    accessibleControlEvent.y -= nArray6[0];
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
                OS.memmove(l4, new int[]{accessibleControlEvent.width}, 4L);
                OS.memmove(l5, new int[]{accessibleControlEvent.height}, 4L);
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.x + "," + accessibleControlEvent.y + "," + accessibleControlEvent.width + "x" + accessibleControlEvent.height);
                }
            }
        }
        return 0L;
    }

    static long atkComponent_get_position(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_position, object: " + l + " x: " + l2 + " y: " + l3 + " coord: " + l4);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_position != 0L) {
            ATK.call(atkComponentIface.get_position, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = nArray[0];
                accessibleControlEvent.y = nArray2[0];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray3, nArray4);
                    accessibleControlEvent.x += nArray3[0];
                    accessibleControlEvent.y += nArray4[0];
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n2;
                }
                if (l4 == 1L) {
                    accessibleControlEvent.x -= nArray3[0];
                    accessibleControlEvent.y -= nArray4[0];
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.x}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.y}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_get_size(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_get_size");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        OS.memmove(l2, new int[1], 4L);
        OS.memmove(l3, new int[1], 4L);
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.get_size != 0L) {
            ATK.call(atkComponentIface.get_size, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.memmove(nArray, l2, 4L);
                OS.memmove(nArray2, l3, 4L);
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.width = nArray[0];
                accessibleControlEvent.height = nArray2[0];
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getLocation(accessibleControlEvent);
                    ++n2;
                }
                OS.memmove(l2, new int[]{accessibleControlEvent.width}, 4L);
                OS.memmove(l3, new int[]{accessibleControlEvent.height}, 4L);
            }
        }
        return 0L;
    }

    static long atkComponent_ref_accessible_at_point(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkComponent_ref_accessible_at_point: " + l + " " + l2 + "," + l3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                Accessible accessible2;
                Object object;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.x = (int)l2;
                accessibleControlEvent.y = (int)l3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleControlEvent.x += nArray[0];
                    accessibleControlEvent.y += nArray2[0];
                }
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleControlListener)vector.elementAt(n2);
                    object.getChildAtPoint(accessibleControlEvent);
                    ++n2;
                }
                if (accessibleControlEvent.childID == accessibleObject.id) {
                    accessibleControlEvent.childID = -1;
                }
                Object object2 = object = (accessible2 = accessibleControlEvent.accessible) != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object != null) {
                    return OS.g_object_ref(((AccessibleObject)object).handle);
                }
            }
        }
        long l5 = 0L;
        AtkComponentIface atkComponentIface = AccessibleObject.getComponentIface(l);
        if (atkComponentIface != null && atkComponentIface.ref_accessible_at_point != 0L) {
            l5 = ATK.call(atkComponentIface.ref_accessible_at_point, l, l2, l3, l4);
        }
        return l5;
    }

    static AtkEditableTextIface getEditableTextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_EDITABLE_TEXT())) {
            AtkEditableTextIface atkEditableTextIface = new AtkEditableTextIface();
            ATK.memmove(atkEditableTextIface, ATK.g_type_interface_peek_parent(ATK.ATK_EDITABLE_TEXT_GET_IFACE(l)));
            return atkEditableTextIface;
        }
        return null;
    }

    static long atkEditableText_set_run_attributes(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_run_attributes");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                Display display = accessible.control.getDisplay();
                long l5 = OS.pango_font_description_new();
                boolean bl = false;
                TextStyle textStyle = new TextStyle();
                String[] stringArray = new String[]{};
                long l6 = l2;
                int n2 = OS.g_slist_length(l2);
                int n3 = 0;
                while (n3 < n2) {
                    long l7 = OS.g_slist_data(l6);
                    if (l7 != 0L) {
                        AtkAttribute atkAttribute = new AtkAttribute();
                        ATK.memmove(atkAttribute, l7, AtkAttribute.sizeof);
                        String string = AccessibleObject.getString(atkAttribute.name);
                        String string2 = AccessibleObject.getString(atkAttribute.value);
                        OS.g_free(l7);
                        if (DEBUG) {
                            AccessibleObject.print("name=" + string + ", value=" + string2);
                        }
                        String[] stringArray2 = new String[stringArray.length + 2];
                        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                        stringArray2[stringArray.length] = string;
                        stringArray2[stringArray.length + 1] = string2;
                        stringArray = stringArray2;
                        try {
                            if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(10)))) {
                                textStyle.rise = Integer.parseInt(string2);
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(11)))) {
                                if (string2.equals("single") || string2.equals("low")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 0;
                                } else if (string2.equals("double")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 1;
                                } else if (string2.equals("error")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 2;
                                } else if (string2.equals("squiggle")) {
                                    textStyle.underline = true;
                                    textStyle.underlineStyle = 3;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(12)))) {
                                if (string2.equals("true") || string2.equals("1") || string2.equals("single")) {
                                    textStyle.strikeout = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(17)))) {
                                byte[] byArray = Converter.wcsToMbcs(null, string2, true);
                                OS.pango_font_description_set_family(l5, byArray);
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(13)))) {
                                float f = Float.parseFloat(string2);
                                OS.pango_font_description_set_size(l5, (int)(f * 1024.0f));
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(27)))) {
                                int n4 = -1;
                                if (string2.equals("normal")) {
                                    n4 = 0;
                                } else if (string2.equals("italic")) {
                                    n4 = 2;
                                } else if (string2.equals("oblique")) {
                                    n4 = 1;
                                }
                                if (n4 != -1) {
                                    OS.pango_font_description_set_style(l5, n4);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(26)))) {
                                int n5 = -1;
                                if (string2.equals("normal")) {
                                    n5 = 0;
                                } else if (string2.equals("small_caps")) {
                                    n5 = 1;
                                }
                                if (n5 != -1) {
                                    OS.pango_font_description_set_variant(l5, n5);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(25)))) {
                                int n6 = -1;
                                if (string2.equals("ultra_condensed")) {
                                    n6 = 0;
                                } else if (string2.equals("extra_condensed")) {
                                    n6 = 1;
                                } else if (string2.equals("condensed")) {
                                    n6 = 2;
                                } else if (string2.equals("semi_condensed")) {
                                    n6 = 3;
                                } else if (string2.equals("normal")) {
                                    n6 = 4;
                                } else if (string2.equals("semi_expanded")) {
                                    n6 = 5;
                                } else if (string2.equals("expanded")) {
                                    n6 = 6;
                                } else if (string2.equals("extra_expanded")) {
                                    n6 = 7;
                                } else if (string2.equals("ultra_expanded")) {
                                    n6 = 8;
                                }
                                if (n6 != -1) {
                                    OS.pango_font_description_set_stretch(l5, n6);
                                    bl = true;
                                }
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(15)))) {
                                int n7 = Integer.parseInt(string2);
                                OS.pango_font_description_set_weight(l5, n7);
                                bl = true;
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(19)))) {
                                textStyle.foreground = AccessibleObject.colorFromString(display, string2);
                            } else if (string.equals(AccessibleObject.getString(ATK.atk_text_attribute_get_name(18)))) {
                                textStyle.background = AccessibleObject.colorFromString(display, string2);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    l6 = OS.g_slist_next(l6);
                    ++n3;
                }
                if (bl) {
                    textStyle.font = Font.gtk_new(display, l5);
                }
                AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(accessible);
                accessibleTextAttributeEvent.start = (int)l3;
                accessibleTextAttributeEvent.end = (int)l4;
                accessibleTextAttributeEvent.textStyle = textStyle;
                accessibleTextAttributeEvent.attributes = stringArray;
                int n8 = 0;
                while (n8 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n8);
                    accessibleEditableTextListener.setTextAttributes(accessibleTextAttributeEvent);
                    ++n8;
                }
                if (textStyle.font != null) {
                    textStyle.font.dispose();
                }
                if (textStyle.foreground != null) {
                    textStyle.foreground.dispose();
                }
                if (textStyle.background != null) {
                    textStyle.background.dispose();
                }
                return "OK".equals(accessibleTextAttributeEvent.result) ? 1 : 0;
            }
        }
        long l8 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.set_run_attributes != 0L) {
            l8 = ATK.call(atkEditableTextIface.set_run_attributes, l, l2, l3, l4);
        }
        return l8;
    }

    static Color colorFromString(Display display, String string) {
        try {
            int n = string.indexOf(44);
            int n2 = string.indexOf(44, n + 1);
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1, string.length()));
            return new Color(display, n3, n4, n5);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static long atkEditableText_set_text_contents(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_set_text_contents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = 0;
                String string = accessibleObject.getText();
                accessibleEditableTextEvent.end = string == null ? 0 : string.length();
                accessibleEditableTextEvent.string = AccessibleObject.getString(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.set_text_contents != 0L) {
            l3 = ATK.call(atkEditableTextIface.set_text_contents, l, l2);
        }
        return l3;
    }

    static long atkEditableText_insert_text(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_insert_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                int[] nArray = new int[1];
                OS.memmove(nArray, l4, (long)OS.PTR_SIZEOF);
                accessibleEditableTextEvent.start = accessibleEditableTextEvent.end = nArray[0];
                accessibleEditableTextEvent.string = AccessibleObject.getString(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l5 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.insert_text != 0L) {
            l5 = ATK.call(atkEditableTextIface.insert_text, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkEditableText_copy_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_copy_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.copyText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.copy_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.copy_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_cut_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_cut_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.cutText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.cut_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.cut_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_delete_text(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_delete_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                accessibleEditableTextEvent.end = (int)l3;
                accessibleEditableTextEvent.string = "";
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l4 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.delete_text != 0L) {
            l4 = ATK.call(atkEditableTextIface.delete_text, l, l2, l3);
        }
        return l4;
    }

    static long atkEditableText_paste_text(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkEditableText_paste_text");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleEditableTextListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(accessible);
                accessibleEditableTextEvent.start = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)vector.elementAt(n2);
                    accessibleEditableTextListener.pasteText(accessibleEditableTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleEditableTextEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkEditableTextIface atkEditableTextIface = AccessibleObject.getEditableTextIface(l);
        if (atkEditableTextIface != null && atkEditableTextIface.paste_text != 0L) {
            l3 = ATK.call(atkEditableTextIface.paste_text, l, l2);
        }
        return l3;
    }

    static AtkHypertextIface getHypertextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_HYPERTEXT())) {
            AtkHypertextIface atkHypertextIface = new AtkHypertextIface();
            ATK.memmove(atkHypertextIface, ATK.g_type_interface_peek_parent(ATK.ATK_HYPERTEXT_GET_IFACE(l)));
            return atkHypertextIface;
        }
        return null;
    }

    static long atkHypertext_get_link(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getHyperlink(accessibleTextEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTextEvent.accessible;
                return accessible2 != null ? accessible2.getAccessibleObject().handle : 0L;
            }
        }
        long l3 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_link != 0L) {
            l3 = ATK.call(atkHypertextIface.get_link, l, l2);
        }
        return l3;
    }

    static long atkHypertext_get_n_links(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_n_links");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getHyperlinkCount(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.count;
            }
        }
        long l2 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_n_links != 0L) {
            l2 = ATK.call(atkHypertextIface.get_n_links, l);
        }
        return l2;
    }

    static long atkHypertext_get_link_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkHypertext_get_link_index");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.offset = (int)l2;
                accessibleTextEvent.index = -1;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getHyperlinkIndex(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.index;
            }
        }
        long l3 = 0L;
        AtkHypertextIface atkHypertextIface = AccessibleObject.getHypertextIface(l);
        if (atkHypertextIface != null && atkHypertextIface.get_link_index != 0L) {
            l3 = ATK.call(atkHypertextIface.get_link_index, l, l2);
        }
        return l3;
    }

    static AtkObjectClass getObjectClass(long l) {
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, ATK.g_type_class_peek(OS.g_type_parent(OS.G_OBJECT_TYPE(l))));
        return atkObjectClass;
    }

    static long atkObject_get_description(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_description: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_description != 0L) {
            l2 = ATK.call(atkObjectClass.get_description, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (l2 != 0L) {
                    accessibleEvent.result = AccessibleObject.getString(l2);
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleListener accessibleListener = (AccessibleListener)vector.elementAt(n2);
                    accessibleListener.getDescription(accessibleEvent);
                    ++n2;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return l2;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return descriptionPtr;
            }
        }
        return l2;
    }

    static long atkObject_get_attributes(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_attributes: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_attributes != 0L) {
            l2 = ATK.call(atkObjectClass.get_attributes, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleAttributeListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(accessible);
                accessibleAttributeEvent.indent = -1;
                accessibleAttributeEvent.alignment = -1;
                accessibleAttributeEvent.rightMargin = -1;
                accessibleAttributeEvent.leftMargin = -1;
                accessibleAttributeEvent.bottomMargin = -1;
                accessibleAttributeEvent.topMargin = -1;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)vector.elementAt(n2);
                    accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
                    ++n2;
                }
                AtkAttribute atkAttribute = new AtkAttribute();
                if (accessibleAttributeEvent.leftMargin != -1) {
                    long l3 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(1));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.leftMargin));
                    ATK.memmove(l3, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l3);
                }
                if (accessibleAttributeEvent.rightMargin != -1) {
                    long l4 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(2));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.rightMargin));
                    ATK.memmove(l4, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l4);
                }
                if (accessibleAttributeEvent.topMargin != -1) {
                    long l5 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("top-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.topMargin));
                    ATK.memmove(l5, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l5);
                }
                if (accessibleAttributeEvent.bottomMargin != -1) {
                    long l6 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = AccessibleObject.getStringPtr("bottom-margin");
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.bottomMargin));
                    ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l6);
                }
                if (accessibleAttributeEvent.indent != -1) {
                    long l7 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(3));
                    atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(accessibleAttributeEvent.indent));
                    ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l7);
                }
                if (accessibleAttributeEvent.justify) {
                    long l8 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    atkAttribute.value = AccessibleObject.getStringPtr("fill");
                    ATK.memmove(l8, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l8);
                } else if (accessibleAttributeEvent.alignment != -1) {
                    long l9 = OS.g_malloc(AtkAttribute.sizeof);
                    atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(24));
                    String string = "left";
                    switch (accessibleAttributeEvent.alignment) {
                        case 16384: {
                            string = "left";
                            break;
                        }
                        case 131072: {
                            string = "right";
                            break;
                        }
                        case 0x1000000: {
                            string = "center";
                        }
                    }
                    atkAttribute.value = AccessibleObject.getStringPtr(string);
                    ATK.memmove(l9, atkAttribute, AtkAttribute.sizeof);
                    l2 = OS.g_slist_append(l2, l9);
                }
                if (accessibleAttributeEvent.attributes != null) {
                    int n3 = accessibleAttributeEvent.attributes.length / 2 * 2;
                    int n4 = 0;
                    while (n4 < n3) {
                        long l10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[n4]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleAttributeEvent.attributes[n4 + 1]);
                        ATK.memmove(l10, atkAttribute, AtkAttribute.sizeof);
                        l2 = OS.g_slist_append(l2, l10);
                        n4 += 2;
                    }
                }
            }
        }
        return l2;
    }

    static long atkObject_get_name(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_name: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_name != 0L) {
            l2 = ATK.call(atkObjectClass.get_name, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleEvent accessibleEvent = new AccessibleEvent(accessible);
                accessibleEvent.childID = accessibleObject.id;
                if (l2 != 0L) {
                    accessibleEvent.result = AccessibleObject.getString(l2);
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleListener accessibleListener = (AccessibleListener)vector.elementAt(n2);
                    accessibleListener.getName(accessibleEvent);
                    ++n2;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleEvent.result);
                }
                if (accessibleEvent.result == null) {
                    return l2;
                }
                if (namePtr != -1L) {
                    OS.g_free(namePtr);
                }
                namePtr = AccessibleObject.getStringPtr(accessibleEvent.result);
                return namePtr;
            }
        }
        return l2;
    }

    static long atkObject_get_n_children(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_n_children: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_n_children != 0L) {
            l2 = ATK.call(atkObjectClass.get_n_children, l);
        }
        if (accessibleObject != null && accessibleObject.id == -1) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getChildCount(accessibleControlEvent);
                    ++n2;
                }
                if (DEBUG) {
                    AccessibleObject.print("--->" + accessibleControlEvent.detail);
                }
                return accessibleControlEvent.detail;
            }
        }
        return l2;
    }

    static long atkObject_get_index_in_parent(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_index_in_parent: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
            accessibleControlEvent.childID = -5;
            accessibleControlEvent.detail = -1;
            int n = 0;
            while (n < vector.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n);
                accessibleControlListener.getChild(accessibleControlEvent);
                ++n;
            }
            if (accessibleControlEvent.detail != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleControlEvent.detail;
            }
            if (accessibleObject.index != -1) {
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleObject.index);
                }
                return accessibleObject.index;
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).get_index_in_parent == 0L) {
            return 0L;
        }
        long l2 = ATK.call(((AtkObjectClass)object).get_index_in_parent, l);
        if (DEBUG) {
            AccessibleObject.print("---*> " + l2);
        }
        return l2;
    }

    static long atkObject_get_parent(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_parent: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null && accessibleObject.parent != null) {
            if (DEBUG) {
                AccessibleObject.print("---> " + accessibleObject.parent.accessible.accessibleObject.handle);
            }
            return accessibleObject.parent.handle;
        }
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.get_parent == 0L) {
            return 0L;
        }
        long l2 = ATK.call(atkObjectClass.get_parent, l);
        if (DEBUG) {
            AccessibleObject.print("---> " + l2);
        }
        return l2;
    }

    static long atkObject_get_role(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_get_role: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(object);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getRole(accessibleControlEvent);
                    ++n2;
                }
                if (DEBUG) {
                    AccessibleObject.print("---> " + accessibleControlEvent.detail);
                }
                if (accessibleControlEvent.detail != -1) {
                    switch (accessibleControlEvent.detail) {
                        case 44: {
                            return 7L;
                        }
                        case 10: {
                            return 18L;
                        }
                        case 46: {
                            return 11L;
                        }
                        case 18: {
                            return 16L;
                        }
                        case 41: {
                            return 28L;
                        }
                        case 30: {
                            return 60L;
                        }
                        case 33: {
                            return 30L;
                        }
                        case 34: {
                            return 31L;
                        }
                        case 11: {
                            return 32L;
                        }
                        case 2: {
                            return 33L;
                        }
                        case 12: {
                            return 34L;
                        }
                        case 48: {
                            return 41L;
                        }
                        case 43: {
                            return 42L;
                        }
                        case 3: {
                            return 47L;
                        }
                        case 21: {
                            return 49L;
                        }
                        case 51: {
                            return 50L;
                        }
                        case 24: {
                            return 54L;
                        }
                        case 29: {
                            return 55L;
                        }
                        case 25: {
                            return 56L;
                        }
                        case 26: {
                            return 57L;
                        }
                        case 60: {
                            return 37L;
                        }
                        case 37: {
                            return 36L;
                        }
                        case 42: {
                            return 60L;
                        }
                        case 22: {
                            return 62L;
                        }
                        case 13: {
                            return 63L;
                        }
                        case 35: {
                            return 64L;
                        }
                        case 36: {
                            return 31L;
                        }
                        case 45: {
                            return 43L;
                        }
                        case 62: {
                            return 42L;
                        }
                        case 9: {
                            return 68L;
                        }
                        case 28: {
                            return ROW_ROLE;
                        }
                        case 27: {
                            return COLUMN_ROLE;
                        }
                        case 8: {
                            return 2L;
                        }
                        case 54: {
                            return 3L;
                        }
                        case 1025: {
                            return 6L;
                        }
                        case 20: {
                            return 38L;
                        }
                        case 52: {
                            return 52L;
                        }
                        case 23: {
                            return 53L;
                        }
                        case 1027: {
                            return 8L;
                        }
                        case 1073: {
                            return 44L;
                        }
                        case 61: {
                            return 66L;
                        }
                        case 47: {
                            return 4L;
                        }
                        case 1029: {
                            return 12L;
                        }
                        case 1038: {
                            return 70L;
                        }
                        case 1040: {
                            return 85L;
                        }
                        case 1043: {
                            return 69L;
                        }
                        case 1044: {
                            return 81L;
                        }
                        case 1053: {
                            return 82L;
                        }
                        case 1054: {
                            return 71L;
                        }
                        case 1060: {
                            return 83L;
                        }
                        case 15: {
                            return 80L;
                        }
                        case 40: {
                            return 26L;
                        }
                    }
                }
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).get_role == 0L) {
            return 0L;
        }
        return ATK.call(((AtkObjectClass)object).get_role, l);
    }

    static long atkObject_ref_child(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_child: " + l2 + " of: " + l);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null && accessibleObject.id == -1) {
            Object object2;
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleObject accessibleObject2;
                object2 = new AccessibleControlEvent(object);
                ((AccessibleControlEvent)object2).childID = -4;
                ((AccessibleControlEvent)object2).detail = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getChild((AccessibleControlEvent)object2);
                    ++n2;
                }
                if (((AccessibleControlEvent)object2).accessible != null && (accessibleObject2 = ((AccessibleControlEvent)object2).accessible.getAccessibleObject()) != null) {
                    return OS.g_object_ref(accessibleObject2.handle);
                }
            }
            accessibleObject.updateChildren();
            object2 = accessibleObject.getChildByIndex((int)l2);
            if (object2 != null) {
                return OS.g_object_ref(((AccessibleObject)object2).handle);
            }
        }
        object = AccessibleObject.getObjectClass(l);
        if (((AtkObjectClass)object).ref_child == 0L) {
            return 0L;
        }
        return ATK.call(((AtkObjectClass)object).ref_child, l, l2);
    }

    static long atkObject_ref_state_set(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkObject_ref_state_set: " + l);
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkObjectClass atkObjectClass = AccessibleObject.getObjectClass(l);
        if (atkObjectClass.ref_state_set != 0L) {
            l2 = ATK.call(atkObjectClass.ref_state_set, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                long l3 = l2;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                accessibleControlEvent.detail = -1;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getState(accessibleControlEvent);
                    ++n2;
                }
                if (accessibleControlEvent.detail != -1) {
                    n2 = accessibleControlEvent.detail;
                    if ((n2 & 0x800) != 0) {
                        ATK.atk_state_set_add_state(l3, 3);
                    }
                    if ((n2 & 0x10) != 0) {
                        ATK.atk_state_set_add_state(l3, 4);
                    }
                    if ((n2 & 0x200) != 0) {
                        ATK.atk_state_set_add_state(l3, 9);
                    }
                    if ((n2 & 0x100000) != 0) {
                        ATK.atk_state_set_add_state(l3, 10);
                    }
                    if ((n2 & 4) != 0) {
                        ATK.atk_state_set_add_state(l3, 11);
                    }
                    if ((n2 & 0x80) != 0) {
                        ATK.atk_state_set_add_state(l3, 2);
                    }
                    if ((n2 & 0x8000) == 0) {
                        ATK.atk_state_set_add_state(l3, 28);
                    }
                    if ((n2 & 0x1000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 16);
                    }
                    if ((n2 & 0x10000) == 0) {
                        ATK.atk_state_set_add_state(l3, 23);
                    }
                    if ((n2 & 8) != 0) {
                        ATK.atk_state_set_add_state(l3, 18);
                    }
                    if ((n2 & 0x40) == 0) {
                        ATK.atk_state_set_add_state(l3, 6);
                    }
                    if ((n2 & 0x200000) != 0) {
                        ATK.atk_state_set_add_state(l3, 20);
                    }
                    if ((n2 & 2) != 0) {
                        ATK.atk_state_set_add_state(l3, 21);
                    }
                    if ((n2 & 0x20000) != 0) {
                        ATK.atk_state_set_add_state(l3, 19);
                    }
                    if ((n2 & 1) == 0) {
                        ATK.atk_state_set_add_state(l3, 7);
                    }
                    if ((n2 & 0x4000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 1);
                    }
                    if ((n2 & 0x8000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 24);
                    }
                    if ((n2 & 0x10000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 15);
                    }
                    if ((n2 & 0x2000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 32);
                    }
                    if ((n2 & 0x20000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 33);
                    }
                    if ((n2 & 0x40000000) != 0) {
                        ATK.atk_state_set_add_state(l3, 34);
                    }
                }
                return l3;
            }
        }
        return l2;
    }

    static AtkSelectionIface getSelectionIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_SELECTION())) {
            AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
            ATK.memmove(atkSelectionIface, ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(l)));
            return atkSelectionIface;
        }
        return null;
    }

    static long atkSelection_is_child_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_is_child_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(l);
        if (atkSelectionIface != null && atkSelectionIface.is_child_selected != 0L) {
            l3 = ATK.call(atkSelectionIface.is_child_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                Object object;
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleControlListener)vector.elementAt(n2);
                    object.getSelection(accessibleControlEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleControlEvent.accessible;
                Object object2 = object = accessible2 != null ? accessible2.getAccessibleObject() : accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (object != null) {
                    return (long)((AccessibleObject)object).index == l2 ? 1 : 0;
                }
            }
        }
        return l3;
    }

    static long atkSelection_ref_selection(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkSelection_ref_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkSelectionIface atkSelectionIface = AccessibleObject.getSelectionIface(l);
        if (atkSelectionIface != null && atkSelectionIface.ref_selection != 0L) {
            l3 = ATK.call(atkSelectionIface.ref_selection, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleControlListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
                accessibleControlEvent.childID = accessibleObject.id;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                    accessibleControlListener.getSelection(accessibleControlEvent);
                    ++n2;
                }
                AccessibleObject accessibleObject2 = accessibleObject.getChildByID(accessibleControlEvent.childID);
                if (accessibleObject2 != null) {
                    if (l3 != 0L) {
                        OS.g_object_unref(l3);
                    }
                    OS.g_object_ref(accessibleObject2.handle);
                    return accessibleObject2.handle;
                }
            }
        }
        return l3;
    }

    static AtkTableIface getTableIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_TABLE())) {
            AtkTableIface atkTableIface = new AtkTableIface();
            ATK.memmove(atkTableIface, ATK.g_type_interface_peek_parent(ATK.ATK_TABLE_GET_IFACE(l)));
            return atkTableIface;
        }
        return null;
    }

    static long atkTable_ref_at(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_ref_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleTableListener)vector.elementAt(n2);
                    object.getCell(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    object = accessible2.getAccessibleObject();
                    OS.g_object_ref(((AccessibleObject)object).handle);
                    return ((AccessibleObject)object).handle;
                }
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.ref_at != 0L) {
            l4 = ATK.call(atkTableIface.ref_at, l, l2, l3);
        }
        return l4;
    }

    static long atkTable_get_index_at(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_index_at");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getCell(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 == null) {
                    return -1L;
                }
                accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n3 = 0;
                while (n3 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n3);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n3;
                }
                return l2 * (long)accessibleTableEvent.count + l3;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_index_at != 0L) {
            l4 = ATK.call(atkTableIface.get_index_at, l, l2, l3);
        }
        return l4;
    }

    static long atkTable_get_column_at_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_at_index: " + l + " " + l2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                long l3;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n2;
                }
                long l4 = l3 = accessibleTableEvent.count == 0 ? -1L : l2 % (long)accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + l3);
                }
                return l3;
            }
        }
        long l5 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_at_index != 0L) {
            l5 = ATK.call(atkTableIface.get_column_at_index, l, l2);
        }
        return l5;
    }

    static long atkTable_get_row_at_index(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_at_index: " + l + " " + l2);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                long l3;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    ++n2;
                }
                long l4 = l3 = accessibleTableEvent.count == 0 ? -1L : l2 / (long)accessibleTableEvent.count;
                if (DEBUG) {
                    AccessibleObject.print("---> " + l3);
                }
                return l3;
            }
        }
        long l5 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_at_index != 0L) {
            l5 = ATK.call(atkTableIface.get_row_at_index, l, l2);
        }
        return l5;
    }

    static long atkTable_get_n_columns(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_columns");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_n_columns != 0L) {
            l2 = ATK.call(atkTableIface.get_n_columns, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getColumnCount(accessibleTableEvent);
                    l2 = accessibleTableEvent.count;
                    ++n2;
                }
            }
        }
        return l2;
    }

    static long atkTable_get_n_rows(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_n_rows");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_n_rows != 0L) {
            l2 = ATK.call(atkTableIface.get_n_rows, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.count = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getRowCount(accessibleTableEvent);
                    l2 = accessibleTableEvent.count;
                    ++n2;
                }
            }
        }
        return l2;
    }

    static long atkTable_get_column_extent_at(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_extent_at != 0L) {
            l4 = ATK.call(atkTableIface.get_column_extent_at, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleTableListener)vector.elementAt(n2);
                    object.getCell(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).count = (int)l4;
                    int n3 = 0;
                    while (n3 < n) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n3);
                        accessibleTableCellListener.getColumnSpan((AccessibleTableCellEvent)object);
                        ++n3;
                    }
                    return ((AccessibleTableCellEvent)object).count;
                }
            }
        }
        return l4;
    }

    static long atkTable_get_row_extent_at(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_extent_at");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_extent_at != 0L) {
            l4 = ATK.call(atkTableIface.get_row_extent_at, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleTableListener)vector.elementAt(n2);
                    object.getCell(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).count = (int)l4;
                    int n3 = 0;
                    while (n3 < n) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n3);
                        accessibleTableCellListener.getRowSpan((AccessibleTableCellEvent)object);
                        ++n3;
                    }
                    return ((AccessibleTableCellEvent)object).count;
                }
            }
        }
        return l4;
    }

    static long atkTable_get_caption(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_caption");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getCaption(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_caption != 0L) {
            l2 = ATK.call(atkTableIface.get_caption, l);
        }
        return l2;
    }

    static long atkTable_get_summary(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_summary");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getSummary(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null) {
                    return accessible2.getAccessibleObject().handle;
                }
            }
        }
        long l2 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_summary != 0L) {
            l2 = ATK.call(atkTableIface.get_summary, l);
        }
        return l2;
    }

    static long atkTable_get_column_description(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_description != 0L) {
            l3 = ATK.call(atkTableIface.get_column_description, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                if (l3 != 0L) {
                    accessibleTableEvent.result = AccessibleObject.getString(l3);
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getColumnDescription(accessibleTableEvent);
                    ++n2;
                }
                if (accessibleTableEvent.result == null) {
                    return l3;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return l3;
    }

    static long atkTable_get_column_header(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_column_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                    ++n2;
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && 0L <= l2 && l2 < (long)accessibleArray.length) {
                    return accessibleArray[(int)l2].getAccessibleObject().handle;
                }
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_column_header != 0L) {
            l3 = ATK.call(atkTableIface.get_column_header, l, l2);
        }
        return l3;
    }

    static long atkTable_get_row_description(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_description");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_description != 0L) {
            l3 = ATK.call(atkTableIface.get_row_description, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                if (l3 != 0L) {
                    accessibleTableEvent.result = AccessibleObject.getString(l3);
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getRowDescription(accessibleTableEvent);
                    ++n2;
                }
                if (accessibleTableEvent.result == null) {
                    return l3;
                }
                if (descriptionPtr != -1L) {
                    OS.g_free(descriptionPtr);
                }
                descriptionPtr = AccessibleObject.getStringPtr(accessibleTableEvent.result);
                return descriptionPtr;
            }
        }
        return l3;
    }

    static long atkTable_get_row_header(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_row_header");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getRowHeaderCells(accessibleTableEvent);
                    ++n2;
                }
                Accessible[] accessibleArray = accessibleTableEvent.accessibles;
                if (accessibleArray != null && 0L <= l2 && l2 < (long)accessibleArray.length) {
                    return accessibleArray[(int)l2].getAccessibleObject().handle;
                }
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_row_header != 0L) {
            l3 = ATK.call(atkTableIface.get_row_header, l, l2);
        }
        return l3;
    }

    static long atkTable_get_selected_columns(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_columns");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getSelectedColumns(accessibleTableEvent);
                    ++n2;
                }
                n2 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                long l3 = OS.g_malloc(n2 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(l3, accessibleTableEvent.selected, (long)(n2 * 4));
                }
                if (l2 != 0L) {
                    OS.memmove(l2, new long[]{l3}, (long)C.PTR_SIZEOF);
                }
                return n2;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_selected_columns != 0L) {
            l4 = ATK.call(atkTableIface.get_selected_columns, l, l2);
        }
        return l4;
    }

    static long atkTable_get_selected_rows(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_get_selected_rows");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.getSelectedRows(accessibleTableEvent);
                    ++n2;
                }
                n2 = accessibleTableEvent.selected != null ? accessibleTableEvent.selected.length : 0;
                long l3 = OS.g_malloc(n2 * 4);
                if (accessibleTableEvent.selected != null) {
                    OS.memmove(l3, accessibleTableEvent.selected, (long)(n2 * 4));
                }
                if (l2 != 0L) {
                    OS.memmove(l2, new long[]{l3}, (long)C.PTR_SIZEOF);
                }
                return n2;
            }
        }
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.get_selected_rows != 0L) {
            l4 = ATK.call(atkTableIface.get_selected_rows, l, l2);
        }
        return l4;
    }

    static long atkTable_is_column_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_column_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_column_selected != 0L) {
            l3 = ATK.call(atkTableIface.is_column_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = l3 != 0L;
                accessibleTableEvent.column = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.isColumnSelected(accessibleTableEvent);
                    ++n2;
                }
                return accessibleTableEvent.isSelected ? 1 : 0;
            }
        }
        return l3;
    }

    static long atkTable_is_row_selected(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_row_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_row_selected != 0L) {
            l3 = ATK.call(atkTableIface.is_row_selected, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.isSelected = l3 != 0L;
                accessibleTableEvent.row = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.isRowSelected(accessibleTableEvent);
                    ++n2;
                }
                return accessibleTableEvent.isSelected ? 1 : 0;
            }
        }
        return l3;
    }

    static long atkTable_is_selected(long l, long l2, long l3) {
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_is_selected");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l4 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.is_selected != 0L) {
            l4 = ATK.call(atkTableIface.is_selected, l, l2, l3);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                Object object;
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                accessibleTableEvent.column = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    object = (AccessibleTableListener)vector.elementAt(n2);
                    object.getCell(accessibleTableEvent);
                    ++n2;
                }
                Accessible accessible2 = accessibleTableEvent.accessible;
                if (accessible2 != null && (n = (vector = accessible2.accessibleTableCellListeners).size()) > 0) {
                    object = new AccessibleTableCellEvent(accessible2);
                    ((AccessibleTableCellEvent)object).isSelected = l4 != 0L;
                    int n3 = 0;
                    while (n3 < n) {
                        AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)vector.elementAt(n3);
                        accessibleTableCellListener.isSelected((AccessibleTableCellEvent)object);
                        ++n3;
                    }
                    return ((AccessibleTableCellEvent)object).isSelected ? 1 : 0;
                }
            }
        }
        return l4;
    }

    static long atkTable_add_row_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.selectRow(accessibleTableEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.add_row_selection != 0L) {
            l3 = ATK.call(atkTableIface.add_row_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_remove_row_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_row_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.row = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.deselectRow(accessibleTableEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.remove_row_selection != 0L) {
            l3 = ATK.call(atkTableIface.remove_row_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_add_column_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_add_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.selectColumn(accessibleTableEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.add_column_selection != 0L) {
            l3 = ATK.call(atkTableIface.add_column_selection, l, l2);
        }
        return l3;
    }

    static long atkTable_remove_column_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkTable_remove_column_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTableListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(accessible);
                accessibleTableEvent.column = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTableListener accessibleTableListener = (AccessibleTableListener)vector.elementAt(n2);
                    accessibleTableListener.deselectColumn(accessibleTableEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTableEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkTableIface atkTableIface = AccessibleObject.getTableIface(l);
        if (atkTableIface != null && atkTableIface.remove_column_selection != 0L) {
            l3 = ATK.call(atkTableIface.remove_column_selection, l, l2);
        }
        return l3;
    }

    static AtkTextIface getTextIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_TEXT())) {
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(l)));
            return atkTextIface;
        }
        return null;
    }

    static long atkText_get_character_extents(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)(l2 + 1L);
                int n2 = 0;
                while (n2 < n) {
                    object2 = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    object2.getTextBounds(accessibleTextEvent);
                    ++n2;
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (l7 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                OS.memmove(l3, new int[]{accessibleTextEvent.x}, 4L);
                OS.memmove(l4, new int[]{accessibleTextEvent.y}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.width}, 4L);
                OS.memmove(l6, new int[]{accessibleTextEvent.height}, 4L);
                return 0L;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_extents != 0L) {
            ATK.call(((AtkTextIface)object).get_character_extents, l, l2, l3, l4, l5, l6, l7);
        }
        return 0L;
    }

    static String getString(long l) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    static long getStringPtr(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string != null ? string : "", true);
        long l = OS.g_malloc(byArray.length);
        OS.memmove(l, byArray, (long)byArray.length);
        return l;
    }

    static long atkText_get_range_extents(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_range_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                Object object2;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    object2 = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    object2.getTextBounds(accessibleTextEvent);
                    ++n2;
                }
                int[] nArray = new int[1];
                object2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, (int[])object2);
                    accessibleTextEvent.x -= nArray[0];
                    accessibleTextEvent.y -= object2[0];
                }
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                atkTextRectangle.x = accessibleTextEvent.x;
                atkTextRectangle.y = accessibleTextEvent.y;
                atkTextRectangle.width = accessibleTextEvent.width;
                atkTextRectangle.height = accessibleTextEvent.height;
                ATK.memmove(l5, atkTextRectangle, AtkTextRectangle.sizeof);
                return 0L;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_range_extents != 0L) {
            ATK.call(((AtkTextIface)object).get_range_extents, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_run_attributes(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_run_attributes");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleAttributeListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(accessible);
                accessibleTextAttributeEvent.offset = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)vector.elementAt(n2);
                    accessibleAttributeListener.getTextAttributes(accessibleTextAttributeEvent);
                    ++n2;
                }
                OS.memmove(l3, new int[]{accessibleTextAttributeEvent.start}, 4L);
                OS.memmove(l4, new int[]{accessibleTextAttributeEvent.end}, 4L);
                TextStyle textStyle = accessibleTextAttributeEvent.textStyle;
                long l5 = 0L;
                AtkAttribute atkAttribute = new AtkAttribute();
                if (textStyle != null) {
                    Color color;
                    Font font;
                    long l6;
                    if (textStyle.rise != 0) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(10));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(textStyle.rise));
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if (textStyle.underline) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(11));
                        String string = "none";
                        switch (textStyle.underlineStyle) {
                            case 1: {
                                string = "double";
                                break;
                            }
                            case 0: {
                                string = "single";
                                break;
                            }
                            case 2: {
                                string = "error";
                                break;
                            }
                            case 3: {
                                string = "squiggle";
                            }
                        }
                        atkAttribute.value = AccessibleObject.getStringPtr(string);
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if (textStyle.strikeout) {
                        l6 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(12));
                        atkAttribute.value = AccessibleObject.getStringPtr("1");
                        ATK.memmove(l6, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l6);
                    }
                    if ((font = textStyle.font) != null && !font.isDisposed()) {
                        long l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(17));
                        atkAttribute.value = ATK.g_strdup(OS.pango_font_description_get_family(font.handle));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(13));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_size(font.handle) / 1024));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(27));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(27, OS.pango_font_description_get_style(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(26));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(26, OS.pango_font_description_get_variant(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(25));
                        atkAttribute.value = ATK.g_strdup(ATK.atk_text_attribute_get_value(25, OS.pango_font_description_get_stretch(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                        l7 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(15));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(OS.pango_font_description_get_weight(font.handle)));
                        ATK.memmove(l7, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l7);
                    }
                    if ((color = textStyle.foreground) != null && !color.isDisposed()) {
                        long l8 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(19));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(l8, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l8);
                    }
                    if ((color = textStyle.background) != null && !color.isDisposed()) {
                        long l9 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = ATK.g_strdup(ATK.atk_text_attribute_get_name(18));
                        atkAttribute.value = AccessibleObject.getStringPtr(String.valueOf(color.handle.red & 0xFFFF) + "," + (color.handle.blue & 0xFFFF) + "," + (color.handle.blue & 0xFFFF));
                        ATK.memmove(l9, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l9);
                    }
                }
                if (accessibleTextAttributeEvent.attributes != null) {
                    int n3 = accessibleTextAttributeEvent.attributes.length / 2 * 2;
                    int n4 = 0;
                    while (n4 < n3) {
                        long l10 = OS.g_malloc(AtkAttribute.sizeof);
                        atkAttribute.name = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[n4]);
                        atkAttribute.value = AccessibleObject.getStringPtr(accessibleTextAttributeEvent.attributes[n4 + 1]);
                        ATK.memmove(l10, atkAttribute, AtkAttribute.sizeof);
                        l5 = OS.g_slist_append(l5, l10);
                        n4 += 2;
                    }
                }
                return l5;
            }
        }
        long l11 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_run_attributes != 0L) {
            l11 = ATK.call(atkTextIface.get_run_attributes, l, l2, l3, l4);
        }
        return l11;
    }

    static long atkText_get_offset_at_point(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_offset_at_point");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.x = (int)l2;
                accessibleTextEvent.y = (int)l3;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (l4 == 1L) {
                    AccessibleObject.windowPoint(accessibleObject, nArray, nArray2);
                    accessibleTextEvent.x += nArray[0];
                    accessibleTextEvent.y += nArray2[0];
                }
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.offset;
            }
        }
        long l5 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_offset_at_point != 0L) {
            l5 = ATK.call(atkTextIface.get_offset_at_point, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkText_add_selection(long l, long l2, long l3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_add_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.addSelection(accessibleTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        long l4 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.add_selection != 0L) {
            l4 = ATK.call(atkTextIface.add_selection, l, l2, l3);
        }
        return l4;
    }

    static long atkText_remove_selection(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_remove_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.remove_selection != 0L) {
            l3 = ATK.call(atkTextIface.remove_selection, l, l2);
        }
        return l3;
    }

    static long atkText_set_caret_offset(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_caret_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.offset = (int)l2;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.setCaretOffset(accessibleTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).set_caret_offset != 0L) {
            return ATK.call(((AtkTextIface)object).set_caret_offset, l, l2);
        }
        return 0L;
    }

    static long atkText_set_selection(long l, long l2, long l3, long l4) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_set_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                accessibleTextEvent.start = (int)l3;
                accessibleTextEvent.end = (int)l4;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.setSelection(accessibleTextEvent);
                    ++n2;
                }
                return "OK".equals(accessibleTextEvent.result) ? 1 : 0;
            }
        }
        long l5 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.set_selection != 0L) {
            l5 = ATK.call(atkTextIface.set_selection, l, l2, l3, l4);
        }
        return l5;
    }

    static long atkText_get_caret_offset(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_caret_offset");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l2 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_caret_offset != 0L) {
            l2 = ATK.call(atkTextIface.get_caret_offset, l);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getCaretOffset(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.offset;
            }
            vector = accessible.accessibleTextListeners;
            n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = (int)l2;
                int n3 = 0;
                while (n3 < n) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n3);
                    accessibleTextListener.getCaretOffset(accessibleTextEvent);
                    ++n3;
                }
                return accessibleTextEvent.offset;
            }
        }
        return l2;
    }

    static long atkText_get_bounded_ranges(long l, long l2, long l3, long l4, long l5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_bounded_ranges");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                AtkTextRectangle atkTextRectangle = new AtkTextRectangle();
                ATK.memmove(atkTextRectangle, l2, AtkTextRectangle.sizeof);
                accessibleTextEvent.x = atkTextRectangle.x;
                accessibleTextEvent.y = atkTextRectangle.y;
                accessibleTextEvent.width = atkTextRectangle.width;
                accessibleTextEvent.height = atkTextRectangle.height;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getRanges(accessibleTextEvent);
                    ++n2;
                }
                int[] nArray = accessibleTextEvent.ranges;
                int n3 = nArray == null ? 1 : nArray.length / 2;
                long l6 = OS.malloc(n3 * AtkTextRange.sizeof);
                AtkTextRange atkTextRange = new AtkTextRange();
                int n4 = 0;
                int n5 = nArray != null ? nArray.length / 2 : 1;
                while (n4 < n5) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    int n6;
                    if (nArray != null) {
                        n6 = n4 * 2;
                        accessibleTextEvent.start = nArray[n6];
                        accessibleTextEvent.end = nArray[n6 + 1];
                    }
                    accessibleTextEvent.count = 0;
                    accessibleTextEvent.type = 5;
                    n6 = 0;
                    while (n6 < n) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n6;
                    }
                    atkTextRange.start_offset = accessibleTextEvent.start;
                    atkTextRange.end_offset = accessibleTextEvent.end;
                    atkTextRange.content = AccessibleObject.getStringPtr(accessibleTextEvent.result);
                    accessibleTextEvent.result = null;
                    accessibleTextEvent.height = 0;
                    accessibleTextEvent.width = 0;
                    accessibleTextEvent.y = 0;
                    accessibleTextEvent.x = 0;
                    accessibleTextEvent.type = 0;
                    accessibleTextEvent.count = 0;
                    n6 = 0;
                    while (n6 < n) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                        accessibleTextExtendedListener.getTextBounds(accessibleTextEvent);
                        ++n6;
                    }
                    atkTextRange.bounds.x = accessibleTextEvent.x;
                    atkTextRange.bounds.y = accessibleTextEvent.y;
                    atkTextRange.bounds.width = accessibleTextEvent.width;
                    atkTextRange.bounds.height = accessibleTextEvent.height;
                    ATK.memmove(l6 + (long)(n4 * AtkTextRange.sizeof), atkTextRange, AtkTextRange.sizeof);
                    ++n4;
                }
                return l6;
            }
        }
        long l7 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_bounded_ranges != 0L) {
            l7 = ATK.call(atkTextIface.get_bounded_ranges, l);
        }
        return l7;
    }

    static long atkText_get_character_at_offset(long l, long l2) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_at_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)(l2 + 1L);
                accessibleTextEvent.type = 0;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n2;
                }
                String string = accessibleTextEvent.result;
                return string != null && string.length() > 0 ? (int)string.charAt(0) : 0;
            }
            String string = accessibleObject.getText();
            if (string != null && (long)string.length() > l2) {
                return string.charAt((int)l2);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_at_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_character_at_offset, l, l2);
        }
        return 0L;
    }

    static long atkText_get_character_count(long l) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_character_count");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.count;
            }
            String string = accessibleObject.getText();
            if (string != null) {
                return string.length();
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_character_count != 0L) {
            return ATK.call(((AtkTextIface)object).get_character_count, l);
        }
        return 0L;
    }

    static long atkText_get_n_selections(long l) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_n_selections");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getSelectionCount(accessibleTextEvent);
                    ++n2;
                }
                return accessibleTextEvent.count;
            }
            vector = accessible.accessibleTextListeners;
            n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessibleObject.accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                int n3 = 0;
                while (n3 < n) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n3);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                    ++n3;
                }
                if (accessibleTextEvent.length > 0) {
                    return 1L;
                }
            }
        }
        long l2 = 0L;
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_n_selections != 0L) {
            l2 = ATK.call(atkTextIface.get_n_selections, l);
        }
        return l2;
    }

    static long atkText_get_selection(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_selection");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        long l5 = 0L;
        OS.memmove(l3, new int[1], 4L);
        OS.memmove(l4, new int[1], 4L);
        AtkTextIface atkTextIface = AccessibleObject.getTextIface(l);
        if (atkTextIface != null && atkTextIface.get_selection != 0L) {
            l5 = ATK.call(atkTextIface.get_selection, l, l2, l3, l4);
        }
        if (accessibleObject != null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.memmove(nArray, l3, 4L);
            OS.memmove(nArray2, l4, 4L);
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextExtendedListener accessibleTextExtendedListener;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.index = (int)l2;
                accessibleTextEvent.start = nArray[0];
                accessibleTextEvent.end = nArray2[0];
                int n2 = 0;
                while (n2 < n) {
                    accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getSelection(accessibleTextEvent);
                    ++n2;
                }
                nArray[0] = accessibleTextEvent.start;
                nArray2[0] = accessibleTextEvent.end;
                OS.memmove(l3, nArray, 4L);
                OS.memmove(l4, nArray2, 4L);
                accessibleTextEvent.index = 0;
                accessibleTextEvent.count = 0;
                accessibleTextEvent.type = 5;
                n2 = 0;
                while (n2 < n) {
                    accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n2;
                }
                if (l5 != 0L) {
                    OS.g_free(l5);
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            if (l2 == 0L && (n = (vector = accessible.accessibleTextListeners).size()) > 0) {
                String string;
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(accessible);
                accessibleTextEvent.childID = accessibleObject.id;
                accessibleTextEvent.offset = nArray[0];
                accessibleTextEvent.length = nArray2[0] - nArray[0];
                int n3 = 0;
                while (n3 < n) {
                    AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n3);
                    accessibleTextListener.getSelectionRange(accessibleTextEvent);
                    ++n3;
                }
                OS.memmove(l3, new int[]{accessibleTextEvent.offset}, 4L);
                OS.memmove(l4, new int[]{accessibleTextEvent.offset + accessibleTextEvent.length}, 4L);
                if (l5 != 0L) {
                    OS.g_free(l5);
                }
                if ((string = accessibleObject.getText()) != null && string.length() > accessibleTextEvent.offset && string.length() >= accessibleTextEvent.offset + accessibleTextEvent.length) {
                    return AccessibleObject.getStringPtr(string.substring(accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length));
                }
                if (atkTextIface != null && atkTextIface.get_text != 0L) {
                    return ATK.call(atkTextIface.get_text, l, accessibleTextEvent.offset, accessibleTextEvent.offset + accessibleTextEvent.length);
                }
                return 0L;
            }
        }
        return l5;
    }

    static long atkText_get_text(long l, long l2, long l3) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text: " + l + " " + l2 + "," + l3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = (int)l2;
                accessibleTextEvent.end = (int)l3;
                accessibleTextEvent.type = 5;
                int n2 = 0;
                while (n2 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n2);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n2;
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                l3 = l3 == -1L ? (long)string.length() : Math.min(l3, (long)string.length());
                l2 = Math.min(l2, l3);
                string = string.substring((int)l2, (int)l3);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text != 0L) {
            return ATK.call(((AtkTextIface)object).get_text, l, l2, l3);
        }
        return 0L;
    }

    static long atkText_get_text_after_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_after_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = 1;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n2 = accessibleTextEvent.start;
                int n3 = accessibleTextEvent.end;
                int n4 = 0;
                while (n4 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n4;
                }
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n4 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = 2;
                        int n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n4 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = 0;
                        int n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        break;
                    }
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n <= n7) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7 - 1);
                        if (n10 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n10)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n10;
                        int n11 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n10);
                        if (n11 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n11);
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n7);
                        if (n12 == -1 || n12 != n7 - 1) {
                            n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n7);
                        }
                        if (n7 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        int n13 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7);
                        if (n13 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n13 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n13)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n13;
                        int n14 = AccessibleObject.nextIndexOfNotChar(string, " \n", n13);
                        if (n14 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n14 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n14)) == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n14);
                        break;
                    }
                    case 3: {
                        int n15 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        int n16 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7);
                        int n17 = 0;
                        if (n15 >= n16) {
                            n17 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n7);
                        } else {
                            n17 = AccessibleObject.nextIndexOfChar(string, "!?.", n7);
                            if (n17 == -1) {
                                n8 = n9 = n;
                                break;
                            }
                            n17 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n17);
                        }
                        if (n17 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n17;
                        int n18 = AccessibleObject.nextIndexOfChar(string, "!?.", n17);
                        if (n18 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n18);
                        break;
                    }
                    case 4: {
                        int n19 = AccessibleObject.nextIndexOfChar(string, "!?.", n7);
                        if (n19 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n19 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n19)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n19;
                        int n20 = AccessibleObject.nextIndexOfNotChar(string, " \n", n19);
                        if (n20 == n) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n20 = AccessibleObject.nextIndexOfChar(string, "!?.", n20)) == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n20);
                        break;
                    }
                    case 5: {
                        int n21 = string.indexOf(10, n7 - 1);
                        if (n21 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        if ((n21 = AccessibleObject.nextIndexOfNotChar(string, "\n", n21)) == n) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n21;
                        int n22 = string.indexOf(10, n21);
                        if (n22 == -1) {
                            n9 = n;
                            break;
                        }
                        n9 = n22 = AccessibleObject.nextIndexOfNotChar(string, "\n", n22);
                        break;
                    }
                    case 6: {
                        int n23;
                        int n24 = AccessibleObject.nextIndexOfChar(string, "\n", n7);
                        if (n24 == -1) {
                            n8 = n9 = n;
                            break;
                        }
                        n8 = n24;
                        n9 = n8 == n ? n : ((n23 = AccessibleObject.nextIndexOfChar(string, "\n", n24 + 1)) == -1 ? n : n23);
                    }
                }
                OS.memmove(l4, new int[]{n8}, 4L);
                OS.memmove(l5, new int[]{++n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_after_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_after_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_text_at_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_at_offset: " + l2 + " start: " + l4 + " end: " + l5);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = 0;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n2 = accessibleTextEvent.start;
                int n3 = accessibleTextEvent.end;
                int n4 = 0;
                while (n4 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n4;
                }
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n4 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = 1;
                        int n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n4 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = -1;
                        int n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        break;
                    }
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n <= n7) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7);
                        if (n10 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n10 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n10) + 1) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = n10;
                        int n11 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n10);
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n11);
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n7 + 1);
                        n12 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n12);
                        n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n12 + 1);
                        if (n12 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n12 + 1;
                        int n13 = AccessibleObject.nextIndexOfNotChar(string, " \n", n8);
                        if (n13 == n) {
                            n9 = n8;
                            break;
                        }
                        if ((n13 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n13)) == -1) {
                            n9 = n8;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n13);
                        break;
                    }
                    case 3: {
                        int n14 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n7 + 1);
                        if (n14 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n14 = AccessibleObject.previousIndexOfChar(string, "!?.", n14) + 1;
                        n8 = AccessibleObject.nextIndexOfNotChar(string, " \n", n14);
                        int n15 = AccessibleObject.nextIndexOfChar(string, "!?.", n8);
                        n9 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n15);
                        break;
                    }
                    case 4: {
                        int n16 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n7 + 1);
                        n16 = AccessibleObject.previousIndexOfChar(string, "!?.", n16);
                        n16 = AccessibleObject.previousIndexOfNotChar(string, " \n", n16 + 1);
                        if (n16 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n16 + 1;
                        int n17 = AccessibleObject.nextIndexOfNotChar(string, " \n", n8);
                        if (n17 == n) {
                            n9 = n8;
                            break;
                        }
                        if ((n17 = AccessibleObject.nextIndexOfChar(string, "!?.", n17)) == -1) {
                            n9 = n8;
                            break;
                        }
                        n9 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n17);
                        break;
                    }
                    case 5: {
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n7) + 1;
                        int n18 = AccessibleObject.nextIndexOfChar(string, "\n", n8);
                        if (n18 < n) {
                            ++n18;
                        }
                        n9 = n18;
                        break;
                    }
                    case 6: {
                        int n19 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n19 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n8 = n19;
                        n9 = AccessibleObject.nextIndexOfChar(string, "\n", n19 + 1);
                    }
                }
                OS.memmove(l4, new int[]{n8}, 4L);
                OS.memmove(l5, new int[]{++n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_at_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_at_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static long atkText_get_text_before_offset(long l, long l2, long l3, long l4, long l5) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkText_get_text_before_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            object = accessibleObject.accessible;
            Vector vector = ((Accessible)object).accessibleTextExtendedListeners;
            int n = vector.size();
            if (n > 0) {
                long l6 = AccessibleObject.atkText_get_character_count(l);
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(object);
                accessibleTextEvent.start = accessibleTextEvent.end = (int)l2;
                accessibleTextEvent.count = -1;
                switch ((int)l3) {
                    case 0: {
                        accessibleTextEvent.type = 0;
                        break;
                    }
                    case 1: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 2: {
                        accessibleTextEvent.type = 1;
                        break;
                    }
                    case 3: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 4: {
                        accessibleTextEvent.type = 2;
                        break;
                    }
                    case 5: {
                        accessibleTextEvent.type = 4;
                        break;
                    }
                    case 6: {
                        accessibleTextEvent.type = 4;
                    }
                }
                int n2 = accessibleTextEvent.start;
                int n3 = accessibleTextEvent.end;
                int n4 = 0;
                while (n4 < n) {
                    AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n4);
                    accessibleTextExtendedListener.getText(accessibleTextEvent);
                    ++n4;
                }
                OS.memmove(l4, new int[]{accessibleTextEvent.start}, 4L);
                OS.memmove(l5, new int[]{accessibleTextEvent.end}, 4L);
                switch ((int)l3) {
                    case 1: 
                    case 3: 
                    case 5: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if ((long)accessibleTextEvent.end >= l6) break;
                        n4 = accessibleTextEvent.start;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = 0;
                        int n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        accessibleTextEvent.end = accessibleTextEvent.start;
                        accessibleTextEvent.start = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n5 = 0;
                        while (n5 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n5);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n5;
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        AccessibleTextExtendedListener accessibleTextExtendedListener;
                        if (accessibleTextEvent.start <= 0) break;
                        n4 = accessibleTextEvent.end;
                        accessibleTextEvent.start = n2;
                        accessibleTextEvent.end = n3;
                        accessibleTextEvent.count = -2;
                        int n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        accessibleTextEvent.start = accessibleTextEvent.end;
                        accessibleTextEvent.end = n4;
                        accessibleTextEvent.type = 5;
                        accessibleTextEvent.count = 0;
                        n6 = 0;
                        while (n6 < n) {
                            accessibleTextExtendedListener = (AccessibleTextExtendedListener)vector.elementAt(n6);
                            accessibleTextExtendedListener.getText(accessibleTextEvent);
                            ++n6;
                        }
                        break;
                    }
                }
                return AccessibleObject.getStringPtr(accessibleTextEvent.result);
            }
            int n7 = (int)l2;
            String string = accessibleObject.getText();
            if (string != null && string.length() > 0) {
                n = string.length();
                int n8 = n7 = Math.min(n7, n - 1);
                int n9 = n7;
                switch ((int)l3) {
                    case 0: {
                        if (n < n7 || n7 <= 0) break;
                        break;
                    }
                    case 1: {
                        int n10 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7 - 1);
                        if (n10 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        int n11 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n10);
                        if (n11 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n10 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n11) + 1;
                        break;
                    }
                    case 2: {
                        int n12 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7);
                        if (n12 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n12 = AccessibleObject.previousIndexOfNotChar(string, " \n", n12 + 1)) == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n12 + 1;
                        int n13 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n9);
                        if ((n13 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n13)) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = AccessibleObject.previousIndexOfNotChar(string, " \n", n13 + 1) + 1;
                        break;
                    }
                    case 3: {
                        int n14 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        if (n14 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        int n15 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n14);
                        if (n15 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n14 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, "!?.", n15) + 1;
                        break;
                    }
                    case 4: {
                        int n16 = AccessibleObject.previousIndexOfChar(string, "!?.", n7);
                        if (n16 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        if ((n16 = AccessibleObject.previousIndexOfNotChar(string, " \n", n16 + 1)) == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n16 + 1;
                        int n17 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n9);
                        if ((n17 = AccessibleObject.previousIndexOfChar(string, "!?.", n17)) == -1) {
                            n8 = 0;
                            break;
                        }
                        n8 = AccessibleObject.previousIndexOfNotChar(string, " \n", n17 + 1) + 1;
                        break;
                    }
                    case 5: {
                        int n18 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n18 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n18 + 1;
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n18) + 1;
                        break;
                    }
                    case 6: {
                        int n19 = AccessibleObject.previousIndexOfChar(string, "\n", n7);
                        if (n19 == -1) {
                            n9 = 0;
                            n8 = 0;
                            break;
                        }
                        n9 = n19;
                        n8 = AccessibleObject.previousIndexOfChar(string, "\n", n19);
                        if (n8 != -1) break;
                        n8 = 0;
                    }
                }
                OS.memmove(l4, new int[]{--n8}, 4L);
                OS.memmove(l5, new int[]{n9}, 4L);
                string = string.substring(n8, n9);
                return AccessibleObject.getStringPtr(string);
            }
        }
        if ((object = AccessibleObject.getTextIface(l)) != null && ((AtkTextIface)object).get_text_before_offset != 0L) {
            return ATK.call(((AtkTextIface)object).get_text_before_offset, l, l2, l3, l4, l5);
        }
        return 0L;
    }

    static void setGValue(long l, Number number) {
        if (number == null) {
            return;
        }
        if (OS.G_VALUE_TYPE(l) != 0L) {
            OS.g_value_unset(l);
        }
        if (number instanceof Double) {
            OS.g_value_init(l, OS.G_TYPE_DOUBLE());
            OS.g_value_set_double(l, number.doubleValue());
        } else if (number instanceof Float) {
            OS.g_value_init(l, OS.G_TYPE_FLOAT());
            OS.g_value_set_float(l, number.floatValue());
        } else if (number instanceof Long) {
            OS.g_value_init(l, OS.G_TYPE_INT64());
            OS.g_value_set_int64(l, number.longValue());
        } else {
            OS.g_value_init(l, OS.G_TYPE_INT());
            OS.g_value_set_int(l, number.intValue());
        }
    }

    static Number getGValue(long l) {
        long l2 = OS.G_VALUE_TYPE(l);
        if (l2 == 0L) {
            return null;
        }
        if (l2 == OS.G_TYPE_DOUBLE()) {
            return new Double(OS.g_value_get_double(l));
        }
        if (l2 == OS.G_TYPE_FLOAT()) {
            return new Float(OS.g_value_get_float(l));
        }
        if (l2 == OS.G_TYPE_INT64()) {
            return new Long(OS.g_value_get_int64(l));
        }
        return new Integer(OS.g_value_get_int(l));
    }

    static AtkValueIface getValueIface(long l) {
        if (ATK.g_type_is_a(OS.g_type_parent(OS.G_OBJECT_TYPE(l)), ATK.ATK_TYPE_VALUE())) {
            AtkValueIface atkValueIface = new AtkValueIface();
            ATK.memmove(atkValueIface, ATK.g_type_interface_peek_parent(ATK.ATK_VALUE_GET_IFACE(l)));
            return atkValueIface;
        }
        return null;
    }

    static long atkValue_get_current_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_current_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_current_value != 0L) {
            ATK.call(atkValueIface.get_current_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n2);
                    accessibleValueListener.getCurrentValue(accessibleValueEvent);
                    ++n2;
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_maximum_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_maximum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_maximum_value != 0L) {
            ATK.call(atkValueIface.get_maximum_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n2);
                    accessibleValueListener.getMaximumValue(accessibleValueEvent);
                    ++n2;
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_get_minimum_value(long l, long l2) {
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_get_minimum_value");
        }
        AccessibleObject accessibleObject = AccessibleObject.getAccessibleObject(l);
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.get_minimum_value != 0L) {
            ATK.call(atkValueIface.get_minimum_value, l, l2);
        }
        if (accessibleObject != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n2);
                    accessibleValueListener.getMinimumValue(accessibleValueEvent);
                    ++n2;
                }
                AccessibleObject.setGValue(l2, accessibleValueEvent.value);
            }
        }
        return 0L;
    }

    static long atkValue_set_current_value(long l, long l2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            AccessibleObject.print("-->atkValue_set_current_value");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(l)) != null) {
            Accessible accessible = accessibleObject.accessible;
            Vector vector = accessible.accessibleValueListeners;
            int n = vector.size();
            if (n > 0) {
                AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(accessible);
                accessibleValueEvent.value = AccessibleObject.getGValue(l2);
                int n2 = 0;
                while (n2 < n) {
                    AccessibleValueListener accessibleValueListener = (AccessibleValueListener)vector.elementAt(n2);
                    accessibleValueListener.setCurrentValue(accessibleValueEvent);
                    ++n2;
                }
                return accessibleValueEvent.value != null ? 1 : 0;
            }
        }
        long l3 = 0L;
        AtkValueIface atkValueIface = AccessibleObject.getValueIface(l);
        if (atkValueIface != null && atkValueIface.set_current_value != 0L) {
            l3 = ATK.call(atkValueIface.set_current_value, l, l2);
        }
        return l3;
    }

    static AccessibleObject getAccessibleObject(long l) {
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(l));
        if (accessibleObject == null) {
            return null;
        }
        if (accessibleObject.accessible == null) {
            return null;
        }
        Control control = accessibleObject.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return accessibleObject;
    }

    AccessibleObject getChildByID(int n) {
        if (n == -1) {
            return this;
        }
        if (n == -2 || n == -3) {
            return null;
        }
        if (this.children != null) {
            int n2 = 0;
            while (n2 < this.children.length) {
                AccessibleObject accessibleObject = this.children[n2];
                if (accessibleObject != null && accessibleObject.id == n) {
                    return accessibleObject;
                }
                ++n2;
            }
        }
        return null;
    }

    AccessibleObject getChildByIndex(int n) {
        if (this.children != null && n < this.children.length) {
            return this.children[n];
        }
        return null;
    }

    String getText() {
        Vector vector = this.accessible.accessibleControlListeners;
        int n = vector.size();
        if (n > 0) {
            long l;
            long l2;
            String string = "";
            AtkTextIface atkTextIface = AccessibleObject.getTextIface(this.handle);
            if (atkTextIface != null && atkTextIface.get_character_count != 0L && (l2 = ATK.call(atkTextIface.get_character_count, this.handle)) > 0L && atkTextIface.get_text != 0L && (l = ATK.call(atkTextIface.get_text, this.handle, 0L, l2)) != 0L) {
                string = AccessibleObject.getString(l);
                OS.g_free(l);
            }
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
            accessibleControlEvent.childID = this.id;
            accessibleControlEvent.result = string;
            int n2 = 0;
            while (n2 < n) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n2);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n2;
            }
            return accessibleControlEvent.result;
        }
        return null;
    }

    static long gObjectClass_finalize(long l) {
        if (DEBUG) {
            AccessibleObject.print("-->gObjectClass_finalize: " + l);
        }
        long l2 = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(l));
        long l3 = ATK.G_OBJECT_CLASS(l2);
        GObjectClass gObjectClass = new GObjectClass();
        ATK.memmove(gObjectClass, l3);
        ATK.call(gObjectClass.finalize, l);
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(l));
        if (accessibleObject != null) {
            AccessibleObjects.remove(new LONG(l));
        }
        return 0L;
    }

    static int toATKRelation(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 12;
            }
            case 14: {
                return 9;
            }
        }
        return 0;
    }

    static void windowPoint(AccessibleObject accessibleObject, int[] nArray, int[] nArray2) {
        GtkAccessible gtkAccessible = new GtkAccessible();
        ATK.memmove(gtkAccessible, accessibleObject.handle);
        while (gtkAccessible.widget == 0L && accessibleObject.parent != null) {
            accessibleObject = accessibleObject.parent;
            ATK.memmove(gtkAccessible, accessibleObject.handle);
        }
        if (gtkAccessible.widget == 0L) {
            return;
        }
        long l = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
        long l2 = OS.GTK_WIDGET_WINDOW(l);
        OS.gdk_window_get_origin(l2, nArray, nArray2);
    }

    static int nextIndexOfChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.indexOf(c, n);
            if (n4 != -1) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int nextIndexOfNotChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (string2.indexOf(c) == -1) break;
            ++n3;
        }
        return n3;
    }

    static int previousIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        if (n < 0) {
            return n2;
        }
        string = string.substring(0, n);
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.lastIndexOf(c);
            if (n4 != -1) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int previousIndexOfNotChar(String string, String string2, int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) == -1) break;
            --n2;
        }
        return n2;
    }

    void addRelation(int n, Accessible accessible) {
        OS.atk_object_add_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void release() {
        if (DEBUG) {
            AccessibleObject.print("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                AccessibleObject accessibleObject = this.children[n];
                if (accessibleObject != null) {
                    OS.g_object_unref(accessibleObject.handle);
                }
                ++n;
            }
            this.children = null;
        }
        if (this.isLightweight) {
            OS.g_object_unref(this.handle);
        }
    }

    void removeRelation(int n, Accessible accessible) {
        OS.atk_object_remove_relationship(this.handle, AccessibleObject.toATKRelation(n), accessible.getAccessibleObject().handle);
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void sendEvent(int n, Object object) {
        block0 : switch (n) {
            case 32777: {
                OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
                break;
            }
            case 32788: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
                break;
            }
            case 32778: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = -1;
                switch (n2) {
                    case 2: {
                        n4 = 21;
                        break;
                    }
                    case 0x200000: {
                        n4 = 20;
                        break;
                    }
                    case 0x1000000: {
                        n4 = 16;
                        break;
                    }
                    case 4: {
                        n4 = 11;
                        break;
                    }
                    case 0x100000: {
                        n4 = 10;
                        break;
                    }
                    case 8: {
                        n4 = 18;
                        break;
                    }
                    case 16: {
                        n4 = 4;
                        break;
                    }
                    case 512: {
                        n4 = 9;
                        break;
                    }
                    case 1024: {
                        n4 = 9;
                        break;
                    }
                    case 128: {
                        n4 = 2;
                        break;
                    }
                    case 2048: {
                        n4 = 3;
                        break;
                    }
                    case 64: {
                        n4 = 6;
                        break;
                    }
                    case 32768: {
                        n4 = 28;
                        break;
                    }
                    case 65536: {
                        n4 = 23;
                        break;
                    }
                    case 131072: {
                        n4 = 19;
                        break;
                    }
                    case 0x400000: {
                        break;
                    }
                    case 1: {
                        n4 = 7;
                        break;
                    }
                    case 0x4000000: {
                        n4 = 1;
                        break;
                    }
                    case 0x8000000: {
                        n4 = 24;
                        break;
                    }
                    case 0x10000000: {
                        n4 = 15;
                        break;
                    }
                    case 0x2000000: {
                        n4 = 32;
                        break;
                    }
                    case 0x20000000: {
                        n4 = 33;
                        break;
                    }
                    case 0x40000000: {
                        n4 = 34;
                    }
                }
                if (n4 == -1) break;
                ATK.atk_object_notify_state_change(this.handle, n4, n3 != 0);
                break;
            }
            case 32779: {
                Vector vector = this.accessible.accessibleControlListeners;
                int n5 = vector.size();
                GdkRectangle gdkRectangle = new GdkRectangle();
                if (n5 > 0) {
                    AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = this.id;
                    int n6 = 0;
                    while (n6 < n5) {
                        AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                        accessibleControlListener.getLocation(accessibleControlEvent);
                        ++n6;
                    }
                    gdkRectangle.x = accessibleControlEvent.x;
                    gdkRectangle.y = accessibleControlEvent.y;
                    gdkRectangle.width = accessibleControlEvent.width;
                    gdkRectangle.height = accessibleControlEvent.height;
                }
                OS.g_signal_emit_by_name(this.handle, ATK.bounds_changed, gdkRectangle);
                break;
            }
            case 32780: {
                OS.g_object_notify(this.handle, ATK.accessible_name);
                break;
            }
            case 32781: {
                OS.g_object_notify(this.handle, ATK.accessible_description);
                break;
            }
            case 32782: {
                OS.g_object_notify(this.handle, ATK.accessible_value);
                break;
            }
            case 261: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_complete);
                break;
            }
            case 262: {
                OS.g_signal_emit_by_name(this.handle, ATK.load_stopped);
                break;
            }
            case 263: {
                OS.g_signal_emit_by_name(this.handle, ATK.reload);
                break;
            }
            case 273: {
                break;
            }
            case 274: {
                break;
            }
            case 256: {
                break;
            }
            case 264: {
                OS.g_object_notify(this.handle, ATK.end_index);
                break;
            }
            case 265: {
                OS.g_object_notify(this.handle, ATK.number_of_anchors);
                break;
            }
            case 266: {
                OS.g_object_notify(this.handle, ATK.selected_link);
                break;
            }
            case 269: {
                OS.g_object_notify(this.handle, ATK.start_index);
                break;
            }
            case 267: {
                OS.g_signal_emit_by_name(this.handle, ATK.link_activated);
                break;
            }
            case 268: {
                if (!(object instanceof Integer)) break;
                int n7 = (Integer)object;
                OS.g_signal_emit_by_name(this.handle, ATK.link_selected, n7);
                break;
            }
            case 271: {
                OS.g_object_notify(this.handle, ATK.accessible_hypertext_nlinks);
                break;
            }
            case 512: {
                OS.g_signal_emit_by_name(this.handle, ATK.attributes_changed);
                break;
            }
            case 515: {
                OS.g_object_notify(this.handle, ATK.accessible_table_caption_object);
                break;
            }
            case 516: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_description);
                break;
            }
            case 517: {
                OS.g_object_notify(this.handle, ATK.accessible_table_column_header);
                break;
            }
            case 518: {
                if (!(object instanceof int[])) break;
                int[] nArray = (int[])object;
                int n8 = nArray[0];
                int n9 = nArray[1];
                int n10 = nArray[2];
                int n11 = nArray[3];
                int n12 = nArray[4];
                switch (n8) {
                    case 1: {
                        if (n10 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_deleted, n9, n10);
                        }
                        if (n12 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_deleted, n11, n12);
                        break;
                    }
                    case 0: {
                        if (n10 > 0) {
                            OS.g_signal_emit_by_name(this.handle, ATK.row_inserted, n9, n10);
                        }
                        if (n12 <= 0) break;
                        OS.g_signal_emit_by_name(this.handle, ATK.column_inserted, n11, n12);
                    }
                }
                break;
            }
            case 519: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_description);
                break;
            }
            case 520: {
                OS.g_object_notify(this.handle, ATK.accessible_table_row_header);
                break;
            }
            case 521: {
                OS.g_object_notify(this.handle, ATK.accessible_table_summary);
                break;
            }
            case 522: {
                OS.g_signal_emit_by_name(this.handle, ATK.text_attributes_changed);
                break;
            }
            case 283: 
            case 285: {
                int n13 = 0;
                Vector vector = this.accessible.accessibleTextExtendedListeners;
                int n14 = vector.size();
                AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this.accessible);
                if (n14 > 0) {
                    int n15 = 0;
                    while (n15 < n14) {
                        AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n15);
                        accessibleTextListener.getCaretOffset(accessibleTextEvent);
                        ++n15;
                    }
                } else {
                    vector = this.accessible.accessibleTextListeners;
                    n14 = vector.size();
                    if (n14 > 0) {
                        accessibleTextEvent.childID = this.id;
                        int n16 = 0;
                        while (n16 < n14) {
                            AccessibleTextListener accessibleTextListener = (AccessibleTextListener)vector.elementAt(n16);
                            accessibleTextListener.getCaretOffset(accessibleTextEvent);
                            ++n16;
                        }
                    }
                }
                n13 = accessibleTextEvent.offset;
                OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n13);
                break;
            }
            case 524: {
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                int n17 = (Integer)objectArray[0];
                int n18 = (Integer)objectArray[1];
                int n19 = (Integer)objectArray[2];
                switch (n17) {
                    case 1: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n18, n19 - n18);
                        break block0;
                    }
                    case 0: {
                        OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n18, n19 - n18);
                    }
                }
            }
        }
    }

    void sendEvent(int n, Object object, int n2) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n2);
        if (accessibleObject != null) {
            accessibleObject.sendEvent(n, object);
        }
    }

    void setFocus(int n) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n);
        if (accessibleObject != null) {
            OS.g_signal_emit_by_name(accessibleObject.handle, ATK.focus_event, 1L, 0L);
            ATK.atk_object_notify_state_change(accessibleObject.handle, 11, true);
        }
    }

    void textCaretMoved(int n) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n);
    }

    void textChanged(int n, int n2, int n3) {
        if (n == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n2, n3);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n2, n3);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        Object object;
        AccessibleObject[] accessibleObjectArray;
        Vector vector = this.accessible.accessibleControlListeners;
        int n = vector.size();
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
        accessibleControlEvent.childID = this.id;
        int n2 = 0;
        while (n2 < n) {
            accessibleObjectArray = (AccessibleObject[])vector.elementAt(n2);
            accessibleObjectArray.getChildren(accessibleControlEvent);
            ++n2;
        }
        Object[] objectArray = accessibleControlEvent.children;
        accessibleObjectArray = this.children;
        int n3 = objectArray != null ? objectArray.length : 0;
        AccessibleObject[] accessibleObjectArray2 = new AccessibleObject[n3];
        int n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            AccessibleObject accessibleObject = null;
            if (object instanceof Integer) {
                int n5 = (Integer)object;
                AccessibleObject accessibleObject2 = accessibleObject = accessibleObjectArray != null && n4 < accessibleObjectArray.length ? accessibleObjectArray[n4] : null;
                if (accessibleObject == null || accessibleObject.id != n5) {
                    accessibleControlEvent = new AccessibleControlEvent(this.accessible);
                    accessibleControlEvent.childID = n5;
                    int n6 = 0;
                    while (n6 < n) {
                        AccessibleControlListener accessibleControlListener = (AccessibleControlListener)vector.elementAt(n6);
                        accessibleControlListener.getChild(accessibleControlEvent);
                        ++n6;
                    }
                    if (accessibleControlEvent.accessible != null) {
                        accessibleObject = accessibleControlEvent.accessible.getAccessibleObject();
                        if (accessibleObject != null) {
                            OS.g_object_ref(accessibleObject.handle);
                        }
                    } else {
                        accessibleObject = AccessibleFactory.createChildAccessible(this.accessible, n5);
                    }
                    accessibleObject.id = n5;
                } else {
                    OS.g_object_ref(accessibleObject.handle);
                }
            } else if (object instanceof Accessible && (accessibleObject = ((Accessible)object).getAccessibleObject()) != null) {
                OS.g_object_ref(accessibleObject.handle);
            }
            if (accessibleObject != null) {
                accessibleObject.index = n4;
                accessibleObject.parent = this;
                accessibleObjectArray2[n4] = accessibleObject;
            }
            ++n4;
        }
        if (accessibleObjectArray != null) {
            n4 = 0;
            while (n4 < accessibleObjectArray.length) {
                object = accessibleObjectArray[n4];
                if (object != null) {
                    OS.g_object_unref(((AccessibleObject)object).handle);
                }
                ++n4;
            }
        }
        this.children = accessibleObjectArray2;
    }
}

