/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    long modelHandle;
    long checkRenderer;
    int columnCount;
    int sortDirection;
    long ignoreCell;
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(long l) {
        int n = this.getId(l, true);
        if (this.items[n] != null) {
            return this.items[n];
        }
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, l);
        int n2 = OS.gtk_tree_path_get_depth(l2);
        int[] nArray = new int[n2];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(l2), (long)(4 * n2));
        long l3 = 0L;
        if (n2 > 1) {
            OS.gtk_tree_path_up(l2);
            l3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_get_iter(this.modelHandle, l3, l2);
        }
        this.items[n] = new TreeItem(this, l3, 0, nArray[nArray.length - 1], false);
        OS.gtk_tree_path_free(l2);
        if (l3 != 0L) {
            OS.g_free(l3);
        }
        return this.items[n];
    }

    TreeItem _getItem(long l, int n) {
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, l, n);
        int n2 = this.getId(l2, true);
        OS.g_free(l2);
        if (this.items[n2] != null) {
            return this.items[n2];
        }
        this.items[n2] = new TreeItem(this, l, 0, n, false);
        return this.items[n2];
    }

    int getId(long l, boolean bl) {
        if (bl) {
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, l, 0, nArray, -1L);
            if (nArray[0] != -1) {
                return nArray[0];
            }
        }
        int n = 0;
        while (n < this.items.length && this.items[n] != null) {
            ++n;
        }
        if (n == this.items.length) {
            TreeItem[] treeItemArray = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
            this.items = treeItemArray;
        }
        OS.gtk_tree_store_set(this.modelHandle, l, 0, n, -1L);
        return n;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        boolean bl;
        if (l2 == this.ignoreCell) {
            return 0L;
        }
        TreeItem treeItem = this._getItem(l4);
        if (treeItem != null) {
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX2, treeItem.handle);
        }
        if (!(bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(l2)) && !OS.GTK_IS_CELL_RENDERER_TEXT(l2)) {
            return 0L;
        }
        int n = -1;
        boolean bl2 = false;
        if (this.columnCount == 0) {
            n = 6;
            bl2 = this.firstCustomDraw;
        } else {
            TreeColumn treeColumn = (TreeColumn)this.display.getWidget(l);
            if (treeColumn != null) {
                n = treeColumn.modelIndex;
                bl2 = treeColumn.customDraw;
            }
        }
        if (n == -1) {
            return 0L;
        }
        boolean bl3 = false;
        if ((this.style & 0x10000000) != 0 && !treeItem.cached) {
            bl3 = this.checkData(treeItem);
        }
        long[] lArray = new long[1];
        if (bl3) {
            if (bl) {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 0, lArray, -1L);
                OS.g_object_set(l2, OS.pixbuf, lArray[0], 0L);
                if (lArray[0] != 0L) {
                    OS.g_object_unref(lArray[0]);
                }
            } else {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 1, lArray, -1L);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.text, lArray[0], 0L);
                    OS.g_free(lArray[0]);
                }
            }
        }
        if (bl2) {
            if (!this.ownerDraw) {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 3, lArray, -1L);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.cell_background_gdk, lArray[0], 0L);
                    OS.gdk_color_free(lArray[0]);
                }
            }
            if (!bl) {
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 2, lArray, -1L);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.foreground_gdk, lArray[0], 0L);
                    OS.gdk_color_free(lArray[0]);
                }
                lArray[0] = 0L;
                OS.gtk_tree_model_get(l3, l4, n + 4, lArray, -1L);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.font_desc, lArray[0], 0L);
                    OS.pango_font_description_free(lArray[0]);
                }
            }
        }
        if (bl3) {
            this.ignoreCell = l2;
            this.setScrollWidth(l, treeItem);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            TreeItem treeItem2 = treeItem.getParentItem();
            Event event = new Event();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            this.currentItem = treeItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            if (treeItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(long l, long l2, boolean bl) {
        OS.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        int n = 0;
        int[] nArray = new int[1];
        long l3 = 0L;
        if (OS.gtk_tree_view_get_expander_column(this.handle) == l) {
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_widget_realize(this.handle);
            l3 = OS.gtk_tree_model_get_path(this.modelHandle, l2);
            OS.gtk_tree_view_get_cell_area(this.handle, l3, l, gdkRectangle);
            n += gdkRectangle.x;
            OS.gtk_widget_style_get(this.handle, OS.expander_size, nArray, 0L);
            n += nArray[0] + 4;
        }
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
        n += 2 * nArray[0];
        long l4 = 0L;
        l4 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(l) : OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l4 == 0L) {
            return 0;
        }
        long l5 = l4;
        while (l5 != 0L) {
            long l6 = OS.g_list_data(l5);
            if (l6 != 0L) {
                OS.gtk_cell_renderer_get_size(l6, this.handle, null, null, null, nArray, null);
                n += nArray[0];
            }
            l5 = OS.g_list_next(l5);
        }
        OS.g_list_free(l4);
        if (bl) {
            boolean bl2;
            if (l3 == 0L) {
                l3 = OS.gtk_tree_model_get_path(this.modelHandle, l2);
            }
            if (bl2 = OS.gtk_tree_view_row_expanded(this.handle, l3)) {
                long l7 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                boolean bl3 = OS.gtk_tree_model_iter_children(this.modelHandle, l7, l2);
                while (bl3) {
                    n = Math.max(n, this.calculateWidth(l, l7, true));
                    bl3 = OS.gtk_tree_model_iter_next(this.modelHandle, l7);
                }
                OS.g_free(l7);
            }
        }
        if (l3 != 0L) {
            OS.gtk_tree_path_free(l3);
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_tree_view_get_rules_hint(this.handle)) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0L);
            n += 2 * nArray[0];
        }
        return n;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        this.clear(0L, n, bl);
    }

    void clear(long l, int n, boolean bl) {
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, l2, l, n);
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
        if (nArray[0] != -1) {
            TreeItem treeItem = this.items[nArray[0]];
            treeItem.clear();
        }
        if (bl) {
            this.clearAll(bl, l2);
        }
        OS.g_free(l2);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(bl, 0L);
    }

    void clearAll(boolean bl, long l) {
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n == 0) {
            return;
        }
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean bl2 = OS.gtk_tree_model_iter_children(this.modelHandle, l2, l);
        int[] nArray = new int[1];
        while (bl2) {
            OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
            if (nArray[0] != -1) {
                TreeItem treeItem = this.items[nArray[0]];
                treeItem.clear();
            }
            if (bl) {
                this.clearAll(bl, l2);
            }
            bl2 = OS.gtk_tree_model_iter_next(this.modelHandle, l2);
        }
        OS.g_free(l2);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void copyModel(long l, int n, long l2, int n2, long[] lArray, long l3, long l4, int n3) {
        long l5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_iter_children(l, l5, l3)) {
            long[] lArray2 = new long[OS.gtk_tree_model_iter_n_children(l, l3)];
            int n4 = 0;
            long[] lArray3 = new long[1];
            int[] nArray = new int[1];
            do {
                long l6;
                if ((l6 = OS.g_malloc(OS.GtkTreeIter_sizeof())) == 0L) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(l2, l6, l4);
                OS.gtk_tree_model_get(l, l5, 0, nArray, -1L);
                int n5 = nArray[0];
                TreeItem treeItem = null;
                if (n5 != -1) {
                    treeItem = this.items[n5];
                    if (treeItem != null) {
                        long l7 = treeItem.handle;
                        lArray2[n4++] = l7;
                        int n6 = 0;
                        while (n6 < 3) {
                            OS.gtk_tree_model_get(l, l7, n6, nArray, -1L);
                            OS.gtk_tree_store_set(l2, l6, n6, nArray[0], -1L);
                            ++n6;
                        }
                        n6 = 3;
                        while (n6 < 6) {
                            OS.gtk_tree_model_get(l, l7, n6, lArray3, -1L);
                            OS.gtk_tree_store_set(l2, l6, n6, lArray3[0], -1L);
                            if (lArray3[0] != 0L) {
                                if (lArray[n6] == OS.G_TYPE_STRING()) {
                                    OS.g_free(lArray3[0]);
                                } else if (lArray[n6] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(lArray3[0]);
                                } else if (lArray[n6] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(lArray3[0]);
                                } else if (lArray[n6] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(lArray3[0]);
                                }
                            }
                            ++n6;
                        }
                        n6 = 0;
                        while (n6 < n3 - 6) {
                            int n7 = n2 + n6;
                            OS.gtk_tree_model_get(l, l7, n + n6, lArray3, -1L);
                            OS.gtk_tree_store_set(l2, l6, n7, lArray3[0], -1L);
                            if (lArray3[0] != 0L) {
                                if (lArray[n7] == OS.G_TYPE_STRING()) {
                                    OS.g_free(lArray3[0]);
                                } else if (lArray[n7] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(lArray3[0]);
                                } else if (lArray[n7] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(lArray3[0]);
                                } else if (lArray[n7] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(lArray3[0]);
                                }
                            }
                            ++n6;
                        }
                    }
                } else {
                    OS.gtk_tree_store_set(l2, l6, 0, -1, -1L);
                }
                this.copyModel(l, n, l2, n2, lArray, l5, l6, n3);
                if (treeItem != null) {
                    treeItem.handle = l6;
                    continue;
                }
                OS.g_free(l6);
            } while (OS.gtk_tree_model_iter_next(l, l5));
            int n8 = 0;
            while (n8 < lArray2.length) {
                long l8 = lArray2[n8];
                if (l8 != 0L) {
                    OS.gtk_tree_store_remove(l, l8);
                    OS.g_free(l8);
                }
                ++n8;
            }
        }
        OS.g_free(l5);
    }

    void createColumn(TreeColumn treeColumn, int n) {
        long l;
        int n2 = 6;
        if (this.columnCount != 0) {
            int n3 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] blArray = new boolean[n3];
            int n4 = 0;
            while (n4 < this.columnCount) {
                int n5 = this.columns[n4].modelIndex;
                int n6 = 0;
                while (n6 < 5) {
                    blArray[n5 + n6] = true;
                    ++n6;
                }
                ++n4;
            }
            while (n2 < n3) {
                if (!blArray[n2]) break;
                ++n2;
            }
            if (n2 == n3) {
                long l2 = this.modelHandle;
                long[] lArray = this.getColumnTypes(this.columnCount + 4);
                long l3 = OS.gtk_tree_store_newv(lArray.length, lArray);
                if (l3 == 0L) {
                    this.error(2);
                }
                this.copyModel(l2, 6, l3, 6, lArray, 0L, 0L, n3);
                OS.gtk_tree_view_set_model(this.handle, l3);
                this.setModel(l3);
            }
        }
        if ((l = OS.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            TreeColumn treeColumn2 = this.columns[0];
            this.createRenderers(treeColumn2.handle, treeColumn2.modelIndex, false, treeColumn2.style);
        }
        this.createRenderers(l, n2, n == 0, treeColumn == null ? 0 : treeColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(l, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(l, 2);
            if (this.columnCount != 0) {
                OS.gtk_tree_view_column_set_visible(l, false);
            }
        }
        OS.gtk_tree_view_column_set_resizable(l, true);
        OS.gtk_tree_view_column_set_clickable(l, true);
        OS.gtk_tree_view_column_set_min_width(l, 0);
        OS.gtk_tree_view_insert_column(this.handle, l, n);
        if (treeColumn != null) {
            treeColumn.handle = l;
            treeColumn.modelIndex = n2;
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n7 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n7 + 1);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0L, 0L);
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_tree_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(l, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    void createItem(TreeColumn treeColumn, int n) {
        long l;
        long l2;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            treeColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(treeColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(treeColumn.handle, false);
            treeColumn.modelIndex = 6;
            this.createRenderers(treeColumn.handle, treeColumn.modelIndex, true, treeColumn.style);
            treeColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(treeColumn, n);
        }
        long l3 = OS.gtk_hbox_new(false, 3);
        if (l3 == 0L) {
            this.error(2);
        }
        if ((l2 = OS.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((l = OS.gtk_image_new()) == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(l3, l);
        OS.gtk_container_add(l3, l2);
        OS.gtk_widget_show(l3);
        OS.gtk_widget_show(l2);
        treeColumn.labelHandle = l2;
        treeColumn.imageHandle = l;
        OS.gtk_tree_view_column_set_widget(treeColumn.handle, l3);
        long l4 = OS.gtk_widget_get_parent(l3);
        while (l4 != this.handle) {
            if (OS.GTK_IS_BUTTON(l4)) {
                treeColumn.buttonHandle = l4;
                break;
            }
            l4 = OS.gtk_widget_get_parent(l4);
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] treeColumnArray = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columns.length);
            this.columns = treeColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        if ((this.state & 0x4000) != 0) {
            treeColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int n2 = 0;
            while (n2 < this.items.length) {
                Font[] fontArray;
                TreeItem treeItem = this.items[n2];
                if (treeItem != null && (fontArray = treeItem.cellFont) != null) {
                    Font[] fontArray2 = new Font[this.columnCount];
                    System.arraycopy(fontArray, 0, fontArray2, 0, n);
                    System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                    treeItem.cellFont = fontArray2;
                }
                ++n2;
            }
        }
    }

    void createItem(TreeItem treeItem, long l, int n) {
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n == -1) {
            n = n2;
        }
        if (n < 0 || n > n2) {
            this.error(6);
        }
        treeItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (treeItem.handle == 0L) {
            this.error(2);
        }
        if (n == n2) {
            OS.gtk_tree_store_append(this.modelHandle, treeItem.handle, l);
        } else {
            OS.gtk_tree_store_insert(this.modelHandle, treeItem.handle, l, n);
        }
        int n3 = this.getId(treeItem.handle, false);
        this.items[n3] = treeItem;
        this.modelChanged = true;
    }

    void createRenderers(long l, int n, boolean bl, int n2) {
        long l2;
        long l3;
        OS.gtk_tree_view_column_clear(l);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(l, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.active, 1);
            OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.inconsistent, 2);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.cell_background_gdk, 4);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(l, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, l);
            }
        }
        long l4 = l3 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : OS.gtk_cell_renderer_pixbuf_new();
        if (l3 == 0L) {
            this.error(2);
        }
        long l5 = l2 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : OS.gtk_cell_renderer_text_new();
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(l3, Display.SWT_OBJECT_INDEX1, l);
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX1, l);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(l3, OS.mode, 1, 0L);
        }
        if ((n2 & 0x20000) != 0) {
            OS.g_object_set(l2, OS.xalign, 1.0f, 0L);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_pack_end(l, l3, false);
            OS.gtk_tree_view_column_set_alignment(l, 1.0f);
        } else if ((n2 & 0x1000000) != 0) {
            OS.g_object_set(l2, OS.xalign, 0.5f, 0L);
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_end(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(l, l3, false);
            OS.gtk_tree_view_column_pack_start(l, l2, true);
            OS.gtk_tree_view_column_set_alignment(l, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(l, l3, OS.pixbuf, n + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(l, l3, OS.cell_background_gdk, 4);
            OS.gtk_tree_view_column_add_attribute(l, l2, OS.cell_background_gdk, 4);
        }
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.text, n + 1);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.foreground_gdk, 3);
        OS.gtk_tree_view_column_add_attribute(l, l2, OS.font_desc, 5);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int n3 = 0;
            while (n3 < this.columnCount) {
                if (this.columns[n3].handle == l) {
                    bl2 = this.columns[n3].customDraw;
                    break;
                }
                ++n3;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(l, l2, this.display.cellDataProc, this.handle, 0L);
            OS.gtk_tree_view_column_set_cell_data_func(l, l3, this.display.cellDataProc, this.handle, 0L);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_iter(l, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn treeColumn) {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) break;
            ++n;
        }
        if (n == this.columnCount) {
            return;
        }
        long l = treeColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = treeColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, l);
        if (this.columnCount == 0) {
            long l2 = this.modelHandle;
            long[] lArray = this.getColumnTypes(1);
            long l3 = OS.gtk_tree_store_newv(lArray.length, lArray);
            if (l3 == 0L) {
                this.error(2);
            }
            this.copyModel(l2, treeColumn.modelIndex, l3, 6, lArray, 0L, 0L, 11);
            OS.gtk_tree_view_set_model(this.handle, l3);
            this.setModel(l3);
            this.createColumn(null, 0);
        } else {
            int n2 = 0;
            while (n2 < this.items.length) {
                TreeItem treeItem = this.items[n2];
                if (treeItem != null) {
                    long l4 = treeItem.handle;
                    int n3 = treeColumn.modelIndex;
                    OS.gtk_tree_store_set(this.modelHandle, l4, n3 + 0, 0L, -1L);
                    OS.gtk_tree_store_set(this.modelHandle, l4, n3 + 1, 0L, -1L);
                    OS.gtk_tree_store_set(this.modelHandle, l4, n3 + 2, 0L, -1L);
                    OS.gtk_tree_store_set(this.modelHandle, l4, n3 + 3, 0L, -1L);
                    OS.gtk_tree_store_set(this.modelHandle, l4, n3 + 4, 0L, -1L);
                    Font[] fontArray = treeItem.cellFont;
                    if (fontArray != null) {
                        if (this.columnCount == 0) {
                            treeItem.cellFont = null;
                        } else {
                            Font[] fontArray2 = new Font[this.columnCount];
                            System.arraycopy(fontArray, 0, fontArray2, 0, n);
                            System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                            treeItem.cellFont = fontArray2;
                        }
                    }
                }
                ++n2;
            }
            if (n == 0) {
                TreeColumn treeColumn2 = this.columns[0];
                treeColumn2.style &= 0xFEFDBFFF;
                treeColumn2.style |= 0x4000;
                this.createRenderers(treeColumn2.handle, treeColumn2.modelIndex, true, treeColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n4 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n4 + 1);
        }
    }

    void destroyItem(TreeItem treeItem) {
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_store_remove(this.modelHandle, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        this.modelChanged = true;
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            long[] lArray = new long[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    long l = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(lArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return OS.GTK_VERSION >= OS.VERSION(2, 12, 0);
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        int n = 0;
        while (n < this.columnCount) {
            TreeColumn treeColumn = this.columns[n];
            if (treeColumn.toolTipText != null) {
                treeColumn.setToolTipText(shell2, null);
                treeColumn.setToolTipText(shell, treeColumn.toolTipText);
            }
            ++n;
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        long l = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(l, nArray3, nArray4);
        long l3 = this.clientHandle();
        int n = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(l3);
        int n2 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(l3);
        return new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n, n2);
    }

    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        OS.gdk_drawable_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long l = OS.gtk_tree_view_get_columns(this.handle);
        if (l == 0L) {
            return new int[0];
        }
        int n = 0;
        int n2 = OS.g_list_length(l);
        int[] nArray = new int[n2];
        long l2 = l;
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                int n3 = 0;
                while (n3 < this.columnCount) {
                    if (this.columns[n3].handle == l3) {
                        nArray[n++] = n3;
                        break;
                    }
                    ++n3;
                }
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return nArray;
    }

    long[] getColumnTypes(int n) {
        long[] lArray = new long[6 + n * 5];
        lArray[0] = OS.G_TYPE_INT();
        lArray[1] = OS.G_TYPE_BOOLEAN();
        lArray[2] = OS.G_TYPE_BOOLEAN();
        lArray[3] = OS.GDK_TYPE_COLOR();
        lArray[4] = OS.GDK_TYPE_COLOR();
        lArray[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int n2 = 6;
        while (n2 < lArray.length) {
            lArray[n2 + 0] = OS.GDK_TYPE_PIXBUF();
            lArray[n2 + 1] = OS.G_TYPE_STRING();
            lArray[n2 + 2] = OS.GDK_TYPE_COLOR();
            lArray[n2 + 3] = OS.GDK_TYPE_COLOR();
            lArray[n2 + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            n2 += 5;
        }
        return lArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    TreeItem getFocusItem() {
        long[] lArray = new long[1];
        OS.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return null;
        }
        TreeItem treeItem = null;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, l, lArray[0])) {
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, l, 0, nArray, -1L);
            if (nArray[0] != -1) {
                treeItem = this.items[nArray[0]];
            }
        }
        OS.g_free(l);
        OS.gtk_tree_path_free(lArray[0]);
        return treeItem;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            int n2 = 0;
            while (n2 < this.columnCount) {
                long l = this.columns[n2].buttonHandle;
                if (l != 0L) {
                    OS.gtk_widget_size_request(l, gtkRequisition);
                    n = Math.max(n, gtkRequisition.height);
                }
                ++n2;
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        long l = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        long l2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(l2, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) {
            this.error(6);
        }
        return this._getItem(0L, n);
    }

    public TreeItem getItem(Point point) {
        long[] lArray;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] lArray2 = new long[1];
        OS.gtk_widget_realize(this.handle);
        int n = point.x;
        int n2 = point.y;
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray2, lArray = new long[1], null, null)) {
            return null;
        }
        if (lArray2[0] == 0L) {
            return null;
        }
        TreeItem treeItem = null;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, l, lArray2[0])) {
            boolean bl = false;
            if (OS.gtk_tree_view_get_expander_column(this.handle) == lArray[0]) {
                int[] nArray = new int[1];
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(this.handle, lArray2[0], lArray[0], gdkRectangle);
                if (OS.GTK_VERSION < OS.VERSION(2, 8, 18)) {
                    OS.gtk_widget_style_get(this.handle, OS.expander_size, nArray, 0L);
                    int n3 = nArray[0] + 4;
                    gdkRectangle.x += n3;
                }
                if ((this.style & 0x8000000) != 0) {
                    bl = n > gdkRectangle.x + gdkRectangle.width;
                } else {
                    boolean bl2 = bl = n < gdkRectangle.x;
                }
            }
            if (!bl) {
                treeItem = this._getItem(l);
            }
        }
        OS.g_free(l);
        OS.gtk_tree_path_free(lArray2[0]);
        return treeItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (n == 0) {
            long l = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, nArray2);
            this.ignoreSize = false;
            return nArray2[0];
        }
        int n2 = 0;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, l);
        int n3 = Math.max(1, this.columnCount);
        int n4 = 0;
        while (n4 < n3) {
            long l2 = OS.gtk_tree_view_get_column(this.handle, n4);
            OS.gtk_tree_view_column_cell_set_cell_data(l2, this.modelHandle, l, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(l2, null, null, null, nArray, nArray3);
            n2 = Math.max(n2, nArray3[0]);
            ++n4;
        }
        OS.g_free(l);
        return n2;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0L);
    }

    TreeItem[] getItems(long l) {
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, l);
        TreeItem[] treeItemArray = new TreeItem[n];
        if (n == 0) {
            return treeItemArray;
        }
        if ((this.style & 0x10000000) != 0) {
            int n2 = 0;
            while (n2 < n) {
                treeItemArray[n2] = this._getItem(l, n2);
                ++n2;
            }
        } else {
            int n3 = 0;
            int[] nArray = new int[1];
            long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            boolean bl = OS.gtk_tree_model_iter_children(this.modelHandle, l2, l);
            while (bl) {
                OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
                treeItemArray[n3++] = this.items[nArray[0]];
                bl = OS.gtk_tree_model_iter_next(this.modelHandle, l2);
            }
            OS.g_free(l2);
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    long getPixbufRenderer(long l) {
        long l2 = 0L;
        l2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(l) : OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l2 == 0L) {
            return 0L;
        }
        int n = OS.g_list_length(l2);
        long l3 = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l4 = OS.g_list_nth_data(l2, n2);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(l4)) {
                l3 = l4;
                break;
            }
            ++n2;
        }
        OS.g_list_free(l2);
        return l3;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.gtk_tree_selection_get_selected_rows(l, null);
        if (l2 != 0L) {
            int n = OS.g_list_length(l2);
            TreeItem[] treeItemArray = new TreeItem[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                long l3 = OS.g_list_nth_data(l2, n3);
                long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (OS.gtk_tree_model_get_iter(this.modelHandle, l4, l3)) {
                    treeItemArray[n2] = this._getItem(l4);
                    ++n2;
                }
                OS.g_free(l4);
                OS.gtk_tree_path_free(l3);
                ++n3;
            }
            OS.g_list_free(l2);
            if (n2 < n) {
                TreeItem[] treeItemArray2 = new TreeItem[n2];
                System.arraycopy(treeItemArray, 0, treeItemArray2, 0, n2);
                treeItemArray = treeItemArray2;
            }
            return treeItemArray;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(l);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long l) {
        long l2 = 0L;
        l2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(l) : OS.gtk_tree_view_column_get_cell_renderers(l);
        if (l2 == 0L) {
            return 0L;
        }
        int n = OS.g_list_length(l2);
        long l3 = 0L;
        int n2 = 0;
        while (n2 < n) {
            long l4 = OS.g_list_nth_data(l2, n2);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(l4)) {
                l3 = l4;
                break;
            }
            ++n2;
        }
        OS.g_list_free(l2);
        return l3;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        TreeItem treeItem = null;
        long l = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, l, lArray[0])) {
            treeItem = this._getItem(l);
        }
        OS.g_free(l);
        OS.gtk_tree_path_free(lArray[0]);
        return treeItem;
    }

    long gtk_button_press_event(long l, long l2) {
        long l3;
        long[] lArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        int n = gdkEventButton.button;
        if (n == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(l3, lArray[0])) {
                l4 = 1L;
            }
            OS.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            l3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_path_free(lArray[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return l4;
    }

    long gtk_button_release_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_button_release_event(l, l2);
    }

    long gtk_changed(long l) {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem != null) {
            Event event = new Event();
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        switch (OS.GDK_EVENT_TYPE(l2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) != 0) break;
                this.gtk_expose_event(l, l2);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_expand_collapse_cursor_row(long l, long l2, long l3, long l4) {
        if (l3 != 0L && l4 != 0L) {
            this.expandAll = true;
        }
        return 0L;
    }

    long gtk_expose_event(long l, long l2) {
        Control control;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
            long l3 = OS.gtk_tree_view_get_bin_window(this.handle);
            if (l3 == gdkEventExpose.window) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gdk_drawable_get_size(l3, nArray, nArray2);
                long l4 = 0L;
                int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, l4);
                GdkRectangle gdkRectangle = new GdkRectangle();
                boolean bl = true;
                while (n != 0 && bl && nArray2[0] > gdkRectangle.y + gdkRectangle.height) {
                    long l5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, l5, l4, n - 1);
                    n = OS.gtk_tree_model_iter_n_children(this.modelHandle, l5);
                    long l6 = OS.gtk_tree_model_get_path(this.modelHandle, l5);
                    OS.gtk_tree_view_get_cell_area(this.handle, l6, 0L, gdkRectangle);
                    bl = OS.gtk_tree_view_row_expanded(this.handle, l6);
                    OS.gtk_tree_path_free(l6);
                    if (l4 != 0L) {
                        OS.g_free(l4);
                    }
                    l4 = l5;
                }
                if (l4 != 0L) {
                    OS.g_free(l4);
                }
                if (nArray2[0] > gdkRectangle.y + gdkRectangle.height) {
                    this.drawBackground(control, l3, gdkEventExpose.region, 0, gdkRectangle.y + gdkRectangle.height, nArray[0], nArray2[0] - (gdkRectangle.y + gdkRectangle.height));
                }
            }
        }
        return super.gtk_expose_event(l, l2);
    }

    long gtk_motion_notify_event(long l, long l2) {
        long l3 = OS.GDK_EVENT_WINDOW(l2);
        if (l3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    long gtk_popup_menu(long l) {
        long l2 = super.gtk_popup_menu(l);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1L : l2;
    }

    long gtk_row_activated(long l, long l2, long l3) {
        Object object;
        if (l2 == 0L) {
            return 0L;
        }
        TreeItem treeItem = null;
        long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, l4, l2)) {
            object = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, l4, 0, object, -1L);
            treeItem = this.items[object[0]];
        }
        OS.g_free(l4);
        object = new Event();
        object.item = treeItem;
        this.sendSelectionEvent(14, (Event)object, false);
        return 0L;
    }

    int gtk_row_deleted(int n, int n2) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_deleted);
        }
        return 0;
    }

    int gtk_row_inserted(int n, int n2, int n3) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_inserted);
        }
        return 0;
    }

    long gtk_start_interactive_search(long l) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(l, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    long gtk_test_collapse_row(long l, long l2, long l3) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean bl2 = this.modelChanged || !OS.gtk_tree_view_row_expanded(this.handle, l3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1L;
        }
        if (bl2) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            OS.gtk_tree_view_collapse_row(this.handle, l3);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            return 1L;
        }
        return 0L;
    }

    long gtk_test_expand_row(long l, long l2, long l3) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
        TreeItem treeItem = this.items[nArray[0]];
        Event event = new Event();
        event.item = treeItem;
        boolean bl = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean bl2 = this.modelChanged || OS.gtk_tree_view_row_expanded(this.handle, l3);
        this.modelChanged = bl;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return 1L;
        }
        if (bl2 || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            OS.gtk_tree_view_expand_row(this.handle, l3, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            return 1L;
        }
        return 0L;
    }

    long gtk_toggled(long l, long l2) {
        long l3 = OS.gtk_tree_path_new_from_string(l2);
        if (l3 == 0L) {
            return 0L;
        }
        TreeItem treeItem = null;
        long l4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (OS.gtk_tree_model_get_iter(this.modelHandle, l4, l3)) {
            treeItem = this._getItem(l4);
        }
        OS.g_free(l4);
        OS.gtk_tree_path_free(l3);
        if (treeItem != null) {
            treeItem.setChecked(!treeItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    void gtk_widget_size_request(long l, GtkRequisition gtkRequisition) {
        long l2;
        long l3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(l, gtkRequisition);
            return;
        }
        long l4 = l3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl = l3 != 0L;
        while (l4 != 0L) {
            l2 = OS.g_list_data(l4);
            if (OS.gtk_tree_view_column_get_visible(l2)) {
                bl = false;
                break;
            }
            l4 = OS.g_list_next(l4);
        }
        l2 = 0L;
        if (bl) {
            l2 = OS.g_list_data(l3);
            OS.gtk_tree_view_column_set_visible(l2, true);
        }
        super.gtk_widget_size_request(l, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(l2, false);
        }
        if (l3 != 0L) {
            OS.g_list_free(l3);
        }
    }

    void hideFirstColumn() {
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, false);
    }

    void hookEvents() {
        super.hookEvents();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.closures[51], false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.closures[50], false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.closures[17], false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.closures[69], false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.closures[64], true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.closures[65], true);
        }
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        long l;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        int n = -1;
        long l2 = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        int n2 = OS.gtk_tree_path_get_depth(l2);
        if (n2 == 1 && (l = OS.gtk_tree_path_get_indices(l2)) != 0L) {
            int[] nArray = new int[1];
            OS.memmove(nArray, l, 4L);
            n = nArray[0];
        }
        OS.gtk_tree_path_free(l2);
        return n;
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.columnCount) {
            long l = this.columns[n].labelHandle;
            if (l != 0L && this.mnemonicHit(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = 0;
        while (n < this.columnCount) {
            long l = this.columns[n].labelHandle;
            if (l != 0L && this.mnemonicMatch(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    long paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            int n = 0;
            while (n < this.columnCount) {
                TreeColumn treeColumn = this.columns[n];
                this.createRenderers(treeColumn.handle, treeColumn.modelIndex, n == 0, treeColumn.style);
                ++n;
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem treeItem, boolean bl) {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, 0, nArray, -1L);
        if (nArray[0] == -1) {
            return;
        }
        if (bl) {
            treeItem.release(false);
        }
        this.items[nArray[0]] = null;
    }

    void releaseItems(long l) {
        int[] nArray = new int[1];
        long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        boolean bl = OS.gtk_tree_model_iter_children(this.modelHandle, l2, l);
        while (bl) {
            this.releaseItems(l2);
            if (!this.isDisposed()) {
                TreeItem treeItem;
                OS.gtk_tree_model_get(this.modelHandle, l2, 0, nArray, -1L);
                if (nArray[0] != -1 && (treeItem = this.items[nArray[0]]) != null) {
                    this.releaseItem(treeItem, true);
                }
            }
            bl = OS.gtk_tree_model_iter_next(this.modelHandle, l2);
        }
        OS.g_free(l2);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            n = 0;
            while (n < this.items.length) {
                item = this.items[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    void remove(long l, int n, int n2) {
        if (n > n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        long l2 = OS.gtk_tree_view_get_selection(this.handle);
        long l3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (l3 == 0L) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int n4 = n;
        while (n4 <= n2) {
            TreeItem treeItem;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, l3, l, n);
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, l3, 0, nArray, -1L);
            TreeItem treeItem2 = treeItem = nArray[0] != -1 ? this.items[nArray[0]] : null;
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
            } else {
                OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
                OS.gtk_tree_store_remove(this.modelHandle, l3);
                OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            }
            ++n4;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(l3);
    }

    public void removeAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.release(false);
            }
            ++n;
        }
        this.items = new TreeItem[4];
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_tree_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n2 = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    long rendererGetSizeProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        long l8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l8);
        long l9 = OS.call(gtkCellRendererClass.get_size, l, this.handle, l3, l4, l5, l6, l7);
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(l)) {
            long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
            TreeItem treeItem = null;
            if (l10 != 0L) {
                treeItem = this._getItem(l10);
            }
            if (treeItem != null) {
                int n = 0;
                if (this.columnCount > 0) {
                    long l11 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
                    int n2 = 0;
                    while (n2 < this.columnCount) {
                        if (this.columns[n2].handle == l11) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                }
                if (this.hooks(41)) {
                    Object object;
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    if (l6 != 0L) {
                        OS.memmove(nArray, l6, 4L);
                    }
                    if (l7 != 0L) {
                        OS.memmove(nArray2, l7, 4L);
                    }
                    Image image = treeItem.getImage(n);
                    int n3 = 0;
                    if (image != null) {
                        object = image.getBounds();
                        n3 = ((Rectangle)object).width;
                    }
                    nArray[0] = nArray[0] + n3;
                    object = new GC(this);
                    ((GC)object).setFont(treeItem.getFont(n));
                    Event event = new Event();
                    event.item = treeItem;
                    event.index = n;
                    event.gc = object;
                    event.width = nArray[0];
                    event.height = nArray2[0];
                    long l12 = OS.gtk_tree_model_get_path(this.modelHandle, l10);
                    long l13 = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(l13, l12)) {
                        event.detail = 2;
                    }
                    OS.gtk_tree_path_free(l12);
                    this.sendEvent(41, event);
                    ((Resource)object).dispose();
                    nArray[0] = event.width - n3;
                    if (nArray2[0] < event.height) {
                        nArray2[0] = event.height;
                    }
                    if (l6 != 0L) {
                        OS.memmove(l6, nArray, 4L);
                    }
                    if (l7 != 0L) {
                        OS.memmove(l7, nArray2, 4L);
                    }
                }
            }
        }
        return l9;
    }

    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        GdkRectangle gdkRectangle;
        Object object;
        Object object2;
        Object object3;
        long l8;
        TreeItem treeItem = null;
        long l9 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
        if (l9 != 0L) {
            treeItem = this._getItem(l9);
        }
        long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
        int n = 0;
        if (this.columnCount > 0) {
            int n2 = 0;
            while (n2 < this.columnCount) {
                if (this.columns[n2].handle == l10) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (treeItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(l) || OS.GTK_IS_CELL_RENDERER_PIXBUF(l) && (n != 0 || (this.style & 0x20) == 0))) {
            long l11;
            Control control;
            this.drawFlags = (int)l7;
            this.drawState = 16;
            long[] lArray = new long[1];
            OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, 4, lArray, -1L);
            if (lArray[0] == 0L) {
                int n3 = this.columnCount == 0 ? 6 : this.columns[n].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, treeItem.handle, n3 + 3, lArray, -1L);
            }
            if (lArray[0] != 0L) {
                this.drawState |= 8;
                OS.gdk_color_free(lArray[0]);
            }
            if ((l7 & 1L) != 0L) {
                this.drawState |= 2;
            }
            if ((l7 & 0x10L) != 0L) {
                this.drawState |= 4;
            }
            GdkRectangle gdkRectangle2 = new GdkRectangle();
            l8 = OS.gtk_tree_model_get_path(this.modelHandle, l9);
            OS.gtk_tree_view_get_background_area(this.handle, l8, l10, gdkRectangle2);
            OS.gtk_tree_path_free(l8);
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                this.drawBackground(control, l2, 0L, gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.width, gdkRectangle2.height);
            }
            if ((l11 = this.getTextRenderer(l10)) != 0L) {
                OS.gtk_cell_renderer_get_size(l11, this.handle, null, null, null, null, null);
            }
            if (this.hooks(40)) {
                boolean bl;
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl) {
                    object3 = this.findBackgroundControl();
                    if (object3 == null) {
                        object3 = this;
                    }
                    this.drawBackground((Control)object3, l2, 0L, gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.width, gdkRectangle2.height);
                }
                object3 = new GC(this);
                if ((this.drawState & 2) != 0) {
                    ((GC)object3).setBackground(this.display.getSystemColor(26));
                    ((GC)object3).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object3).setBackground(treeItem.getBackground(n));
                    ((GC)object3).setForeground(treeItem.getForeground(n));
                }
                ((GC)object3).setFont(treeItem.getFont(n));
                if ((this.style & 0x8000000) != 0) {
                    gdkRectangle2.x = this.getClientWidth() - gdkRectangle2.width - gdkRectangle2.x;
                }
                ((GC)object3).setClipping(gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.width, gdkRectangle2.height);
                object2 = new Event();
                ((Event)object2).item = treeItem;
                ((Event)object2).index = n;
                ((Event)object2).gc = object3;
                ((Event)object2).x = gdkRectangle2.x;
                ((Event)object2).y = gdkRectangle2.y;
                ((Event)object2).width = gdkRectangle2.width;
                ((Event)object2).height = gdkRectangle2.height;
                ((Event)object2).detail = this.drawState;
                this.sendEvent(40, (Event)object2);
                this.drawForeground = null;
                this.drawState = ((Event)object2).doit ? ((Event)object2).detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    long l12 = OS.gtk_widget_get_style(l3);
                    object = Converter.wcsToMbcs(null, "cell_odd", true);
                    OS.gtk_paint_flat_box(l12, l2, 3, 0, gdkRectangle2, l3, (byte[])object, gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.width, gdkRectangle2.height);
                } else if (bl) {
                    this.drawForeground = ((GC)object3).getForeground().handle;
                }
                ((Resource)object3).dispose();
            }
        }
        long l13 = 0L;
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = new GC(this);
            gC.setBackground(treeItem.getBackground(n));
            gdkRectangle = new GdkRectangle();
            OS.memmove(gdkRectangle, l4, (long)GdkRectangle.sizeof);
            gC.fillRectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(l)) {
            l8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
            GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
            OS.memmove(gtkCellRendererClass, l8);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(l)) {
                OS.g_object_set(l, OS.foreground_gdk, this.drawForeground, 0L);
            }
            l13 = OS.call(gtkCellRendererClass.render, l, l2, this.handle, l4, l5, l6, this.drawFlags);
        }
        if (treeItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(42)) {
            Object object4;
            GdkRectangle gdkRectangle3 = new GdkRectangle();
            gdkRectangle = new GdkRectangle();
            long l14 = OS.gtk_tree_model_get_path(this.modelHandle, l9);
            OS.gtk_tree_view_get_cell_area(this.handle, l14, l10, gdkRectangle3);
            OS.gtk_tree_view_get_background_area(this.handle, l14, l10, gdkRectangle);
            OS.gtk_tree_path_free(l14);
            if (OS.GTK_VERSION < OS.VERSION(2, 8, 18) && OS.gtk_tree_view_get_expander_column(this.handle) == l10) {
                int[] nArray = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.expander_size, nArray, 0L);
                gdkRectangle3.x += nArray[0] + 4;
                gdkRectangle3.width -= nArray[0] + 4;
            }
            this.ignoreSize = true;
            int[] nArray = new int[1];
            object3 = new int[1];
            OS.gtk_cell_renderer_get_size(l, this.handle, null, null, null, (int[])object3, null);
            OS.gtk_tree_view_column_cell_get_position(l10, l, nArray, null);
            this.ignoreSize = false;
            object2 = treeItem.getImage(n);
            int n4 = 0;
            if (object2 != null) {
                object4 = ((Image)object2).getBounds();
                n4 = ((Rectangle)object4).width;
            }
            nArray[0] = nArray[0] - n4;
            Object object5 = object3;
            object5[0] = object5[0] + n4;
            object4 = new GC(this);
            if ((this.drawState & 2) != 0) {
                ((GC)object4).setBackground(this.display.getSystemColor(26));
                ((GC)object4).setForeground(this.display.getSystemColor(27));
            } else {
                ((GC)object4).setBackground(treeItem.getBackground(n));
                object = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : treeItem.getForeground(n);
                ((GC)object4).setForeground((Color)object);
            }
            ((GC)object4).setFont(treeItem.getFont(n));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle3.x = this.getClientWidth() - gdkRectangle3.width - gdkRectangle3.x;
                gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
            }
            ((GC)object4).setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            object = new Event();
            ((Event)object).item = treeItem;
            ((Event)object).index = n;
            ((Event)object).gc = object4;
            ((Event)object).x = gdkRectangle3.x + nArray[0];
            ((Event)object).y = gdkRectangle3.y;
            ((Event)object).width = (int)object3[0];
            ((Event)object).height = gdkRectangle3.height;
            ((Event)object).detail = this.drawState;
            this.sendEvent(42, (Event)object);
            ((Resource)object4).dispose();
        }
        return l13;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[n2].customDraw : this.firstCustomDraw;
            if (bl) {
                long l = OS.gtk_tree_view_get_column(this.handle, n2);
                long l2 = this.getTextRenderer(l);
                OS.gtk_tree_view_column_set_cell_data_func(l, l2, 0L, 0L, 0L);
                if (this.columnCount != 0) {
                    this.columns[n2].customDraw = false;
                }
            }
            ++n2;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            n2 = 0;
            while (n2 < this.items.length) {
                item = this.items[n2];
                if (item != null) {
                    item.reskinChildren(n);
                }
                ++n2;
            }
        }
        if (this.columns != null) {
            n2 = 0;
            while (n2 < this.columns.length) {
                item = this.columns[n2];
                if (item != null) {
                    item.reskinChildren(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        if ((this.style & 0x10000000) != 0) {
            return false;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            int n = 229376;
            Shell shell = this.getShell();
            if ((shell.style & n) != 0) {
                return false;
            }
        }
        return true;
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem == null) {
            OS.gtk_tree_view_set_drag_dest_row(this.handle, 0L, 0);
            return;
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        Rectangle rectangle = treeItem.getBounds();
        long[] lArray = new long[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, rectangle.x, rectangle.y, lArray, null, null, null)) {
            return;
        }
        if (lArray[0] == 0L) {
            return;
        }
        int n = bl ? 0 : 1;
        OS.gtk_tree_view_set_drag_dest_row(this.handle, lArray[0], n);
        OS.gtk_tree_path_free(lArray[0]);
    }

    void setItemCount(long l, int n) {
        boolean bl;
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, l);
        if (n == n2) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(l, n, n2 - 1);
        if (bl) {
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int n3 = n2;
            while (n3 < n) {
                long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (l2 == 0L) {
                    this.error(2);
                }
                OS.gtk_tree_store_append(this.modelHandle, l2, l);
                OS.gtk_tree_store_set(this.modelHandle, l2, 0, -1, -1L);
                OS.g_free(l2);
                ++n3;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
        } else {
            int n4 = n2;
            while (n4 < n) {
                new TreeItem(this, l, 0, n4, true);
                ++n4;
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.setItemCount(0L, n);
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_iter(l, treeItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L) == 0) {
            this.redraw(false);
        }
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            ++n;
        }
        long l = 0L;
        int n3 = 0;
        while (n3 < nArray.length) {
            long l2 = this.columns[nArray[n3]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, l2, l);
            l = l2;
            ++n3;
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        TreeColumn[] treeColumnArray = this.getColumns();
        int n = 0;
        while (n < treeColumnArray.length) {
            if (treeColumnArray[n] != null) {
                treeColumnArray[n].setFontDescription(l);
            }
            ++n;
        }
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
        }
    }

    void setModel(long l) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = l;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.closures[64], true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.closures[65], true);
        }
    }

    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        if (this.items != null) {
            n = 0;
            while (n < this.items.length) {
                if (this.items[n] != null) {
                    this.items[n].setOrientation(bl);
                }
                ++n;
            }
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columns.length) {
                if (this.columns[n] != null) {
                    this.columns[n].setOrientation(bl);
                }
                ++n;
            }
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(long l) {
        long l2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(l, l2);
    }

    void setScrollWidth(long l, TreeItem treeItem) {
        int n;
        if (this.columnCount != 0 || this.currentItem == treeItem) {
            return;
        }
        int n2 = OS.gtk_tree_view_column_get_fixed_width(l);
        if (n2 < (n = this.calculateWidth(l, treeItem.handle, true))) {
            OS.gtk_tree_view_column_set_fixed_width(l, n);
        }
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem != null) {
                if (treeItem.isDisposed()) break;
                if (treeItem.parent == this) {
                    long l2 = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
                    this.showItem(l2, false);
                    if (bl2) {
                        OS.gtk_tree_view_set_cursor(this.handle, l2, 0L, false);
                    }
                    OS.gtk_tree_selection_select_iter(l, treeItem.handle);
                    OS.gtk_tree_path_free(l2);
                    bl2 = false;
                }
            }
            ++n2;
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = treeColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem treeItem) {
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        long l = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(l, false);
        OS.gtk_tree_view_scroll_to_cell(this.handle, l, 0L, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, l, 0L, gdkRectangle);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle.x, gdkRectangle.y, nArray, nArray2);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        }
        OS.gtk_tree_path_free(l);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, 0L, treeColumn.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle2);
        if (gdkRectangle.x < gdkRectangle2.x) {
            OS.gtk_tree_view_scroll_to_point(this.handle, gdkRectangle.x, -1);
        } else {
            int n = Math.min(gdkRectangle2.width, gdkRectangle.width);
            if (gdkRectangle.x + n > gdkRectangle2.x + gdkRectangle2.width) {
                int n2 = gdkRectangle.x + n - gdkRectangle2.width;
                OS.gtk_tree_view_scroll_to_point(this.handle, n2, -1);
            }
        }
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            long l = OS.gtk_tree_view_get_column(this.handle, n2);
            if (OS.gtk_tree_view_column_get_visible(l)) {
                return false;
            }
            ++n2;
        }
        long l = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(l, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length != 0 && treeItemArray[0] != null) {
            this.showItem(treeItemArray[0]);
        }
    }

    void showItem(long l, boolean bl) {
        int n;
        Object object;
        int n2 = OS.gtk_tree_path_get_depth(l);
        if (n2 > 1) {
            object = new int[n2 - 1];
            long l2 = OS.gtk_tree_path_get_indices(l);
            OS.memmove(object, l2, (long)(((int[])object).length * 4));
            long l3 = OS.gtk_tree_path_new();
            n = 0;
            while (n < ((int[])object).length) {
                OS.gtk_tree_path_append_index(l3, object[n]);
                OS.gtk_tree_view_expand_row(this.handle, l3, false);
                ++n;
            }
            OS.gtk_tree_path_free(l3);
        }
        if (bl) {
            OS.gtk_widget_realize(this.handle);
            object = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, l, 0L, (GdkRectangle)object);
            boolean bl2 = object.y == 0 && object.height == 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_tree_view_convert_widget_to_bin_window_coords(this.handle, object.x, object.y, nArray, nArray2);
            } else {
                OS.gtk_tree_view_widget_to_tree_coords(this.handle, object.x, object.y, nArray, nArray2);
            }
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
            if (!(bl2 || nArray2[0] >= gdkRectangle.y && nArray2[0] + object.height <= gdkRectangle.y + gdkRectangle.height)) {
                bl2 = true;
            }
            if (bl2) {
                if (n2 != 1) {
                    OS.gtk_tree_view_scroll_to_cell(this.handle, l, 0L, true, 0.5f, 0.0f);
                } else if (nArray2[0] < gdkRectangle.y) {
                    OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
                } else {
                    n = Math.min(gdkRectangle.height, object.height);
                    if (nArray2[0] + n > gdkRectangle.y + gdkRectangle.height) {
                        OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0] + object.height - gdkRectangle.height);
                    }
                }
            }
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        long l = OS.gtk_tree_model_get_path(this.modelHandle, treeItem.handle);
        this.showItem(l, true);
        OS.gtk_tree_path_free(l);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        long l = this.parentingHandle();
        long l2 = OS.gtk_container_get_children(l);
        if (l2 == 0L) {
            return;
        }
        long l3 = l2;
        while (l3 != 0L) {
            long l4 = OS.g_list_data(l3);
            if (l4 != 0L) {
                OS.gtk_widget_queue_resize(l4);
            }
            l3 = OS.g_list_next(l3);
        }
        OS.g_list_free(l2);
    }

    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 19: {
                Control control;
                int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
                if (n != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
                long l4 = OS.gtk_tree_view_get_bin_window(l);
                if (l4 != gdkEventExpose.window) break;
                this.drawBackground(control, l4, gdkEventExpose.region, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
            }
        }
        return super.windowProc(l, l2, l3);
    }
}

