/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli.common;

import java.util.Arrays;
import java.util.Iterator;
import org.tizen.library.sdkutils.cli.common.Command;
import org.tizen.library.sdkutils.cli.common.CommandLine;
import org.tizen.library.sdkutils.cli.common.CommandParser;
import org.tizen.library.sdkutils.cli.common.Commands;
import org.tizen.library.sdkutils.cli.common.Option;
import org.tizen.library.sdkutils.cli.common.OptionFormatException;
import org.tizen.library.sdkutils.cli.common.Options;
import org.tizen.library.sdkutils.cli.common.ParseException;

public class DefaultParser
implements CommandParser {
    @Override
    public CommandLine parse(Commands commands, String[] args) throws ParseException {
        CommandLine commandLine = new CommandLine();
        Iterator<String> iterator = Arrays.asList(args).iterator();
        Command command = null;
        String cmdArg = null;
        if (iterator.hasNext() && commands.containsCommand(cmdArg = iterator.next().trim())) {
            command = commands.getCommand(cmdArg);
        }
        if (command == null) {
            throw new ParseException(cmdArg + " : " + "Command not found");
        }
        if (!command.hasOptions()) {
            commandLine.setCommand(new Command(command));
            return commandLine;
        }
        Options cmdOpts = new Options();
        while (iterator.hasNext()) {
            String arg = iterator.next().trim();
            if (command.getOptions().containsOption(arg)) {
                Option option = command.getOptions().getOption(arg);
                if (option.isHasArg()) {
                    if (iterator.hasNext()) {
                        cmdOpts.addOption(option, iterator.next().trim());
                        continue;
                    }
                    throw new OptionFormatException("Missing argument for " + option.getOption(), command);
                }
                cmdOpts.addOption(option, null);
                continue;
            }
            throw new OptionFormatException(arg + "is not valid option for action", command);
        }
        command.setRunOptions(cmdOpts);
        commandLine.setCommand(command);
        String requiredOpt = command.getUndefinedRequiredOption();
        if (requiredOpt != null) {
            throw new OptionFormatException(requiredOpt + " " + "must be defined for action", command);
        }
        return commandLine;
    }
}

