/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.manager.util.PathUtil;
import org.tizen.packagemanager.ui.page.CommonTreeView;

public class CustomGifImageAnimation {
    private ArrayList<Image> images = new ArrayList();
    private long startTime = System.currentTimeMillis();
    private long lastTickTime;
    private long period = 100L;
    private Thread animateThread = null;
    private Composite parentView = null;
    private ImageLoader loader = new ImageLoader();
    private ImageData[] gif1Data = this.loader.load(PathUtil.getResourceAsStream("/res/images/wizard/manager/png/half_1.gif"));
    private ImageData[] gif2Data = new ImageLoader().load(PathUtil.getResourceAsStream("/res/images/wizard/manager/png/half_2.gif"));

    public CustomGifImageAnimation(ArrayList<Image> images, Composite parent) {
        int i;
        this.images = new ArrayList();
        for (i = 0; i < this.loader.data.length; ++i) {
            this.images.add(new Image((Device)Display.getDefault(), this.gif1Data[i]));
        }
        for (i = 0; i < this.gif2Data.length; ++i) {
            this.images.add(new Image((Device)Display.getDefault(), this.gif2Data[i]));
        }
        this.parentView = parent;
    }

    public Image getImage() {
        this.lastTickTime = System.currentTimeMillis();
        int imageIndex = (int)((this.lastTickTime - this.startTime) / this.period) % this.images.size();
        if (this.animateThread == null) {
            this.animateThread = new Thread(){

                @Override
                public void run() {
                    while (System.currentTimeMillis() - CustomGifImageAnimation.this.lastTickTime <= 1000L) {
                        try {
                            Thread.sleep(CustomGifImageAnimation.this.period);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Display.getDefault() == null || Display.getDefault().isDisposed()) continue;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!Display.getDefault().isDisposed()) {
                                    if (CustomGifImageAnimation.this.parentView instanceof CommonTreeView) {
                                        ((CommonTreeView)CustomGifImageAnimation.this.parentView).getTree().redraw();
                                    } else {
                                        CustomGifImageAnimation.this.parentView.redraw();
                                    }
                                }
                            }
                        });
                    }
                    CustomGifImageAnimation.this.animateThread = null;
                }
            };
            this.animateThread.start();
        }
        return this.images.get(imageIndex);
    }
}

