/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class PackageContentEditor {
    private static PackageContentEditor contentEditor = null;

    public static PackageContentEditor getInstance() {
        if (contentEditor == null) {
            contentEditor = new PackageContentEditor();
        }
        return contentEditor;
    }

    public static boolean replaceContent(String fileName, String packageName, String contentName, String content) {
        File file = new File(fileName);
        return PackageContentEditor.replaceContent(file, packageName, contentName, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceContent(File file, String packageName, String contentName, String content) {
        boolean result = false;
        File rfile = file;
        File wfile = new File(file.toString() + ".bak");
        if (!rfile.exists()) {
            return result;
        }
        if (wfile.exists()) {
            wfile.delete();
        }
        try {
            wfile.createNewFile();
        }
        catch (IOException e1) {
            System.out.println("A file cannot be created: " + wfile.toString());
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter wr = null;
        try {
            String readLine;
            fis = new FileInputStream(rfile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            fos = new FileOutputStream(wfile);
            osr = new OutputStreamWriter(fos);
            wr = new BufferedWriter(osr);
            while ((readLine = br.readLine()) != null) {
                if (readLine.matches("Package[\\s]*:[\\s]*" + packageName)) {
                    wr.write(readLine);
                    wr.newLine();
                    while (!(readLine = br.readLine()).contains(contentName)) {
                        wr.write(readLine);
                        wr.newLine();
                    }
                    String writeLine = new String(readLine);
                    int startChar = readLine.indexOf(":");
                    if (startChar == -1) {
                        break;
                    }
                    String str = readLine.substring(startChar + 2);
                    writeLine = writeLine.replace(str, content);
                    wr.write(writeLine);
                    wr.newLine();
                    result = true;
                    continue;
                }
                wr.write(readLine);
                wr.newLine();
            }
        }
        catch (IOException ioe) {
            ioe.getStackTrace();
            result = false;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (osr != null) {
                try {
                    osr.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
        }
        rfile.delete();
        wfile.renameTo(rfile);
        return result;
    }

    public static String getContent(String fileName, String packageName, String contentName) {
        File file = new File(fileName);
        return PackageContentEditor.getContent(file, packageName, contentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File file, String packageName, String contentName) {
        String retString = "";
        File rfile = file;
        if (!rfile.exists()) {
            return retString;
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String readLine;
            fis = new FileInputStream(rfile);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            while ((readLine = br.readLine()) != null) {
                if (!readLine.matches("Package[\\s]*:[\\s]*" + packageName)) continue;
                while (!(readLine = br.readLine()).contains(contentName)) {
                }
                int startChar = readLine.indexOf(":");
                if (startChar == -1) {
                } else {
                    retString = readLine.substring(startChar + 1);
                    retString = retString.trim();
                }
                break;
            }
        }
        catch (IOException ioe) {
            ioe.getStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
        }
        return retString;
    }
}

