/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.common;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.custom.CustomTableProfileImage;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ComponentNameColumnLabelProvider
extends OwnerDrawLabelProvider {
    private CommonTreeView parentView;
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Font treeTextFont;
    private Font treeTextBoldFont;
    private Color treeTextColor;
    private Color treeSelRowColor;
    private Color treeBackColor;
    private Rectangle treeBounds;

    public ComponentNameColumnLabelProvider(CommonTreeView parent) {
        this.parentView = parent;
        this.treeTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58);
        this.treeTextFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
        this.treeTextBoldFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1);
        this.treeBackColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.treeSelRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
        this.treeBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TREE);
    }

    @Override
    protected void erase(Event event, Object element) {
        Color oldBackground = event.gc.getBackground();
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.treeSelRowColor);
            event.detail &= 0xFFFFFFFD;
        } else {
            event.gc.setBackground(this.treeBackColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void measure(Event event, Object element) {
        event.height = this.treeBounds.height;
    }

    @Override
    protected void paint(Event event, Object element) {
        Component component = (Component)element;
        String displayName = component.getDisplayName();
        if (component.getParent() == null) {
            event.gc.setFont(this.treeTextBoldFont);
        } else {
            event.gc.setFont(this.treeTextFont);
        }
        event.gc.setForeground(this.treeTextColor);
        int textOffsetX = 4;
        TreeItem treeItem = (TreeItem)event.item;
        if (component.getParent() == null) {
            CustomTableProfileImage profileImage = this.parentView.getProfileIconImage(treeItem);
            Image targetImage = profileImage.getImage();
            int imgOffsetY = (event.getBounds().height - targetImage.getBounds().height) / 2;
            event.gc.drawImage(targetImage, event.getBounds().x + 8, event.getBounds().y + imgOffsetY);
            textOffsetX += 8 + targetImage.getBounds().width;
        }
        int textOffsetY = (event.getBounds().height - event.gc.textExtent((String)displayName).y) / 2;
        event.gc.drawText(displayName, event.getBounds().x + textOffsetX, event.getBounds().y + textOffsetY, true);
    }
}

