/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.progresstab;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.page.ProgressTableView;
import org.tizen.packagemanager.ui.page.custom.CustomTableIconButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressCancelColumnLabelProvider
extends OwnerDrawLabelProvider {
    private ProgressTableView parentView;
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Color activeColor;
    private Color inactiveColor;
    private Color selectBgColor;

    public ProgressCancelColumnLabelProvider(ProgressTableView parent) {
        this.parentView = parent;
        this.activeColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.inactiveColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.selectBgColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
    }

    @Override
    public void update(ViewerCell cell) {
        ProgressItem progressItem = (ProgressItem)cell.getElement();
        Component component = progressItem.getComponent();
        TableItem tableItem = (TableItem)cell.getItem();
        CustomTableIconButton btnCancel = this.parentView.getCancelButton(tableItem);
        CustomTableIconButton btnRetry = this.parentView.getRetryButton(tableItem);
        if (!(component.getInstallState() != Component.InstallState.INSTALLING && component.getInstallState() != Component.InstallState.UPDATING && component.getInstallState() != Component.InstallState.UNINSTALLING || progressItem.getMonitor().isCanceled())) {
            btnRetry.setHidden(true);
            btnCancel.setHidden(false);
            if (progressItem.isCancelable()) {
                btnCancel.setDisabled(false);
            } else {
                btnCancel.setDisabled(true);
            }
        } else {
            btnCancel.setHidden(true);
            if (component.getError() != null) {
                btnRetry.setHidden(false);
                btnRetry.setDisabled(false);
            }
        }
        super.update(cell);
    }

    @Override
    protected void erase(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        TableItem item = (TableItem)event.item;
        Color oldBackground = event.gc.getBackground();
        if (progressItem.isActive()) {
            event.gc.setBackground(this.activeColor);
        } else {
            event.gc.setBackground(this.inactiveColor);
        }
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.selectBgColor);
            event.detail &= 0xFFFFFFFD;
        }
        if (item != null && item.getData("isSelect") != null && ((Boolean)item.getData("isSelect")).booleanValue()) {
            event.gc.setBackground(this.selectBgColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void measure(Event arg0, Object arg1) {
    }

    @Override
    protected void paint(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        Component component = progressItem.getComponent();
        TableItem tableItem = (TableItem)event.item;
        CustomTableIconButton btnCancel = this.parentView.getCancelButton(tableItem);
        CustomTableIconButton btnRetry = this.parentView.getRetryButton(tableItem);
        Image buttonImage = null;
        if (component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.UNINSTALLING) {
            buttonImage = btnCancel.getImage();
        } else if (component.getError() != null) {
            buttonImage = btnRetry.getImage();
        }
        if (buttonImage != null) {
            int imgOffsetY = (event.getBounds().height - buttonImage.getBounds().height) / 2;
            event.gc.drawImage(buttonImage, event.x, event.y + imgOffsetY);
        }
    }
}

