/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

public class PlatformUtil {
    public static final int LINUX_32 = 1;
    public static final int LINUX_64 = 4;
    public static final int WINDOWS_32 = 8;
    public static final int WINDOWS_64 = 16;
    public static final int MACOS_32 = 32;
    public static final int MACOS_64 = 64;
    private static final int UBUNTU_32 = 128;
    private static final int UBUNTU_64 = 256;
    private static final int GENERIC_LINUX = 389;
    private static final int GENERIC_WINDOWS = 24;
    private static final int GENERIC_MACOS = 96;
    private static final String DATA_MODEL_32 = "32";
    public static final int CURRENT_PLATFORM = PlatformUtil.getCurrentPlatform();
    public static final String CURRENT_CHARSET = PlatformUtil.getCurrentCharset();

    private static int getCurrentPlatform() {
        String os = System.getProperty("os.name");
        String dataModel = System.getProperty("sun.arch.data.model");
        if (os.startsWith("Linux")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 1;
            }
            return 4;
        }
        if (os.startsWith("Windows")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 8;
            }
            return 16;
        }
        if (os.startsWith("Mac OS")) {
            return 64;
        }
        if (dataModel.equals(DATA_MODEL_32)) {
            return 1;
        }
        return 4;
    }

    private static String getCurrentCharset() {
        return System.getProperty("sun.jnu.encoding");
    }

    public static boolean isLinux() {
        return (CURRENT_PLATFORM & 0x185) > 0;
    }

    public static boolean isUbuntu() {
        return PlatformUtil.isLinux();
    }

    public static boolean isMacOS() {
        return (CURRENT_PLATFORM & 0x60) > 0;
    }

    public static boolean isWindows() {
        return (CURRENT_PLATFORM & 0x18) > 0;
    }
}

