/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.pkg.PackageUtil;
import org.tizen.manager.pkg.PackageVersion;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;

public class PackageManager
implements Cloneable {
    private static final Logger logger = Log.getLogger(PackageManager.class);
    private static final int MAX_INIT_THREADS = 5;
    private PackageSet installedPackages = null;
    private PackageSet repoPackages = null;
    private PackageSet extensionPackages = null;
    private PackageSet recentPackages = null;
    private PackageSet virtualPackages = null;
    private String installedRepository = null;
    private File installedPackageListFile = null;
    private boolean areRepoPkgsOutdated = false;
    private ContentProvider contentProvider;

    public PackageManager(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.installedPackageListFile = null;
        this.extensionPackages = new PackageSet();
        this.virtualPackages = new PackageSet();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public PackageManager clone(ContentProvider contentProvider) throws CloneNotSupportedException {
        PackageManager pkgmgr = (PackageManager)this.clone();
        pkgmgr.installedPackages = (PackageSet)this.installedPackages.clone();
        pkgmgr.repoPackages = (PackageSet)this.repoPackages.clone();
        pkgmgr.extensionPackages = (PackageSet)this.extensionPackages.clone();
        pkgmgr.recentPackages = (PackageSet)this.recentPackages.clone();
        pkgmgr.virtualPackages = (PackageSet)this.virtualPackages.clone();
        pkgmgr.contentProvider = contentProvider;
        return pkgmgr;
    }

    public synchronized void init(boolean refreshRemotePkgs) {
        this.installedPackageListFile = new File(PathUtil.get(PathUtil.getFromInstalledPath(this.contentProvider.getSDKInfo(), ".info"), "installedpackage.list"));
        this.installedRepository = this.contentProvider.getConfig().getDistributionURL();
        this.reloadPackageInfo(this.installedRepository, refreshRemotePkgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reloadPackageInfo(String repositoryURL, boolean refreshRemotePkgs) {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        Future<PackageSet> repoFuture = null;
        if (refreshRemotePkgs) {
            repoFuture = this.getFutureToloadRepoPackageList(repositoryURL, executor);
        }
        Future<PackageSet> installedFuture = this.getFutureToloadInstalledPackageList(executor);
        PackageSet installedPkgs = new PackageSet();
        if (installedFuture != null) {
            try {
                installedPkgs = installedFuture.get();
            }
            catch (Exception e) {
                logger.throwing(e);
            }
        }
        this.setInstalledPackages(installedPkgs);
        PackageSet repoPkgs = new PackageSet();
        if (repoFuture != null) {
            try {
                repoPkgs = repoFuture.get();
            }
            catch (Exception e) {
                logger.throwing(e);
            }
        }
        this.setRepoPackages(repoPkgs);
        PackageSet extPkgs = new PackageSet();
        logger.trace("\t[#EXT] Load Extension");
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (!repo.getActivateStatus()) continue;
            try {
                logger.trace("\t[#EXT] Create new ExtensionResult : " + repo.getName() + " : " + repo.getRepository());
                ExtensionResult extensionResult = new ExtensionResult(repo, this.loadExtensionPackagesFromRepository(repo));
                logger.trace("\t[#EXT] Get result : " + repo.getName() + " : " + repo.getRepository());
                if (extensionResult.getPkgset() == null || extensionResult.getPkgset().isEmpty()) continue;
                try {
                    extPkgs.addAll(extensionResult.getPkgset());
                }
                catch (Exception e) {
                    extensionResult.getExtInfo().setActivateStatus(false);
                    extensionResult.getExtInfo().setError(e);
                    logger.error("\t[#EXT] " + repo.getName() + e);
                }
                finally {
                    extensionResult.getExtInfo().setExtPackageSet(extensionResult.getPkgset());
                }
            }
            catch (UMException e) {
                logger.error("\t[#EXT] " + repo.getName() + e);
                repo.setActivateStatus(false);
                repo.setError(e);
            }
            catch (Exception e) {
                logger.error("\t[#EXT] " + repo.getName() + e);
                repo.setActivateStatus(false);
                repo.setError(e);
            }
        }
        this.setExtensionPackages(extPkgs);
        executor.shutdown();
        this.updateRecentPackages();
        if (!this.installedPackages.isEmpty() && !this.repoPackages.isEmpty()) {
            PackageInfoJSON.savePackageInfoToFile(this.contentProvider.getSDKInfo(), this);
        }
    }

    public static String getPackageListFileName() {
        if (PlatformUtil.isMacOS()) {
            return "pkg_list_macos-64";
        }
        if (PlatformUtil.isLinux()) {
            if (PlatformUtil.CURRENT_PLATFORM == 1) {
                return "pkg_list_ubuntu-32";
            }
            return "pkg_list_ubuntu-64";
        }
        if (PlatformUtil.isWindows()) {
            if (PlatformUtil.CURRENT_PLATFORM == 8) {
                return "pkg_list_windows-32";
            }
            return "pkg_list_windows-64";
        }
        return null;
    }

    private Future<PackageSet> getFutureToloadRepoPackageList(final String repoURL, ExecutorService executor) {
        return executor.submit(new Callable<PackageSet>(){

            @Override
            public PackageSet call() throws Exception {
                try {
                    PackageManager.this.addVirtualMetaPackages();
                    PackageSet repoPkgs = null;
                    repoPkgs = repoURL.startsWith("file:") ? PackageUtil.readPackageListFromRepository(PackageManager.this.contentProvider.getConfig(), repoURL) : PackageManager.this.loadPackageListFromRemoteRepository(repoURL);
                    PackageManager.this.contentProvider.getRepoMgr().setNetworkOK(true);
                    return repoPkgs;
                }
                catch (Exception e) {
                    logger.throwing(e);
                    PackageManager.this.contentProvider.getRepoMgr().setNetworkOK(false);
                    throw e;
                }
            }
        });
    }

    private PackageSet loadPackageListFromRemoteRepository(String repoURL) throws UMException {
        Config config = this.contentProvider.getConfig();
        String snapshotPath = config.getSnapshotPath();
        RepositoryManager repoController = this.contentProvider.getRepoMgr();
        repoController.reload();
        if (config.isAutoUpdate() || snapshotPath == null || snapshotPath.isEmpty() || snapshotPath.equalsIgnoreCase("null")) {
            String distribution = config.getConfigFile().getDistribution();
            Snapshot latestSnapshot = repoController.getLatestSnapshot(distribution);
            if (latestSnapshot != null) {
                snapshotPath = latestSnapshot.getPath();
            } else {
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_REPO_CONFIG_FILE, "No snapshot!");
            }
        }
        PackageSet repoPkgs = PackageUtil.readPackageListFromRepository(this.contentProvider.getConfig(), repoURL, snapshotPath);
        if (snapshotPath != null) {
            this.contentProvider.getConfig().setSnapshotPath(snapshotPath);
        }
        return repoPkgs;
    }

    private ArrayList<Future<ExtensionResult>> getFuturesToloadExtensionPackages(ExecutorService executor) {
        ArrayList<Future<ExtensionResult>> result = new ArrayList<Future<ExtensionResult>>();
        for (final ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (!repo.getActivateStatus()) continue;
            Future<ExtensionResult> future = executor.submit(new Callable<ExtensionResult>(){

                @Override
                public ExtensionResult call() throws Exception {
                    try {
                        return new ExtensionResult(repo, PackageManager.this.loadExtensionPackagesFromRepository(repo));
                    }
                    catch (UMException e) {
                        logger.throwing(e);
                        repo.setActivateStatus(false);
                        repo.setError(e);
                        throw e;
                    }
                    catch (Exception e) {
                        logger.throwing(e);
                        repo.setActivateStatus(false);
                        repo.setError(e);
                        throw e;
                    }
                }
            });
            result.add(future);
        }
        return result;
    }

    public synchronized void addExtensionPackagesFromRepository(ExtensionInformation repo) throws UMException {
        this.extensionPackages.addAll(this.loadExtensionPackagesFromRepository(repo));
    }

    private PackageSet loadExtensionPackagesFromRepository(ExtensionInformation extInfo) throws UMException {
        logger.trace("\t[#EXT] loadExtensionPackagesFromRepository start : " + extInfo.getName() + " : " + extInfo.getRepository());
        ExtRepositoryManager.ValidationResult result = this.contentProvider.getExtRepoMgr().validateRepository(extInfo.getRepository(), extInfo.getId());
        logger.trace("\t[#EXT] Validated : " + extInfo.getName() + " : " + extInfo.getRepository());
        PackageSet extensionRepo = null;
        if (extInfo.getRepotype().equals("server")) {
            logger.trace("\t[#EXT] Load server type start : " + extInfo.getName() + ":" + extInfo.getRepository());
            extensionRepo = PackageUtil.readPackageListFromRepository(this.contentProvider.getConfig(), extInfo.getRepository(), true, extInfo.getId());
            logger.trace("\t[#EXT] Load server type end : " + extInfo.getName() + ":" + extInfo.getRepository());
        } else if (extInfo.getRepotype().equals("file")) {
            logger.trace("\t[#EXT] Load file type start : " + extInfo.getName() + ":" + extInfo.getRepository());
            if (result.getLastModifiedDate() != null) {
                extInfo.setLastModifiedDate(result.getLastModifiedDate());
            }
            this.contentProvider.getExtRepoMgr().unzipNeededFiles(new File(result.getCachePath()), extInfo.getId());
            String zipExtPath = this.contentProvider.getExtRepoMgr().getExtCacheDir(extInfo.getId());
            extensionRepo = PackageUtil.readPackageListFromRepository(this.contentProvider.getConfig(), zipExtPath, true, extInfo.getId());
            logger.trace("\t[#EXT] Load file type end : " + extInfo.getName() + ":" + extInfo.getRepository());
        } else {
            throw new UMException(ErrorController.ErrorCode.INVALID_EXT_REPO_TYPE);
        }
        return extensionRepo;
    }

    private PackageSet validateExtensionRepoPackages(ExtensionResult extensionResult, ArrayList<ExtensionResult> extensionResultList) throws UMException {
        PackageSet returnPackages = new PackageSet();
        PackageSet duplicatedPackages = new PackageSet();
        PackageSet extPackageSet = extensionResult.getPkgset();
        for (Package extPackage : extPackageSet) {
            if (this.repoPackages.contains(extPackage)) {
                duplicatedPackages.add(extPackage);
                continue;
            }
            if (this.installedPackages.contains(extPackage)) {
                Package installedPackage = this.installedPackages.getPackageByName(extPackage.getPackageName());
                if (installedPackage.getExtensionServer().equals(extPackage.getExtensionServer())) continue;
                duplicatedPackages.add(extPackage);
                continue;
            }
            int duplicatedExtensionCount = 0;
            if (!extensionResult.getExtInfo().isDefaultExtension()) {
                for (ExtensionResult er : extensionResultList) {
                    PackageSet otherExtensionPackageSet;
                    if (!er.getExtInfo().getActivateStatus() || er.getExtInfo().getName().equals(extensionResult.getExtInfo().getName()) || !(otherExtensionPackageSet = er.getPkgset()).contains(extPackage)) continue;
                    ++duplicatedExtensionCount;
                    duplicatedPackages.add(extPackage);
                }
            }
            if (duplicatedExtensionCount > 0 || !duplicatedPackages.isEmpty()) continue;
            Collection<String> dependentPackageNames = extPackage.getDependentPackageNames();
            ArrayList<String> selectedGroupNames = extPackage.getSelectedGroupNames();
            if (dependentPackageNames != null && !dependentPackageNames.isEmpty()) {
                for (String depPackageName : dependentPackageNames) {
                    this.validateExtensionPackage(extensionResult, extensionResultList, returnPackages, extPackageSet, extPackage, depPackageName);
                }
                continue;
            }
            if (selectedGroupNames != null && !selectedGroupNames.isEmpty()) {
                for (String selGroupPacakgeName : selectedGroupNames) {
                    this.validateExtensionPackage(extensionResult, extensionResultList, returnPackages, extPackageSet, extPackage, selGroupPacakgeName);
                }
                continue;
            }
            returnPackages.add(extPackage);
        }
        if (!duplicatedPackages.isEmpty()) {
            throw new UMException(ErrorController.ErrorCode.DUPLICATED_EXTENSION_PACKAGE, "Extension name : " + extensionResult.getExtInfo().getName() + "\nDuplicated packages : " + duplicatedPackages);
        }
        return returnPackages;
    }

    private void validateExtensionPackage(ExtensionResult extensionResult, ArrayList<ExtensionResult> extensionResultList, PackageSet returnPackages, PackageSet extPackageSet, Package extPackage, String targetPackageName) throws UMException {
        Package pkgInRepo = this.repoPackages.getPackageByName(targetPackageName);
        Package pkgInInstalled = this.installedPackages.getPackageByName(targetPackageName);
        Package pkgInExtension = extPackageSet.getPackageByName(targetPackageName);
        Package pkgInOtherExtension = null;
        Package testPackage = null;
        int dependentExtensionCount = 0;
        for (ExtensionResult er : extensionResultList) {
            PackageSet otherExtensionPackageSet;
            if (!er.getExtInfo().getActivateStatus() || er.getExtInfo().getName().equals(extensionResult.getExtInfo().getName()) || (testPackage = (otherExtensionPackageSet = er.getPkgset()).getPackageByName(targetPackageName)) == null) continue;
            ++dependentExtensionCount;
            pkgInOtherExtension = testPackage;
        }
        if (dependentExtensionCount > 1) {
            throw new UMException(ErrorController.ErrorCode.INVALID_EXTENSION_PACKAGE, "Extension name : " + extensionResult.getExtInfo().getName() + "\nInvalid packages : " + targetPackageName);
        }
        if (pkgInRepo != null && pkgInInstalled == null && pkgInOtherExtension == null && pkgInExtension == null) {
            returnPackages.add(extPackage);
        } else if (pkgInRepo == null && pkgInInstalled != null && pkgInOtherExtension == null && pkgInExtension == null) {
            returnPackages.add(extPackage);
        } else if (pkgInRepo == null && pkgInInstalled == null && pkgInOtherExtension == null && pkgInExtension != null) {
            returnPackages.add(extPackage);
        } else if (pkgInRepo == null && pkgInInstalled == null && pkgInOtherExtension != null && pkgInExtension == null) {
            returnPackages.add(extPackage);
        } else {
            if (pkgInRepo == null && pkgInInstalled == null && pkgInOtherExtension == null && pkgInExtension == null) {
                throw new UMException(ErrorController.ErrorCode.NOT_EXISTS_EXTENSION_PACKAGE, "Extension name : " + extensionResult.getExtInfo().getName() + "\nInvalid packages : " + targetPackageName);
            }
            if (pkgInRepo != null && pkgInInstalled != null) {
                if (pkgInInstalled.isExtensionPackage()) {
                    // empty if block
                }
            } else if (pkgInRepo != null && (pkgInOtherExtension != null || pkgInExtension != null)) {
                throw new UMException(ErrorController.ErrorCode.DUPLICATED_EXTENSION_PACKAGE, "Extension name : " + extensionResult.getExtInfo().getName() + "\nDuplicated package : " + targetPackageName);
            }
        }
    }

    public synchronized void resetExtensionPackages() {
        this.extensionPackages = new PackageSet();
    }

    private void setExtensionPackages(PackageSet extPkgs) {
        this.extensionPackages = new PackageSet();
        this.extensionPackages.addAll(extPkgs);
    }

    private void addVirtualMetaPackages() {
        this.addExtraTopMetaPackage();
        this.addDeprecatedTopMetaPackage();
    }

    private void addExtraTopMetaPackage() {
        if (this.virtualPackages == null) {
            this.virtualPackages = new PackageSet();
        }
        if (this.virtualPackages.hasPackageByName("EXTRAS")) {
            return;
        }
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(new Property("Package", "EXTRAS"));
        props.add(new Property("Label", "Extras"));
        props.add(new Property("Attribute", "root"));
        props.add(new Property("Size", "0"));
        props.add(new Property("Uncompressed-size", "0"));
        props.add(new Property("Version", "0.0.0"));
        props.add(new Property("Description", "Tools and SDKs in this group are extension SDKs that provide extra functions and environments such as Samsung Certificate Extension and Wearable Extension."));
        Package extraPackage = new Package(props);
        this.virtualPackages.add(extraPackage);
    }

    private Package addDeprecatedTopMetaPackage() {
        if (this.virtualPackages == null) {
            this.virtualPackages = new PackageSet();
        }
        if (this.virtualPackages.hasPackageByName("DEPRECATED")) {
            return this.virtualPackages.getPackageByName("DEPRECATED");
        }
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(new Property("Package", "DEPRECATED"));
        props.add(new Property("Label", "Deprecated"));
        props.add(new Property("Attribute", "root"));
        props.add(new Property("Size", "0"));
        props.add(new Property("Uncompressed-size", "0"));
        props.add(new Property("Version", "0.0.0"));
        props.add(new Property("Description", "Packages in this group is literally deprecated packages because their repositories are removed or their depending packages are also deleted."));
        Package deprecatedPackage = new Package(props);
        this.virtualPackages.add(deprecatedPackage);
        return deprecatedPackage;
    }

    PackageSet getDeprecatedPackages() {
        PackageSet normalMetaPkgs = this.getRootMetaPackagesOfRepository();
        PackageSet deprecatedMetaPkgs = new PackageSet();
        for (Package installedPkg : this.getInstalledMetaPackages()) {
            String pkgName = installedPkg.getPackageName();
            if (installedPkg.isExtensionPackage()) {
                String extServer = installedPkg.getExtensionServer();
                if (this.contentProvider.getExtRepoMgr().getExtensionInfoById(extServer) != null) {
                    PackageSet extMetaPkgs = this.getExtensionMetaPackagesFrom(extServer);
                    if (extMetaPkgs.isEmpty() || extMetaPkgs.getPackageByName(pkgName) != null) continue;
                    deprecatedMetaPkgs.add(installedPkg);
                    continue;
                }
                deprecatedMetaPkgs.add(installedPkg);
                continue;
            }
            if (this.repoPackages == null || this.repoPackages.isEmpty() || normalMetaPkgs.getPackageByName(pkgName) != null) continue;
            deprecatedMetaPkgs.add(installedPkg);
        }
        return deprecatedMetaPkgs;
    }

    private Future<PackageSet> getFutureToloadInstalledPackageList(ExecutorService executor) {
        return executor.submit(new Callable<PackageSet>(){

            @Override
            public PackageSet call() throws Exception {
                List<Object> sectionsInstalled = null;
                PropertyParser parser = new PropertyParser();
                sectionsInstalled = PackageManager.this.installedPackageListFile != null && PackageManager.this.installedPackageListFile.exists() ? parser.readFromFile(PackageManager.this.installedPackageListFile, false) : new LinkedList();
                PackageSet installedPkgs = new PackageSet();
                if (sectionsInstalled != null) {
                    for (PropertySection sect : sectionsInstalled) {
                        installedPkgs.add(new Package(sect.getProperties()));
                    }
                }
                return installedPkgs;
            }
        });
    }

    private void setInstalledPackages(PackageSet pkgs) {
        this.installedPackages = new PackageSet();
        this.installedPackages.addAll(pkgs);
    }

    public synchronized PackageSet getInstalledPackages() {
        return (PackageSet)this.installedPackages.clone();
    }

    private void setRepoPackages(PackageSet pkgs) {
        this.repoPackages = new PackageSet();
        this.repoPackages.addAll(pkgs);
        PackageSet clone = (PackageSet)this.repoPackages.clone();
        for (Package pkg : this.repoPackages) {
            if (pkg.isVisible()) continue;
            clone.remove(pkg);
        }
        this.repoPackages.clear();
        this.repoPackages.addAll(clone);
    }

    PackageSet getRootMetaPackagesOfRepository() {
        PackageSet result = new PackageSet();
        result = this.profileMeta(this.repoPackages);
        result.addAll(this.rootMeta(this.repoPackages));
        return result;
    }

    PackageSet getRecentRootMetaPackages() {
        PackageSet result = new PackageSet();
        result = this.profileMeta(this.recentPackages);
        result.addAll(this.rootMeta(this.recentPackages));
        return result;
    }

    private PackageSet getExtensionMetaPackages() {
        return this.rootMeta(this.extensionPackages);
    }

    private PackageSet getExtensionMetaPackagesFrom(String extServerName) {
        PackageSet result = new PackageSet();
        for (Package pkg : this.getExtensionMetaPackages()) {
            if (pkg.getExtensionServer() == null || !pkg.getExtensionServer().equals(extServerName)) continue;
            result.add(pkg);
        }
        return result;
    }

    PackageSet getRecentExtensionMetaPackages() {
        PackageSet result = new PackageSet();
        PackageSet extraPkgs = this.getExtensionMetaPackages();
        result.addAll(extraPkgs);
        for (Package installedPkg : this.getInstalledMetaPackages()) {
            String pkgName = installedPkg.getPackageName();
            if (!installedPkg.isExtensionPackage()) continue;
            String extServer = installedPkg.getExtensionServer();
            if (this.contentProvider.getExtRepoMgr().getExtensionInfoById(extServer) != null) {
                PackageSet extMetaPkgs = this.getExtensionMetaPackagesFrom(extServer);
                if (result.hasPackageByName(pkgName) || !extMetaPkgs.hasPackageByName(pkgName) && !extMetaPkgs.isEmpty()) continue;
                result.add(installedPkg);
                continue;
            }
            result.remove(installedPkg);
        }
        return result;
    }

    public synchronized PackageSet getRecentPackages() {
        return (PackageSet)this.recentPackages.clone();
    }

    public synchronized PackageSet getRepoPackages() {
        return (PackageSet)this.repoPackages.clone();
    }

    private void updateRecentPackages() {
        this.recentPackages = new PackageSet();
        this.areRepoPkgsOutdated = false;
        for (Package ip : this.installedPackages) {
            if (this.repoPackages != null && this.repoPackages.contains(ip)) {
                Package rp = this.repoPackages.getPackage(ip);
                if (ip.getVersion().compareTo(rp.getVersion()) > 0) {
                    this.recentPackages.add(ip);
                    this.areRepoPkgsOutdated = true;
                    continue;
                }
                this.recentPackages.add(rp);
                continue;
            }
            if (this.extensionPackages != null && this.extensionPackages.contains(ip)) {
                Package ep = this.extensionPackages.getPackage(ip);
                if (ip.getVersion().compareTo(ep.getVersion()) > 0) {
                    this.recentPackages.add(ip);
                    continue;
                }
                this.recentPackages.add(ep);
                continue;
            }
            this.recentPackages.add(ip);
        }
        if (this.repoPackages != null) {
            for (Package rp : this.repoPackages) {
                if (this.recentPackages.contains(rp)) continue;
                this.recentPackages.add(rp);
            }
        }
        if (this.extensionPackages != null) {
            for (Package p : this.extensionPackages) {
                if (this.recentPackages.contains(p)) continue;
                this.recentPackages.add(p);
            }
        }
    }

    PackageSet getVirtualPackages() {
        return this.virtualPackages;
    }

    public synchronized void removeFromInstalledPackages(Package pkg) {
        this.installedPackages.remove(pkg);
        this.updateRecentPackages();
    }

    public synchronized void addPackageToInstalledPackages(Package pkg) {
        this.installedPackages.remove(pkg);
        this.installedPackages.add(pkg);
        this.updateRecentPackages();
    }

    private PackageSet getUpdatableInstalledPackages() {
        PackageSet updatables = new PackageSet();
        for (Package ip : this.installedPackages) {
            Package rp;
            if (ip.isExtensionPackage()) {
                if (!this.extensionPackages.contains(ip) || (rp = this.extensionPackages.getPackage(ip)).getVersion().compareTo(ip.getVersion()) == 0) continue;
                updatables.add(ip);
                continue;
            }
            if (!this.repoPackages.contains(ip) || (rp = this.repoPackages.getPackage(ip)).getVersion().compareTo(ip.getVersion()) == 0) continue;
            updatables.add(ip);
        }
        return updatables;
    }

    public synchronized boolean isUpdatable(Package pkg) {
        if (pkg == null) {
            return false;
        }
        PackageSet updatables = this.getUpdatableInstalledPackages();
        return updatables.contains(pkg);
    }

    public synchronized boolean isInstalledPackage(Package pkg) {
        if (pkg == null) {
            return false;
        }
        return this.installedPackages.contains(pkg);
    }

    public synchronized boolean isInstalledPackage(String name) {
        if (name == null) {
            return false;
        }
        Package pkg = this.getInstalledPackageByName(name);
        return this.installedPackages.contains(pkg);
    }

    PackageSet getRecentMetaPackages() {
        PackageSet recentPackages = this.union(this.repoPackages, this.installedPackages);
        return this.rootMeta(recentPackages);
    }

    PackageSet getInstalledMetaPackages() {
        return this.getMetaPackagesFrom(this.installedPackages);
    }

    public synchronized PackageSet getInstalledMetaPackagesSync() {
        return (PackageSet)this.getMetaPackagesFrom(this.installedPackages).clone();
    }

    public synchronized List<String> getInstalledMetaNames() {
        ArrayList<String> installedMetaNames = new ArrayList<String>();
        for (Package meta : this.getInstalledMetaPackages()) {
            installedMetaNames.add(meta.getPackageName());
        }
        return installedMetaNames;
    }

    public synchronized List<String> getInstalledPkgNames() {
        ArrayList<String> installedPkgNames = new ArrayList<String>();
        for (Package pkg : this.installedPackages) {
            installedPkgNames.add(pkg.getPackageName());
        }
        return installedPkgNames;
    }

    PackageSet getAllMetaPackages() {
        PackageSet allMeta = new PackageSet();
        allMeta.addAll(this.getMetaPackagesFrom(this.recentPackages));
        allMeta.addAll(this.getMetaPackagesFrom(this.extensionPackages));
        allMeta.addAll(this.getMetaPackagesFrom(this.virtualPackages));
        return allMeta;
    }

    private PackageSet getLeafMetaPackages() {
        PackageSet allMetas = this.getMetaPackagesFrom(this.recentPackages);
        PackageSet leafMetas = new PackageSet();
        for (Package meta : allMetas) {
            if (meta.getDependentPackageNames().size() <= 0) {
                leafMetas.add(meta);
                continue;
            }
            if (this.isChildrenAllMeta(meta)) continue;
            leafMetas.add(meta);
        }
        return leafMetas;
    }

    public boolean hasMetaPackagesInChildren(Package pkg) {
        PackageSet dependPackages = this.getDependentPackages(pkg);
        if (dependPackages == null) {
            return true;
        }
        for (Package dPackage : dependPackages) {
            if (!dPackage.isMeta()) continue;
            return true;
        }
        return false;
    }

    private boolean isChildrenAllMeta(Package pkg) {
        PackageSet dependPackages = this.getDependentPackages(pkg);
        if (dependPackages == null) {
            return true;
        }
        for (Package dPackage : dependPackages) {
            if (dPackage.isMeta()) continue;
            return false;
        }
        return true;
    }

    private PackageSet getDependentPackages(Package pkg) {
        PackageSet dependPackages = new PackageSet();
        if (pkg == null) {
            return dependPackages;
        }
        Collection<String> depends = pkg.getDependentPackageNames();
        dependPackages = this.recentPackages.getPackagesByNames(depends);
        return dependPackages;
    }

    private PackageSet getUpdatableMetaPackages() {
        PackageSet result = new PackageSet();
        for (Package m : this.getAllMetaPackages()) {
            if (!this.isMetaUpdatable(m)) continue;
            result.add(m);
        }
        return result;
    }

    private PackageSet getResultPackagesAfterUpdate(PackageSet selectedMetas) {
        PackageSet deps = this.dep(selectedMetas, State.INSTALL);
        PackageSet conflicts = this.conflictPackages(selectedMetas);
        PackageSet remainedFromConflicts = this.diff(this.installedPackages, conflicts);
        return this.union(deps, remainedFromConflicts);
    }

    private PackageSet getRemovablePackages(PackageSet selectedMetas) {
        PackageSet pkgSet = new PackageSet();
        ArrayList<String> depPkgNames = this.getAllDependentPackageNames(selectedMetas);
        for (String pkgName : depPkgNames) {
            Package installedPkg = this.getInstalledPackageByName(pkgName);
            if (installedPkg == null) continue;
            pkgSet.add(installedPkg);
        }
        for (Package pkg : selectedMetas) {
            if (pkgSet.getPackageByName(pkg.getPackageName()) != null) continue;
            pkgSet.add(pkg);
        }
        return pkgSet;
    }

    private PackageSet getInstallablePackages(PackageSet selectedMetas) {
        PackageSet result = this.getResultPackagesAfterUpdate(selectedMetas);
        return this.diffPackageWithVersion(result, this.installedPackages);
    }

    PackageSet getInstallablePackages(Package pkg) {
        PackageSet selectedMetas = new PackageSet();
        selectedMetas.add(pkg);
        PackageSet result = this.getResultPackagesAfterUpdate(selectedMetas);
        return this.diffPackageWithVersion(result, this.installedPackages);
    }

    private PackageSet getInstallablePackagesWithInstalledPackage(PackageSet selectedMetas) {
        PackageSet result = this.getResultPackagesAfterUpdate(selectedMetas);
        return this.diffPackageWithVersion(result, this.installedPackages);
    }

    public synchronized boolean isInstallablePackage(String pkgName) {
        Package installedPkg = this.installedPackages.getPackageByName(pkgName);
        Package recentPkg = this.recentPackages.getPackageByName(pkgName);
        return installedPkg == null || recentPkg != null && recentPkg.getVersion().compareTo(installedPkg.getVersion()) > 0;
    }

    public synchronized PackageSet getConflictPackages(Package pkg) {
        PackageSet conflicts = this.conflictPackages(pkg);
        conflicts.addAll(this.reverseDep(conflicts));
        return this.intersect(this.getConflictMetaPackages(), conflicts);
    }

    private PackageSet getConflictMetaPackages() {
        PackageSet leafMetas = new PackageSet();
        for (Package meta : this.recentPackages) {
            if (meta.getDependentPackageNames().size() <= 0) {
                leafMetas.add(meta);
                continue;
            }
            if (this.hasMetaPackagesInChildren(meta)) continue;
            leafMetas.add(meta);
        }
        return leafMetas;
    }

    public synchronized PackageSet getInstallableMetaPackagesInSnapshot() {
        PackageSet repoMetas = this.getMetaPackagesFrom(this.repoPackages);
        PackageSet installableMeta = new PackageSet();
        for (Package metaPackage : repoMetas) {
            if (!this.isMetaInstallable(metaPackage)) continue;
            installableMeta.add(metaPackage);
        }
        return installableMeta;
    }

    public synchronized PackageSet getRemovablePackagesOfMetaPackages(PackageSet metaPkgs) {
        PackageSet result = new PackageSet();
        PackageSet allRemovablePkgs = this.getRemovablePackages(metaPkgs);
        PackageSet allRemovablePkgsClone = (PackageSet)allRemovablePkgs.clone();
        int removeItemCount = 0;
        do {
            removeItemCount = allRemovablePkgs.getSize();
            block1: for (Package pkg : allRemovablePkgsClone) {
                if (metaPkgs.contains(pkg)) continue;
                PackageSet reverseDepInstalled = this.getDirectReverseDepInstalledPackages(pkg);
                for (Package pkg1 : reverseDepInstalled) {
                    if (allRemovablePkgs.contains(pkg1)) continue;
                    allRemovablePkgs.remove(pkg);
                    continue block1;
                }
            }
        } while (removeItemCount != allRemovablePkgs.getSize());
        HashMap<Package, Collection<String>> depNames = new HashMap<Package, Collection<String>>();
        for (Package pkg : allRemovablePkgs) {
            depNames.put(pkg, pkg.getDependentPackageNames());
        }
        while (result.getSize() != allRemovablePkgs.getSize()) {
            for (Package pkg : allRemovablePkgs) {
                if (result.contains(pkg)) continue;
                boolean found = false;
                for (Package pkg1 : allRemovablePkgs) {
                    if (pkg == pkg1 || result.contains(pkg1) || !((Collection)depNames.get(pkg1)).contains(pkg.getPackageName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(pkg);
            }
        }
        return result;
    }

    private PackageSet getMetaPackagesFrom(PackageSet pset) {
        PackageSet metas = new PackageSet();
        if (pset == null) {
            return metas;
        }
        for (Package p : pset) {
            if (!p.isMeta()) continue;
            metas.add(p);
        }
        return metas;
    }

    private PackageSet rootMeta(PackageSet pset) {
        PackageSet metas = new PackageSet();
        for (Package p : pset) {
            if (!p.isRootMeta() && !p.isExtraMeta()) continue;
            metas.add(p);
        }
        return metas;
    }

    private PackageSet profileMeta(PackageSet pset) {
        PackageSet metas = new PackageSet();
        for (Package p : pset) {
            if (!p.isProfileMeta()) continue;
            metas.add(p);
        }
        return metas;
    }

    private PackageSet dep(Package p, State state) {
        PackageSet dep = new PackageSet();
        this.depp(p, dep);
        return dep;
    }

    private void depp(Package p, PackageSet dep) {
        PackageSet depPackageSet = new PackageSet();
        if (this.repoPackages != null) {
            depPackageSet = this.getPackagesByNames(p.getDependentPackageNames());
            for (Package depPkg : depPackageSet) {
                if (p.equals(depPkg)) {
                    logger.error("Circular dependency found: " + p);
                    continue;
                }
                this.depp(depPkg, dep);
            }
        }
        if (!dep.contains(p)) {
            dep.add(p);
        }
    }

    private PackageSet reverseDep(PackageSet packages) {
        PackageSet reversePackages = new PackageSet();
        for (Package pkg : packages) {
            reversePackages.addAll(this.reverseDep(pkg));
        }
        return reversePackages;
    }

    private PackageSet reverseDep(Package p) {
        PackageSet reverseDep = new PackageSet();
        Stack<Package> pkgStack = new Stack<Package>();
        pkgStack.push(p);
        while (!pkgStack.isEmpty()) {
            Package pkg = (Package)pkgStack.pop();
            if (!reverseDep.contains(pkg)) {
                reverseDep.add(pkg);
                block1: for (Package recentPkg : this.recentPackages) {
                    Collection<String> dependsList = recentPkg.getDependentPackageNames();
                    for (String pkgName : dependsList) {
                        if (!pkgName.equals(pkg.getPackageName())) continue;
                        pkgStack.push(recentPkg);
                        continue block1;
                    }
                }
                continue;
            }
            this.addDependsSet(reverseDep, pkg);
        }
        return reverseDep;
    }

    private void addDependsSet(PackageSet dependsSet, Package pkg) {
        if (dependsSet.contains(pkg)) {
            dependsSet.remove(pkg);
        }
        dependsSet.add(pkg);
    }

    private PackageSet dep(PackageSet pset, State state) {
        PackageSet dep = new PackageSet();
        for (Package p : pset) {
            dep.addAll(this.dep(p, state));
        }
        return dep;
    }

    private PackageSet conflictPackages(Package p) {
        PackageSet conflicts = new PackageSet();
        PackageSet dep = this.dep(p, State.INSTALL);
        for (Package pkg : dep) {
            Collection<String> conflictPackageNames = pkg.getConflictPackageNames();
            for (String conflictPackageName : conflictPackageNames) {
                Package conflictPackage;
                if (this.installedPackages.hasPackageByName(conflictPackageName)) {
                    conflictPackage = this.installedPackages.getPackageByName(conflictPackageName);
                    conflicts.addAll(this.reverseDep(conflictPackage));
                    continue;
                }
                if (!this.repoPackages.hasPackageByName(conflictPackageName)) continue;
                conflictPackage = this.repoPackages.getPackageByName(conflictPackageName);
                conflicts.addAll(this.reverseDep(conflictPackage));
            }
        }
        return conflicts;
    }

    private PackageSet conflictPackages(PackageSet pset) {
        PackageSet conflicts = new PackageSet();
        for (Package p : pset) {
            conflicts.addAll(this.conflictPackages(p));
        }
        return conflicts;
    }

    private PackageSet union(PackageSet pset1, PackageSet pset2) {
        PackageSet union = (PackageSet)pset1.clone();
        union.addAll(pset2);
        return union;
    }

    private PackageSet diff(PackageSet pset1, PackageSet pset2) {
        PackageSet diff = new PackageSet();
        for (Package p : pset1) {
            if (pset2.contains(p)) continue;
            diff.add(p);
        }
        return diff;
    }

    private PackageSet diffPackageWithVersion(PackageSet pset1, PackageSet pset2) {
        PackageSet diff = new PackageSet();
        for (Package p : pset1) {
            Package pkg = pset2.getPackage(p);
            if (pkg == null) {
                diff.add(p);
                continue;
            }
            if (PackageVersion.compareTo(p.getVersion(), pkg.getVersion()) == 0) continue;
            diff.add(p);
        }
        return diff;
    }

    private PackageSet intersect(PackageSet pset1, PackageSet pset2) {
        PackageSet pset = new PackageSet();
        for (Package p : pset1) {
            if (!pset2.contains(p)) continue;
            pset.add(p);
        }
        return pset;
    }

    public boolean isMetaUpdatable(Package m) {
        if (this.installedPackages.getPackage(m) == null) {
            return false;
        }
        if (m.isExtensionPackage() ? this.extensionPackages == null || !this.extensionPackages.hasPackage(m) : this.repoPackages == null || !this.repoPackages.hasPackage(m)) {
            return false;
        }
        PackageSet targetPkgs = this.getAllDependentPackages(m);
        targetPkgs.add(m);
        boolean existsUpdatable = false;
        for (Package p : targetPkgs) {
            Package ip = this.installedPackages.getPackage(p);
            if (ip == null) continue;
            Package rp = null;
            if (ip.isExtensionPackage()) {
                if (this.extensionPackages != null && this.extensionPackages.hasPackage(p)) {
                    rp = this.extensionPackages.getPackage(p);
                }
            } else if (this.repoPackages != null && this.repoPackages.hasPackage(p)) {
                rp = this.repoPackages.getPackage(p);
            }
            if (rp == null) continue;
            if (rp.getVersion().compareTo(ip.getVersion()) > 0) {
                existsUpdatable = true;
                continue;
            }
            if (rp.getVersion().compareTo(ip.getVersion()) >= 0) continue;
            return false;
        }
        return existsUpdatable;
    }

    private boolean isMetaInstallable(Package meta) {
        PackageSet dep = this.dep(meta, State.INSTALL);
        LinkedHashSet<Package> circularPackageSet = dep.getCircularPackage();
        if (circularPackageSet != null && !circularPackageSet.isEmpty()) {
            return false;
        }
        for (Package p : dep) {
            if (p.isMeta()) continue;
            if (this.installedPackages.contains(p)) {
                Package rp;
                Package ip = this.installedPackages.getPackage(p);
                if (ip == null || (rp = this.repoPackages.getPackage(p)) == null || rp.getVersion().compareTo(ip.getVersion()) == 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public Package getInstalledPackageByName(String pkgName) {
        Package retPkg = this.installedPackages.getPackageByName(pkgName);
        return retPkg;
    }

    public synchronized Package getPackageByName(String pkgName) {
        if (this.repoPackages.hasPackageByName(pkgName)) {
            return this.repoPackages.getPackageByName(pkgName);
        }
        if (this.extensionPackages.hasPackageByName(pkgName)) {
            return this.extensionPackages.getPackageByName(pkgName);
        }
        if (this.installedPackages.hasPackageByName(pkgName)) {
            return this.installedPackages.getPackageByName(pkgName);
        }
        if (this.virtualPackages.hasPackageByName(pkgName)) {
            return this.virtualPackages.getPackageByName(pkgName);
        }
        return null;
    }

    public synchronized Package getPackageByNameInstalledFirst(String pkgName) {
        if (this.installedPackages.hasPackageByName(pkgName)) {
            return this.installedPackages.getPackageByName(pkgName);
        }
        if (this.repoPackages.hasPackageByName(pkgName)) {
            return this.repoPackages.getPackageByName(pkgName);
        }
        if (this.extensionPackages.hasPackageByName(pkgName)) {
            return this.extensionPackages.getPackageByName(pkgName);
        }
        if (this.virtualPackages.hasPackageByName(pkgName)) {
            return this.virtualPackages.getPackageByName(pkgName);
        }
        return null;
    }

    public synchronized PackageSet getPackagesByNames(Collection<String> packageNames) {
        PackageSet pset = new PackageSet();
        for (String name : packageNames) {
            Package pkg;
            if (this.repoPackages.hasPackageByName(name)) {
                pkg = this.repoPackages.getPackageByName(name);
                pset.add(pkg);
                continue;
            }
            if (this.extensionPackages.hasPackageByName(name)) {
                pkg = this.extensionPackages.getPackageByName(name);
                pset.add(pkg);
                continue;
            }
            if (!this.installedPackages.hasPackageByName(name)) continue;
            pkg = this.installedPackages.getPackageByName(name);
            pset.add(pkg);
        }
        return pset;
    }

    public synchronized PackageSet getAllDependentPackages(Package pkg) {
        PackageSet result = new PackageSet();
        ArrayList<String> depPkgNames = this.getAllDependentPackageNames(pkg);
        for (String depPkgName : depPkgNames) {
            Package depPkg = this.getPackageByName(depPkgName);
            if (depPkg == null) continue;
            result.add(depPkg);
        }
        return result;
    }

    private ArrayList<String> getAllDependentPackageNames(Package pkg) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> depPkgNames = pkg.getDependentPackageNames();
        for (String depPkgName : depPkgNames) {
            Package depPkg = this.getPackageByName(depPkgName);
            if (depPkg == null) continue;
            ArrayList<String> subDepPkgNames = this.getAllDependentPackageNames(depPkg);
            if (subDepPkgNames != null && !subDepPkgNames.isEmpty()) {
                for (String subDepPkgName : subDepPkgNames) {
                    if (result.contains(subDepPkgName)) continue;
                    result.add(subDepPkgName);
                }
            }
            if (result.contains(depPkgName)) continue;
            result.add(depPkgName);
        }
        return result;
    }

    private ArrayList<String> getAllDependentPackageNames(PackageSet pkgs) {
        ArrayList<String> result = new ArrayList<String>();
        for (Package pkg : pkgs) {
            ArrayList<String> subDepPkgNames = this.getAllDependentPackageNames(pkg);
            for (String subDepPkgName : subDepPkgNames) {
                if (result.contains(subDepPkgName)) continue;
                result.add(subDepPkgName);
            }
        }
        return result;
    }

    public synchronized long getTotalSizeOfInstallablePackages(PackageSet pkgs, boolean isUncompressed) {
        PackageSet depPkgSet = this.getInstallablePackages(pkgs);
        long totalSize = 0L;
        if (depPkgSet != null) {
            totalSize = this.getTotalSize(depPkgSet, isUncompressed);
        } else {
            logger.error("Installable packages are null.");
        }
        return totalSize;
    }

    public synchronized long getTotalSizeOfRemovablePackages(PackageSet pkgs) {
        PackageSet depPkgSet = this.getRemovablePackages(pkgs);
        return this.getTotalSize(depPkgSet, true);
    }

    private long getTotalSize(PackageSet pkgs, boolean isUncompressed) {
        long totalSize = 0L;
        for (Package depPkg : pkgs) {
            if (isUncompressed) {
                totalSize += depPkg.getUncompressedPackageSize().longValue();
                continue;
            }
            totalSize += depPkg.getPackageSize().longValue();
        }
        return totalSize;
    }

    public synchronized PackageSet getInstallableMetaPackages() {
        return this.diff(this.getAllMetaPackages(), this.getInstalledMetaPackages());
    }

    public synchronized void saveInstalledList() throws UMException {
        String filePath = PathUtil.get(PathUtil.getFromInstalledPath(this.contentProvider.getSDKInfo(), ".info"), "installedpackage.list");
        PropertyParser parser = new PropertyParser();
        List<PropertySection> pSections = this.saveProperySectionsFromPackages(this.installedPackages);
        try {
            parser.writeToFile(pSections, filePath);
        }
        catch (Throwable e) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_SAVE_INSTALLED_PACKAGE_INFO_FILE, filePath);
        }
    }

    private List<PropertySection> saveProperySectionsFromPackages(PackageSet packages) {
        ArrayList<PropertySection> pSections = new ArrayList<PropertySection>();
        PropertySection pSection = null;
        ArrayList properties = null;
        for (Package pkg : packages) {
            properties = (ArrayList)pkg.getProperties();
            pSection = new PropertySection();
            pSection.setProperties(properties);
            pSections.add(pSection);
        }
        return pSections;
    }

    boolean isInstallableMetaPackages(Package pkg) {
        if (this.getLeafMetaPackages().contains(pkg)) {
            return this.getInstallableMetaPackages().contains(pkg);
        }
        for (Package depPkg : this.getDependentPackages(pkg)) {
            if (!depPkg.isMeta() || !this.isInstallableMetaPackages(depPkg)) continue;
            return true;
        }
        return false;
    }

    boolean isUpdatableMetaPackage(Package pkg) {
        return this.getUpdatableMetaPackages().contains(pkg);
    }

    public synchronized PackageSet getInstallablePackagesOfMetaPackageNames(List<String> metaPkgNames) {
        PackageSet installablePackages = this.getInstallablePackagesWithInstalled(metaPkgNames);
        logger.info("InstallManager.install() installable packages : " + installablePackages);
        this.addParentMetaPackagesWhichIsRequiredUpdate(installablePackages);
        return installablePackages;
    }

    private PackageSet getInstallablePackagesWithInstalled(Collection<String> installList) {
        PackageSet selectedMetas = this.getPackagesByNames(installList);
        return this.getInstallablePackagesWithInstalledPackage(selectedMetas);
    }

    private void addParentMetaPackagesWhichIsRequiredUpdate(PackageSet installablePackages) {
        PackageSet clone = (PackageSet)installablePackages.clone();
        HashSet<Package> getMetaSet = new HashSet<Package>();
        for (Package package1 : clone) {
            if (!package1.isMeta()) continue;
            PackageSet allMetaPackages = this.getAllMetaPackages();
            for (Package package2 : allMetaPackages) {
                Collection<String> dependentPackageNames = package2.getDependentPackageNames();
                for (String string : dependentPackageNames) {
                    if (this.isInstalledPackage(package2) || package2.isInstallMeta() || !package2.isMeta() || !package1.getPackageName().equals(string) || clone.contains(package2)) continue;
                    getMetaSet.add(package2);
                }
            }
        }
        if (!getMetaSet.isEmpty()) {
            for (Package next : getMetaSet) {
                installablePackages.add(next);
                this.addParentMetaPackagesWhichIsRequiredUpdate(installablePackages);
            }
        }
    }

    public static long getTotalDownloadSize(PackageSet pkgSet) {
        if (pkgSet == null) {
            return -1L;
        }
        long totalSize = 0L;
        for (Package pkg : pkgSet) {
            totalSize += pkg.getPackageSize().longValue();
        }
        return totalSize;
    }

    public static long getTotalInstallSize(PackageSet pkgSet) {
        if (pkgSet == null) {
            return -1L;
        }
        long totalSize = 0L;
        for (Package pkg : pkgSet) {
            totalSize += pkg.getUncompressedPackageSize().longValue();
        }
        return totalSize;
    }

    private PackageSet getDirectReverseDepInstalledPackages(Package pkg) {
        PackageSet reverseDep = new PackageSet();
        block0: for (Package installedPkg : this.installedPackages) {
            Collection<String> depPkgNames = installedPkg.getDependentPackageNames();
            for (String pkgName : depPkgNames) {
                if (!pkgName.equals(pkg.getPackageName())) continue;
                reverseDep.add(installedPkg);
                break;
            }
            if (!installedPkg.isMeta()) continue;
            Package recentPkg = this.recentPackages.getPackageByName(installedPkg.getPackageName());
            depPkgNames = recentPkg.getDependentPackageNames();
            for (String pkgName : depPkgNames) {
                if (!pkgName.equals(pkg.getPackageName())) continue;
                reverseDep.add(installedPkg);
                continue block0;
            }
        }
        return reverseDep;
    }

    public boolean areRepoPackagesOutdated() {
        return this.areRepoPkgsOutdated;
    }

    public boolean isOutdatedSnapshotURL(String targetURL) {
        return this.isOutdatedSnapshotURL(targetURL, null);
    }

    public boolean isOutdatedSnapshotURL(String targetURL, String snapshotPath) {
        try {
            PackageSet targetPkgs = PackageUtil.readPackageListFromRepository(this.contentProvider.getConfig(), targetURL, snapshotPath);
            PackageSet installedPkgs = this.getInstalledPackages();
            for (Package installedPkg : installedPkgs) {
                Package destPackage = targetPkgs.getPackageByName(installedPkg.getPackageName());
                if (destPackage == null || destPackage.getVersion().compareTo(installedPkg.getVersion()) >= 0) continue;
                return true;
            }
        }
        catch (UMException uMException) {
            // empty catch block
        }
        return false;
    }

    public boolean isMBCSOutdatedPkgMgrSnapshotURL(String targetURL, String snapshotPath) {
        Package pkgMgr = this.getPackageByName("package-manager");
        if (pkgMgr == null) {
            this.reloadPackageInfo(null, false);
            pkgMgr = this.getPackageByName("package-manager");
            if (pkgMgr == null) {
                return false;
            }
        }
        boolean isInstalledMBCSPath = PathUtil.isInstalledMBCSPath(this.contentProvider);
        try {
            PackageSet targetPkgs;
            Package repoPkgMgr;
            if (isInstalledMBCSPath && (repoPkgMgr = (targetPkgs = PackageUtil.readPackageListFromRepository(this.contentProvider.getConfig(), targetURL, snapshotPath)).getPackage(pkgMgr)) != null && repoPkgMgr.getVersion().compareTo(new PackageVersion("0.3.37")) < 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setContentProvider(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    private class ExtensionResult {
        PackageSet pkgset;
        ExtensionInformation extInfo;

        public PackageSet getPkgset() {
            return this.pkgset;
        }

        public ExtensionInformation getExtInfo() {
            return this.extInfo;
        }

        public ExtensionResult(ExtensionInformation extInfo, PackageSet pkgset) {
            this.pkgset = pkgset;
            this.extInfo = extInfo;
        }
    }

    private static enum State {
        INSTALL,
        UNINSTALL;

    }
}

