/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.pkg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.model.Property;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class ComponentManager {
    private static final String EXTRAS_COMPONENT_NAME = "EXTRAS";
    private static final String DEPRECATED_COMPONENT_NAME = "DEPRECATED";
    private static final String PROFILE_FILTER_HISTORY_FILE_NAME = "profile_filter_history.info";
    private Logger logger = Log.getLogger(ComponentManager.class);
    private PackageManager packageManager = null;
    private List<Component> extraComponentList = null;
    private List<Component> deprecatedComponentList = null;
    private List<Component> mainComponentList = null;
    private List<Component> allComponentList = null;
    private ContentProvider contentProvider;
    private Set<Package.ProfileType> filteredProfile;

    public ComponentManager(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.allComponentList = new ArrayList<Component>();
        this.mainComponentList = new ArrayList<Component>();
        this.extraComponentList = new ArrayList<Component>();
        this.deprecatedComponentList = new ArrayList<Component>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        this.allComponentList.clear();
        this.mainComponentList.clear();
        this.extraComponentList.clear();
        this.deprecatedComponentList.clear();
        PackageManager packageManager = this.packageManager = this.contentProvider.getPkgMgr();
        synchronized (packageManager) {
            this.createMainComponentTree();
            this.allComponentList.addAll(this.mainComponentList);
            this.extraComponentList = this.generateExtensionComponents();
            if (!this.extraComponentList.isEmpty()) {
                ArrayList<Component> extTreeComps = this.buildAdditionalComponentsTree(EXTRAS_COMPONENT_NAME, this.extraComponentList);
                this.allComponentList.addAll(extTreeComps);
            }
            this.deprecatedComponentList = this.generateDeprecatedComponents();
            if (!this.deprecatedComponentList.isEmpty()) {
                ArrayList<Component> deprecatedTreeComps = this.buildAdditionalComponentsTree(DEPRECATED_COMPONENT_NAME, this.deprecatedComponentList);
                this.allComponentList.addAll(deprecatedTreeComps);
            }
        }
        this.initProfileFilterHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initProfileFilterHistory() {
        int filterCount = Package.ProfileType.values().length;
        this.filteredProfile = new HashSet<Package.ProfileType>();
        File profileFilterFilterFile = new File(PathUtil.getFromInstalledPath(this.contentProvider.getSDKInfo(), ".info", PROFILE_FILTER_HISTORY_FILE_NAME));
        if (profileFilterFilterFile.exists()) {
            BufferedReader fr = null;
            try {
                fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(profileFilterFilterFile), "UTF-8"));
                String line = null;
                block11: while ((line = fr.readLine()) != null) {
                    for (Package.ProfileType pt : Package.ProfileType.values()) {
                        if (!pt.name().equals(line.trim())) continue;
                        this.filteredProfile.add(pt);
                        continue block11;
                    }
                }
                return;
            }
            catch (Exception e) {
                this.logger.error(e);
                this.logger.trace("Set default profile");
                this.filteredProfile.clear();
                this.addInstalledProfileTypeFilter(filterCount);
                if ((this.filteredProfile.size() != 1 || !this.filteredProfile.contains((Object)Package.ProfileType.NONE)) && this.filteredProfile.size() != 0) return;
                for (Package.ProfileType pt : Package.ProfileType.values()) {
                    this.filteredProfile.add(pt);
                }
                return;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        this.logger.error(e);
                    }
                }
            }
        }
        this.addInstalledProfileTypeFilter(filterCount);
        if ((this.filteredProfile.size() != 1 || !this.filteredProfile.contains((Object)Package.ProfileType.NONE)) && this.filteredProfile.size() != 0) return;
        for (Package.ProfileType pt : Package.ProfileType.values()) {
            this.filteredProfile.add(pt);
        }
    }

    private void addInstalledProfileTypeFilter(int filterCount) {
        for (Component next : this.mainComponentList) {
            if (next.getInstalledPackage() != null) {
                this.filteredProfile.add(next.getProfileType());
                if (this.filteredProfile.size() != filterCount) continue;
                break;
            }
            if (!next.hasUninstallableLeafDecendents() && !next.hasUpdatableLeafDecendents()) continue;
            this.filteredProfile.add(next.getProfileType());
            if (this.filteredProfile.size() != filterCount) continue;
            break;
        }
    }

    public Set<Package.ProfileType> getFilteredProfile() {
        return this.filteredProfile;
    }

    public void setFilteredProfile(Package.ProfileType type, boolean isShow) {
        if (isShow) {
            this.filteredProfile.add(type);
        } else {
            this.filteredProfile.remove((Object)type);
        }
    }

    public void saveFilteredProfile() {
        File profileFilterFilterFile = new File(PathUtil.getFromInstalledPath(this.contentProvider.getSDKInfo(), ".info", PROFILE_FILTER_HISTORY_FILE_NAME));
        String NEW_LINE = System.getProperty("line.separator");
        if (profileFilterFilterFile.exists()) {
            profileFilterFilterFile.delete();
        }
        try {
            BufferedWriter fw = null;
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(profileFilterFilterFile), "UTF-8"));
            for (Package.ProfileType type : this.filteredProfile) {
                fw.write(type.name());
                fw.write(NEW_LINE);
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            this.logger.throwing(e);
        }
    }

    private void createMainComponentTree() {
        PackageSet metaPkgs = new PackageSet();
        PackageSet repoMetaPkgs = this.packageManager.getRootMetaPackagesOfRepository();
        for (Package pkg : this.packageManager.getRecentRootMetaPackages()) {
            if (pkg.isExtraMeta() || pkg.isExtensionPackage() || repoMetaPkgs != null && !repoMetaPkgs.isEmpty() && repoMetaPkgs.getPackageByName(pkg.getPackageName()) == null) continue;
            metaPkgs.add(pkg);
        }
        this.mainComponentList = this.makeComponentsFromMetaPkgs(metaPkgs);
        this.buildTreeRelationAdvanced(this.mainComponentList);
    }

    private ArrayList<Component> buildAdditionalComponentsTree(String rootComponentName, List<Component> components) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (components.isEmpty()) {
            return result;
        }
        Component rootComponent = this.createVirtualComponent(rootComponentName);
        this.buildTreeRelationAdvanced(components);
        for (Component comp : components) {
            if (comp.getParent() != null) continue;
            rootComponent.addChildItem(comp);
            comp.setParent(rootComponent);
        }
        result.add(rootComponent);
        result.addAll(components);
        return result;
    }

    private Component createVirtualComponent(String pkgName) {
        for (Component tItem : this.allComponentList) {
            if (!tItem.getPackageName().equalsIgnoreCase(pkgName)) continue;
            return tItem;
        }
        Package extraPkg = this.packageManager.getAllMetaPackages().getPackageByName(pkgName);
        Component extraItem = new Component(this.packageManager, extraPkg, extraPkg, Component.InstallState.INSTALL);
        return extraItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        this.allComponentList.clear();
        PackageManager packageManager = this.packageManager;
        synchronized (packageManager) {
            this.refreshComponentTree(this.mainComponentList, this.packageManager.getRecentMetaPackages());
            this.allComponentList.addAll(this.mainComponentList);
            this.refreshComponentTree(this.extraComponentList, this.packageManager.getRecentExtensionMetaPackages());
            ArrayList<Component> extTreeComps = this.buildAdditionalComponentsTree(EXTRAS_COMPONENT_NAME, this.extraComponentList);
            this.allComponentList.addAll(extTreeComps);
            this.refreshComponentTree(this.deprecatedComponentList, null);
            ArrayList<Component> deprecatedTreeComps = this.buildAdditionalComponentsTree(DEPRECATED_COMPONENT_NAME, this.deprecatedComponentList);
            this.allComponentList.addAll(deprecatedTreeComps);
        }
    }

    private void refreshComponentTree(List<Component> targetComponents, PackageSet remoteMetaPkgs) {
        ArrayList<Component> componentListClone = new ArrayList<Component>();
        componentListClone.addAll(targetComponents);
        PackageSet installedMetaPkgs = this.packageManager.getInstalledMetaPackages();
        for (Component component : componentListClone) {
            if (this.packageManager.getVirtualPackages().hasPackageByName(component.getPackageName()) || component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.UNINSTALLING) continue;
            if (remoteMetaPkgs != null && remoteMetaPkgs.hasPackageByName(component.getPackageName())) {
                component.setInstallState(this.calculateInstallState(component));
                if (component.getInstallState() != Component.InstallState.UNINSTALL) continue;
                component.setInstalledPackage(installedMetaPkgs.getPackageByName(component.getPackageName()));
                continue;
            }
            targetComponents.remove(component);
        }
        this.buildTreeRelationAdvanced(targetComponents);
    }

    public synchronized List<Component> getComponentList() {
        ArrayList<Component> clone = new ArrayList<Component>();
        clone.addAll(this.allComponentList);
        return clone;
    }

    public synchronized boolean isExistProfileType(Package.ProfileType type) {
        for (Component comp : this.allComponentList) {
            if (comp.getProfileType() != type) continue;
            return true;
        }
        return false;
    }

    public synchronized Component getComponentByName(String packageName) {
        for (Component comp : this.allComponentList) {
            if (!comp.getPackageName().equals(packageName)) continue;
            return comp;
        }
        return null;
    }

    public synchronized ArrayList<Component> getUpdatableComponents() {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component comp : this.allComponentList) {
            if (comp.hasChildren() || comp.getInstallState() != Component.InstallState.UPDATE) continue;
            result.add(comp);
        }
        return result;
    }

    public static ArrayList<Component> getSortedComponentsByInstallOrder(ArrayList<Component> components) {
        ArrayList<Component> result = new ArrayList<Component>();
        int oldSize = -1;
        while (result.size() != components.size() || result.size() != oldSize) {
            oldSize = result.size();
            for (Component comp : components) {
                if (result.contains(comp)) continue;
                boolean foundDep = false;
                for (Component comp2 : components) {
                    ArrayList<String> selCompNames = comp.getSelectedGroupNames();
                    if (comp == comp2 || result.contains(comp2) || !selCompNames.contains(comp2.getPackageName())) continue;
                    foundDep = true;
                    break;
                }
                if (foundDep) continue;
                result.add(comp);
            }
        }
        if (oldSize != components.size()) {
            for (Component comp2 : components) {
                if (result.contains(comp2)) continue;
                result.add(comp2);
            }
        }
        return result;
    }

    public synchronized ArrayList<Component> getSelectGroupComponentsToInstall(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<Component> depComps = this.getDependentComponentsBySelectGroup(component);
        for (Component depComp : depComps) {
            if (depComp.getInstallState() != Component.InstallState.INSTALL || depComp.hasChildren()) continue;
            result.add(depComp);
        }
        return result;
    }

    public synchronized ArrayList<Component> getSelectGroupComponentsToUninstall(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<Component> depComps = this.getReverseDependentComponentsBySelectGroup(component);
        for (Component depComp : depComps) {
            if (depComp.getInstallState() != Component.InstallState.UNINSTALL && depComp.getInstallState() != Component.InstallState.UPDATE || depComp.hasChildren()) continue;
            result.add(depComp);
        }
        return result;
    }

    public synchronized ArrayList<Component> getDependentComponentsBySelectGroup(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(component);
        int oldSize = -1;
        while (result.size() != oldSize) {
            oldSize = result.size();
            for (Component comp : this.allComponentList) {
                if (result.contains(comp)) continue;
                boolean foundDep = false;
                for (Component comp2 : result) {
                    ArrayList<String> selCompNames = comp2.getSelectedGroupNames();
                    if (comp == comp2 || !selCompNames.contains(comp.getPackageName())) continue;
                    foundDep = true;
                    break;
                }
                if (!foundDep) continue;
                result.add(comp);
            }
        }
        result.remove(component);
        return result;
    }

    public synchronized ArrayList<Component> getReverseDependentComponentsBySelectGroup(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(component);
        int oldSize = -1;
        while (result.size() != oldSize) {
            oldSize = result.size();
            for (Component comp : this.allComponentList) {
                if (result.contains(comp)) continue;
                boolean foundDep = false;
                for (Component comp2 : result) {
                    ArrayList<String> selCompNames = comp.getSelectedGroupNames();
                    if (comp == comp2 || !selCompNames.contains(comp2.getPackageName())) continue;
                    foundDep = true;
                    break;
                }
                if (!foundDep) continue;
                result.add(comp);
            }
        }
        result.remove(component);
        return result;
    }

    private List<Component> generateDeprecatedComponents() {
        return this.makeComponentsFromMetaPkgs(this.packageManager.getDeprecatedPackages());
    }

    private List<Component> generateExtensionComponents() {
        return this.makeComponentsFromMetaPkgs(this.packageManager.getRecentExtensionMetaPackages());
    }

    private List<Component> makeComponentsFromMetaPkgs(PackageSet pkgSet) {
        ArrayList<Component> treeItemList = new ArrayList<Component>();
        if (pkgSet == null) {
            return treeItemList;
        }
        for (Package pkg : pkgSet) {
            Package installedPkg;
            if (!pkg.isMeta() || pkg.getPackageName().equalsIgnoreCase(EXTRAS_COMPONENT_NAME) || pkg.getPackageName().equalsIgnoreCase(DEPRECATED_COMPONENT_NAME) || pkg.getLabel().equals("")) continue;
            Component.InstallState itemState = this.calculateInstallState(pkg);
            Component newItem = null;
            if (itemState == Component.InstallState.INSTALL) {
                newItem = new Component(this.packageManager, pkg, null, itemState);
            } else if (itemState == Component.InstallState.UPDATE) {
                installedPkg = this.packageManager.getInstalledMetaPackages().getPackage(pkg);
                newItem = new Component(this.packageManager, pkg, installedPkg, itemState);
            } else if (itemState == Component.InstallState.UNINSTALL) {
                installedPkg = this.packageManager.getInstalledMetaPackages().getPackage(pkg);
                newItem = new Component(this.packageManager, pkg, installedPkg, itemState);
            } else {
                this.logger.error("Cannot find install state. => " + (Object)((Object)itemState));
                continue;
            }
            treeItemList.add(newItem);
        }
        return treeItemList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component.InstallState calculateInstallState(Component component) {
        PackageManager packageManager = this.packageManager;
        synchronized (packageManager) {
            return this.calculateInstallState(component.getRecentPackage());
        }
    }

    private Component.InstallState calculateInstallState(Package pkg) {
        if (this.packageManager.isUpdatableMetaPackage(pkg)) {
            return Component.InstallState.UPDATE;
        }
        if (this.packageManager.isInstallableMetaPackages(pkg)) {
            return Component.InstallState.INSTALL;
        }
        return Component.InstallState.UNINSTALL;
    }

    private void buildTreeRelationAdvanced(List<Component> components) {
        for (Component comp : components) {
            comp.setParent(null);
            comp.getChildren().clear();
        }
        ArrayList<Component> newList = new ArrayList<Component>();
        newList.addAll(components);
        for (Component comp : components) {
            Collection<String> depPkgNames = comp.getRecentPackage().getDependentPackageNames();
            ArrayList<Component> children = new ArrayList<Component>();
            for (Component comp1 : components) {
                if (comp1.getParent() != null || !depPkgNames.contains(comp1.getPackageName())) continue;
                comp1.setParent(comp);
                children.add(comp1);
            }
            Collections.sort(children);
            comp.getChildren().addAll(children);
        }
        for (Component comp : components) {
            if (comp.getParent() != null || !comp.hasChildren()) continue;
            ArrayList<Component> children = comp.getChildren();
            boolean notAdvanced = false;
            for (Component component : children) {
                if (component.isAdvanced()) continue;
                notAdvanced = true;
                break;
            }
            if (!notAdvanced) continue;
            ArrayList<Component> advancedList = new ArrayList<Component>();
            ArrayList<Component> notAdvancedList = new ArrayList<Component>();
            for (Component component : children) {
                if (component.isAdvanced()) {
                    advancedList.add(component);
                    continue;
                }
                notAdvancedList.add(component);
            }
            if (advancedList.isEmpty()) continue;
            ArrayList<Property> props = new ArrayList<Property>();
            props.add(new Property("Package", "Advanced" + comp.getPackageName()));
            props.add(new Property("Label", "Advanced"));
            props.add(new Property("Attribute", "root"));
            props.add(new Property("Size", "0"));
            props.add(new Property("Uncompressed-size", "0"));
            props.add(new Property("Version", "0.0.0"));
            props.add(new Property("Description", "Advanced tools contains diverse types of tools for developing Tizen application such as command-line SDKs and JavaScript library for an advanced Tizen web application."));
            Package advancedPackage = new Package(props);
            Component advanced = new Component(this.packageManager, advancedPackage, null, Component.InstallState.INSTALL);
            comp.getChildren().clear();
            if (!notAdvancedList.isEmpty()) {
                Collections.sort(notAdvancedList);
                for (Component child : notAdvancedList) {
                    comp.addChildItem(child);
                    child.setParent(comp);
                }
            }
            Collections.sort(advancedList);
            for (Component child : advancedList) {
                advanced.addChildItem(child);
                child.setParent(advanced);
            }
            comp.addChildItem(advanced);
            advanced.setParent(comp);
            newList.add(advanced);
        }
        Collections.sort(newList);
        components.clear();
        components.addAll(newList);
    }

    public PackageSet getInstallablePackagesOfComponent(Component component) {
        ArrayList<String> targetMetaPkgNames = new ArrayList<String>();
        targetMetaPkgNames.add(component.getPackageName());
        return this.packageManager.getInstallablePackagesOfMetaPackageNames(targetMetaPkgNames);
    }

    public boolean existsRepoPackagesToInstallByDependency(Component component) {
        ArrayList<String> targetMetaPkgNames = new ArrayList<String>();
        if (!component.hasChildren()) {
            targetMetaPkgNames.add(component.getPackageName());
        } else {
            for (Component subComponent : component.getLeafDecendents()) {
                if (targetMetaPkgNames.contains(subComponent.getPackageName()) || subComponent.getInstallState() != Component.InstallState.INSTALL) continue;
                targetMetaPkgNames.add(subComponent.getPackageName());
            }
        }
        PackageSet installablePackages = this.packageManager.getInstallablePackagesOfMetaPackageNames(targetMetaPkgNames);
        PackageSet installedPkgs = this.packageManager.getInstalledPackages();
        boolean found = false;
        for (Package pkg : installablePackages) {
            if (pkg.isExtensionPackage() || installedPkgs.hasPackageByName(pkg.getPackageName())) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean existsMainComponentsBySelectedGroup(Component component) {
        if (!component.hasChildren()) {
            ArrayList<Component> selGroupComps = this.getSelectGroupComponentsToInstall(component);
            for (Component selComp : selGroupComps) {
                if (selComp.getRecentPackage().isExtensionPackage()) continue;
                return true;
            }
        } else {
            for (Component subComponent : component.getLeafDecendents()) {
                if (subComponent.getInstallState() != Component.InstallState.INSTALL) continue;
                ArrayList<Component> selGroupComps = this.getSelectGroupComponentsToInstall(subComponent);
                for (Component selComp : selGroupComps) {
                    if (selComp.getRecentPackage().isExtensionPackage()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

