/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class AddExtensionDialog
extends Dialog {
    private static final Logger logger = Log.getLogger(AddExtensionDialog.class);
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private String DIALOG_TITLE = "Add Repository";
    private boolean isAddRepository = true;
    private String targetRepoId = null;
    private StyledText nameText = null;
    private StyledText repositoryText = null;
    private CustomImageButton selectImageBtn;
    private ExtensionInformation currentExtRepo = null;
    private ArrayList<ExtensionInformation> extensionList;
    private Shell parentShell;
    private boolean isChildOpened = false;
    private ExtRepositoryManager extRepoMgr;

    public AddExtensionDialog(ExtRepositoryManager extRepoMgr, Shell parentShell, String repoId, ArrayList<ExtensionInformation> extensionList) {
        super(parentShell);
        this.setShellStyle(67680);
        WizardUIResourceHandler.getInstance();
        if (repoId != null) {
            this.DIALOG_TITLE = "Modify Repository";
            this.isAddRepository = false;
            this.targetRepoId = repoId;
        }
        this.extRepoMgr = extRepoMgr;
        this.extensionList = extensionList;
        this.parentShell = parentShell;
    }

    @Override
    protected Point getInitialSize() {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG);
        return new Point(rect.width, rect.height);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout(gridLayout);
        container.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.setTitle();
        this.setContent(container);
        this.setBottom(container);
        for (ExtensionInformation extRepo : this.extensionList) {
            if (!extRepo.getId().equals(this.targetRepoId)) continue;
            this.currentExtRepo = extRepo;
            this.nameText.setText(extRepo.getName());
            this.repositoryText.setText(extRepo.getRepository());
            break;
        }
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    private void setTitle() {
        this.getShell().setText(this.DIALOG_TITLE);
        this.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
    }

    private void setContent(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(4, 0x1000000, true, false);
        container.setLayoutData(gd);
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_CONTENT_MARGIN);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginTop = marginRect.width;
        gridLayout.marginLeft = marginRect.width;
        gridLayout.marginRight = marginRect.width;
        gridLayout.marginBottom = marginRect.width;
        gridLayout.verticalSpacing = marginRect.height;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout(gridLayout);
        container.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.setNameText(container);
        this.setRepositoryText(container);
    }

    private void setBottom(Composite parent) {
        Composite bottomComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        bottomComposite.setLayoutData(gd);
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_BOTTOM_MARGIN);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = marginRect.width;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        bottomComposite.setLayout(gridLayout);
        bottomComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        bottomComposite.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                Rectangle rect = AddExtensionDialog.this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG);
                e.gc.setForeground(AddExtensionDialog.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_99));
                e.gc.drawLine(0, 0, rect.width, 0);
            }
        });
        this.setBottomButton(bottomComposite);
    }

    private void setBottomButton(Composite container) {
        Rectangle marginRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_BOTTOM_MARGIN);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = marginRect.x;
        gridLayout.marginTop = marginRect.y;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        Rectangle buttonRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_BOTTOM_BUTTON);
        Button btnConfirm = new Button(container, 8);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = buttonRect.height;
        gd.widthHint = buttonRect.width;
        btnConfirm.setLayoutData(gd);
        btnConfirm.setText("OK");
        btnConfirm.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        btnConfirm.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        btnConfirm.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddExtensionDialog.this.okPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button btnCancel = new Button(container, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.heightHint = buttonRect.height;
        gd.widthHint = buttonRect.width;
        btnCancel.setLayoutData(gd);
        btnCancel.setText("Cancel");
        btnCancel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        btnCancel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        btnCancel.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                AddExtensionDialog.this.cancelPressed();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    @Override
    protected void okPressed() {
        String repoName = this.nameText.getText();
        if (repoName.isEmpty()) {
            CustomMessageDialog.showError(this.getShell(), "Extra Repository Settings", ErrorController.ErrorCode.REPOSITORY_NAME_IS_EMPTY);
            return;
        }
        String repoURL = NetworkUtil.normalizeURL(this.repositoryText.getText());
        if (repoURL.isEmpty()) {
            CustomMessageDialog.showError(this.getShell(), "Extra Repository Settings", ErrorController.ErrorCode.REPOSITORY_URL_IS_EMPTY);
            return;
        }
        if (this.isAddRepository) {
            for (ExtensionInformation extInfo : this.extensionList) {
                if (extInfo.getName().equals(repoName)) {
                    CustomMessageDialog.showError(this.getShell(), "Extra Repository Settings", ErrorController.ErrorCode.DUPLICATED_EXTENSION_REPOSITORY_NAME);
                    return;
                }
                if (!NetworkUtil.isSameURL(extInfo.getRepository(), repoURL)) continue;
                CustomMessageDialog.showError(this.getShell(), "Extra Repository Settings", ErrorController.ErrorCode.DUPLICATED_EXTENSION_REPOSITORY);
                return;
            }
        }
        final String targetURL = repoURL;
        final String repoId = this.isAddRepository ? UUID.randomUUID().toString() : this.targetRepoId;
        ExtRepositoryManager.ValidationResult result = null;
        try {
            CustomProgressDialog progressbar = new CustomProgressDialog(this.getShell(), null);
            result = progressbar.run(new CallableWithMonitor<ExtRepositoryManager.ValidationResult>(){

                @Override
                public ExtRepositoryManager.ValidationResult call(IProgressMonitor monitor) throws Exception {
                    ExtRepositoryManager.ValidationResult result = null;
                    try {
                        monitor.beginTask("Validating extension repository...", -1);
                        Thread.sleep(100L);
                        logger.trace("Validating extension repository..." + targetURL);
                        result = AddExtensionDialog.this.extRepoMgr.validateRepository(targetURL, repoId);
                        logger.trace("Valid!!!");
                    }
                    catch (UMException e) {
                        throw e;
                    }
                    finally {
                        monitor.done();
                    }
                    return result;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof UMException) {
                CustomMessageDialog.showDlg(this.getShell(), "Extra Repository Settings", e.getMessage(), CustomMessageDialog.DialogType.ERROR, true);
                return;
            }
            logger.throwing(e);
        }
        if (this.isAddRepository) {
            if (result.getCachePath() == null) {
                this.extensionList.add(ExtRepositoryManager.createNewRepository(repoId, repoName, repoURL, true, null));
            } else {
                this.extensionList.add(ExtRepositoryManager.createNewRepository(repoId, repoName, NetworkUtil.getFileURL(result.getCachePath()), true, result.getLastModifiedDate()));
            }
        } else {
            this.currentExtRepo.setName(repoName);
            if (result.getCachePath() == null) {
                this.currentExtRepo.setRepository(repoURL);
                this.currentExtRepo.setRepotype("server");
            } else {
                this.currentExtRepo.setRepository(NetworkUtil.getFileURL(result.getCachePath()));
                this.currentExtRepo.setRepotype("file");
                if (result.getLastModifiedDate() != null) {
                    this.currentExtRepo.setLastModifiedDate(result.getLastModifiedDate());
                }
            }
        }
        this.close();
    }

    private void setNameText(Composite composite) {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_NAME);
        Label nameLabel = new Label(composite, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.x;
        gd.heightHint = rect.height - 5;
        nameLabel.setLayoutData(gd);
        nameLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        nameLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        nameLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        nameLabel.setText("Name :");
        this.nameText = new StyledText(composite, 2052);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height - 5;
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData(gd);
        this.nameText.setText("");
        Rectangle innerRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_TEXT_MARGIN);
        this.nameText.setMargins(innerRect.x, innerRect.y, 0, 0);
        this.nameText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.nameText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.nameText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
    }

    private void setRepositoryText(Composite composite) {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_REPOSITORY);
        Label repositoryLabel = new Label(composite, 0);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.x;
        gd.heightHint = rect.height - 5;
        repositoryLabel.setLayoutData(gd);
        repositoryLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        repositoryLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        repositoryLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        repositoryLabel.setText("Repository :");
        this.repositoryText = new StyledText(composite, 2052);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = rect.width;
        gd.heightHint = rect.height - 5;
        this.repositoryText.setLayoutData(gd);
        this.repositoryText.append("http://");
        Rectangle innerRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_ADD_DIALOG_TEXT_MARGIN);
        this.repositoryText.setMargins(innerRect.x, innerRect.y, 0, 0);
        this.repositoryText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.repositoryText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.repositoryText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        this.selectImageBtn = new CustomImageButton(composite, 0);
        this.selectImageBtn.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_NORMAL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_IC_LOCATION_DIS));
        gd = new GridData(131072, 0x1000000, false, false);
        gd.widthHint = rect.y;
        gd.heightHint = rect.height;
        this.selectImageBtn.setLayoutData(gd);
        this.selectImageBtn.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        this.selectImageBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent event) {
                AddExtensionDialog.this.repositoryText.setText("");
                logger.info("Open select-local-ext-repo dialog.");
                String repoFilePath = AddExtensionDialog.this.openSelectLocalExensionRepositoryDialog();
                if (repoFilePath == null) {
                    logger.error("Fail to select extension SDK repository.");
                    return;
                }
                logger.info("Local extension repository : " + repoFilePath);
                if (repoFilePath.endsWith(".zip")) {
                    AddExtensionDialog.this.repositoryText.setText(NetworkUtil.getFileURL(repoFilePath));
                } else {
                    File repoFile = new File(repoFilePath);
                    AddExtensionDialog.this.repositoryText.setText(NetworkUtil.getFileURL(repoFile.getParent()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String openSelectLocalExensionRepositoryDialog() {
        FileDialog dlg = new FileDialog(this.getShell());
        dlg.setFilterExtensions(new String[]{"*.zip;" + PackageManager.getPackageListFileName()});
        dlg.setText("Select a SDK image file.");
        String strDir = null;
        try {
            this.parentShell.setEnabled(false);
            this.getShell().setEnabled(false);
            this.isChildOpened = true;
            strDir = dlg.open();
        }
        catch (SWTException e) {
            logger.throwing(e);
        }
        finally {
            this.parentShell.setEnabled(true);
            this.getShell().setEnabled(true);
            this.isChildOpened = false;
        }
        return strDir;
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        if (!this.isChildOpened) {
            return super.canHandleShellCloseEvent();
        }
        return false;
    }
}

