/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.tizen.library.sdkutils.api.ISDKUtils;
import org.tizen.library.sdkutils.api.impl.SDKUtils;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.SelfUpdater;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.packagemanager.ui.configuration.ConfigurationDialog;
import org.tizen.packagemanager.ui.dialog.InformationDialog;
import org.tizen.packagemanager.ui.exception.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.page.ViewController;
import org.tizen.packagemanager.ui.page.custom.CallableWithMonitor;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.page.custom.CustomProgressBar;
import org.tizen.packagemanager.ui.page.custom.CustomProgressDialog;
import org.tizen.packagemanager.ui.page.custom.ProgressTabImageButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class PackageManagerMainWindow {
    private static final String TAB1_MAIN_SDK = "Main SDK";
    private static final String TAB2_EXTENDED_SDK = "Extension SDK";
    private static final String TAB3_PROGRESS = "Progress";
    private static Logger logger = Log.getLogger(PackageManagerMainWindow.class);
    private TabViewType currentTabView = TabViewType.MAIN;
    private static PackageManagerMainWindow window;
    private WizardUIResourceHandler uiRsrcHandler;
    private ToolTip toolTip;
    private Composite mainContainer;
    private Label topBackgroundBI;
    private StyledText subTitle;
    private CustomImageButton buttonInstalledPkgs;
    private ProgressTabImageButton buttonProgress;
    private Label disconnectLabel;
    private Label disconnectImage;
    private CustomImageButton buttonTroubleShooting;
    private CustomImageButton buttonConfiguration;
    private CustomImageButton buttonInfo;
    private Composite tab1;
    private Composite tab2;
    private Composite tab3;
    private StackLayout stackLayout = null;
    private Composite pageComposite;
    private Shell shell;
    private int refreshExiteCode = 0;
    private Composite titleViewArea;
    private Display display;
    private int runningTimerNum = 0;
    private CustomProgressBar progressBar;
    private ContentProvider contentProvider;
    private ViewController viewController;

    public PackageManagerMainWindow(ContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.viewController = new ViewController(this.contentProvider);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        window = this;
        this.display = Display.getDefault();
        this.shell = new Shell(this.display, 224);
        this.shell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
    }

    public static PackageManagerMainWindow getPackageManagerWindow() {
        return window;
    }

    public void run() throws Exception {
        String title = this.uiRsrcHandler.getStringFromResource(WizardUIResourceHandler.UITerms.MANAGER_TITLE);
        Rectangle windowSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_BASIC);
        Rectangle displayBounds = this.display.getBounds();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors != null && monitors.length >= 1) {
            Monitor monitor = monitors[0];
            Rectangle bounds = monitor.getBounds();
            this.shell.setBounds(bounds.width / 2 - windowSize.width / 2, bounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        } else {
            this.shell.setBounds(displayBounds.width / 2 - windowSize.width / 2, displayBounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        }
        this.shell.setSize(windowSize.width, windowSize.height);
        this.shell.setText(title);
        try {
            this.createContents(this.shell);
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        this.shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                arg0.doit = PackageManagerMainWindow.this.canHandleShellCloseEvent();
            }
        });
    }

    protected boolean canHandleShellCloseEvent() {
        if (this.viewController.getProgressView().getTotalMonitor().isDone()) {
            int flag;
            PackageSet installedPackages = this.contentProvider.getPkgMgr().getInstalledPackages();
            if (installedPackages == null || installedPackages != null && installedPackages.isEmpty()) {
                int result = 128;
                result = CustomMessageDialog.showDlg(this.shell, "Package Manager", "No installed package exists. Do you want to remove the Tizen Studio's directory completely?", CustomMessageDialog.DialogType.CONFIRM, false);
                if (result == 64) {
                    this.contentProvider.getInstController().removeSDKLegacy(false);
                    return true;
                }
                return false;
            }
            ProgramController controller = ProgramController.createProgramController(this.contentProvider.getSDKInfo());
            List<String> sdkProcessList = controller.getSDKProcessList();
            for (String progName : sdkProcessList) {
                if (!progName.equals(ProgramController.PROG_NAME_IDE)) continue;
                return true;
            }
            SDKUtils sdkUtils = SDKUtils.getInstance();
            boolean isBaseIdeExist = this.contentProvider.getPkgMgr().isInstalledPackage("base-ide-product");
            boolean ret = true;
            if (isBaseIdeExist && (ret = ((flag = CustomMessageDialog.showDlg(this.shell, "Package Manager", "Before exiting the Package Manager,\ncheck the checkbox to launch the Tizen Studio immediately.", "Launch the Tizen Studio", CustomMessageDialog.DialogType.CONFIRM_CHECK, true)) & 0x40) == 64) && (flag & 0x20) == 32) {
                String tizenStudioPath;
                String sdkInfoLocation = this.contentProvider.getSDKInfo().getInstalledPath() + File.separator + "sdk.info";
                String executionDir = PathUtil.getExecutableJarParentDir();
                boolean copyResult = PathUtil.fileCopy(sdkInfoLocation, executionDir + File.separator + "sdk.info");
                logger.trace("copy sdk.info to " + executionDir + " : result -> " + copyResult);
                if (copyResult && (tizenStudioPath = sdkUtils.getSDKToolPath(ISDKUtils.SdkTool.TIZEN_STUDIO)) != null) {
                    logger.trace("execute SDK Tools: Tizen Studio, path : " + tizenStudioPath);
                    sdkUtils.executeSDKTools(ISDKUtils.SdkTool.TIZEN_STUDIO);
                    logger.trace("execute SDK Tools: Tizen Studio run end");
                }
            }
            return ret;
        }
        CustomMessageDialog.showDlg(this.shell, "Package Manager", "You cannot close the window while Package Manager is still running.", CustomMessageDialog.DialogType.WARNING, true);
        return false;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected void createContents(Composite parent) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        formLayout.spacing = 0;
        parent.setLayout(formLayout);
        this.toolTip = new ToolTip(this.shell, 2048);
        this.toolTip.setAutoHide(false);
        this.mainContainer = new Composite(parent, 0);
        this.mainContainer.setBounds(parent.getBounds());
        this.mainContainer.setSize(parent.getBounds().width, parent.getBounds().height);
        this.mainContainer.setLayout(formLayout);
        try {
            this.createTopView(this.mainContainer);
            this.createTabViews(this.mainContainer);
            this.viewController.init(this, this.pageComposite, this.stackLayout);
            this.refreshWelcome();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshWelcome() {
        this.viewController.reloadPage(true);
        this.viewController.enablePages(this.viewController.getCurrent());
    }

    private void createTopView(Composite parent) {
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_BASIC);
        this.titleViewArea = new Composite(parent, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, 0, 0x1000000);
        formData.top = new FormAttachment(parent, 0, 0x1000000);
        formData.width = rect.width;
        formData.height = rect.height;
        this.titleViewArea.setLayoutData(formData);
        this.titleViewArea.setLayout(new FormLayout());
        this.titleViewArea.setBackgroundMode(2);
        this.titleViewArea.setBackgroundImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_TITLE_BACKGROUND));
        this.createTitleMessage(this.titleViewArea);
        this.createTabButtonView(this.titleViewArea);
        this.createSpliterComposites(this.titleViewArea);
        this.createTroubleShootingButton(this.titleViewArea);
        this.createConfigurationButton(this.titleViewArea);
        this.createInfoButton(this.titleViewArea);
        this.createDisconnectStatus(this.titleViewArea);
    }

    private void createSpliterComposites(Composite tabViewArea) {
        Label title = new Label(tabViewArea, 0);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_SPLITER);
        FormData formData = new FormData();
        formData.left = new FormAttachment(tabViewArea, rect.x);
        formData.top = new FormAttachment(tabViewArea, rect.y);
        formData.width = rect.width;
        formData.height = rect.height;
        title.setLayoutData(formData);
        title.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_233));
    }

    public void setProgress(int percent) {
        if (this.subTitle != null && !this.subTitle.isDisposed()) {
            if (percent < 100) {
                this.subTitle.setText(String.format("Progressing...%02d%%", percent));
            } else {
                this.subTitle.setText("Complete");
                int waitTime = 5000;
                Runnable timer = new Runnable(){

                    @Override
                    public void run() {
                        if (PackageManagerMainWindow.this.runningTimerNum == 1 && PackageManagerMainWindow.this.subTitle.getText().equals("Complete")) {
                            PackageManagerMainWindow.this.subTitle.setText("Package Manager");
                        }
                        PackageManagerMainWindow.this.runningTimerNum--;
                    }
                };
                this.display.timerExec(waitTime, timer);
                ++this.runningTimerNum;
            }
            this.subTitle.redraw();
        }
    }

    private void createTitleMessage(Composite tabViewArea) {
        Label title = new Label(tabViewArea, 0);
        title.setText("TIZEN STUDIO");
        title.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        title.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_20PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_REGULAR, 0));
        GC gc = new GC(title);
        Point textExtent = gc.textExtent("TIZEN STUDIO");
        gc.dispose();
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_TEXT);
        FormData formData = new FormData();
        formData.left = new FormAttachment(tabViewArea, rect.x);
        formData.top = new FormAttachment(tabViewArea, rect.y);
        formData.width = textExtent.x;
        formData.height = textExtent.y;
        title.setLayoutData(formData);
        this.subTitle = new StyledText(tabViewArea, 0);
        this.subTitle.setText("Package Manager");
        this.subTitle.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.subTitle.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_36PX, WizardUIResourceHandler.FontType.WIZARD_FONT_TYPE_BOLD, 1));
        this.subTitle.setEnabled(false);
        GC gc2 = new GC(this.subTitle);
        Point textExtent2 = gc2.textExtent(String.format("Progressing...%02d%%", 100));
        gc2.dispose();
        Rectangle subRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_SUB_TEXT);
        formData = new FormData();
        formData.left = new FormAttachment(tabViewArea, subRect.x);
        formData.top = new FormAttachment(tabViewArea, subRect.y);
        formData.width = textExtent2.x + 10;
        formData.height = textExtent2.y;
        this.subTitle.setLayoutData(formData);
        this.createProgressComposites(tabViewArea);
    }

    private void createProgressComposites(Composite parent) {
        Composite viewContainer = new Composite(parent, 0);
        FormData formData = new FormData();
        Rectangle progressRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_PROGRESS_BAR);
        formData.left = new FormAttachment(parent, progressRect.x);
        formData.top = new FormAttachment(parent, progressRect.y);
        formData.width = progressRect.width;
        formData.height = progressRect.height;
        viewContainer.setLayoutData(formData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        viewContainer.setLayout(gridLayout);
        viewContainer.setBackgroundMode(1);
        this.createProgressBar(viewContainer);
    }

    private void createProgressBar(Composite viewContainer) {
        this.progressBar = new CustomProgressBar(viewContainer, this.uiRsrcHandler);
        GridData gridData = new GridData(4, 4, false, false);
        Rectangle progressRect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_PROGRESS_BAR);
        gridData.widthHint = progressRect.width;
        gridData.heightHint = progressRect.height;
        this.progressBar.setLayoutData(gridData);
        this.progressBar.setProgressBarColor(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.progressBar.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_BLUE));
        this.progressBar.setTextColor(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE), this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
        this.progressBar.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.progressBar.setVisible(false);
    }

    public CustomProgressBar getProgressBar() {
        if (!this.progressBar.getVisible()) {
            this.progressBar.setVisible(true);
        }
        return this.progressBar;
    }

    private void createTabButtonView(Composite tabViewArea) {
        Rectangle tab1ButtonSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_MAIN_BUTTON);
        Rectangle tab2ButtonSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_EXT_BUTTON);
        Rectangle tab3ButtonSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_PROGRESS_BUTTON);
        this.tab1 = new Composite(tabViewArea, 8);
        this.createTabButton(tabViewArea, tab1ButtonSize, this.tab1);
        this.tab2 = new Composite(tabViewArea, 8);
        this.createTabButton(tabViewArea, tab2ButtonSize, this.tab2);
        this.tab3 = new Composite(tabViewArea, 8);
        this.createTabButton(tabViewArea, tab3ButtonSize, this.tab3);
        this.createTabEventListener(this.tab1, TabViewType.MAIN, tab1ButtonSize, TAB1_MAIN_SDK);
        this.createTabEventListener(this.tab2, TabViewType.EXTEND, tab2ButtonSize, TAB2_EXTENDED_SDK);
        this.createTabEventListener(this.tab3, TabViewType.PROGRESS, tab3ButtonSize, TAB3_PROGRESS);
    }

    private void createTabEventListener(Composite tab, final TabViewType selectedValue, final Rectangle tabButtonSize, final String title) {
        tab.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                PackageManagerMainWindow.this.currentTabView = selectedValue;
                PackageManagerMainWindow.this.tab1.redraw();
                PackageManagerMainWindow.this.tab2.redraw();
                PackageManagerMainWindow.this.tab3.redraw();
                PackageManagerMainWindow.this.viewController.reloadPage(false);
                PackageManagerMainWindow.this.viewController.enablePages(selectedValue);
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        tab.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                PackageManagerMainWindow.this.drawTabButton(tabButtonSize, selectedValue, arg0, title);
            }
        });
    }

    private void createTabButton(Composite tabViewArea, Rectangle tab1ButtonSize, Composite tab1) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(tabViewArea, tab1ButtonSize.x, 0x1000000);
        formData.top = new FormAttachment(tabViewArea, tab1ButtonSize.y, 0x1000000);
        formData.width = tab1ButtonSize.width;
        formData.height = tab1ButtonSize.height;
        tab1.setLayoutData(formData);
        tab1.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private void drawTabButton(Rectangle tabButtonBounds, TabViewType target, PaintEvent arg0, String textValue) {
        Image bufferedImage = new Image((Device)arg0.display, new Rectangle(0, 0, tabButtonBounds.width, tabButtonBounds.height));
        GC gc = new GC(bufferedImage);
        gc.setAntialias(1);
        if (this.currentTabView == target) {
            gc.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
            gc.drawLine(0, tabButtonBounds.height - 2, tabButtonBounds.width, tabButtonBounds.height - 2);
            gc.drawLine(0, tabButtonBounds.height - 1, tabButtonBounds.width, tabButtonBounds.height - 1);
            gc.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        } else {
            gc.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_46));
            gc.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        }
        Point textExtent = gc.textExtent(textValue);
        int textX = tabButtonBounds.width / 2 - textExtent.x / 2;
        int textY = tabButtonBounds.height / 2 - textExtent.y / 2;
        gc.drawText(textValue, textX, textY);
        arg0.gc.drawImage(bufferedImage, 0, 0);
        gc.dispose();
    }

    private void createDisconnectStatus(Composite parent) {
        this.disconnectLabel = new Label(parent, 0);
        this.disconnectImage = new Label(parent, 0);
        Rectangle bounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_NETWORK_INFO);
        this.disconnectLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.disconnectLabel.setText("Network disconnected");
        this.disconnectLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GC gc = new GC(this.disconnectLabel);
        Point textExtent = gc.textExtent("Network disconnected");
        gc.dispose();
        int left = bounds.x + bounds.width - textExtent.x;
        int top = bounds.y - 10 - textExtent.y;
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, left);
        formData.top = new FormAttachment(parent, top);
        formData.width = textExtent.x;
        formData.height = textExtent.y;
        this.disconnectLabel.setLayoutData(formData);
        Image image = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_NETWORK_DISCONNECTED);
        this.disconnectImage.setImage(image);
        Rectangle imageBounds = image.getBounds();
        int imageLeft = left - 5 - imageBounds.width;
        int imageTop = bounds.y - 10 - imageBounds.height;
        FormData imageformData = new FormData();
        imageformData.left = new FormAttachment(parent, imageLeft);
        imageformData.top = new FormAttachment(parent, imageTop);
        imageformData.width = imageBounds.width;
        imageformData.height = imageBounds.height;
        this.disconnectImage.setLayoutData(imageformData);
        this.disconnectLabel.moveAbove(this.topBackgroundBI);
        this.disconnectLabel.setVisible(true);
    }

    private void createInfoButton(Composite parent) {
        this.buttonInfo = new CustomImageButton(parent, 0);
        this.buttonInfo.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_INFO_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_INFO_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_INFO_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_INFO_DIS));
        this.buttonInfo.moveAbove(this.topBackgroundBI);
        Rectangle bounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_INFO_BUTTON);
        this.buttonInfo.setBounds(bounds);
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, bounds.x);
        formData.top = new FormAttachment(parent, bounds.y);
        formData.width = bounds.width;
        formData.height = bounds.height;
        this.buttonInfo.setLayoutData(formData);
        this.buttonInfo.addMouseClickEventListener(new CustomImageButton.IClickEventListener(){

            @Override
            public void onClick(CustomImageButton button) {
                logger.trace("Info button clicked!!");
                PackageManagerMainWindow.this.onClickInformationButtion();
            }
        });
        this.buttonInfo.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setVisible(false);
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setMessage("Information");
                PackageManagerMainWindow.this.toolTip.setLocation(((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().x + 1, ((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().y + 1);
                PackageManagerMainWindow.this.toolTip.setVisible(true);
            }
        });
    }

    protected void onClickInformationButtion() {
        InformationDialog dialog = new InformationDialog(this.getShell(), this.contentProvider.getSDKInfo(), this.contentProvider.getConfig());
        this.shell.setEnabled(false);
        try {
            dialog.open();
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            if (!this.shell.isDisposed()) {
                this.shell.setEnabled(true);
            }
        }
    }

    private void createConfigurationButton(Composite parent) {
        this.buttonConfiguration = new CustomImageButton(parent, 0);
        this.buttonConfiguration.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_SETTING_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_SETTING_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_SETTING_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_SETTING_DIS));
        this.buttonConfiguration.moveAbove(this.topBackgroundBI);
        Rectangle bounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_SETTING_BUTTON);
        this.buttonConfiguration.setBounds(bounds);
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, bounds.x);
        formData.top = new FormAttachment(parent, bounds.y);
        formData.width = bounds.width;
        formData.height = bounds.height;
        this.buttonConfiguration.setLayoutData(formData);
        this.buttonConfiguration.addMouseClickEventListener(new CustomImageButton.IClickEventListener(){

            @Override
            public void onClick(CustomImageButton button) {
                logger.trace("Configuration button clicked!!");
                PackageManagerMainWindow.this.onClickConfigurationButton();
            }
        });
        this.buttonConfiguration.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setVisible(false);
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setMessage("Configuration");
                PackageManagerMainWindow.this.toolTip.setLocation(((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().x + 1, ((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().y + 1);
                PackageManagerMainWindow.this.toolTip.setVisible(true);
            }
        });
    }

    protected void onClickConfigurationButton() {
        this.shell.setEnabled(false);
        this.viewController.setConfigurationDialogOpened(true);
        final ConfigurationDialog dialog = new ConfigurationDialog(this.contentProvider, this.shell);
        try {
            dialog.open();
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            if (!this.shell.isDisposed()) {
                this.shell.setEnabled(true);
                this.viewController.setConfigurationDialogOpened(false);
            }
        }
        if (dialog.isConfirmed() && dialog.getSelectedServerType() != null) {
            this.contentProvider.getConfig().setServerType(dialog.getSelectedServerType());
        }
        if (dialog.isServerChanged()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (dialog.isUninstallationNeeded()) {
                        PackageManagerMainWindow.this.refresh(true, false, true, dialog);
                    } else {
                        PackageManagerMainWindow.this.refresh(true, false, false, dialog);
                    }
                }
            });
        } else if (dialog.isRefreshNeeded()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PackageManagerMainWindow.this.refresh(false, dialog.isCheckExtRepositoryNeeded(), false, dialog);
                }
            });
        }
    }

    private void createTroubleShootingButton(Composite parent) {
        this.buttonTroubleShooting = new CustomImageButton(parent, 0);
        this.buttonTroubleShooting.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_HELP_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_HELP_OVER), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_HELP_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ICON_HELP_DIS));
        this.buttonTroubleShooting.moveAbove(this.topBackgroundBI);
        Rectangle bounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TITLE_HELP_BUTTON);
        this.buttonTroubleShooting.setBounds(bounds);
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, bounds.x);
        formData.top = new FormAttachment(parent, bounds.y);
        formData.width = bounds.width;
        formData.height = bounds.height;
        this.buttonTroubleShooting.setLayoutData(formData);
        this.buttonTroubleShooting.addMouseClickEventListener(new CustomImageButton.IClickEventListener(){

            @Override
            public void onClick(CustomImageButton button) {
                logger.trace("Troubleshooting button clicked!!");
                PackageManagerMainWindow.this.onClickTroubleShootingButtion();
            }
        });
        this.buttonTroubleShooting.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setVisible(false);
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                PackageManagerMainWindow.this.toolTip.setMessage("Inside Trouble Shooting");
                PackageManagerMainWindow.this.toolTip.setLocation(((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().x + 1, ((PackageManagerMainWindow)PackageManagerMainWindow.this).display.getCursorLocation().y + 1);
                PackageManagerMainWindow.this.toolTip.setVisible(true);
            }
        });
    }

    protected void onClickTroubleShootingButtion() {
        this.shell.setEnabled(false);
        try {
            InsideTroubleShootingDialog.open(this.getShell());
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        finally {
            if (!this.shell.isDisposed()) {
                this.shell.setEnabled(true);
            }
        }
    }

    public CustomImageButton getInstalledPackagesTabButton() {
        return this.buttonInstalledPkgs;
    }

    public ProgressTabImageButton getProgressTabButton() {
        return this.buttonProgress;
    }

    public CustomImageButton getConfigurationButton() {
        return this.buttonConfiguration;
    }

    private void createTabViews(Composite parent) {
        Rectangle tabViewSize = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_TAB_VIEW);
        this.pageComposite = new Composite(parent, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(parent, 0, 0x1000000);
        formData.top = new FormAttachment(parent, tabViewSize.y, 0x1000000);
        formData.width = tabViewSize.width;
        formData.height = tabViewSize.height;
        this.pageComposite.setLayoutData(formData);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.pageComposite.setLayout(this.stackLayout);
    }

    public void refresh(final boolean isServerChanged, final boolean checkExtRepository, final boolean uninstallRequired, final ConfigurationDialog dialog) {
        String title = "";
        if (dialog != null) {
            title = "Refreshing repository";
        }
        CustomProgressDialog progressbar = new CustomProgressDialog(this.shell, title);
        final Shell shell = progressbar.getParent();
        try {
            progressbar.run(new CallableWithMonitor<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call(IProgressMonitor monitor) throws Exception {
                    monitor.beginTask("Refreshing...", -1);
                    HashMap<String, String> uninstallAll = null;
                    if (uninstallRequired) {
                        monitor.subTask("Removing existing packages...");
                        uninstallAll = PackageManagerMainWindow.this.contentProvider.getInstController().uninstallAll(monitor, true);
                        PackageManagerMainWindow.this.contentProvider.getInstController().removeShortcutMenu();
                    }
                    if (uninstallAll != null && !uninstallAll.isEmpty()) {
                        final HashMap<String, String> uninstallFailMap = new HashMap<String, String>();
                        uninstallFailMap.putAll(uninstallAll);
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                boolean isFirst = true;
                                do {
                                    String[] cmd;
                                    String errorMsg = "";
                                    if (isFirst) {
                                        isFirst = false;
                                        Set keySet = uninstallFailMap.keySet();
                                        for (String key : keySet) {
                                            errorMsg = errorMsg + String.format("[%s] :  %s", key, uninstallFailMap.get(key));
                                        }
                                        UMException umException = new UMException(ErrorController.ErrorCode.CANNOT_DELETE_INSTALLED_DIRECTORY, errorMsg);
                                        PackageManagerMainWindow.this.refreshExiteCode = InsideTroubleShootingDialog.open(shell, (Exception)umException, true);
                                        continue;
                                    }
                                    ShellParser sparser = new ShellParser();
                                    File file = new File(PackageManagerMainWindow.this.contentProvider.getConfig().getTargetDir());
                                    if (PlatformUtil.isWindows()) {
                                        try {
                                            cmd = new String[]{"cmd", "/c", "rmdir", "/s", "/q", file.getAbsolutePath()};
                                            PackageManagerMainWindow.this.refreshExiteCode = ShellUtil.execute(cmd, sparser);
                                        }
                                        catch (IMShellCommandFail e) {
                                            PackageManagerMainWindow.this.refreshExiteCode = -1;
                                        }
                                        continue;
                                    }
                                    try {
                                        cmd = new String[]{"rm", "-rf", file.getAbsolutePath()};
                                        PackageManagerMainWindow.this.refreshExiteCode = ShellUtil.execute(cmd, sparser);
                                    }
                                    catch (IMShellCommandFail e) {
                                        PackageManagerMainWindow.this.refreshExiteCode = -1;
                                    }
                                    if (PackageManagerMainWindow.this.refreshExiteCode == 0) continue;
                                    UMException umException = new UMException(ErrorController.ErrorCode.CANNOT_DELETE_INSTALLED_DIRECTORY, sparser.getOutputMessage());
                                    PackageManagerMainWindow.this.refreshExiteCode = InsideTroubleShootingDialog.open(shell, (Exception)umException, true);
                                } while (PackageManagerMainWindow.this.refreshExiteCode != 0);
                            }
                        });
                    }
                    monitor.subTask("Loading configuration");
                    if (dialog != null) {
                        ContentProvider newContentProvider = dialog.getNewContentProvider();
                        PackageManagerMainWindow.this.contentProvider.setConfig(newContentProvider.getConfig());
                        PackageManagerMainWindow.this.contentProvider.setRepoMgr(newContentProvider.getRepoMgr());
                        PackageManagerMainWindow.this.contentProvider.setExtRepoMgr(newContentProvider.getExtRepoMgr());
                        if (isServerChanged) {
                            PackageManagerMainWindow.this.contentProvider.getConfig().saveSnapshotSettings(dialog.getSelectedRepository(), dialog.getSelectedDistribution(), dialog.getSelectedSnapshotPath(), dialog.getOriginRepo(), dialog.getDistributionId(), dialog.isAutoUpdate());
                            if (Config.ServerType.SNAPSHOT.equals((Object)dialog.getSelectedServerType())) {
                                PackageManagerMainWindow.this.contentProvider.getConfig().setImageFileInfo(null);
                            }
                        } else {
                            Config.ServerType selectedServerType = PackageManagerMainWindow.this.contentProvider.getConfig().getServerType();
                            String selectedRepository = dialog.getSelectedRepository();
                            if (selectedServerType == Config.ServerType.LOCAL) {
                                if (selectedRepository != null && !selectedRepository.isEmpty()) {
                                    PackageManagerMainWindow.this.contentProvider.getConfig().saveSnapshotSettings(dialog.getSelectedRepository(), dialog.getSelectedDistribution(), dialog.getSelectedSnapshotPath(), dialog.getOriginRepo(), dialog.getDistributionId(), dialog.isAutoUpdate());
                                }
                            } else {
                                String selectedDistribution = dialog.getSelectedDistribution();
                                if (selectedRepository != null && !selectedRepository.isEmpty() && selectedDistribution != null && !selectedDistribution.isEmpty()) {
                                    PackageManagerMainWindow.this.contentProvider.getConfig().saveSnapshotSettings(dialog.getSelectedRepository(), dialog.getSelectedDistribution(), dialog.getSelectedSnapshotPath(), dialog.getOriginRepo(), dialog.getDistributionId(), dialog.isAutoUpdate());
                                }
                            }
                            if (Config.ServerType.SNAPSHOT.equals((Object)dialog.getSelectedServerType())) {
                                PackageManagerMainWindow.this.contentProvider.getConfig().setImageFileInfo(null);
                            }
                        }
                    }
                    try {
                        monitor.beginTask("Refreshing...", -1);
                        try {
                            if (checkExtRepository) {
                                monitor.subTask("Checking extension repositories...");
                                PackageManagerMainWindow.this.checkExtRepository();
                            }
                            PackageManagerMainWindow.this.contentProvider.getConfig().saveConfig();
                            PackageManagerMainWindow.this.contentProvider.getSDKInfo().save(false);
                            if (isServerChanged) {
                                monitor.subTask("Loading alternative repositories...");
                                PackageManagerMainWindow.this.contentProvider.getAlterMgr().init(true);
                            }
                            monitor.subTask("Loading package information...");
                            String repositoryURL = PackageManagerMainWindow.this.contentProvider.getConfig().getDistributionURL();
                            PackageManagerMainWindow.this.contentProvider.getPkgMgr().reloadPackageInfo(repositoryURL, true);
                            for (ExtensionInformation repo : PackageManagerMainWindow.this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
                                if (repo.getError() == null) continue;
                                UMException e = (UMException)repo.getError();
                                if (e.getAdditionalMessage() != null) {
                                    CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Extra Repository Settings", e.getMessage() + "\n" + e.getAdditionalMessage(), CustomMessageDialog.DialogType.ERROR, true);
                                    continue;
                                }
                                CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Extra Repository Settings", e.getMessage(), CustomMessageDialog.DialogType.ERROR, true);
                            }
                            PackageManagerMainWindow.this.contentProvider.getCompMgr().init();
                        }
                        catch (UMException e1) {
                            logger.throwing(e1);
                        }
                        final SelfUpdater selfupdater = new SelfUpdater(PackageManagerMainWindow.this.contentProvider);
                        if (selfupdater.canManagerUpdate()) {
                            shell.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        int ret = CustomMessageDialog.showDlg(new Shell(Display.getDefault(), 16384), "Confirm to update Package Manager", "A new version of the Package Manager is available.\nDo you want to update now?", CustomMessageDialog.DialogType.CONFIRM, false);
                                        if (ret == 64) {
                                            try {
                                                selfupdater.updateManager(null);
                                                shell.dispose();
                                            }
                                            catch (Throwable e) {
                                                logger.throwing(e);
                                                logger.trace("\tSelf-Update failed.");
                                            }
                                        } else {
                                            logger.trace("\tPackage Manager was updatable itself but user did not want it.");
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.throwing(e);
                                    }
                                }
                            });
                        }
                        monitor.subTask("Initialize contents.");
                        try {
                            PackageManagerMainWindow.this.contentProvider.getInstController().checkAndInstallUntouchablePackage();
                        }
                        catch (Exception e) {
                            logger.throwing(e);
                        }
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PackageManagerMainWindow.this.refreshWelcome();
                                }
                                catch (Exception e) {
                                    logger.throwing(e);
                                }
                            }
                        });
                    }
                    finally {
                        monitor.done();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.throwing(e);
        }
        logger.info("Window refresh end");
    }

    private void checkExtRepository() {
        this.contentProvider.getPkgMgr().resetExtensionPackages();
        for (ExtensionInformation repo : this.contentProvider.getExtRepoMgr().getCurrentExtensions()) {
            if (!repo.getActivateStatus()) continue;
            try {
                repo.setError(null);
                this.contentProvider.getPkgMgr().addExtensionPackagesFromRepository(repo);
            }
            catch (UMException e) {
                logger.throwing(e);
                repo.setActivateStatus(false);
                repo.setError(e);
                CustomMessageDialog.showDlg(this.shell, "Extra Repository Settings", e.getMessage(), CustomMessageDialog.DialogType.ERROR, true);
            }
        }
        this.contentProvider.getExtRepoMgr().writeToFile();
    }

    public void topMenuButtonSetEnable(final boolean value) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PackageManagerMainWindow.this.buttonConfiguration.setEnabled(value);
            }
        });
    }

    public void setDisconnected(boolean isDisconnected) {
        this.disconnectLabel.setVisible(isDisconnected);
        this.disconnectImage.setVisible(isDisconnected);
    }

    public void tabRedraw(TabViewType selectedValue) {
        this.currentTabView = selectedValue;
        this.tab1.redraw();
        this.tab2.redraw();
        this.tab3.redraw();
    }

    public static enum TabViewType {
        MAIN,
        EXTEND,
        PROGRESS;

    }
}

