/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.maintab;

import java.util.ArrayList;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.tizen.manager.pkg.Component;
import org.tizen.packagemanager.ui.page.CommonTreeView;
import org.tizen.packagemanager.ui.page.custom.CustomTableImageAnimation;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ActionStatusColumnLabelProvider
extends OwnerDrawLabelProvider {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Color treeSelRowColor;
    private Color treeBackColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
    private Image progressStatusImageBG;
    private CustomTableImageAnimation progressStatusImage;
    private int columnWidth;

    public ActionStatusColumnLabelProvider(CommonTreeView parent, int columnWidth) {
        this.treeSelRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);
        this.columnWidth = columnWidth;
        ArrayList<Image> animatingImages = this.uiRsrcHandler.getAnimatingImages(WizardUIResourceHandler.UIAnimatingImage.WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_HALF_1);
        ArrayList<Image> animatingImages2 = this.uiRsrcHandler.getAnimatingImages(WizardUIResourceHandler.UIAnimatingImage.WIZARD_IMAGE_MANAGER_ANIMATION_PROGRESS_HALF_2);
        animatingImages.addAll(animatingImages2);
        this.progressStatusImage = new CustomTableImageAnimation(animatingImages, parent, 50L);
    }

    @Override
    protected void measure(Event arg0, Object arg1) {
    }

    @Override
    public void update(ViewerCell cell) {
        super.update(cell);
    }

    @Override
    protected void erase(Event event, Object element) {
        Color oldBackground = event.gc.getBackground();
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.treeSelRowColor);
            event.detail &= 0xFFFFFFFD;
        } else {
            event.gc.setBackground(this.treeBackColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void paint(Event event, Object element) {
        Component component = (Component)element;
        Image image = null;
        Image bg = null;
        if (!component.hasChildren()) {
            if (component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UNINSTALLING) {
                image = this.progressStatusImage.getImage();
                bg = this.progressStatusImageBG;
            }
        } else if (component.hasInstallingLeafDecendents() || component.hasUninstallingLeafDecendents()) {
            image = this.progressStatusImage.getImage();
            bg = this.progressStatusImageBG;
        }
        if (image != null) {
            int imgOffsetY = (event.getBounds().height - image.getBounds().height) / 2;
            int imgOffsetX = (this.columnWidth - image.getBounds().width) / 2 - 1;
            if (bg != null) {
                event.gc.drawImage(bg, event.x + imgOffsetX, event.y + imgOffsetY);
            }
            event.gc.drawImage(image, event.x + imgOffsetX, event.y + imgOffsetY);
        }
    }
}

