/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class CustomProgressBar
extends Composite {
    private final int FILL_DRAW_REVISION = 0;
    private Rectangle progressBarRect;
    private Color progressBarColor;
    private Color textOverColor;
    private Font textFont;
    private int space;
    private Composite bufferedComposite;
    int percent;
    WizardUIResourceHandler uiRsrcHandler;

    public CustomProgressBar(Composite parent, WizardUIResourceHandler uiRsrcHandler) {
        super(parent, 262144);
        this.uiRsrcHandler = uiRsrcHandler;
        this.progressBarColor = parent.getDisplay().getSystemColor(9);
        this.textOverColor = parent.getDisplay().getSystemColor(2);
        this.textFont = parent.getDisplay().getSystemFont();
        this.space = 0;
        this.bufferedComposite = this;
        this.progressBarRect = null;
        this.initEventHandler();
    }

    public void setBound(Rectangle rect) {
        this.progressBarRect = rect;
    }

    public void setProgressBarColor(Color color) {
        this.progressBarColor = color;
    }

    public void setTextColor(Color textNormalColor, Color textOverColor) {
        this.textOverColor = textOverColor;
    }

    @Override
    public void setFont(Font font) {
        this.textFont = font;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public void setProgress(int percent) {
        this.percent = percent * 10;
        this.redraw();
    }

    public void clean() {
        this.setProgress(0);
        this.redraw();
    }

    private void initEventHandler() {
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                CustomProgressBar.this.onPaint(e);
            }
        });
    }

    private void onPaint(PaintEvent e) {
        Image bufferedImage = new Image((Device)this.bufferedComposite.getDisplay(), this.bufferedComposite.getBounds());
        GC gc = new GC(bufferedImage);
        gc.setAntialias(1);
        Rectangle containerBounds = this.bufferedComposite.getBounds();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, containerBounds.width, containerBounds.height);
        Rectangle rect = null;
        rect = this.progressBarRect == null ? new Rectangle(0, 0, containerBounds.width, containerBounds.height) : this.progressBarRect;
        gc.setBackground(this.progressBarColor);
        int barRatio = rect.width * this.percent / 1000;
        if (barRatio > 0) {
            int barX = rect.x + 0 + this.space;
            int barY = rect.y + 0 + this.space;
            int barW = barRatio - this.space * 2 - 0;
            int barH = rect.height - this.space * 2 - 0;
            gc.fillRectangle(barX, barY, barW, barH);
            String text = this.percent / 10 + "%";
            Point size = e.gc.textExtent(text);
            int y_offset = Math.max(0, (rect.height - size.y) / 2);
            int textY = rect.y + y_offset;
            Rectangle topProgressBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_TOP_PROGRESS_STRING);
            int textX = barRatio - size.x - topProgressBounds.x;
            Color textColor = this.textOverColor;
            if (textX > 0) {
                gc.setForeground(textColor);
                gc.setFont(this.textFont);
                gc.drawText(text, textX, textY, true);
            }
        }
        e.gc.drawImage(bufferedImage, 0, 0);
        bufferedImage.dispose();
        gc.dispose();
    }
}

