/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tizen.library.sdkutils.cli.common.Option;

public class Options {
    private Map<String, Option> options = new LinkedHashMap<String, Option>();

    public void addOption(String option, boolean hasArg, String argName, String description) {
        this.options.put(option, new Option(option, hasArg, argName, description));
    }

    public void addOption(String option, boolean hasArg, String argName, String description, boolean required) {
        this.options.put(option, new Option(null, option, hasArg, argName, description, required));
    }

    public void addOption(String shortOpt, String option, boolean hasArg, String argName, String description) {
        this.options.put(option, new Option(shortOpt, option, hasArg, argName, description));
    }

    public void addOption(String shortOpt, String option, boolean hasArg, String argName, String description, boolean required) {
        this.options.put(option, new Option(shortOpt, option, hasArg, argName, description, required));
    }

    public void addOption(Option option, String argValue) {
        this.options.put(option.getOption(), new Option(option, argValue));
    }

    public List<Option> getOptions() {
        return new ArrayList<Option>(this.options.values());
    }

    public Option getOption(String option) {
        Option opt = this.options.get(option);
        if (opt != null) {
            return new Option(opt);
        }
        return null;
    }

    public boolean hasOption() {
        return !this.options.isEmpty();
    }

    public boolean containsOption(String option) {
        return this.options.containsKey(option);
    }

    public boolean containsOption(Option option) {
        return this.options.containsKey(option.getOption());
    }
}

