/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli;

import java.util.Map;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.api.ISDKUtils;
import org.tizen.library.sdkutils.api.impl.SDKPackage;
import org.tizen.library.sdkutils.api.impl.SDKUtils;
import org.tizen.library.sdkutils.cli.CLIMain;
import org.tizen.library.sdkutils.cli.common.Command;
import org.tizen.library.sdkutils.cli.common.CommandLine;
import org.tizen.library.sdkutils.cli.common.Option;
import org.tizen.library.sdkutils.service.ExecutorService;

public class CLICommandExecutor {
    public void execute(CommandLine cmdLine) throws Exception {
        Command command = cmdLine.getCommand();
        if (command.getCommand().equals("--help")) {
            if (command.hasRunOptions()) {
                if (command.getRunOptions().containsOption("show-package")) {
                    CLIMain.COMMANDS.getCommands().printCommendHelp("show-package");
                } else if (command.getRunOptions().containsOption("show-packages")) {
                    CLIMain.COMMANDS.getCommands().printCommendHelp("show-packages");
                }
            } else {
                CLIMain.COMMANDS.getCommands().printHelp();
            }
        } else if (command.getCommand().equals("show-sdk-path")) {
            this.doInstalledPath();
        } else if (command.getCommand().equals("show-sdkdata-path")) {
            this.doDataPath();
        } else if (command.getCommand().equals("show-sdk-version")) {
            this.doVersion();
        } else if (command.getCommand().equals("show-tool-path")) {
            String toolName = null;
            for (Option option : command.getRunOptions().getOptions()) {
                if (!option.getOption().equals("--tool")) continue;
                toolName = option.getArgValue();
            }
            this.doToolPath(toolName);
        } else if (command.getCommand().equals("show-package")) {
            String pkgName = null;
            boolean useCache = false;
            for (Option option : command.getRunOptions().getOptions()) {
                if (option.getOption().equals("--pkg-name")) {
                    pkgName = option.getArgValue();
                    continue;
                }
                if (!option.getOption().equals("--cache")) continue;
                useCache = true;
            }
            this.doShowPackage(pkgName, useCache);
        } else if (command.getCommand().equals("show-packages")) {
            SDKPackage sdkPkg = new SDKPackage();
            this.initSDKPackage(sdkPkg);
            boolean useCache = false;
            ISDKPackage.SearchPackageType pkgType = null;
            for (Option option : command.getRunOptions().getOptions()) {
                if (option.getOption() == "--profile") {
                    sdkPkg.setProfile(ISDKPackage.Profile.getProfile(option.getArgValue()));
                    continue;
                }
                if (option.getOption().equals("--version")) {
                    sdkPkg.setPlatformVersion(ISDKPackage.PlatformVersion.getPlatformVersion(option.getArgValue()));
                    continue;
                }
                if (option.getOption().equals("--ext-type")) {
                    sdkPkg.setExtension(ISDKPackage.Extension.getExtension(option.getArgValue()));
                    continue;
                }
                if (option.getOption().equals("--pkg-type")) {
                    pkgType = ISDKPackage.SearchPackageType.getSearchPkgType(option.getArgValue());
                    continue;
                }
                if (option.getOption().equals("--install-only")) {
                    sdkPkg.setInstalled(true);
                    continue;
                }
                if (!option.getOption().equals("--cache")) continue;
                useCache = true;
            }
            this.doShowPackages(sdkPkg.getProfile(), sdkPkg.getPlatformVersion(), sdkPkg.getExtName(), pkgType, sdkPkg.isInstalled(), useCache);
        } else if (command.getCommand().equals("execute")) {
            String toolName = null;
            for (Option option : command.getRunOptions().getOptions()) {
                if (!option.getOption().equals("--tool")) continue;
                toolName = option.getArgValue();
            }
            this.doRunSDKTools(toolName);
        } else if (command.getCommand().equals("version")) {
            this.showVersion();
        } else if (command.getCommand().equals("create-cache")) {
            this.doCreateCache();
        } else if (command.getCommand().equals("show-autoupdate")) {
            this.showAutoUpdate();
        } else if (command.getCommand().equals("set-autoupdate")) {
            String value = null;
            for (Option option : command.getRunOptions().getOptions()) {
                if (!option.getOption().equals("--value")) continue;
                value = option.getArgValue();
            }
            this.setAutoUpdate(value);
        }
    }

    public void doIsUpdatable(boolean useCache) {
        boolean isUpdatable = SDKUtils.getInstance().isUpdatable(useCache);
        System.out.println("Updatable: " + isUpdatable);
    }

    public void doShowPackage(String pkgName, boolean useCache) {
        Map<String, ISDKPackage> pkgMap = SDKUtils.getInstance().getPackages(pkgName, useCache);
        if (pkgMap != null) {
            for (Map.Entry<String, ISDKPackage> entry : pkgMap.entrySet()) {
                SDKPackage pkg = (SDKPackage)entry.getValue();
                System.out.println(pkg.getPackageInfoString());
            }
        } else {
            String errMsg = "No matching package found(" + pkgName + ")";
            throw new RuntimeException(errMsg);
        }
    }

    public void doShowPackages(ISDKPackage.Profile profile, ISDKPackage.PlatformVersion version, String extName, ISDKPackage.SearchPackageType searchPkgType, boolean installedOnly, boolean useCache) {
        Map<String, ISDKPackage> pkgMap = SDKUtils.getInstance().getPackages(profile, version, extName, searchPkgType, installedOnly, useCache);
        if (pkgMap != null) {
            System.out.println(String.format("%-7s %-45s %-10s %s", "Status", "Package Name", "Version", "Label"));
            for (Map.Entry<String, ISDKPackage> entry : pkgMap.entrySet()) {
                SDKPackage pkg = (SDKPackage)entry.getValue();
                System.out.println(String.format("%-7s %-45s %-10s %s", pkg.getStatus(), pkg.getName(), pkg.getVersion(), pkg.getLabel()));
            }
        } else {
            throw new RuntimeException("There are no results that match your search");
        }
    }

    public void doRunSDKTools(String tool) {
        ISDKUtils.SdkTool sdkTool = ISDKUtils.SdkTool.getSdkTool(tool);
        if (sdkTool == null) {
            throw new RuntimeException("No matching sdk tool found");
        }
        ISDKUtils.ExecuteResult ret = SDKUtils.getInstance().executeSDKTools(sdkTool);
        if (!ISDKUtils.ExecuteResult.SUCCESS.equals((Object)ret)) {
            if (ISDKUtils.ExecuteResult.NOT_INSTALLED.equals((Object)ret)) {
                String errMsg = String.format("This %s is not installed.", sdkTool.toString());
                throw new RuntimeException(errMsg);
            }
            String errMsg = String.format("The %s has faild to start.", sdkTool.toString());
            throw new RuntimeException(errMsg);
        }
        System.out.printf("Run the %s.", sdkTool.toString());
    }

    public void doInstalledPath() {
        String path = SDKUtils.getInstance().getInstalledSDKPath();
        if (path == null) {
            throw new RuntimeException("Fail to get Tizen SDK installed path.");
        }
        System.out.println(path);
    }

    public void doDataPath() {
        String path = SDKUtils.getInstance().getInstalledSDKDataPath();
        if (path == null) {
            throw new RuntimeException("Fail to get Tizen SDK Data path.");
        }
        System.out.println(path);
    }

    public void doVersion() {
        String version = SDKUtils.getInstance().getSDKVersion();
        if (version == null) {
            throw new RuntimeException("Fail to get Tizen SDK version.");
        }
        System.out.println(version);
    }

    public void doToolPath(String tool) {
        ISDKUtils.SdkTool sdkTool = ISDKUtils.SdkTool.getSdkTool(tool);
        if (sdkTool == null) {
            throw new RuntimeException("No matching sdk tool found");
        }
        String toolPath = ExecutorService.getSDKToolPath(sdkTool);
        if (toolPath == null) {
            String errMsg = String.format("This %s is not installed.", sdkTool.toString());
            throw new RuntimeException(errMsg);
        }
        System.out.println(toolPath);
    }

    public void doCreateCache() {
        Map<String, ISDKPackage> pkgMap = SDKUtils.getInstance().getPackages("sdk-utils", true);
        if (pkgMap == null) {
            throw new RuntimeException("Fail to create cache-file.");
        }
    }

    private void initSDKPackage(SDKPackage pkg) {
        pkg.setProfile(null);
        pkg.setPlatformVersion(null);
        pkg.setExtension(null);
        pkg.setType(null);
    }

    private void showVersion() {
        System.out.println("SDK-Utils (0.1.35)");
    }

    private void showAutoUpdate() {
        boolean isAutoUpdate = SDKUtils.getInstance().isAutoUpdate();
        System.out.println(isAutoUpdate);
    }

    private void setAutoUpdate(String isAutoUpdateStr) {
        boolean ret = true;
        if (isAutoUpdateStr != null && isAutoUpdateStr.equalsIgnoreCase("true")) {
            ret = SDKUtils.getInstance().setAutoUpdate(true);
        } else if (isAutoUpdateStr != null && isAutoUpdateStr.equalsIgnoreCase("false")) {
            ret = SDKUtils.getInstance().setAutoUpdate(false);
        } else {
            throw new RuntimeException("Fail to get argument. Please check argument(e.g. true or false).");
        }
        if (!ret) {
            throw new RuntimeException("Fail to set autoupdate.");
        }
        System.out.println(String.format("Success to set autoupdate(%s).", isAutoUpdateStr));
    }
}

