/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.packagemanager.ui.page.CommonTreeView;

public class CustomTableImageAnimation {
    private static final int CHECK_LAST_TICK = 1000;
    private ArrayList<Image> images = new ArrayList();
    private long startTime = System.currentTimeMillis();
    private long lastTickTime;
    private long period = 100L;
    private Thread animateThread = null;
    private Composite parentView = null;

    public CustomTableImageAnimation(ArrayList<Image> images, Composite parent) {
        this.images = images;
        this.parentView = parent;
    }

    public CustomTableImageAnimation(ArrayList<Image> images, Composite parent, long period) {
        this.images = images;
        this.parentView = parent;
        this.period = period;
    }

    public Image getImage() {
        this.lastTickTime = System.currentTimeMillis();
        int imageIndex = (int)((this.lastTickTime - this.startTime) / this.period) % this.images.size();
        if (this.animateThread == null) {
            this.animateThread = new Thread(){

                @Override
                public void run() {
                    while (System.currentTimeMillis() - CustomTableImageAnimation.this.lastTickTime <= 1000L) {
                        try {
                            Thread.sleep(CustomTableImageAnimation.this.period);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Display.getDefault() == null || Display.getDefault().isDisposed()) continue;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!Display.getDefault().isDisposed()) {
                                    if (CustomTableImageAnimation.this.parentView instanceof CommonTreeView) {
                                        ((CommonTreeView)CustomTableImageAnimation.this.parentView).getTree().redraw();
                                    } else {
                                        CustomTableImageAnimation.this.parentView.redraw();
                                    }
                                }
                            }
                        });
                    }
                    CustomTableImageAnimation.this.animateThread = null;
                }
            };
            this.animateThread.start();
        }
        return this.images.get(imageIndex);
    }
}

