/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.util.ArrayList;
import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.Install.ProcessQueueItem;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.ComponentManager;

public class InstallProcessQueue {
    ArrayList<ProcessQueueItem> processQueue = new ArrayList();

    public synchronized void addProcessQueue(ComponentManager compMgr, String componentName, ICommonProgressMonitor monitor) {
        Component component = compMgr.getComponentByName(componentName);
        this.processQueue.add(new ProcessQueueItem(componentName, component, monitor));
    }

    public synchronized void removeProcessQueue() {
        if (!this.processQueue.isEmpty()) {
            this.processQueue.remove(0);
        }
    }

    private synchronized ProcessQueueItem getFirstProcessQueueItem() {
        if (!this.processQueue.isEmpty()) {
            return this.processQueue.get(0);
        }
        return null;
    }

    private ProcessQueueItem getProcessQueueItem(String processKey) {
        for (ProcessQueueItem item : this.processQueue) {
            if (!item.getProcessKey().equals(processKey)) continue;
            return item;
        }
        return null;
    }

    private ProcessQueueItem getProcessQueueItemByMonitor(ICommonProgressMonitor monitor) {
        for (ProcessQueueItem item : this.processQueue) {
            if (item.getProcessMonitor() != monitor) continue;
            return item;
        }
        return null;
    }

    public void waitForProcessQueue(String processKey, ICommonProgressMonitor monitor) {
        while (!this.canFinishWaiting(processKey, monitor)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean canFinishWaiting(String processKey, ICommonProgressMonitor monitor) {
        ProcessQueueItem item = this.getProcessQueueItem(processKey);
        if (item != null) {
            item.setWaitingForQueue(true);
        }
        ProcessQueueItem firstItem = this.getFirstProcessQueueItem();
        if (item == null || firstItem == null) {
            return true;
        }
        if (monitor.isCanceled()) {
            return true;
        }
        if (firstItem.getProcessKey().equals(processKey)) {
            return monitor.getMonitorGroup() == null || monitor.getMonitorGroup().size() > 15 || this.areAllGroupComponentsWaiting(monitor);
        }
        return false;
    }

    private boolean areAllGroupComponentsWaiting(ICommonProgressMonitor monitor) {
        if (monitor.getMonitorGroup() != null) {
            for (ICommonProgressMonitor monitor1 : monitor.getMonitorGroup()) {
                ProcessQueueItem item = this.getProcessQueueItemByMonitor(monitor1);
                if (item == null || item.isWaitingForQueue()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized ArrayList<ICommonProgressMonitor> getDependentUninstallingProgressMonitors(ComponentManager compMgr, String selectedItemKey) {
        ArrayList<ICommonProgressMonitor> result = new ArrayList<ICommonProgressMonitor>();
        ArrayList<Component> depComps = compMgr.getDependentComponentsBySelectGroup(compMgr.getComponentByName(selectedItemKey));
        for (ProcessQueueItem item : this.processQueue) {
            if (item.getProcessComponent() == null || item.getProcessMonitor() == null || item.getProcessComponent().getInstallState() != Component.InstallState.UNINSTALLING || !depComps.contains(item.getProcessComponent())) continue;
            result.add(item.getProcessMonitor());
        }
        return result;
    }

    public synchronized ArrayList<ICommonProgressMonitor> getReverseDependentInstallingProgressMonitors(ComponentManager compMgr, ICommonProgressMonitor monitor) {
        ProcessQueueItem processItem = this.getProcessQueueItemByMonitor(monitor);
        if (processItem != null) {
            return this.getReverseDependentInstallingProgressMonitors(compMgr, processItem.getProcessKey());
        }
        return new ArrayList<ICommonProgressMonitor>();
    }

    public synchronized ArrayList<ICommonProgressMonitor> getReverseDependentInstallingProgressMonitors(ComponentManager compMgr, String selectedItemKey) {
        ArrayList<ICommonProgressMonitor> result = new ArrayList<ICommonProgressMonitor>();
        ArrayList<Component> revDepComps = compMgr.getReverseDependentComponentsBySelectGroup(compMgr.getComponentByName(selectedItemKey));
        for (ProcessQueueItem item : this.processQueue) {
            if (item.getProcessComponent() == null || item.getProcessMonitor() == null || item.getProcessComponent().getInstallState() != Component.InstallState.INSTALLING || !revDepComps.contains(item.getProcessComponent())) continue;
            result.add(item.getProcessMonitor());
        }
        return result;
    }

    public synchronized int getProcessCount() {
        return this.processQueue.size();
    }

    public synchronized String getProcessKeyByMonitor(ICommonProgressMonitor monitor) {
        ProcessQueueItem item = this.getProcessQueueItemByMonitor(monitor);
        if (item != null) {
            return item.getProcessKey();
        }
        return "null";
    }

    public synchronized String getProcessDisplayNameByMonitor(ICommonProgressMonitor monitor) {
        ProcessQueueItem item = this.getProcessQueueItemByMonitor(monitor);
        if (item != null) {
            return item.getProcessKey();
        }
        return "null";
    }
}

