/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.download;

import org.tizen.manager.core.ICommonProgressMonitor;
import org.tizen.manager.core.download.IDownloadPackageProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;

public class DownloadPackageProgressMonitor
implements IDownloadPackageProgressMonitor {
    private int downloadWorked = 0;
    private int extractWorked = 0;
    private boolean isStarted = false;
    private boolean isDone = false;
    private boolean isCanceled = false;
    private Exception error = null;
    private Package targetPackage = null;
    private ICommonProgressMonitor parentMonitor = null;

    public DownloadPackageProgressMonitor(Package pkg, ICommonProgressMonitor monitor) {
        this.targetPackage = pkg;
        this.parentMonitor = monitor;
    }

    @Override
    public void beginTask(String arg0) {
        this.isStarted = true;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean val) {
        this.setProgress("Requesting to cancel downloading/extracting...");
        this.isCanceled = val;
        if (!this.isStarted) {
            this.setError(new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, this.targetPackage.getPackageName()));
            this.done();
        }
    }

    @Override
    public void done() {
        this.isDone = true;
        if (this.getError() == null) {
            this.downloadWorked = 100;
            this.extractWorked = 100;
            this.setProgress("Downloading/extracting succeeded!");
        } else {
            this.setProgress("Downloading/extracting failed!");
        }
    }

    @Override
    public boolean getDone() {
        return this.isDone;
    }

    @Override
    public void downloadWorked(int percent) {
        this.downloadWorked = percent;
    }

    @Override
    public void extractWorked(int percent) {
        this.extractWorked = percent;
    }

    @Override
    public int getDownloadWorked() {
        return this.downloadWorked;
    }

    @Override
    public int getExtractWorked() {
        return this.extractWorked;
    }

    @Override
    public void setError(Exception err) {
        this.error = err;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setProgress(String message) {
    }
}

