/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.util.TextUtil;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class ComponentDetailView
extends Composite {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private final int MAX_TEXT_WIDTH = 570;
    private final int DETAIL_WIDTH_MARGIN = 5;
    private StyledText nameLabel = null;
    private StyledText descriptionText = null;
    private StyledText licenseTitleLabel = null;
    private StyledText licenseText = null;
    private String componentName = "";
    private String componentDescription = "";
    private String componentVersion = "";
    private String componentInstalledVersion = "";
    private String componentLicense = "";
    private ScrolledComposite scrolledComposite = null;
    private Font componentNameFont = null;
    private Font titleFont = null;
    private Font detailFont = null;
    private Color componentNameColor = null;
    private Color titleColor = null;
    private Color detailColor = null;
    private Color background_white = null;
    private Color background_title = null;

    ComponentDetailView(Composite parent, int style) {
        super(parent, style);
        this.init();
        this.setLayout(new FillLayout(768));
        this.createComposites();
    }

    private void init() {
        this.componentNameFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1);
        this.titleFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
        this.detailFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
        this.componentNameColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_46);
        this.titleColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58);
        this.detailColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77);
        this.background_white = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.background_title = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DEFAULT_BACKGROUND);
    }

    private void createComposites() {
        if (this.scrolledComposite != null) {
            this.scrolledComposite.dispose();
        }
        this.scrolledComposite = new ScrolledComposite(this, 528);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(this.background_white);
        Composite composite = new Composite(this.scrolledComposite, 0);
        composite.setBackground(this.background_white);
        composite.setLayout(new GridLayout(1, true));
        this.setRedraw(false);
        if (this.componentName.isEmpty()) {
            this.nameLabel = new StyledText(composite, 16384);
            this.nameLabel.setFont(this.detailFont);
            this.nameLabel.setForeground(this.detailColor);
            this.nameLabel.setText("To see the detailed package information, select any package on above tree view.");
            GridData gd = new GridData(4, 4, true, true);
            this.nameLabel.setLayoutData(gd);
            this.nameLabel.setBackground(this.background_white);
            this.nameLabel.setEditable(false);
            this.nameLabel.setEnabled(false);
            composite.setSize(composite.computeSize(-1, -1));
            this.scrolledComposite.setMinSize(composite.computeSize(-1, -1));
            this.setRedraw(true);
            this.layout();
            return;
        }
        this.createComponentNameComposite(composite);
        this.createDescriptionComposites(composite);
        this.createInformationComposites(composite);
        if (!this.componentLicense.isEmpty()) {
            this.createLicenseAgreementComposites(composite);
        }
        this.scrolledComposite.setContent(composite);
        composite.setSize(composite.computeSize(-1, -1));
        this.scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        composite.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                ComponentDetailView.this.scrolledComposite.setFocus();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
                ComponentDetailView.this.scrolledComposite.setFocus();
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        composite.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                ComponentDetailView.this.scrolledComposite.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                ComponentDetailView.this.scrolledComposite.setFocus();
            }
        });
        this.setRedraw(true);
        this.layout();
    }

    private void createComponentNameComposite(Composite composite) {
        Composite outerBox = new Composite(composite, 16384);
        outerBox.setBackground(this.background_white);
        GridData gd = new GridData(4, 0x1000000, true, false);
        outerBox.setLayoutData(gd);
        outerBox.setLayout(new GridLayout(1, false));
        this.nameLabel = new StyledText(outerBox, 16448);
        this.nameLabel.setFont(this.componentNameFont);
        this.nameLabel.setForeground(this.componentNameColor);
        this.nameLabel.setText(this.componentName);
        this.nameLabel.setBackground(this.background_white);
        this.nameLabel.setEditable(false);
        this.nameLabel.setEnabled(false);
        gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 1;
        gd.widthHint = 570;
        this.nameLabel.setLayoutData(gd);
    }

    private void createDescriptionComposites(Composite parent) {
        Composite outerBox = new Composite(parent, 16384);
        outerBox.setBackground(this.background_title);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        outerBox.setLayoutData(gd);
        outerBox.setLayout(new GridLayout(1, false));
        StyledText titleText = new StyledText(outerBox, 16384);
        titleText.setFont(this.titleFont);
        titleText.setForeground(this.titleColor);
        titleText.setText("Description");
        titleText.setEditable(false);
        titleText.setEnabled(false);
        titleText.setBackground(this.background_title);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        titleText.setLayoutData(gd);
        this.descriptionText = new StyledText(parent, 64);
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.widthHint = 553;
        this.descriptionText.setLayoutData(gd);
        this.descriptionText.setFont(this.detailFont);
        this.descriptionText.setForeground(this.detailColor);
        this.descriptionText.setText(this.componentDescription);
        this.descriptionText.setBackground(this.background_white);
        this.descriptionText.setEditable(false);
        this.descriptionText.setEnabled(false);
        this.descriptionText.setCaret(null);
    }

    private void createInformationComposites(Composite parent) {
        Composite outerBox = new Composite(parent, 16384);
        outerBox.setBackground(this.background_title);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        outerBox.setLayoutData(gd);
        outerBox.setLayout(new GridLayout(1, false));
        StyledText titleLabel = new StyledText(outerBox, 16384);
        titleLabel.setFont(this.titleFont);
        titleLabel.setForeground(this.titleColor);
        titleLabel.setText("Information");
        titleLabel.setEditable(false);
        titleLabel.setEnabled(false);
        titleLabel.setCaret(null);
        titleLabel.setBackground(this.background_title);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        titleLabel.setLayoutData(gd);
        Composite info = new Composite(parent, 0);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 5;
        info.setLayoutData(gd);
        info.setLayout(new GridLayout(2, false));
        info.setBackground(this.background_white);
        StyledText versionLabel = new StyledText(info, 16384);
        versionLabel.setFont(this.detailFont);
        versionLabel.setForeground(this.detailColor);
        versionLabel.setText("Version");
        versionLabel.setEditable(false);
        versionLabel.setEnabled(false);
        versionLabel.setCaret(null);
        gd = new GridData(16384, 0x1000000, false, false);
        gd.heightHint = 16;
        versionLabel.setLayoutData(gd);
        StyledText versionValLabel = new StyledText(info, 16384);
        versionValLabel.setFont(this.detailFont);
        versionValLabel.setForeground(this.detailColor);
        versionValLabel.setText(": " + this.componentVersion);
        versionValLabel.setEditable(false);
        versionValLabel.setEnabled(false);
        versionValLabel.setCaret(null);
        gd = new GridData(16384, 0x1000000, true, false);
        gd.heightHint = 16;
        versionValLabel.setLayoutData(gd);
        if (!this.componentInstalledVersion.isEmpty() && !this.componentVersion.equals(this.componentInstalledVersion)) {
            StyledText installedVerText = new StyledText(info, 16384);
            installedVerText.setFont(this.detailFont);
            installedVerText.setForeground(this.detailColor);
            installedVerText.setText("Installed Version");
            installedVerText.setEditable(false);
            installedVerText.setEnabled(false);
            installedVerText.setCaret(null);
            gd = new GridData(16384, 0x1000000, false, false);
            gd.heightHint = 16;
            installedVerText.setLayoutData(gd);
            StyledText installedVerValText = new StyledText(info, 16384);
            installedVerValText.setFont(this.detailFont);
            installedVerValText.setForeground(this.detailColor);
            installedVerValText.setText(": " + this.componentInstalledVersion);
            installedVerValText.setEditable(false);
            installedVerValText.setEnabled(false);
            installedVerValText.setCaret(null);
            gd = new GridData(16384, 0x1000000, true, false);
            gd.heightHint = 16;
            installedVerValText.setLayoutData(gd);
        }
    }

    private void createLicenseAgreementComposites(Composite parent) {
        Composite outerBox = new Composite(parent, 16384);
        outerBox.setBackground(this.background_white);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        outerBox.setLayoutData(gd);
        outerBox.setLayout(new GridLayout(1, false));
        this.licenseTitleLabel = new StyledText(outerBox, 16384);
        this.licenseTitleLabel.setFont(this.titleFont);
        this.licenseTitleLabel.setForeground(this.titleColor);
        this.licenseTitleLabel.setText("License Agreement");
        this.licenseTitleLabel.setEditable(false);
        this.licenseTitleLabel.setEnabled(false);
        this.licenseTitleLabel.setBackground(this.background_title);
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 23;
        this.licenseTitleLabel.setLayoutData(gd);
        this.licenseText = new StyledText(parent, 64);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 5;
        gd.widthHint = 570;
        this.licenseText.setLayoutData(gd);
        this.licenseText.setFont(this.detailFont);
        this.licenseText.setForeground(this.detailColor);
        this.licenseText.setText(TextUtil.getMultilinesText(this.componentLicense.trim(), this.licenseText, 565).trim());
        this.licenseText.setEditable(false);
        this.licenseText.setEnabled(false);
        this.licenseText.setCaret(null);
    }

    void updateComponentInformation(Component selectedItem) {
        if (selectedItem != null) {
            Package topPkg = selectedItem.getRootComponent().getRecentPackage();
            this.componentName = topPkg != null ? (!topPkg.getLabel().equals("") && !topPkg.getLabel().equals(selectedItem.getDisplayName()) ? selectedItem.getDisplayName() + " (" + topPkg.getLabel() + ")" : selectedItem.getDisplayName()) : selectedItem.getDisplayName();
            this.componentDescription = selectedItem.getRecentPackage().getDescription();
            this.componentVersion = selectedItem.getRecentPackage().getVersion().toString();
            this.componentInstalledVersion = selectedItem.getInstalledVersion();
            this.componentLicense = !selectedItem.hasChildren() ? selectedItem.getLicense() : "";
        } else {
            this.componentName = "";
        }
        this.createComposites();
    }
}

