/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.page.custom;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressTabImageButton
extends CustomImageButton {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private boolean showProgress = false;
    private final int ANIMATION_DELAY = 100;
    private Thread animateThread;
    private Display display = this.getDisplay();
    private ProgressTabImageButton thisButton = this;
    private ArrayList<Image> normalImages = this.uiRsrcHandler.getAnimatingImages(WizardUIResourceHandler.UIAnimatingImage.IMAGE_ANIMATION_BTN_TAB_PROGRESS_NORMAL);
    private ArrayList<Image> selectedImages = this.uiRsrcHandler.getAnimatingImages(WizardUIResourceHandler.UIAnimatingImage.IMAGE_ANIMATION_BTN_TAB_PROGRESS_SELECTED);
    private Image imgNormal = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_0_PROGRESS_NORMAL);
    private Image imgHover = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_0_PROGRESS_HOVER);
    private Image imgPush = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_0_PROGRESS_PUSH);
    private Image imgSelected = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_0_PROGRESS_SELECTED);
    private Image imgDisabled = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_0_PROGRESS_DISABLED);
    private Image imgProgressingNormal = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_PROGRESS_NORMAL);
    private Image imgProgressingHover = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_PROGRESS_HOVER);
    private Image imgProgressingPush = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_PROGRESS_PUSH);
    private Image imgProgressingSelected = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_PROGRESS_SELECTED);
    private Image imgProgressingDisabled = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_TAB_PROGRESS_DISABLED);
    private Color colorProgressText = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_PROGRESS_TAB_TEXT);
    private Font fontProgressText = this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_LARGE);
    private int currentProgress = 0;
    private boolean isDone = false;

    public ProgressTabImageButton(Composite parent, int style) {
        super(parent, style);
    }

    public void showProgress(boolean show) {
        if (show) {
            this.showProgress = true;
            this.currentProgress = 0;
            this.isDone = false;
            this.setImage(this.imgProgressingNormal, this.imgProgressingHover, this.imgProgressingPush, this.imgProgressingSelected, this.imgProgressingDisabled);
            this.createAnimatingThread();
        } else {
            this.showProgress = false;
            this.setImage(this.imgNormal, this.imgHover, this.imgPush, this.imgSelected, this.imgDisabled);
        }
        this.thisButton.redraw();
    }

    private void createAnimatingThread() {
        if (this.animateThread == null) {
            this.animateThread = new Thread(){

                @Override
                public void run() {
                    while (!ProgressTabImageButton.this.isDone) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (ProgressTabImageButton.this.display != null && !ProgressTabImageButton.this.display.isDisposed()) {
                            long currentTime = System.currentTimeMillis();
                            int imageIndex = (int)(currentTime / 100L % (long)ProgressTabImageButton.this.normalImages.size());
                            ProgressTabImageButton.this.hoverImage = ProgressTabImageButton.this.normalImage = (Image)ProgressTabImageButton.this.normalImages.get(imageIndex);
                            ProgressTabImageButton.this.pushImage = ProgressTabImageButton.this.normalImage;
                            ProgressTabImageButton.this.selectImage = (Image)ProgressTabImageButton.this.selectedImages.get(imageIndex);
                            ProgressTabImageButton.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressTabImageButton.this.thisButton.redraw();
                                }
                            });
                            if (ProgressTabImageButton.this.currentProgress < 100) continue;
                            break;
                        }
                        ProgressTabImageButton.this.isDone = true;
                    }
                    ProgressTabImageButton.this.animateThread = null;
                }
            };
            this.animateThread.start();
        }
    }

    @Override
    protected void onPaintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.displayImage == null) {
            return;
        }
        if (!this.showProgress) {
            this.setImage(this.imgNormal, this.imgHover, this.imgPush, this.imgSelected, this.imgDisabled);
        }
        this.displayImage = this.getSelection() ? this.selectImage : this.normalImage;
        gc.drawImage(this.displayImage, 0, 0, this.displayImage.getImageData().width, this.displayImage.getImageData().height, 0, 0, this.displayImage.getImageData().width, this.displayImage.getImageData().height);
        if (this.showProgress) {
            gc.setFont(this.fontProgressText);
            String progressPercent = String.format("%d%%", this.currentProgress);
            int textOffsetY = (e.height - gc.textExtent((String)progressPercent).y) / 2;
            int textOffsetX = 130 - gc.textExtent((String)progressPercent).x;
            gc.setForeground(this.colorProgressText);
            gc.drawText(progressPercent, textOffsetX, textOffsetY, true);
        }
    }

    public void setProgress(int currentPercent) {
        this.currentProgress = currentPercent;
        this.thisButton.redraw();
    }
}

