/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class SnapshotChangeLogDialog
extends Dialog {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private String DIALOG_TITLE = null;
    private String snapshotLog = "";
    private StyledText displayLogText;

    protected SnapshotChangeLogDialog(Shell parentShell, String log, String snapshot) {
        super(parentShell);
        this.snapshotLog = log;
        this.DIALOG_TITLE = snapshot + " information.";
        this.setShellStyle(67632);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout(16);
        container.setLayout(layout);
        container.getShell().setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        container.setLayout(new GridLayout(1, true));
        this.setTitle();
        this.setDisplayLogText(container);
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        Button okBtn = this.createButton(parent, 0, "OK", true);
        okBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
    }

    private void setTitle() {
        this.getShell().setText(this.DIALOG_TITLE);
    }

    private void setDisplayLogText(Composite composite) {
        if (this.displayLogText == null) {
            this.displayLogText = new StyledText(composite, 74);
            this.displayLogText.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            this.displayLogText.setText("");
            GridData gd = new GridData(4, 1, true, true);
            gd.heightHint = 400;
            gd.widthHint = 300;
            this.displayLogText.setLayoutData(gd);
        }
        this.displayLogText.setText(this.snapshotLog);
        this.displayLogText.setTextLimit(20);
        this.displayLogText.setEnabled(true);
        this.displayLogText.setEditable(false);
    }
}

