/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.core.Install.PackageUninstaller;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.util.Log;

public class ManagerableUninstallerCallable
implements Callable<Boolean> {
    private Package pkg;
    private IInstallUninstallPackageProgressMonitor monitor;
    private Logger logger;
    private ContentProvider contentProvier;

    public ManagerableUninstallerCallable(ContentProvider contentProvier, Package pkg, IInstallUninstallPackageProgressMonitor monitor) {
        this.contentProvier = contentProvier;
        this.pkg = pkg;
        this.monitor = monitor;
        this.logger = Log.getLogger(ManagerableUninstallerCallable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        PackageManager packageManager = this.contentProvier.getPkgMgr();
        Boolean bResult = false;
        try {
            if (packageManager.isInstalledPackage(this.pkg)) {
                PackageUninstaller pu = new PackageUninstaller(this.contentProvier);
                this.monitor.setProgress("Start to uninstall.");
                bResult = pu.uninstall(this.pkg, this.monitor);
            } else {
                bResult = true;
            }
            this.logger.trace(String.format("[%s] uninstall completed.", this.pkg));
        }
        catch (Exception e) {
            this.logger.throwing(e);
            this.monitor.setError(e);
        }
        finally {
            this.monitor.done();
        }
        return bResult;
    }
}

