/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.provider.progresstab;

import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.page.ProgressItem;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class ProgressColumnLabelProvider
extends OwnerDrawLabelProvider {
    private WizardUIResourceHandler uiRsrcHandler = WizardUIResourceHandler.getInstance();
    private Color installColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE);
    private Color uninstallColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE);
    private Color activeColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
    private Color barBgColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F5);
    private Color inactiveColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
    private Color progressNormalTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58);
    private Color progressOverTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
    private Color errorTextColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58);
    private Font percentTextFont = this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0);
    private Color selectBgColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_SKY_BLUE);

    public ProgressColumnLabelProvider(TableViewer parent) {
    }

    @Override
    protected void erase(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        TableItem item = (TableItem)event.item;
        Color oldBackground = event.gc.getBackground();
        if (progressItem.isActive()) {
            event.gc.setBackground(this.activeColor);
        } else {
            event.gc.setBackground(this.inactiveColor);
        }
        if ((event.detail & 2) != 0) {
            event.gc.setBackground(this.selectBgColor);
            event.detail &= 0xFFFFFFFD;
        }
        if (item != null && item.getData("isSelect") != null && ((Boolean)item.getData("isSelect")).booleanValue()) {
            event.gc.setBackground(this.selectBgColor);
        }
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        event.gc.setBackground(oldBackground);
        super.erase(event, element);
    }

    @Override
    protected void measure(Event event, Object element) {
    }

    @Override
    protected void paint(Event event, Object element) {
        ProgressItem progressItem = (ProgressItem)element;
        int percent = progressItem.getProgress();
        GC gc = event.gc;
        gc.setAntialias(1);
        Rectangle bounds = event.getBounds();
        Rectangle progressBounds = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_MANAGER_PROGRESS_MAIN_COLUMN_PROGRESS_PROGRESS);
        int additionalWitdh = 0;
        if (PlatformUtil.isLinux()) {
            additionalWitdh = progressBounds.x;
        } else if (PlatformUtil.isMacOS()) {
            additionalWitdh = progressBounds.y;
        }
        int heightCenter = (bounds.height - progressBounds.height) / 2;
        Rectangle barRect = new Rectangle(bounds.x, bounds.y + heightCenter, progressBounds.width + additionalWitdh, progressBounds.height);
        this.drawProgressBorder(gc, barRect, progressItem.isActive());
        Component component = progressItem.getComponent();
        if (component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.UNINSTALLING) {
            this.fillProgressBar(gc, progressItem, percent, barRect);
        } else if (component.getError() != null) {
            this.fillError(gc, progressItem, barRect);
        } else if (component.getInstallState() == Component.InstallState.INSTALL || component.getInstallState() == Component.InstallState.UNINSTALL || component.getInstallState() == Component.InstallState.UPDATE) {
            this.fillDone(gc, progressItem, barRect);
        }
    }

    private void drawProgressBorder(GC gc, Rectangle barRect, boolean isActive) {
        if (isActive) {
            gc.setBackground(this.activeColor);
        } else {
            gc.setBackground(this.inactiveColor);
        }
    }

    private void fillDone(GC gc, ProgressItem progressItem, Rectangle barRect) {
        String text = "";
        if (progressItem.getWorkType() == ProgressItem.WorkType.INSTALL) {
            text = "Installed";
        } else if (progressItem.getWorkType() == ProgressItem.WorkType.UPDATE) {
            text = "Updated";
        } else if (progressItem.getWorkType() == ProgressItem.WorkType.UNINSTALL) {
            text = "Removed";
        } else {
            Component component = progressItem.getComponent();
            if (component.getInstallState() == Component.InstallState.UNINSTALL) {
                text = "Installed or Updated";
            } else if (component.getInstallState() == Component.InstallState.INSTALL) {
                text = "Removed";
            }
        }
        gc.setBackground(this.barBgColor);
        gc.fillRectangle(barRect.x, barRect.y, barRect.width, barRect.height);
        gc.setForeground(this.progressNormalTextColor);
        gc.setFont(this.percentTextFont);
        Point size = gc.textExtent(text);
        int y_offset = Math.max(0, (barRect.height - size.y) / 2);
        int x_offset = Math.max(0, (barRect.width - size.x) / 2);
        gc.drawText(text, barRect.x + x_offset, barRect.y + y_offset - 1, true);
    }

    private void fillError(GC gc, ProgressItem progressItem, Rectangle barRect) {
        String text = "";
        Component component = progressItem.getComponent();
        if (this.isCanceled(progressItem)) {
            if (progressItem.getWorkType() == ProgressItem.WorkType.INSTALL) {
                text = "Installation canceled";
            } else if (progressItem.getWorkType() == ProgressItem.WorkType.UPDATE) {
                text = "Update canceled";
            } else if (progressItem.getWorkType() == ProgressItem.WorkType.UNINSTALL) {
                text = "Uninstallation canceled";
            } else if (component.getInstallState() == Component.InstallState.INSTALL) {
                text = "Installation canceled";
            } else if (component.getInstallState() == Component.InstallState.UPDATE) {
                text = "Update canceled";
            } else if (component.getInstallState() == Component.InstallState.UNINSTALL) {
                text = "Uninstallation canceled";
            }
        } else if (component.getError() != null) {
            if (progressItem.getWorkType() == ProgressItem.WorkType.INSTALL) {
                text = "Installation failed";
            } else if (progressItem.getWorkType() == ProgressItem.WorkType.UPDATE) {
                text = "Update failed";
            } else if (progressItem.getWorkType() == ProgressItem.WorkType.UNINSTALL) {
                text = "Uninstallation failed";
            } else if (component.getInstallState() == Component.InstallState.INSTALL) {
                text = "Installation failed";
            } else if (component.getInstallState() == Component.InstallState.UPDATE) {
                text = "Update failed";
            } else if (component.getInstallState() == Component.InstallState.UNINSTALL) {
                text = "Uninstallation failed";
            }
        }
        gc.setBackground(this.barBgColor);
        gc.fillRectangle(barRect.x, barRect.y, barRect.width, barRect.height);
        gc.setForeground(this.errorTextColor);
        gc.setFont(this.percentTextFont);
        Point size = gc.textExtent(text);
        int y_offset = Math.max(0, (barRect.height - size.y) / 2);
        int x_offset = Math.max(0, (barRect.width - size.x) / 2);
        gc.drawText(text, barRect.x + x_offset, barRect.y + y_offset - 1, true);
    }

    private boolean isCanceled(ProgressItem progressItem) {
        Component component = progressItem.getComponent();
        return component != null && component.getError() != null && component.getError() instanceof UMException && ((UMException)component.getError()).isCancelException();
    }

    private void fillProgressBar(GC gc, ProgressItem progressItem, int percent, Rectangle barRect) {
        Component component = progressItem.getComponent();
        String bgText = "";
        if (progressItem.getMonitor().isCanceled()) {
            if (!progressItem.getMonitor().isDone()) {
                bgText = "Canceling";
            }
        } else if (component.getInstallState() == Component.InstallState.INSTALLING) {
            bgText = "Installing";
        } else if (component.getInstallState() == Component.InstallState.UPDATING) {
            bgText = "Updating";
        } else if (component.getInstallState() == Component.InstallState.UNINSTALLING) {
            bgText = "Removing";
        } else if (progressItem.getWorkType() == ProgressItem.WorkType.INSTALL) {
            bgText = "Installing";
        } else if (progressItem.getWorkType() == ProgressItem.WorkType.UPDATE) {
            bgText = "Updating";
        } else if (progressItem.getWorkType() == ProgressItem.WorkType.UNINSTALL) {
            bgText = "Removing";
        } else if (component.getInstallState() == Component.InstallState.UNINSTALL) {
            bgText = "Installing or Updating";
        } else if (component.getInstallState() == Component.InstallState.INSTALL) {
            bgText = "Removing";
        }
        gc.setBackground(this.barBgColor);
        gc.fillRectangle(barRect.x, barRect.y, barRect.width, barRect.height);
        String text = percent + "%";
        int barRatio = (barRect.width - 1) * percent / 100;
        if (barRatio > 0) {
            gc.setBackground(this.barBgColor);
            gc.fillRectangle(barRect.x, barRect.y, barRect.width, barRect.height);
            if (component.getInstallState() == Component.InstallState.INSTALLING || component.getInstallState() == Component.InstallState.UPDATING || component.getInstallState() == Component.InstallState.UNINSTALL) {
                gc.setBackground(this.installColor);
            } else if (component.getInstallState() == Component.InstallState.UNINSTALLING || component.getInstallState() == Component.InstallState.INSTALL) {
                gc.setBackground(this.uninstallColor);
            } else {
                gc.setBackground(this.installColor);
            }
            if (!bgText.isEmpty()) {
                gc.setForeground(this.progressNormalTextColor);
                gc.setFont(this.percentTextFont);
                Point bgSize = gc.textExtent(bgText);
                int y_offset = Math.max(0, (barRect.height - bgSize.y) / 2);
                int x_offset = Math.max(0, (barRect.width - bgSize.x) / 2);
                gc.drawText(bgText, barRect.x + x_offset, barRect.y + y_offset - 1, true);
            }
            int barX = barRect.x;
            int barY = barRect.y;
            int barW = barRatio;
            int barH = barRect.height;
            gc.setAlpha(180);
            gc.fillRectangle(barX, barY, barW, barH);
            gc.setAlpha(255);
            Point size = gc.textExtent(text);
            int xoffset = Math.max(0, (barRect.width - size.x) / 2);
            int textX = barRect.x + xoffset;
            Color textColor = this.progressNormalTextColor;
            if (barX + barW > textX + size.x) {
                textColor = this.progressOverTextColor;
            }
            gc.setForeground(textColor);
            gc.setFont(this.percentTextFont);
        }
    }
}

