/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Display display;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n7 = OS.gtk_color_selection_dialog_new(byArray);
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (this.parent != null) {
            n6 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(n7, n6);
            int n8 = OS.gtk_window_get_icon_list(n6);
            if (n8 != 0) {
                OS.gtk_window_set_icon_list(n7, n8);
                OS.g_list_free(n8);
            }
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            n6 = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(n6, n7);
        }
        OS.gtk_window_set_modal(n7, true);
        GtkColorSelectionDialog gtkColorSelectionDialog = new GtkColorSelectionDialog();
        OS.memmove(gtkColorSelectionDialog, n7);
        GdkColor gdkColor = new GdkColor();
        if (this.rgb != null) {
            gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
        }
        OS.gtk_color_selection_set_has_palette(gtkColorSelectionDialog.colorsel, true);
        if (this.rgbs != null) {
            int n9 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
            n5 = 0;
            while (n5 < this.rgbs.length) {
                RGB rGB = this.rgbs[n5];
                if (rGB != null) {
                    gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                    gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                    gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                    OS.memmove(n9 + n5 * GdkColor.sizeof, gdkColor, GdkColor.sizeof);
                }
                ++n5;
            }
            n5 = OS.gtk_color_selection_palette_to_string(n9, this.rgbs.length);
            n4 = OS.strlen(n5);
            byArray = new byte[n4];
            OS.memmove(byArray, n5, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.g_free(n9);
            n3 = OS.gtk_settings_get_default();
            if (n3 != 0) {
                OS.gtk_settings_set_string_property(n3, OS.gtk_color_palette, byArray, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(n7)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        n5 = 0;
        n4 = 0;
        if ((this.style & 0x4000000) != 0) {
            n5 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n4 = OS.g_signal_add_emission_hook(n5, 0, display.emissionProc, n7, 0);
        }
        int n10 = OS.gtk_dialog_run(n7);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n5, n4);
        }
        if (OS.gtk_window_get_modal(n7)) {
            display.setModalDialog(dialog);
        }
        int n11 = n3 = n10 == -5 ? 1 : 0;
        if (n3 != 0) {
            OS.gtk_color_selection_get_current_color(gtkColorSelectionDialog.colorsel, gdkColor);
            n2 = gdkColor.red >> 8 & 0xFF;
            int n12 = gdkColor.green >> 8 & 0xFF;
            n = gdkColor.blue >> 8 & 0xFF;
            this.rgb = new RGB(n2, n12, n);
        }
        if ((n2 = OS.gtk_settings_get_default()) != 0) {
            int[] nArray = new int[1];
            OS.g_object_get(n2, OS.gtk_color_palette, nArray, 0);
            if (nArray[0] != 0) {
                n = OS.strlen(nArray[0]);
                byArray = new byte[n];
                OS.memmove(byArray, nArray[0], n);
                OS.g_free(nArray[0]);
                String[] stringArray = null;
                if (n > 0) {
                    String string = new String(Converter.mbcsToWcs(null, byArray));
                    stringArray = ColorDialog.splitString(string, ':');
                    n = stringArray.length;
                }
                this.rgbs = new RGB[n];
                int n13 = 0;
                while (n13 < n) {
                    String string = stringArray[n13];
                    byArray = Converter.wcsToMbcs(null, string, true);
                    OS.gdk_color_parse(byArray, gdkColor);
                    int n14 = gdkColor.red >> 8 & 0xFF;
                    int n15 = gdkColor.green >> 8 & 0xFF;
                    int n16 = gdkColor.blue >> 8 & 0xFF;
                    this.rgbs[n13] = new RGB(n14, n15, n16);
                    ++n13;
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n7);
        if (n3 == 0) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

