/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.configuration;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

class ExtRepoDetailView
extends Composite {
    private WizardUIResourceHandler uiRsrcHandler;
    private StyledText nameLabel = null;
    private StyledText vendorLabel = null;
    private StyledText urlLabel = null;
    private StyledText descriptionText = null;
    private String repoName = "";
    private String repoDescription = "";
    private String repoVendor = "";
    private String repoURL = "";
    private ScrolledComposite scrolledComposite = null;
    private Composite infoComposite = null;
    private Composite parent = null;
    private ExtRepositoryManager extRepoMgr;

    ExtRepoDetailView(ExtRepositoryManager extRepoMgr, Composite parent, int style) {
        super(parent, style);
        this.extRepoMgr = extRepoMgr;
        this.parent = parent;
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.setLayout(new FillLayout(768));
        this.createComposites();
    }

    private void createComposites() {
        if (this.scrolledComposite != null) {
            this.scrolledComposite.dispose();
        }
        this.scrolledComposite = new ScrolledComposite(this, 528);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.infoComposite = new Composite(this.scrolledComposite, 0);
        this.infoComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_MARGIN);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = rect.height;
        gridLayout.marginWidth = rect.width;
        this.infoComposite.setLayout(gridLayout);
        this.setRedraw(false);
        this.createNameComposite(this.infoComposite);
        this.createVendorComposite(this.infoComposite);
        this.createURLComposite(this.infoComposite);
        this.createDescriptionComposites(this.infoComposite);
        this.scrolledComposite.setContent(this.infoComposite);
        this.infoComposite.setSize(this.infoComposite.computeSize(-1, -1));
        this.scrolledComposite.setMinSize(this.infoComposite.computeSize(-1, -1));
        this.setRedraw(true);
        this.layout();
        this.infoComposite.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                ExtRepoDetailView.this.scrolledComposite.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
                ExtRepoDetailView.this.parent.getParent().setFocus();
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                ExtRepoDetailView.this.scrolledComposite.setFocus();
            }
        });
    }

    private void createNameComposite(Composite composite) {
        Label titleLabel = new Label(composite, 16384);
        titleLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        titleLabel.setText(" Name");
        titleLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 0x1000000, true, false);
        titleLabel.setLayoutData(gd);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_TEXT);
        this.nameLabel = new StyledText(composite, 16448);
        this.nameLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.nameLabel.setText(this.repoName);
        this.nameLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.nameLabel.setEditable(false);
        this.nameLabel.setEnabled(false);
        gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 5;
        gd.widthHint = rect.width;
        this.nameLabel.setLayoutData(gd);
    }

    private void createVendorComposite(Composite composite) {
        Label titleLabel = new Label(composite, 16384);
        titleLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        titleLabel.setText(" Vendor");
        titleLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 4, true, false);
        titleLabel.setLayoutData(gd);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_TEXT);
        this.vendorLabel = new StyledText(composite, 16448);
        this.vendorLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.vendorLabel.setText(this.repoVendor);
        this.vendorLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.vendorLabel.setEditable(false);
        this.vendorLabel.setEnabled(false);
        gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 5;
        gd.widthHint = rect.width;
        this.vendorLabel.setLayoutData(gd);
    }

    private void createURLComposite(Composite composite) {
        Label titleLabel = new Label(composite, 16384);
        titleLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        titleLabel.setText(" Repository URL");
        titleLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 0x1000000, true, false);
        titleLabel.setLayoutData(gd);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_TEXT);
        this.urlLabel = new StyledText(composite, 16448);
        this.urlLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.urlLabel.setText(this.repoURL);
        this.urlLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.urlLabel.setEditable(false);
        this.urlLabel.setEnabled(false);
        gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 5;
        gd.widthHint = rect.width;
        this.urlLabel.setLayoutData(gd);
    }

    private void createDescriptionComposites(Composite parent) {
        Label titleLabel = new Label(parent, 16384);
        titleLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        titleLabel.setText(" Description");
        titleLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData(4, 4, true, false);
        titleLabel.setLayoutData(gd);
        Rectangle rect = this.uiRsrcHandler.getRect(WizardUIResourceHandler.UISize.WIZARD_CONF_INSTALL_OPTION_EXT_INFO_BOX_TEXT);
        this.descriptionText = new StyledText(parent, 16448);
        this.descriptionText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.descriptionText.setText(this.repoDescription);
        this.descriptionText.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.descriptionText.setEditable(false);
        this.descriptionText.setEnabled(false);
        gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = 5;
        gd.widthHint = rect.width;
        this.descriptionText.setLayoutData(gd);
    }

    void updateRepositoryInformation(ExtensionInformation selectedItem) {
        if (selectedItem != null) {
            this.repoName = selectedItem.getName();
            this.repoVendor = selectedItem.getVendor();
            if (this.repoVendor == null) {
                this.repoVendor = "Unknown";
            }
            this.repoURL = this.extRepoMgr.isLocalFileExtRepo(selectedItem) ? "Local cached" : selectedItem.getRepository();
            this.repoDescription = selectedItem.getDescription();
            if (this.repoDescription == null) {
                this.repoDescription = "No description";
            }
        } else {
            this.repoName = "";
        }
        this.createComposites();
    }
}

