/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.util.PathUtil;

public class Log {
    private static final Date startTime = new Date();
    private static final String logfileNameHead = "tizen_manager";
    private static final String LOG_FILE_DIRECTORY = "install-log";
    private static Logger logger = null;
    private static Logger infoLogger = null;
    public static final String LOG_INDENT_TRACE = "\t";
    public static final String LOG_MARK_DEBUG_EXT = "\t[#EXT] ";

    public static void open() {
        Log.removeTooOldLogs();
        System.setProperty("installerLogFileName", PathUtil.get(Config.getManagerConfigHome(), LOG_FILE_DIRECTORY, "package-manager", "tizen_manager_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(startTime) + ".log"));
        logger = LogManager.getLogger(Log.class.getName());
        infoLogger = LogManager.getLogger("infoLoger");
    }

    private static void removeTooOldLogs() {
        File confDir = new File(PathUtil.get(Config.getManagerConfigHome(), LOG_FILE_DIRECTORY, "package-manager"));
        File[] logs = confDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().contains(Log.logfileNameHead);
            }
        });
        if (logs == null) {
            return;
        }
        Arrays.sort(logs, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                return arg0.compareTo(arg1);
            }
        });
        for (int i = 0; i < logs.length - 10; ++i) {
            if (logs[i].delete() || logger == null) continue;
            logger.error("Fail to delete file ==> " + logs[i]);
        }
    }

    public static void logTitle(String msg) {
        infoLogger.info("**********************  " + msg + "  **********************");
    }

    public static void logInfo(String msg) {
        infoLogger.info(msg);
    }

    public static Logger getLogger(Class<?> object) {
        if (logger == null) {
            Log.open();
        }
        return LogManager.getLogger(object.getName());
    }
}

