/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.pkg.Component;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.page.custom.CustomImageButton;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class LicenseAgreementDialog
extends Dialog {
    private static final int DIALOG_WIDTH = 550;
    private static final int TOP_HEIGHT = 60;
    private static final int MID_HEIGHT = 239;
    private WizardUIResourceHandler uiRsrcHandler;
    private Composite bottomComposites;
    private Composite topComposites;
    private Composite mainComposites;
    private Composite middleComposites;
    private int scrollCompWidthPad;
    private Composite[] licenseContainers;
    private Composite[] licenseTitleContainers;
    private StyledText[] licenseTitleText;
    private CustomImageButton[] licenseTitleButton;
    private StyledText[] licenseText;
    private boolean[] isFolded;
    private ScrolledComposite scrolledComposite;
    private Composite multiLicenseContainer;
    private String buttonText;
    Component component;
    ArrayList<Component> components;

    public LicenseAgreementDialog(Shell parentShell, Component component, int option) {
        super(parentShell);
        this.setShellStyle(67680);
        this.buttonText = option == 32 ? "OK" : "Accept";
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        LicenseAgreementDialog.setDefaultImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        this.component = component;
    }

    public LicenseAgreementDialog(Shell parentShell, ArrayList<Component> components, int option) {
        super(parentShell);
        this.setShellStyle(67680);
        this.buttonText = option == 32 ? "OK" : "Accept";
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        LicenseAgreementDialog.setDefaultImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
        this.components = components;
        this.component = components.get(0);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.mainComposites = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        this.mainComposites.setLayout(gridLayout);
        this.mainComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.scrollCompWidthPad = !PlatformUtil.isLinux() ? -15 : 0;
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 361;
        this.mainComposites.setLayoutData(gd);
        this.createTopComposites(this.mainComposites);
        this.createMiddleComposites(this.mainComposites);
        Label middleStroke = new Label(this.mainComposites, 0);
        GridData strokeGD = new GridData();
        strokeGD.widthHint = 550;
        strokeGD.heightHint = 1;
        middleStroke.setLayoutData(strokeGD);
        middleStroke.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_AA));
        this.createBottomComposites(this.mainComposites);
        return this.mainComposites;
    }

    private void createTopComposites(Composite parent) {
        String strTitle = "Software License Agreement";
        String strReview = "Please review and accept the license terms before installing or updating packages";
        this.topComposites = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 60;
        gd.verticalAlignment = 0x1000000;
        gd.verticalIndent = 1;
        this.topComposites.setLayoutData(gd);
        this.topComposites.setBackgroundMode(1);
        this.topComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.topComposites.setLayout(gridLayout);
        Label title = new Label(this.topComposites, 0);
        title.setText(strTitle);
        title.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        title.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData titleGD = new GridData();
        GC gc = new GC(title);
        Point textExt = gc.stringExtent(strTitle);
        gc.dispose();
        titleGD.widthHint = textExt.x;
        titleGD.horizontalIndent = 20;
        titleGD.verticalAlignment = 1024;
        titleGD.grabExcessVerticalSpace = true;
        title.setLayoutData(titleGD);
        Label review = new Label(this.topComposites, 0);
        review.setText(strReview);
        review.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        review.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        GridData reviewGD = new GridData();
        gc = new GC(review);
        textExt = gc.stringExtent(strReview);
        gc.dispose();
        reviewGD.widthHint = textExt.x;
        reviewGD.horizontalIndent = 20;
        reviewGD.verticalAlignment = 128;
        reviewGD.grabExcessVerticalSpace = true;
        review.setLayoutData(reviewGD);
    }

    private void createMiddleComposites(Composite parent) {
        boolean needRepack = false;
        if (this.middleComposites != null) {
            this.middleComposites.dispose();
            needRepack = true;
        }
        this.middleComposites = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 550;
        gd.heightHint = 239;
        this.middleComposites.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.middleComposites.setLayout(gridLayout);
        this.middleComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE_F8));
        if (this.components != null && this.components.size() >= 1) {
            this.createMultiLicenseContents(this.middleComposites);
        } else {
            this.createLicenseContents(this.middleComposites);
        }
        if (needRepack) {
            parent.layout();
        }
    }

    private void createBottomComposites(Composite parent) {
        this.bottomComposites = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 131072;
        this.bottomComposites.setLayoutData(gd);
        this.bottomComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout buttonLayout = new GridLayout(1, true);
        buttonLayout.marginRight = 20;
        this.bottomComposites.setLayout(buttonLayout);
        Button btnAccept = new Button(this.bottomComposites, 8);
        gd = new GridData();
        gd.widthHint = 90;
        gd.heightHint = 25;
        btnAccept.setLayoutData(gd);
        if (this.components != null && this.components.size() > 1) {
            btnAccept.setText("Accept All");
        } else {
            btnAccept.setText(this.buttonText);
        }
        btnAccept.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        btnAccept.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                LicenseAgreementDialog.this.okPressed();
            }
        });
    }

    private void createLicenseContentsOnRequest(int idx, Composite parent, MouseEvent e) {
        parent.setRedraw(false);
        if (this.isFolded[idx]) {
            this.isFolded[idx] = false;
            this.licenseText[idx] = new StyledText(this.licenseContainers[idx], 16448);
            this.licenseText[idx].setLeftMargin(5);
            this.licenseText[idx].setRightMargin(5);
            this.licenseText[idx].setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
            this.licenseText[idx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
            this.licenseText[idx].setEditable(false);
            this.licenseText[idx].setEnabled(false);
            this.licenseText[idx].setText(this.components.get(idx).getLicense());
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 455 + this.scrollCompWidthPad;
            this.licenseText[idx].setLayoutData(gd);
            this.licenseTitleButton[idx].setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_UP_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_UP_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_UP_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_UP_SEL));
        } else {
            this.licenseTitleButton[idx].setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_SEL));
            this.isFolded[idx] = true;
            this.licenseText[idx].dispose();
        }
        this.scrolledComposite.setContent(this.multiLicenseContainer);
        this.multiLicenseContainer.setSize(this.multiLicenseContainer.computeSize(-1, -1));
        this.scrolledComposite.setMinSize(this.multiLicenseContainer.computeSize(-1, -1));
        parent.setRedraw(true);
        parent.redraw();
    }

    private void createMultiLicenseContents(final Composite parent) {
        Composite outter = new Composite(parent, 2048);
        GridData gd = new GridData();
        gd.widthHint = 510;
        gd.heightHint = 199;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 20;
        outter.setLayoutData(gd);
        outter.setLayout(new FillLayout());
        outter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.scrolledComposite = new ScrolledComposite(outter, 512);
        gd = new GridData(4, 4, true, true);
        this.scrolledComposite.setLayoutData(gd);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        if (PlatformUtil.isWindows()) {
            this.scrolledComposite.setAlwaysShowScrollBars(true);
        }
        this.multiLicenseContainer = new Composite(this.scrolledComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 2;
        this.multiLicenseContainer.setLayout(gl);
        this.multiLicenseContainer.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        parent.setRedraw(false);
        final int numOfComponents = this.components.size();
        this.licenseContainers = new Composite[numOfComponents];
        this.licenseTitleContainers = new Composite[numOfComponents];
        this.licenseTitleText = new StyledText[numOfComponents];
        this.licenseTitleButton = new CustomImageButton[numOfComponents];
        this.licenseText = new StyledText[numOfComponents];
        this.isFolded = new boolean[numOfComponents];
        for (int i = 0; i < numOfComponents; ++i) {
            this.isFolded[i] = true;
        }
        for (int compIdx = 0; compIdx < numOfComponents; ++compIdx) {
            this.licenseContainers[compIdx] = new Composite(this.multiLicenseContainer, 2048);
            gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 460;
            this.licenseContainers[compIdx].setLayoutData(gd);
            this.licenseContainers[compIdx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
            gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginLeft = 20;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.licenseContainers[compIdx].setLayout(gl);
            this.licenseTitleContainers[compIdx] = new Composite(this.licenseContainers[compIdx], 0);
            gd = new GridData(4, 4, true, false);
            this.licenseTitleContainers[compIdx].setLayoutData(gd);
            this.licenseTitleContainers[compIdx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
            gl = new GridLayout(2, false);
            gl.marginLeft = 0;
            gl.marginRight = 0;
            gl.marginHeight = 0;
            this.licenseTitleContainers[compIdx].setLayout(gl);
            this.licenseTitleText[compIdx] = new StyledText(this.licenseTitleContainers[compIdx], 0);
            this.licenseTitleText[compIdx].setText(this.components.get(compIdx).getDisplayName() + " Software License Agreement");
            this.licenseTitleText[compIdx].setEditable(false);
            this.licenseTitleText[compIdx].setEnabled(false);
            this.licenseTitleText[compIdx].setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
            this.licenseTitleText[compIdx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
            GC gc = new GC(this.licenseTitleText[compIdx]);
            Point textExt = gc.textExtent(this.licenseTitleText[compIdx].getText());
            gc.dispose();
            this.licenseTitleText[compIdx].setTopMargin(24 - textExt.y / 2);
            this.licenseTitleText[compIdx].setBottomMargin(24 - textExt.y / 2);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            gd.horizontalAlignment = 16384;
            this.licenseTitleText[compIdx].setLayoutData(gd);
            this.licenseTitleButton[compIdx] = new CustomImageButton(this.licenseTitleContainers[compIdx], 0);
            this.licenseTitleButton[compIdx].setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_NOR), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_SEL), this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_ARROW_DOWN_SEL));
            this.licenseTitleButton[compIdx].setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
            gd = new GridData(0x1000008, 0x1000000, true, true);
            gd.widthHint = 15;
            gd.heightHint = 9;
            this.licenseTitleButton[compIdx].setLayoutData(gd);
            final int xIndex = compIdx;
            this.licenseTitleButton[compIdx].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseUp(MouseEvent e) {
                    for (int i = 0; i < LicenseAgreementDialog.this.licenseTitleContainers.length; ++i) {
                        if (!e.widget.equals(LicenseAgreementDialog.this.licenseTitleButton[i])) continue;
                        LicenseAgreementDialog.this.createLicenseContentsOnRequest(i, parent, e);
                    }
                    LicenseAgreementDialog.this.setScrolledFocus(numOfComponents, xIndex);
                }
            });
            this.licenseTitleContainers[compIdx].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                    for (int i = 0; i < LicenseAgreementDialog.this.licenseTitleContainers.length; ++i) {
                        if (!e.widget.equals(LicenseAgreementDialog.this.licenseTitleContainers[i])) continue;
                        LicenseAgreementDialog.this.createLicenseContentsOnRequest(i, parent, e);
                    }
                    LicenseAgreementDialog.this.setScrolledFocus(numOfComponents, xIndex);
                }
            });
        }
        this.scrolledComposite.setFocus();
        this.scrolledComposite.setContent(this.multiLicenseContainer);
        this.multiLicenseContainer.setSize(this.multiLicenseContainer.computeSize(-1, -1));
        this.scrolledComposite.setMinSize(this.multiLicenseContainer.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    private void setScrolledFocus(int numOfComponents, int xIndex) {
        Rectangle bounds;
        int y = 0;
        if (xIndex > 0) {
            bounds = this.licenseContainers[xIndex - 1].getBounds();
            y = bounds.y + bounds.height + 5;
        }
        bounds = this.licenseContainers[numOfComponents - 1].getBounds();
        this.scrolledComposite.setMinSize(bounds.width, bounds.y + bounds.height + 5);
        this.scrolledComposite.setOrigin(new Point(this.scrolledComposite.getOrigin().x, this.scrolledComposite.getOrigin().y + y));
    }

    private void createLicenseContents(Composite parent) {
        Composite outter = new Composite(parent, 2048);
        GridData gd = new GridData();
        gd.widthHint = 510;
        gd.heightHint = 199;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 20;
        outter.setLayoutData(gd);
        outter.setLayout(new FillLayout());
        outter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        ScrolledComposite scrolledComposite = new ScrolledComposite(outter, 512);
        gd = new GridData(4, 4, true, true);
        scrolledComposite.setLayoutData(gd);
        scrolledComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Composite container = new Composite(scrolledComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginLeft = 25;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        gl.marginHeight = 15;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        container.setLayout(gl);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        gd = new GridData(4, 4, true, true);
        container.setLayoutData(gd);
        parent.setRedraw(false);
        StyledText titleText = new StyledText(container, 16384);
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        titleText.setText(this.component.getDisplayName() + " Software License Agreement");
        titleText.setEditable(false);
        titleText.setEnabled(false);
        gd = new GridData(4, 0x1000000, true, false);
        titleText.setLayoutData(gd);
        ScrollBar sb = scrolledComposite.getVerticalBar();
        StyledText textLicense = new StyledText(container, 64);
        gd = new GridData();
        gd.verticalIndent = 10;
        gd.widthHint = 485 - sb.getSize().x - 5;
        textLicense.setLayoutData(gd);
        textLicense.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        textLicense.setEditable(false);
        textLicense.setEnabled(false);
        textLicense.setText(this.component.getLicense());
        textLicense.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        scrolledComposite.setFocus();
        scrolledComposite.setContent(container);
        container.setSize(container.computeSize(-1, -1));
        scrolledComposite.setMinSize(container.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Package Manager");
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

