/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.exception;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.ui.exception.TroubleColumnLabelProvider;
import org.tizen.packagemanager.ui.exception.TroubleSearchFilter;
import org.tizen.packagemanager.ui.exception.TroubleTableContentProvider;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class InsideTroubleShootingDialog
extends Dialog {
    private static final int SIZE_WIDTH = 380;
    private static final int SIZE_SINGLE = 370;
    private static final int SIZEN_SINGLE_ITEM = 300;
    private static final int COL_TROUBLE_WIDTH = 380;
    private WizardUIResourceHandler uiRsrcHandler;
    private StackLayout stackLayout;
    private Composite mainComposites;
    private Composite troubleShootingComposites;
    private StyledText textTroubleMessage;
    private StyledText textCauseMessage;
    private StyledText textActionMessage;
    private StyledText textLog;
    private Button btnBack;
    private Button btnClose;
    private Composite troubleListComposites;
    private Composite troubleResponseComposites;
    private Text textTroubleFilter;
    private TableViewer troubleTableViewer;
    private Color oddRowColor;
    private Color errorColor;
    private Image imgExpandedDetail;
    private Image imgCollapsedDetail;
    private Image imgBackButton;
    private Image warningIcon;
    private Exception exception = null;
    private ArrayList<ProgressLog> progressLogs = null;
    private ArrayList<ProgressLog.LogType> progressTypes = null;
    private boolean hasTroubleList = false;
    private Image imgSearchIcon;
    private boolean isRetry = false;
    private ErrorController.ErrorCode lastSelErrCode = null;
    boolean toggleDetail = false;
    private Label toggleImageLabel;
    private ScrolledComposite causeActionScrolledComposite;
    private Composite troubleListTableContainer;
    private Label detailLabel;

    public static void open(Shell parentShell) {
        new InsideTroubleShootingDialog(parentShell).open();
    }

    public static void open(Shell parentShell, Exception e) {
        new InsideTroubleShootingDialog(parentShell, e).open();
    }

    public static void open(Shell parentShell, Exception e, ArrayList<ProgressLog> logs) {
        new InsideTroubleShootingDialog(parentShell, e, logs).open();
    }

    public static int open(Shell parentShell, Exception e, boolean isRetry) {
        return new InsideTroubleShootingDialog(parentShell, e, isRetry).open();
    }

    private InsideTroubleShootingDialog(Shell parentShell) {
        super(parentShell);
        if (PlatformUtil.isWindows()) {
            this.setShellStyle(84064);
        } else {
            this.setShellStyle(67680);
        }
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.oddRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE);
        this.errorColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_ERROR_LOG);
        this.imgExpandedDetail = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_SEL);
        this.imgCollapsedDetail = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.WIZARD_IMAGE_MANAGER_CONFIG_EXT_ARROW_NORMAL);
        this.imgBackButton = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_BACK);
        this.imgSearchIcon = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_SEARCH);
        this.warningIcon = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.WIZARD_ICON_MANAGER_WARNING);
        this.hasTroubleList = true;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception) {
        this(parentShell);
        this.exception = exception;
        this.hasTroubleList = false;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception, boolean isRetry) {
        this(parentShell);
        this.exception = exception;
        this.hasTroubleList = false;
        this.isRetry = isRetry;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception, ArrayList<ProgressLog> logs) {
        this(parentShell, exception);
        this.progressLogs = logs;
        this.progressTypes = new ArrayList();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.mainComposites = (Composite)super.createDialogArea(parent);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.mainComposites.setLayout(this.stackLayout);
        this.mainComposites.setBackground(this.uiRsrcHandler.getBackGroundColor());
        if (this.exception != null) {
            this.createTroubleShootingComposites(this.mainComposites);
            this.stackLayout.topControl = this.troubleShootingComposites;
        }
        if (this.hasTroubleList) {
            this.createTroubleListComposites(this.mainComposites, this.lastSelErrCode);
            this.stackLayout.topControl = this.troubleListComposites;
        }
        return this.mainComposites;
    }

    private void createTroubleShootingComposites(Composite parent) {
        if (this.troubleShootingComposites != null) {
            this.troubleShootingComposites.dispose();
        }
        int style = 0;
        this.troubleShootingComposites = new Composite(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        this.troubleShootingComposites.setLayout(gridLayout);
        this.troubleShootingComposites.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite topContainer = new Composite(this.troubleShootingComposites, style);
        gridLayout = new GridLayout(2, false);
        topContainer.setLayout(gridLayout);
        topContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite detailContainer = new Composite(this.troubleShootingComposites, style);
        gridLayout = new GridLayout(2, false);
        detailContainer.setLayout(gridLayout);
        detailContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite midContainer = new Composite(this.troubleShootingComposites, style);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        midContainer.setLayout(gridLayout);
        midContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite spliterContainer = new Composite(this.troubleShootingComposites, style);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        spliterContainer.setLayout(gridLayout);
        spliterContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite bottomContainer = new Composite(this.troubleShootingComposites, style);
        gridLayout = new GridLayout(1, false);
        bottomContainer.setLayout(gridLayout);
        bottomContainer.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.createSingleMessageComposites(topContainer);
        if (this.progressLogs != null) {
            this.createDetailButton(detailContainer);
            this.createLogViewer(midContainer);
        }
        this.createSpliter(spliterContainer);
        this.createButtonComposites(bottomContainer);
    }

    private void createSpliter(Composite parent) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, true, true);
        gd.heightHint = 1;
        gd.widthHint = 380;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 0;
        lbl.setLayoutData(gd);
        lbl.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_AA));
    }

    private void createSingleMessageComposites(Composite parent) {
        this.troubleResponseComposites = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.troubleResponseComposites.setLayout(gridLayout);
        this.troubleResponseComposites.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gd = new GridData();
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 355;
        gd.heightHint = 145;
        this.troubleResponseComposites.setLayoutData(gd);
        if (this.exception != null) {
            Label lbl = new Label(this.troubleResponseComposites, 0);
            lbl.setImage(this.warningIcon);
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.widthHint = 28;
            lbl.setLayoutData(gd);
            lbl.setBackground(this.uiRsrcHandler.getBackGroundColor());
            Label textTroubleMessage = new Label(this.troubleResponseComposites, 0);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            textTroubleMessage.setLayoutData(gd);
            textTroubleMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
            textTroubleMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
            textTroubleMessage.setBackground(this.uiRsrcHandler.getBackGroundColor());
            textTroubleMessage.setText(this.exception.getMessage());
            Label dummy = new Label(this.troubleResponseComposites, 0);
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.widthHint = 28;
            dummy.setLayoutData(gd);
            dummy.setBackground(this.uiRsrcHandler.getBackGroundColor());
            this.createActionCauseContainer(this.troubleResponseComposites, this.exception.getMessage());
        }
    }

    private void createActionCauseContainer(Composite parent, String message) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        GridData gd = new GridData();
        gd.heightHint = 105;
        gd.widthHint = 300;
        scrolledComposite.setLayoutData(gd);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Composite container = new Composite(scrolledComposite, 0);
        gd = new GridData();
        gd.verticalIndent = 5;
        gd.verticalAlignment = 128;
        gd.heightHint = 105;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        container.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleResponseComposites.setFocus();
            }
        });
        container.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleResponseComposites.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleResponseComposites.setFocus();
            }
        });
        String actionMsg = this.getActionMessage(this.exception);
        this.createActionMessage(container, actionMsg);
        String causeMsg = this.getCauseMessage(this.exception);
        this.createCauseMessage(container, causeMsg);
        scrolledComposite.setContent(container);
        Point computeSize = container.computeSize(-1, -1);
        container.setSize(computeSize.x, computeSize.y + 10);
        scrolledComposite.setMinSize(computeSize.x, computeSize.y + 10);
        parent.setRedraw(true);
    }

    private void createCauseMessage(Composite container, String causeMsg) {
        Label titleText = new Label(container, 16384);
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        titleText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        titleText.setText("Cause");
        titleText.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gd = new GridData(4, 0x1000000, true, false);
        titleText.setLayoutData(gd);
        this.textCauseMessage = new StyledText(container, 64);
        gd = new GridData();
        gd.widthHint = 300;
        this.textCauseMessage.setLayoutData(gd);
        this.textCauseMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.textCauseMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.textCauseMessage.setEditable(false);
        this.textCauseMessage.setEnabled(false);
        this.textCauseMessage.setLineSpacing(16 - this.textCauseMessage.getLineHeight());
        this.textCauseMessage.setText(causeMsg);
        this.textCauseMessage.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void createActionMessage(Composite container, String actionMsg) {
        Label titleText = new Label(container, 16384);
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        titleText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
        titleText.setText("Action");
        titleText.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 16384;
        titleText.setLayoutData(gd);
        this.textActionMessage = new StyledText(container, 66);
        gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 16384;
        this.textActionMessage.setLayoutData(gd);
        this.textActionMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.textActionMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.textActionMessage.setEditable(false);
        this.textActionMessage.setEnabled(false);
        this.textActionMessage.setLineSpacing(16 - this.textActionMessage.getLineHeight());
        this.textActionMessage.setText(actionMsg);
        this.textActionMessage.setBackground(this.uiRsrcHandler.getBackGroundColor());
    }

    private void createMessageComposites(Composite parent) {
        this.troubleResponseComposites = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.verticalSpacing = 0;
        this.troubleResponseComposites.setLayout(gridLayout);
        this.troubleResponseComposites.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridData gd = new GridData();
        gd.verticalIndent = 10;
        gd.widthHint = 380;
        gd.heightHint = 188;
        this.troubleResponseComposites.setLayoutData(gd);
        if (this.exception != null) {
            this.createTroubleMessageArea(this.troubleResponseComposites, this.exception.getMessage());
            this.createCauseActionArea(this.troubleResponseComposites);
        }
    }

    private void createTroubleMessageArea(Composite parent, String message) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 380;
        gd.horizontalIndent = 10;
        gd.verticalAlignment = 0x1000000;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 5;
        container.setLayout(gridLayout);
        Label errorImageLabel = new Label(container, 0);
        gd = new GridData();
        gd.widthHint = 15;
        gd.verticalAlignment = 0x1000000;
        errorImageLabel.setLayoutData(gd);
        errorImageLabel.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_CAUTION));
        errorImageLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.textTroubleMessage = new StyledText(container, 16448);
        gd = new GridData();
        gd.widthHint = 335;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        this.textTroubleMessage.setLayoutData(gd);
        this.textTroubleMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.textTroubleMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.textTroubleMessage.setEditable(false);
        this.textTroubleMessage.setEnabled(false);
        this.textTroubleMessage.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.textTroubleMessage.setText(this.exception.getMessage());
    }

    private void createCauseActionArea(Composite parent) {
        String actionMsg;
        Composite outter = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 380;
        gd.heightHint = 158;
        outter.setLayoutData(gd);
        outter.setLayout(new FillLayout());
        outter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.causeActionScrolledComposite = new ScrolledComposite(outter, 512);
        gd = new GridData(4, 4, true, true);
        this.causeActionScrolledComposite.setLayoutData(gd);
        this.causeActionScrolledComposite.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Composite container = new Composite(this.causeActionScrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        parent.setRedraw(false);
        String causeMsg = this.getCauseMessage(this.exception);
        if (!causeMsg.isEmpty()) {
            this.createCauseMessageArea(container, causeMsg);
        }
        if (!(actionMsg = this.getActionMessage(this.exception)).isEmpty()) {
            this.createActionMessageArea(container, actionMsg);
        }
        this.causeActionScrolledComposite.setContent(container);
        Point computeSize = container.computeSize(-1, -1);
        container.setSize(computeSize.x, computeSize.y + 30);
        this.causeActionScrolledComposite.setMinSize(computeSize.x, computeSize.y + 30);
        parent.setRedraw(true);
        container.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.causeActionScrolledComposite.setFocus();
            }
        });
        container.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.causeActionScrolledComposite.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.causeActionScrolledComposite.setFocus();
            }
        });
    }

    private void createCauseMessageArea(Composite container, String causeMsg) {
        Composite titleOuter = new Composite(container, 0);
        titleOuter.setLayout(new GridLayout(1, false));
        titleOuter.setLayoutData(new GridData(4, 0x1000000, true, false));
        titleOuter.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Label titleText = new Label(titleOuter, 16384);
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        titleText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77));
        titleText.setText("Cause");
        titleText.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 380;
        gd.horizontalIndent = 10;
        titleText.setLayoutData(gd);
        this.textCauseMessage = new StyledText(container, 66);
        gd = new GridData();
        gd.widthHint = 340;
        gd.horizontalIndent = 20;
        this.textCauseMessage.setLayoutData(gd);
        this.textCauseMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.textCauseMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77));
        this.textCauseMessage.setEditable(false);
        this.textCauseMessage.setEnabled(false);
        this.textCauseMessage.setLineSpacing(16 - this.textCauseMessage.getLineHeight());
        this.textCauseMessage.setText(causeMsg);
        this.textCauseMessage.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private void createActionMessageArea(Composite container, String actionMsg) {
        Composite titleOuter = new Composite(container, 0);
        titleOuter.setLayout(new GridLayout(1, false));
        titleOuter.setLayoutData(new GridData(4, 0x1000000, true, false));
        titleOuter.setBackground(this.uiRsrcHandler.getBackGroundColor());
        Label titleText = new Label(titleOuter, 16384);
        titleText.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        titleText.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77));
        titleText.setText("Action");
        titleText.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 380;
        gd.horizontalIndent = 10;
        titleText.setLayoutData(gd);
        this.textActionMessage = new StyledText(container, 66);
        gd = new GridData();
        gd.widthHint = 340;
        gd.horizontalIndent = 20;
        this.textActionMessage.setLayoutData(gd);
        this.textActionMessage.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        this.textActionMessage.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_DARK_GRAY_77));
        this.textActionMessage.setEditable(false);
        this.textActionMessage.setEnabled(false);
        this.textActionMessage.setLineSpacing(16 - this.textActionMessage.getLineHeight());
        this.textActionMessage.setText(actionMsg);
        this.textActionMessage.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private String getCauseMessage(Exception err) {
        String msg = "";
        if (err instanceof UMException) {
            if (((UMException)err).getAdditionalMessage() != null) {
                if (!msg.isEmpty()) {
                    msg = msg + "\n";
                }
                msg = msg + "- " + ((UMException)this.exception).getAdditionalMessage();
            }
            if (((UMException)err).getCauseMessage() != null) {
                if (!msg.isEmpty()) {
                    msg = msg + "\n";
                }
                msg = msg + ((UMException)err).getErrorCode().getCauseMessage();
            }
        }
        if (err.getCause() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + err.getCause().getMessage();
        }
        return msg;
    }

    private String getActionMessage(Exception err) {
        String msg = "";
        if (err instanceof UMException && ((UMException)err).getActionMessage() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + ((UMException)err).getActionMessage();
        }
        if (err.getCause() != null && err.getCause() instanceof UMException && ((UMException)err.getCause()).getActionMessage() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + ((UMException)err.getCause()).getActionMessage();
        }
        return msg;
    }

    private void createButtonComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = 350;
        gd.heightHint = 40;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getBackGroundColor());
        container.setBackgroundMode(2);
        int gridCount = 2;
        if (this.isRetry) {
            gridCount = 3;
        }
        GridLayout gridLayout = new GridLayout(gridCount, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        if (this.hasTroubleList) {
            this.createBackButton(container);
        }
        Composite dummy = new Composite(container, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 40;
        dummy.setLayoutData(gd);
        if (this.isRetry) {
            Button btnRetry = new Button(container, 8);
            btnRetry.setText("Retry");
            btnRetry.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
            gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = 90;
            gd.heightHint = 20;
            btnRetry.setLayoutData(gd);
            btnRetry.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    InsideTroubleShootingDialog.this.cancelPressed();
                }
            });
        }
        Button btnClose = new Button(container, 8);
        if (this.isRetry) {
            btnClose.setText("Skip");
        } else {
            btnClose.setText("Confirm");
        }
        btnClose.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        gd = new GridData();
        gd.widthHint = 90;
        gd.heightHint = 23;
        gd.verticalAlignment = 0x1000000;
        btnClose.setLayoutData(gd);
        btnClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.okPressed();
            }
        });
    }

    private void createDetailButton(Composite parent) {
        this.toggleImageLabel = new Label(parent, 0);
        GridData gd = new GridData(4, 0x1000000, false, true);
        this.toggleImageLabel.setImage(this.imgCollapsedDetail);
        gd.widthHint = 20;
        gd.heightHint = 20;
        gd.horizontalIndent = 20;
        this.toggleImageLabel.setLayoutData(gd);
        this.toggleImageLabel.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.detailLabel = new Label(parent, 0);
        this.detailLabel.setText("Detail");
        this.detailLabel.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 1));
        this.detailLabel.setForeground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
        this.detailLabel.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.toggleImageLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
                boolean bl = InsideTroubleShootingDialog.this.toggleDetail = !InsideTroubleShootingDialog.this.toggleDetail;
                if (InsideTroubleShootingDialog.this.toggleDetail) {
                    InsideTroubleShootingDialog.this.toggleImageLabel.setImage(InsideTroubleShootingDialog.this.imgExpandedDetail);
                    InsideTroubleShootingDialog.this.detailLabel.setForeground(InsideTroubleShootingDialog.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_PURE_BLUE));
                    GridData gd = new GridData(4, 4, true, false);
                    gd.widthHint = 330;
                    gd.heightHint = 176;
                    gd.verticalIndent = 7;
                    gd.horizontalIndent = 20;
                    InsideTroubleShootingDialog.this.textLog.setLayoutData(gd);
                    InsideTroubleShootingDialog.this.textLog.setVisible(true);
                } else {
                    InsideTroubleShootingDialog.this.toggleImageLabel.setImage(InsideTroubleShootingDialog.this.imgCollapsedDetail);
                    InsideTroubleShootingDialog.this.detailLabel.setForeground(InsideTroubleShootingDialog.this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_58));
                    GridData gd = new GridData(4, 4, true, false);
                    gd.widthHint = 330;
                    gd.heightHint = 0;
                    gd.verticalIndent = 0;
                    gd.horizontalIndent = 20;
                    InsideTroubleShootingDialog.this.textLog.setLayoutData(gd);
                    InsideTroubleShootingDialog.this.textLog.setVisible(false);
                }
                InsideTroubleShootingDialog.this.toggleImageLabel.getParent().getShell().pack();
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void createBackButton(Composite parent) {
        this.btnBack = new Button(parent, 8);
        this.btnBack.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        GridData gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        gd.horizontalIndent = 0;
        this.btnBack.setLayoutData(gd);
        this.btnBack.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Image targetImage = InsideTroubleShootingDialog.this.imgBackButton;
                int imgOffsetY = (event.height - targetImage.getBounds().height) / 2;
                event.gc.drawImage(targetImage, event.x + 8, event.y + imgOffsetY);
                int textOffsetX = 24 + (66 - event.gc.textExtent((String)"Detail").x) / 2;
                int textOffsetY = (event.height - event.gc.textExtent((String)"Detail").y) / 2;
                event.gc.drawText("Back", event.x + textOffsetX, event.y + textOffsetY, true);
            }
        });
        this.btnBack.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.changeToTroubleListView();
            }
        });
    }

    private void createLogViewer(Composite parent) {
        this.textLog = new StyledText(parent, 2624);
        GridData gd = new GridData();
        gd.widthHint = 330;
        gd.heightHint = 0;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.textLog.setLayoutData(gd);
        this.textLog.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        this.textLog.addLineBackgroundListener(new LineBackgroundListener(){

            @Override
            public void lineGetBackground(LineBackgroundEvent event) {
                int line = ((StyledText)event.widget).getLineAtOffset(event.lineOffset);
                event.lineBackground = line < InsideTroubleShootingDialog.this.progressTypes.size() && InsideTroubleShootingDialog.this.progressTypes.get(line) == ProgressLog.LogType.ERROR ? InsideTroubleShootingDialog.this.errorColor : InsideTroubleShootingDialog.this.oddRowColor;
            }
        });
        this.textLog.setEditable(false);
        this.textLog.setVisible(false);
        this.textLog.setLineSpacing(16 - this.textLog.getLineHeight());
        if (this.progressLogs != null) {
            this.textLog.setText(this.generateCurrentLogString());
        }
    }

    private String generateCurrentLogString() {
        StringBuilder result = new StringBuilder("");
        for (ProgressLog log : this.progressLogs) {
            String msg = log.getMessage();
            ProgressLog.LogType type = log.getType();
            if (msg.contains("\n")) {
                boolean firstMsg = true;
                for (String splitMsg : msg.split("\n")) {
                    if (firstMsg) {
                        result.append(splitMsg).append("\n");
                        this.progressTypes.add(type);
                        firstMsg = false;
                        continue;
                    }
                    result.append("  ").append(splitMsg).append("\n");
                    this.progressTypes.add(type);
                }
                continue;
            }
            result.append(msg).append("\n");
            this.progressTypes.add(type);
        }
        return result.toString();
    }

    private void createTroubleListComposites(Composite parent, ErrorController.ErrorCode selErrCode) {
        this.troubleListComposites = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 20;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.marginBottom = 20;
        this.troubleListComposites.setLayout(gridLayout);
        this.troubleListComposites.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.createFilterSearchBar(this.troubleListComposites);
        this.createToubleListTable(this.troubleListComposites, selErrCode);
        this.createMessageComposites(this.troubleListComposites);
        this.createCloseButtonComposites(this.troubleListComposites);
    }

    private void createFilterSearchBar(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 380;
        gd.heightHint = 24;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        this.textTroubleFilter = new Text(container, 16900);
        gd = new GridData(4, 0x1000000, true, false);
        this.textTroubleFilter.setLayoutData(gd);
        this.textTroubleFilter.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.textTroubleFilter.setEditable(true);
        this.textTroubleFilter.setEnabled(true);
        this.textTroubleFilter.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        this.textTroubleFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode != 0x1000050 && arg0.keyCode != 13) {
                    InsideTroubleShootingDialog.this.troubleTableViewer.refresh();
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        Label searchImgLabel = new Label(container, 0);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 13;
        gd.heightHint = 13;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 0x1000000;
        searchImgLabel.setLayoutData(gd);
        searchImgLabel.setImage(this.imgSearchIcon);
        searchImgLabel.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
        Label dummy = new Label(container, 0);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 10;
        dummy.setLayoutData(gd);
        dummy.setBackground(this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_WHITE));
    }

    private void createToubleListTable(Composite parent, ErrorController.ErrorCode selErrCode) {
        this.troubleListTableContainer = new Composite(parent, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 380;
        gd.verticalIndent = 10;
        gd.heightHint = 152;
        this.troubleListTableContainer.setLayoutData(gd);
        int style = 66064;
        this.troubleTableViewer = new TableViewer(this.troubleListTableContainer, style);
        this.troubleTableViewer.setUseHashlookup(true);
        this.troubleTableViewer.setContentProvider(new TroubleTableContentProvider());
        Table table = this.troubleTableViewer.getTable();
        table.setVisible(true);
        table.setEnabled(true);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.addMouseMoveListener(new MouseMoveListener(){

            @Override
            public void mouseMove(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleListTableContainer.setFocus();
            }
        });
        table.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseHover(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleListTableContainer.setFocus();
            }

            @Override
            public void mouseExit(MouseEvent arg0) {
            }

            @Override
            public void mouseEnter(MouseEvent arg0) {
                InsideTroubleShootingDialog.this.troubleListTableContainer.setFocus();
            }
        });
        this.setTableColumn(this.troubleListTableContainer);
        this.troubleTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ErrorController.ErrorCode selectedError = (ErrorController.ErrorCode)((Object)selection.getFirstElement());
                if (selectedError != null) {
                    InsideTroubleShootingDialog.this.lastSelErrCode = selectedError;
                    InsideTroubleShootingDialog.this.changeToTroubleShootingView(selectedError);
                }
            }
        });
        int selectIndex = 0;
        this.troubleTableViewer.addFilter(new TroubleSearchFilter(this.textTroubleFilter));
        ArrayList<ErrorController.ErrorCode> input = new ArrayList<ErrorController.ErrorCode>();
        for (ErrorController.ErrorCode err : ErrorController.ErrorCode.values()) {
            if (!err.isTroubleShootingCategory()) continue;
            if (selErrCode != null && err == selErrCode) {
                selectIndex = input.size();
            }
            input.add(err);
        }
        this.troubleTableViewer.setInput(input);
        if (!input.isEmpty()) {
            table.select(selectIndex);
            this.exception = new UMException((ErrorController.ErrorCode)((Object)input.get(selectIndex)));
        }
    }

    private void setTableColumn(Composite parent) {
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableViewerColumn troubleClmn = new TableViewerColumn(this.troubleTableViewer, 16384);
        troubleClmn.setLabelProvider(new TroubleColumnLabelProvider());
        troubleClmn.getColumn().setWidth(380);
        columnLayout.setColumnData(troubleClmn.getColumn(), new ColumnWeightData(100, 380));
        parent.setLayout(columnLayout);
    }

    private void createCloseButtonComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 380;
        gd.heightHint = 23;
        gd.verticalIndent = 10;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        Composite dummy = new Composite(container, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 23;
        dummy.setLayoutData(gd);
        dummy.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.btnClose = new Button(container, 8);
        this.btnClose.setText("Close");
        this.btnClose.setFont(this.uiRsrcHandler.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
        gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        this.btnClose.setLayoutData(gd);
        this.btnClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.okPressed();
            }
        });
    }

    protected void changeToTroubleShootingView(ErrorController.ErrorCode selectedError) {
        this.exception = new UMException(selectedError);
        if (this.troubleListComposites != null) {
            this.troubleListComposites.dispose();
        }
        this.mainComposites.setRedraw(false);
        this.createTroubleListComposites(this.mainComposites, selectedError);
        this.stackLayout.topControl = this.troubleListComposites;
        this.mainComposites.setRedraw(true);
        this.mainComposites.layout();
    }

    protected void changeToTroubleListView() {
        this.createTroubleListComposites(this.mainComposites, this.lastSelErrCode);
        this.stackLayout.topControl = this.troubleListComposites;
        this.mainComposites.layout();
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Inside Trouble Shooting");
        newShell.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_MANAGER));
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

