/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util.commonstring;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tizen.library.sdkutils.util.commonstring.CSV2StringFile;

public class ReadCSV2Map {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readCSVCotent2Map(String csvPath) {
        LinkedHashMap<String, String> retMaps = null;
        BufferedReader br = null;
        String line = "";
        String csvSplitBy = ",";
        if (csvPath == null || csvPath.length() <= 0) {
            CSV2StringFile.PRINT_ERROR("Invalid csv Path(NULL or zero length");
        } else {
            try {
                retMaps = new LinkedHashMap<String, String>();
                br = new BufferedReader(new FileReader(csvPath));
                int SpaceLineNum = 0;
                int CommentNum = 0;
                while ((line = br.readLine()) != null) {
                    String[] splitString = line.split(csvSplitBy);
                    if (splitString.length == 2) {
                        if (splitString[0].equals("KEY") && splitString[1].equals("VALUE")) continue;
                        String key = splitString[0].trim();
                        String value = splitString[1].trim();
                        retMaps.put(key, value);
                        continue;
                    }
                    if (splitString.length == 1 && splitString[0].length() == 0) {
                        retMaps.put("!*MAP_KEY_SPACELINE*!" + String.valueOf(CommentNum++), splitString[0]);
                        CSV2StringFile.PRINT_INFO("space line(" + splitString.length + ") content: " + line);
                        continue;
                    }
                    if (splitString.length == 1 && splitString[0].charAt(0) == '#') {
                        retMaps.put("!*MAP_KEY_COMMNET*!" + String.valueOf(SpaceLineNum++), splitString[0]);
                        CSV2StringFile.PRINT_INFO("comment(" + splitString.length + ") content: " + line);
                        continue;
                    }
                    CSV2StringFile.PRINT_ERROR("invalid split length(" + splitString.length + ") content: " + line);
                }
            }
            catch (FileNotFoundException e) {
                CSV2StringFile.PRINT_ERROR("FileNotFoundException " + e.toString());
            }
            catch (IOException e) {
                CSV2StringFile.PRINT_ERROR("IOException " + e.toString());
            }
            catch (Exception e) {
                CSV2StringFile.PRINT_ERROR("Exception " + e.toString());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        CSV2StringFile.PRINT_ERROR("IOException " + e.toString());
                    }
                }
            }
        }
        return retMaps;
    }
}

