/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.dialog;

import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.packagemanager.ui.page.custom.CustomMessageDialog;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class AuthenticationDialog
extends Dialog {
    private WizardUIResourceHandler uiRsrcHandler;
    private Text idText;
    private Text pwText;
    private String id = "";
    private String pw = "";
    private String message = "";
    private Label messageLabel;

    public AuthenticationDialog(Shell parentShell, String message) {
        super(parentShell);
        this.setShellStyle(67616);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.message = message;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout(new GridLayout(3, false));
        Label imageLabel = new Label(container, 0x1000000);
        imageLabel.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_LOGIN));
        GridData gd = new GridData(0x1000000, 0x1000000, false, true);
        imageLabel.setLayoutData(gd);
        this.messageLabel = new Label(container, 64);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 32;
        gd.horizontalSpan = 2;
        this.messageLabel.setLayoutData(gd);
        if (this.message == null || this.message.isEmpty()) {
            this.messageLabel.setText("ID/Password required");
        } else {
            this.messageLabel.setText(this.message);
        }
        this.messageLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        Label idLabel = new Label(container, 0);
        idLabel.setAlignment(131072);
        idLabel.setText("ID :");
        gd = new GridData(4, 4, false, false);
        gd.widthHint = 74;
        gd.horizontalSpan = 2;
        idLabel.setLayoutData(gd);
        idLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.idText = new Text(container, 2048);
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 183;
        gd.heightHint = 10;
        this.idText.setLayoutData(gd);
        this.idText.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.idText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                AuthenticationDialog.this.id = AuthenticationDialog.this.idText.getText();
                if (!AuthenticationDialog.this.id.isEmpty() && !AuthenticationDialog.this.pw.isEmpty()) {
                    AuthenticationDialog.this.setOKButtonEnabled(true);
                } else {
                    AuthenticationDialog.this.setOKButtonEnabled(false);
                }
            }
        });
        Label pwLabel = new Label(container, 0);
        pwLabel.setAlignment(131072);
        pwLabel.setText("Password :");
        gd = new GridData(4, 4, false, false);
        gd.widthHint = 74;
        gd.horizontalSpan = 2;
        gd.heightHint = 10;
        pwLabel.setLayoutData(gd);
        pwLabel.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.pwText = new Text(container, 0x400800);
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 183;
        gd.heightHint = 10;
        this.pwText.setLayoutData(gd);
        this.pwText.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.pwText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                AuthenticationDialog.this.pw = AuthenticationDialog.this.pwText.getText();
                if (!AuthenticationDialog.this.id.isEmpty() && !AuthenticationDialog.this.pw.isEmpty()) {
                    AuthenticationDialog.this.setOKButtonEnabled(true);
                } else {
                    AuthenticationDialog.this.setOKButtonEnabled(false);
                }
            }
        });
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okBtn = this.getButton(0);
        okBtn.setText("OK");
        okBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.setButtonLayoutData(okBtn);
        Button cancelBtn = this.getButton(1);
        cancelBtn.setText("Cancel");
        cancelBtn.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.setButtonLayoutData(cancelBtn);
    }

    private void setOKButtonEnabled(boolean isEnabled) {
        this.getButton(0).setEnabled(isEnabled);
    }

    @Override
    protected void okPressed() {
        if (!this.id.isEmpty() && !this.pw.isEmpty()) {
            this.close();
        } else {
            CustomMessageDialog.showDlg(this.getShell(), "Input ID/PW", "The proxy server requires ID/PASSWORD. Input your ID/PASSWORD.", CustomMessageDialog.DialogType.WARNING, true);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getPassword() {
        return this.pw;
    }

    public void setURL(URL url) {
        if (url != null) {
            this.message = "Please input user account for connecting \"" + url.toExternalForm() + "\".";
            if (this.messageLabel != null) {
                this.messageLabel.setText(this.message);
            }
        }
    }

    public void setMessage(String message) {
        if (message == null) {
            return;
        }
        this.message = message;
    }

    public void setWarningMessage(String message) {
        if (message == null) {
            return;
        }
        this.message = message;
    }
}

