/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.ui.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.util.Log;

public class CopyDir
extends SimpleFileVisitor<Path> {
    private static final Logger logger = Log.getLogger(CopyDir.class);
    private Path sourceDir;
    private Path targetDir;

    public CopyDir(Path sourceDir, Path targetDir) {
        this.sourceDir = sourceDir;
        this.targetDir = targetDir;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
        try {
            Path targetFile = this.targetDir.resolve(this.sourceDir.relativize(file));
            Files.copy(file, targetFile, new CopyOption[0]);
        }
        catch (IOException ex) {
            logger.error(ex);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) {
        try {
            Path newDir = this.targetDir.resolve(this.sourceDir.relativize(dir));
            Files.createDirectory(newDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.error(ex);
        }
        return FileVisitResult.CONTINUE;
    }
}

