/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.mac;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.mac.MacShellRunningProgramParser;
import org.tizen.manager.mac.ProcessInformation;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.manager.util.ShellUtil;

public class MacProgramController
extends ProgramController {
    private static final Logger logger = Log.getLogger(MacProgramController.class);
    private SDKInfo sdkInfo;

    public MacProgramController(SDKInfo sdkInfo) {
        this.sdkInfo = sdkInfo;
    }

    @Override
    public List<String> getSDKProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.sdkInfo.getInstalledPath().isEmpty()) {
            return result;
        }
        String[] command = new String[]{"/bin/sh", "-c", "ps -ax -o pid,tty,stat,time,command"};
        MacShellRunningProgramParser parser = new MacShellRunningProgramParser();
        try {
            ShellUtil.execute(command, parser);
        }
        catch (IMShellCommandFail e1) {
            logger.trace("\tFailed to get SDK pid's");
            return result;
        }
        for (ProcessInformation processInfo : parser.getProcessInformation()) {
            if (this.isIDE(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_IDE);
                continue;
            }
            if (this.isEmulatorManager(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_EMUL_MGR);
                continue;
            }
            if (this.isEmulator(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_EMUL);
                continue;
            }
            if (this.isDynamicAnalyzer(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_DA);
                continue;
            }
            if (this.isWebSimulator(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_WEB_SIM);
                continue;
            }
            if (this.isManager(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_MANAGER);
                continue;
            }
            if (!this.isUninstaller(processInfo.getCommand())) continue;
            result.add(ProgramController.PROG_NAME_UNINSTALLER);
        }
        return result;
    }

    @Override
    public List<String> getPkgMgrProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.sdkInfo.getInstalledPath().isEmpty()) {
            return result;
        }
        String[] command = new String[]{"/bin/sh", "-c", "ps -ax -o pid,tty,stat,time,command"};
        MacShellRunningProgramParser parser = new MacShellRunningProgramParser();
        try {
            ShellUtil.execute(command, parser);
        }
        catch (IMShellCommandFail e1) {
            logger.trace("\tFailed to get SDK pid's");
            return result;
        }
        for (ProcessInformation processInfo : parser.getProcessInformation()) {
            if (this.isManager(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_MANAGER);
                continue;
            }
            if (this.isManagerCli(processInfo.getCommand())) {
                result.add(ProgramController.PROG_NAME_MANAGER_CLI);
                continue;
            }
            if (!this.isUninstaller(processInfo.getCommand())) continue;
            result.add(ProgramController.PROG_NAME_UNINSTALLER);
        }
        return result;
    }

    boolean isIDE(String commandLine) {
        return commandLine != null && commandLine.startsWith(this.sdkInfo.getInstalledPath()) && commandLine.contains("TizenStudio.app/Contents/MacOS");
    }

    private boolean isEmulatorManager(String commandLine) {
        return commandLine != null && commandLine.contains("-jar " + this.sdkInfo.getInstalledPath()) && commandLine.contains("emulator-manager.app/Contents/MacOS");
    }

    private boolean isEmulator(String commandLine) {
        return commandLine != null && commandLine.startsWith(this.sdkInfo.getInstalledPath()) && commandLine.contains("emulator-x86");
    }

    private boolean isDynamicAnalyzer(String commandLine) {
        return commandLine != null && commandLine.contains("java") && commandLine.contains("-jar") && commandLine.contains(PathUtil.get(this.sdkInfo.getInstalledPath(), "tools/dynamic-analyzer/dynamic-analyzer.app/Contents/MacOS"));
    }

    private boolean isWebSimulator(String commandLine) {
        return false;
    }

    private boolean isManager(String commandLine) {
        return commandLine != null && commandLine.contains("java") && commandLine.contains("-jar " + ProgramController.JAR_NAME_MANAGER) && commandLine.contains("-path " + this.sdkInfo.getInstalledPath());
    }

    private boolean isManagerCli(String commandLine) {
        return commandLine != null && commandLine.contains("java") && commandLine.contains("-jar " + ProgramController.JAR_NAME_MANAGER_CLI) && commandLine.contains("-path " + this.sdkInfo.getInstalledPath());
    }

    private boolean isUninstaller(String commandLine) {
        return commandLine != null && commandLine.contains("java") && commandLine.contains("-jar " + ProgramController.JAR_NAME_UNINSTALLER) && commandLine.contains("-path " + this.sdkInfo.getInstalledPath());
    }
}

