/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Event;

public final class ExternalActionManager {
    private static ExternalActionManager instance;
    private ICallback callback;

    public static ExternalActionManager getInstance() {
        if (instance == null) {
            instance = new ExternalActionManager();
        }
        return instance;
    }

    private ExternalActionManager() {
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void setCallback(ICallback callbackToUse) {
        this.callback = callbackToUse;
    }

    public static class CommandCallback
    implements IBindingManagerListener,
    IBindingManagerCallback,
    IExecuteCallback {
        private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(ExternalActionManager.class.getName());
        private final IActiveChecker activeChecker;
        private final IExecuteApplicable applicabilityChecker;
        private final BindingManager bindingManager;
        private boolean bindingManagerListenerAttached = false;
        private final CommandManager commandManager;
        private final Set<String> loggedCommandIds = new HashSet<String>();
        private final Map<String, Object> registeredListeners = new HashMap<String, Object>();

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager) {
            this(bindingManager, commandManager, new IActiveChecker(){

                @Override
                public boolean isActive(String commandId) {
                    return true;
                }
            }, new IExecuteApplicable(){

                @Override
                public boolean isApplicable(IAction action) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker activeChecker) {
            this(bindingManager, commandManager, activeChecker, new IExecuteApplicable(){

                @Override
                public boolean isApplicable(IAction action) {
                    return true;
                }
            });
        }

        public CommandCallback(BindingManager bindingManager, CommandManager commandManager, IActiveChecker activeChecker, IExecuteApplicable checker) {
            if (bindingManager == null) {
                throw new NullPointerException("The callback needs a binding manager");
            }
            if (commandManager == null) {
                throw new NullPointerException("The callback needs a command manager");
            }
            if (activeChecker == null) {
                throw new NullPointerException("The callback needs an active callback");
            }
            if (checker == null) {
                throw new NullPointerException("The callback needs an applicable callback");
            }
            this.activeChecker = activeChecker;
            this.bindingManager = bindingManager;
            this.commandManager = commandManager;
            this.applicabilityChecker = checker;
        }

        @Override
        public final void addPropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            Object existing = this.registeredListeners.get(commandId);
            if (existing instanceof ListenerList) {
                ((ListenerList)existing).add(listener);
            } else if (existing != null) {
                ListenerList listeners = new ListenerList(1);
                listeners.add(existing);
                listeners.add(listener);
                this.registeredListeners.put(commandId, listeners);
            } else {
                this.registeredListeners.put(commandId, listener);
            }
            if (!this.bindingManagerListenerAttached) {
                this.bindingManager.addBindingManagerListener(this);
                this.bindingManagerListenerAttached = true;
            }
        }

        @Override
        public final void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged()) {
                for (Map.Entry<String, Object> entry : this.registeredListeners.entrySet()) {
                    String commandId = entry.getKey();
                    Command command = this.commandManager.getCommand(commandId);
                    ParameterizedCommand parameterizedCommand = new ParameterizedCommand(command, null);
                    if (!event.isActiveBindingsChangedFor(parameterizedCommand)) continue;
                    Object value = entry.getValue();
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(event.getManager(), "text", null, null);
                    if (value instanceof ListenerList) {
                        Object[] listeners = ((ListenerList)value).getListeners();
                        int i = 0;
                        while (i < listeners.length) {
                            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
                            listener.propertyChange(propertyChangeEvent);
                            ++i;
                        }
                        continue;
                    }
                    IPropertyChangeListener listener = (IPropertyChangeListener)value;
                    listener.propertyChange(propertyChangeEvent);
                }
            }
        }

        @Override
        public final Integer getAccelerator(String commandId) {
            Trigger trigger;
            Trigger[] triggers;
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(commandId);
            if (triggerSequence != null && (triggers = triggerSequence.getTriggers()).length == 1 && (trigger = triggers[0]) instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)trigger;
                int accelerator = SWTKeySupport.convertKeyStrokeToAccelerator(keyStroke);
                return new Integer(accelerator);
            }
            return null;
        }

        @Override
        public final String getAcceleratorText(String commandId) {
            TriggerSequence triggerSequence = this.bindingManager.getBestActiveBindingFor(commandId);
            if (triggerSequence == null) {
                return null;
            }
            return triggerSequence.format();
        }

        @Override
        public final TriggerSequence[] getActiveBindingsFor(String commandId) {
            return this.bindingManager.getActiveBindingsFor(commandId);
        }

        @Override
        public final boolean isAcceleratorInUse(int accelerator) {
            KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(accelerator));
            return this.bindingManager.isPerfectMatch(keySequence) || this.bindingManager.isPartialMatch(keySequence);
        }

        @Override
        public final boolean isActive(final String commandId) {
            if (commandId != null) {
                final Command command = this.commandManager.getCommand(commandId);
                if (!command.isDefined() && !this.loggedCommandIds.contains(commandId)) {
                    String message = MessageFormat.format(Util.translateString(RESOURCE_BUNDLE, "undefinedCommand.WarningMessage", null), command.getId());
                    Status status = new Status(4, "org.eclipse.jface", 0, message, new Exception());
                    Policy.getLog().log(status);
                    this.loggedCommandIds.add(commandId);
                    command.addCommandListener(new ICommandListener(){

                        @Override
                        public final void commandChanged(CommandEvent commandEvent) {
                            if (command.isDefined()) {
                                command.removeCommandListener(this);
                                CommandCallback.this.loggedCommandIds.remove(commandId);
                            }
                        }
                    });
                    return true;
                }
                return this.activeChecker.isActive(commandId);
            }
            return true;
        }

        @Override
        public final void removePropertyChangeListener(String commandId, IPropertyChangeListener listener) {
            Object existing = this.registeredListeners.get(commandId);
            if (existing == listener) {
                this.registeredListeners.remove(commandId);
                if (this.registeredListeners.isEmpty()) {
                    this.bindingManager.removeBindingManagerListener(this);
                    this.bindingManagerListenerAttached = false;
                }
            } else if (existing instanceof ListenerList) {
                ListenerList existingList = (ListenerList)existing;
                existingList.remove(listener);
                if (existingList.size() == 1) {
                    this.registeredListeners.put(commandId, existingList.getListeners()[0]);
                }
            }
        }

        @Override
        public void preExecute(IAction action, Event event) {
            String actionDefinitionId = action.getActionDefinitionId();
            if (actionDefinitionId == null || !this.applicabilityChecker.isApplicable(action)) {
                return;
            }
            Command command = this.commandManager.getCommand(actionDefinitionId);
            ExecutionEvent executionEvent = new ExecutionEvent(command, Collections.EMPTY_MAP, event, null);
            this.commandManager.firePreExecute(actionDefinitionId, executionEvent);
        }

        @Override
        public void postExecuteSuccess(IAction action, Object returnValue) {
            String actionDefinitionId = action.getActionDefinitionId();
            if (actionDefinitionId == null || !this.applicabilityChecker.isApplicable(action)) {
                return;
            }
            this.commandManager.firePostExecuteSuccess(actionDefinitionId, returnValue);
        }

        @Override
        public void postExecuteFailure(IAction action, ExecutionException exception) {
            String actionDefinitionId = action.getActionDefinitionId();
            if (actionDefinitionId == null || !this.applicabilityChecker.isApplicable(action)) {
                return;
            }
            this.commandManager.firePostExecuteFailure(actionDefinitionId, exception);
        }

        @Override
        public void notDefined(IAction action, NotDefinedException exception) {
            String actionDefinitionId = action.getActionDefinitionId();
            if (actionDefinitionId == null || !this.applicabilityChecker.isApplicable(action)) {
                return;
            }
            this.commandManager.fireNotDefined(actionDefinitionId, exception);
        }

        @Override
        public void notEnabled(IAction action, NotEnabledException exception) {
            String actionDefinitionId = action.getActionDefinitionId();
            if (actionDefinitionId == null || !this.applicabilityChecker.isApplicable(action)) {
                return;
            }
            this.commandManager.fireNotEnabled(actionDefinitionId, exception);
        }
    }

    public static interface IActiveChecker {
        public boolean isActive(String var1);
    }

    public static interface IBindingManagerCallback
    extends ICallback {
        public TriggerSequence[] getActiveBindingsFor(String var1);
    }

    public static interface ICallback {
        public void addPropertyChangeListener(String var1, IPropertyChangeListener var2);

        public Integer getAccelerator(String var1);

        public String getAcceleratorText(String var1);

        public boolean isAcceleratorInUse(int var1);

        public boolean isActive(String var1);

        public void removePropertyChangeListener(String var1, IPropertyChangeListener var2);
    }

    public static interface IExecuteApplicable {
        public boolean isApplicable(IAction var1);
    }

    public static interface IExecuteCallback {
        public void notEnabled(IAction var1, NotEnabledException var2);

        public void notDefined(IAction var1, NotDefinedException var2);

        public void preExecute(IAction var1, Event var2);

        public void postExecuteSuccess(IAction var1, Object var2);

        public void postExecuteFailure(IAction var1, ExecutionException var2);
    }
}

