/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ContentProvider;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.download.DownloadResult;
import org.tizen.manager.core.download.DownloaderCallable;
import org.tizen.manager.core.download.IDownloadManagerMonitor;
import org.tizen.manager.core.model.ExtensionInformation;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.util.ChecksumUtil;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ZipLibrary;

public class ManagerableDownloaderCallable
implements Callable<Void> {
    private Logger logger;
    private Package pkg;
    private String targetDir;
    private IDownloadManagerMonitor monitor;
    private long CHUNK_SIZE = 0xA00000L;
    private ContentProvider contentProvider;

    public ManagerableDownloaderCallable(ContentProvider contentProvider, Package pkg, String targetDir, IDownloadManagerMonitor downloadMonitor) {
        this.contentProvider = contentProvider;
        this.pkg = pkg;
        this.targetDir = targetDir;
        this.monitor = downloadMonitor;
        this.logger = Log.getLogger(ManagerableDownloaderCallable.class);
    }

    @Override
    public Void call() throws Exception {
        try {
            this.monitor.beginTask();
            if (this.monitor.isCanceled()) {
                this.monitor.setProgress("Detected the cancelation of downloading progress... " + this.pkg.getPackageName());
                throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, this.pkg.getPackageName());
            }
            this.logger.info("ManagerableDownloaderCallable download call package => " + this.pkg.getPackageName());
            this.monitor.setProgress("Started to download the package file.");
            this.monitor.downloadWorked(0);
            boolean result = this.downloadPackage(this.pkg, this.monitor);
            if (!result) {
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, this.pkg.getPackageName());
            }
            this.monitor.setProgress("Downloading the package file succeeded.");
            this.monitor.downloadWorked(100);
            this.logger.trace("\tDownload completed => " + this.pkg.getPackageName());
            if (this.monitor.isCanceled()) {
                throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, this.pkg.getPackageName());
            }
            long unZipPackage = 0L;
            this.monitor.setProgress("Started to extract the package file.");
            String tempDir = PathUtil.get(this.targetDir, "temp", this.pkg.getPackageName());
            File tmpDir = new File(tempDir);
            if (new File(PathUtil.get(tmpDir.getAbsolutePath(), this.pkg.getPackageName() + ".list")).exists()) {
                this.logger.trace("[" + this.pkg.getPackageName() + "] already exists in cache do not extract. ##");
                unZipPackage = 1L;
            } else {
                unZipPackage = this.unZipPackage(this.pkg, this.monitor);
                this.logger.trace("[" + this.pkg.getPackageName() + "] download extracted ....");
            }
            this.monitor.extractWorked(100);
            if (unZipPackage <= 0L) {
                this.logger.error("Unzip failed. => " + this.pkg);
                PathUtil.remove(PathUtil.get(this.targetDir, "temp", this.pkg.getPackageName()));
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_UNPACK_PACKAGE_FILE, this.pkg.getPackageName());
            }
            this.monitor.setProgress("Extracting the package file succeeded.");
            this.monitor.extractWorked(100);
        }
        catch (Exception e) {
            this.logger.throwing(e);
            this.monitor.setError(e);
            throw e;
        }
        finally {
            this.monitor.done();
        }
        return null;
    }

    private boolean downloadPackage(Package pkg, IDownloadManagerMonitor monitor) throws UMException {
        this.logger.info("Download package => " + pkg);
        if (pkg == null) {
            this.logger.error("Cannot find package.");
            return false;
        }
        if (monitor.isCanceled()) {
            monitor.setProgress("Detected the cancelation of downloading progress... " + pkg.getPackageName());
            throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName());
        }
        URL downloadFileURL = pkg.getURL();
        String downloadTargetPath = this.contentProvider.getInstController().getDownloadTargetPath(pkg);
        if (this.existInCacheFolder(pkg, downloadTargetPath, monitor)) {
            this.logger.trace("[" + pkg.getPackageName() + "] already exists in cache. ##");
            monitor.downloadWorked(100);
            return true;
        }
        File targetFile = new File(downloadTargetPath);
        if (targetFile.exists()) {
            if (targetFile.length() == pkg.getPackageSize().longValue()) {
                this.logger.trace("[" + pkg.getPackageName() + "] already exists in cache. ##");
                monitor.downloadWorked(100);
                return true;
            }
            PathUtil.remove(targetFile);
        }
        long size = 0L;
        if (pkg.isExtensionPackage()) {
            ExtensionInformation extensionInfoById = this.contentProvider.getExtRepoMgr().getExtensionInfoById(pkg.getExtensionServer());
            size = downloadFileURL.getProtocol().equals("file") && extensionInfoById != null && extensionInfoById.getRepotype().equals("file") ? this.downloadFromLocal(downloadTargetPath, pkg, true) : this.downloadPackageFile(pkg, monitor, downloadFileURL, downloadTargetPath, size);
        } else {
            size = this.contentProvider.getRepoMgr().isLocalServerType() ? this.downloadFromLocal(downloadTargetPath, pkg, false) : this.downloadPackageFile(pkg, monitor, downloadFileURL, downloadTargetPath, size);
        }
        if (size < 0L || size != pkg.getPackageSize() || !new File(downloadTargetPath).exists()) {
            this.logger.error("download failed => " + downloadFileURL);
            PathUtil.remove(downloadTargetPath);
            if (monitor.isCanceled()) {
                throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName());
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, pkg.getPackageName() + "," + ErrorController.getErrorMessage());
        }
        this.logger.info("finish download => " + pkg);
        this.logger.info("Validate package  => " + pkg);
        if (!this.checkPackageSize(pkg, size)) {
            this.logger.error("The expected size of package => " + pkg.getPackageSize());
            this.logger.error("Package size error. downloaded size => " + size);
            PathUtil.remove(downloadTargetPath);
            throw new UMException(ErrorController.ErrorCode.DOWNLOADED_PACKAGE_FILE_SIZE_NOT_MATCHED);
        }
        return true;
    }

    private long downloadPackageFile(Package pkg, IDownloadManagerMonitor monitor, URL downloadFileURL, String downloadTargetPath, long size) throws UMException {
        if (pkg.getPackageSize() > this.CHUNK_SIZE) {
            int count = 0;
            ArrayList<Future<DownloadResult>> futureList = new ArrayList<Future<DownloadResult>>();
            ArrayList<DownloaderCallable> downloadCallableList = new ArrayList<DownloaderCallable>();
            long i = 0L;
            while (i < pkg.getPackageSize()) {
                long l = this.CHUNK_SIZE;
                if (i + l > pkg.getPackageSize()) {
                    l = pkg.getPackageSize() - i;
                }
                double rate = (double)l * 1.0 / (double)pkg.getPackageSize().longValue() * 100.0;
                DownloadProgressMonitor downloadProgressMonitor = new DownloadProgressMonitor(monitor, rate);
                monitor.addDownloadProgressMonitor(downloadProgressMonitor);
                String partialDownloadTargetPath = downloadTargetPath + "." + count;
                File partialTargetFile = new File(partialDownloadTargetPath);
                if (partialTargetFile.exists()) {
                    PathUtil.remove(partialTargetFile);
                }
                DownloaderCallable dc = new DownloaderCallable(this.contentProvider.getConfig(), downloadFileURL, partialDownloadTargetPath, i, l, downloadProgressMonitor);
                downloadCallableList.add(dc);
                i += this.CHUNK_SIZE;
                ++count;
            }
            for (DownloaderCallable downloaderCallable : downloadCallableList) {
                Future<DownloadResult> future = this.contentProvider.getInstController().getDownloadMgr().donwloadThreadExecutorSubmit(downloaderCallable);
                futureList.add(future);
            }
            ArrayList<DownloadResult> failList = new ArrayList<DownloadResult>();
            for (Future future : futureList) {
                try {
                    DownloadResult downloadResult = (DownloadResult)future.get();
                    if (downloadResult.getError() != null) {
                        UMException err = (UMException)downloadResult.getError();
                        if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                            throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                        }
                        this.logger.error("Fail to download : " + downloadResult.getDownloadTargetPath());
                        failList.add(downloadResult);
                        continue;
                    }
                    size += downloadResult.getDownloadSize();
                }
                catch (InterruptedException e) {
                    this.logger.throwing(e);
                    throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof UMException) {
                        UMException err = (UMException)e.getCause();
                        if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                            throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                        }
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)err);
                    }
                    throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
                }
            }
            if (failList.size() > 0) {
                if (failList.size() != futureList.size()) {
                    for (DownloadResult downloadResult : failList) {
                        long prevSize = size;
                        for (int i2 = 0; i2 < 3; ++i2) {
                            this.logger.trace("Recovery_Multi : [" + i2 + "] : " + downloadResult.getDownloadFileURL());
                            long retryDownloadFile = this.retryDownloadFile(pkg, downloadResult);
                            if (retryDownloadFile <= 0L) continue;
                            size += retryDownloadFile;
                            break;
                        }
                        if (prevSize != size) continue;
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, pkg.getPackageName());
                    }
                } else {
                    throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, pkg.getPackageName());
                }
            }
            if (size == pkg.getPackageSize()) {
                this.mergeDownloadedFile(downloadTargetPath, count);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.logger.trace("Try_single : [" + i + "] : " + pkg);
                try {
                    DownloadResult downloadSingleFile = this.downloadSingleFile(pkg, monitor, downloadFileURL, downloadTargetPath);
                    if (downloadSingleFile.getError() != null) {
                        if (i != 2) continue;
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)downloadSingleFile.getError());
                    }
                    size = downloadSingleFile.getDownloadSize();
                    break;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof UMException) {
                        UMException err = (UMException)e.getCause();
                        if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                            throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                        }
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)err);
                    }
                    throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
                }
            }
        }
        return size;
    }

    private DownloadResult downloadSingleFile(Package pkg, IDownloadManagerMonitor monitor, URL downloadFileURL, String downloadTargetPath) throws UMException {
        DownloadResult dr = null;
        DownloadProgressMonitor downloadProgressMonitor = new DownloadProgressMonitor(monitor, 100.0);
        monitor.addDownloadProgressMonitor(downloadProgressMonitor);
        DownloaderCallable dc = new DownloaderCallable(this.contentProvider.getConfig(), downloadFileURL, downloadTargetPath, 0L, -1L, downloadProgressMonitor);
        Future<DownloadResult> submit = this.contentProvider.getInstController().getDownloadMgr().donwloadThreadExecutorSubmit(dc);
        try {
            UMException err;
            dr = submit.get();
            if (dr.getError() != null && (err = (UMException)dr.getError()).getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
            }
        }
        catch (InterruptedException e) {
            this.logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UMException) {
                UMException err = (UMException)e.getCause();
                if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                    throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                }
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)err);
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
        }
        return dr;
    }

    private long retryDownloadFile(Package pkg, DownloadResult failDownloadInfo) throws UMException {
        long size = -1L;
        DownloadProgressMonitor downloadProgressMonitor = failDownloadInfo.getDownloadProgressMonitor();
        DownloaderCallable dc = new DownloaderCallable(this.contentProvider.getConfig(), failDownloadInfo.getDownloadFileURL(), failDownloadInfo.getDownloadTargetPath(), failDownloadInfo.getSkipBytes(), failDownloadInfo.getMaxDownloadSize(), downloadProgressMonitor);
        Future<DownloadResult> submit = this.contentProvider.getInstController().getDownloadMgr().donwloadThreadExecutorSubmit(dc);
        try {
            DownloadResult dr = submit.get();
            if (dr.getError() != null) {
                UMException err = (UMException)dr.getError();
                if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                    throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                }
                size = -1L;
            } else {
                size = dr.getDownloadSize();
            }
        }
        catch (InterruptedException e) {
            this.logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UMException) {
                UMException err = (UMException)e.getCause();
                if (err.getErrorCode() == ErrorController.ErrorCode.CANCELED_DOWNLOADING_FILE) {
                    throw new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE, pkg.getPackageName(), err);
                }
                throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)err);
            }
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_PACKAGE_FILE, (Throwable)e);
        }
        return size;
    }

    private void mergeDownloadedFile(String downloadTargetPath, int count) throws UMException {
        File parentDir = new File(downloadTargetPath).getParentFile();
        if (parentDir != null && parentDir.exists()) {
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(downloadTargetPath);
                for (int i = 0; i < count; ++i) {
                    if (this.monitor != null && this.monitor.isCanceled()) {
                        this.logger.warn("Canceled by user");
                    }
                    File f = new File(parentDir, new File(downloadTargetPath).getName() + "." + i);
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(f);
                        byte[] buf = new byte[1024];
                        int len = 0;
                        while ((len = ((InputStream)inputStream).read(buf)) > 0) {
                            ((OutputStream)outStream).write(buf, 0, len);
                        }
                        if (f.delete()) continue;
                        this.logger.error("delete operation failed!!");
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        this.logger.throwing(e);
                        throw new UMException(ErrorController.ErrorCode.PARTIAL_DOWNLOADED_FILE_NOT_FOUND, f.getAbsolutePath());
                    }
                    catch (IOException e) {
                        this.logger.throwing(e);
                        throw new UMException(ErrorController.ErrorCode.FAILED_TO_MERGE_PARTIAL_DOWNLOADED_FILES, f.getAbsolutePath());
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (IOException e) {
                                this.logger.throwing(e);
                            }
                        }
                    }
                }
            }
            catch (FileNotFoundException e1) {
                this.logger.error(e1.getMessage());
                throw new UMException(ErrorController.ErrorCode.DOWNLOADED_FILE_NOT_FOUND, downloadTargetPath);
            }
            finally {
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException e) {
                        this.logger.throwing(e);
                    }
                }
            }
        }
        if (parentDir != null) {
            this.logger.error("Parent directory is not exists ==> " + parentDir.getName());
        } else {
            this.logger.error("Parent directory is not exists");
        }
    }

    private long downloadFromLocal(String downloadPath, Package downlodPkg, boolean isExtra) throws UMException {
        long size = 0L;
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(downlodPkg.getFileName());
        String repository = downlodPkg.getBaseURL().toString();
        ZipLibrary zipLibrary = null;
        if (isExtra) {
            String cacheDirPath = null;
            cacheDirPath = repository.startsWith("file:") ? NetworkUtil.getRemoveFileURL(repository) : NetworkUtil.getPathFromURL(downlodPkg.getBaseURL().toExternalForm());
            String repoId = this.pkg.getExtensionServer();
            String cachedZipFilePath = PathUtil.get(cacheDirPath, this.contentProvider.getExtRepoMgr().getExtensionFileName(repoId));
            zipLibrary = new ZipLibrary(cachedZipFilePath, null);
        } else {
            zipLibrary = new ZipLibrary(this.contentProvider.getRepoMgr().getImageFileName(), null);
        }
        String encodeRepository = null;
        try {
            encodeRepository = URLEncoder.encode(repository, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.throwing(e);
        }
        downloadPath = PathUtil.get(Config.getTempDownloadDirectory(this.contentProvider.getSDKInfo()), encodeRepository);
        size = zipLibrary.unzipSelectedList(downloadPath, fileNames);
        zipLibrary.close();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unZipPackage(Package pkg, IDownloadManagerMonitor monitor) throws UMException {
        String tempDir = PathUtil.get(this.targetDir, "temp", pkg.getPackageName());
        File tmpDir = new File(tempDir);
        if (tmpDir.exists() && !PathUtil.remove(tmpDir)) {
            this.logger.error("Fail to delete " + tmpDir);
        }
        String filePath = this.contentProvider.getInstController().getDownloadTargetPath(pkg);
        String installedFileListPath = PathUtil.get(tmpDir.getAbsolutePath(), pkg.getPackageName() + ".list");
        ZipLibrary zlib = null;
        try {
            zlib = new ZipLibrary(filePath, installedFileListPath);
        }
        catch (UMException e) {
            this.logger.throwing(e);
            throw e;
        }
        try {
            long e = zlib.unzip(tempDir, monitor, pkg.getUncompressedPackageSize());
            return e;
        }
        catch (IOException e) {
            this.logger.throwing(e);
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            this.logger.throwing(e);
            long l = -1L;
            return l;
        }
        finally {
            zlib.close();
        }
    }

    private boolean checkFileChecksum(Package pkg, MessageDigest mDigest) {
        if (pkg.getSHA256() == null || pkg.getSHA256().isEmpty()) {
            return false;
        }
        if (mDigest.getAlgorithm().equals("SHA-256")) {
            return pkg.getSHA256().equalsIgnoreCase(ChecksumUtil.messageDigestToString(mDigest));
        }
        return false;
    }

    private boolean checkPackageSize(Package pkg, long size) {
        return pkg.getPackageSize() == size;
    }

    private boolean existInCacheFolder(Package pkg, String filePath, IDownloadManagerMonitor monitor) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (file.length() != pkg.getPackageSize().longValue()) {
            return false;
        }
        if (monitor != null) {
            // empty if block
        }
        if (ChecksumUtil.getSHA256(filePath) != null) {
            return this.checkFileChecksum(pkg, ChecksumUtil.getSHA256(filePath));
        }
        return false;
    }
}

