/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    private static final String UTF8_STRING = "UTF8_STRING";
    private static final String STRING = "STRING";
    private static final int COMPOUND_TEXT_ID = TextTransfer.registerType("COMPOUND_TEXT");
    private static final int UTF8_STRING_ID = TextTransfer.registerType("UTF8_STRING");
    private static final int STRING_ID = TextTransfer.registerType("STRING");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (transferData.type == (long)COMPOUND_TEXT_ID) {
            long[] lArray = new long[1];
            int[] nArray = new int[1];
            long[] lArray2 = new long[1];
            int[] nArray2 = new int[1];
            boolean bl = OS.gdk_utf8_to_compound_text(byArray, lArray, nArray, lArray2, nArray2);
            if (!bl) {
                return;
            }
            transferData.type = lArray[0];
            transferData.format = nArray[0];
            transferData.length = nArray2[0];
            transferData.pValue = lArray2[0];
            transferData.result = 1;
        }
        if (transferData.type == (long)UTF8_STRING_ID) {
            long l = OS.g_malloc(byArray.length);
            if (l == 0L) {
                return;
            }
            OS.memmove(l, byArray, (long)byArray.length);
            transferData.type = UTF8_STRING_ID;
            transferData.format = 8;
            transferData.length = byArray.length - 1;
            transferData.pValue = l;
            transferData.result = 1;
        }
        if (transferData.type == (long)STRING_ID) {
            long l = OS.gdk_utf8_to_string_target(byArray);
            if (l == 0L) {
                return;
            }
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = OS.strlen(l);
            transferData.pValue = l;
            transferData.result = 1;
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        long[] lArray = new long[1];
        int n = OS.gdk_text_property_to_utf8_list_for_display(OS.gdk_display_get_default(), transferData.type, transferData.format, transferData.pValue, transferData.length, lArray);
        if (n == 0) {
            return null;
        }
        long[] lArray2 = new long[1];
        OS.memmove(lArray2, lArray[0], (long)OS.PTR_SIZEOF);
        int n2 = OS.strlen(lArray2[0]);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, lArray2[0], (long)n2);
        OS.g_strfreev(lArray[0]);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        String string = new String(cArray);
        int n3 = string.indexOf(0);
        return n3 == -1 ? string : string.substring(0, n3);
    }

    protected int[] getTypeIds() {
        return new int[]{UTF8_STRING_ID, COMPOUND_TEXT_ID, STRING_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{UTF8_STRING, COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

