/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.packagemanager.exception.ui;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.ProgressLog;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.packagemanager.exception.ui.TroubleColumnLabelProvider;
import org.tizen.packagemanager.exception.ui.TroubleSearchFilter;
import org.tizen.packagemanager.exception.ui.TroubleTableContentProvider;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;

public class InsideTroubleShootingDialog
extends Dialog {
    private static final int COL_TROUBLE_WIDTH = 400;
    private WizardUIResourceHandler uiRsrcHandler;
    private StackLayout stackLayout;
    private Composite mainComposites;
    private Composite troubleShootingComposites;
    private StyledText textTroubleMessage;
    private StyledText textCauseMessage;
    private StyledText textActionMessage;
    private StyledText textLog;
    private Button btnDetail;
    private Button btnBack;
    private Composite troubleListComposites;
    private Text textTroubleFilter;
    private TableViewer troubleTableViewer;
    private Color oddRowColor;
    private Color errorColor;
    private Image imgExpandedDetail;
    private Image imgCollapsedDetail;
    private Image imgBackButton;
    private Exception exception = null;
    private ArrayList<ProgressLog> progressLogs = null;
    private ArrayList<ProgressLog.LogType> progressTypes = null;
    private boolean hasTroubleList = false;
    private Image imgSearchIcon;
    private boolean isRetry = false;

    public static void open(Shell parentShell) {
        new InsideTroubleShootingDialog(parentShell).open();
    }

    public static void open(Shell parentShell, Exception e) {
        new InsideTroubleShootingDialog(parentShell, e).open();
    }

    public static void open(Shell parentShell, Exception e, ArrayList<ProgressLog> logs) {
        new InsideTroubleShootingDialog(parentShell, e, logs).open();
    }

    public static int open(Shell parentShell, Exception e, boolean isRetry) {
        return new InsideTroubleShootingDialog(parentShell, e, isRetry).open();
    }

    private InsideTroubleShootingDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67616);
        this.uiRsrcHandler = WizardUIResourceHandler.getInstance();
        this.oddRowColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_ODD_TREE_ROW);
        this.errorColor = this.uiRsrcHandler.getColor(WizardUIResourceHandler.UIColor.COLOR_ERROR_LOG);
        this.imgExpandedDetail = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_TITLE_TREE_EXPANDED);
        this.imgCollapsedDetail = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_TITLE_TREE_CLOSED);
        this.imgBackButton = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_BACK);
        this.imgSearchIcon = this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIIcon.ICON_SEARCH);
        this.hasTroubleList = true;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception) {
        this(parentShell);
        this.exception = exception;
        this.hasTroubleList = false;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception, boolean isRetry) {
        this(parentShell);
        this.exception = exception;
        this.hasTroubleList = false;
        this.isRetry = isRetry;
    }

    private InsideTroubleShootingDialog(Shell parentShell, Exception exception, ArrayList<ProgressLog> logs) {
        this(parentShell, exception);
        this.progressLogs = logs;
        this.progressTypes = new ArrayList();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.mainComposites = (Composite)super.createDialogArea(parent);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.mainComposites.setLayout(this.stackLayout);
        if (this.exception != null) {
            this.createTroubleShootingComposites(this.mainComposites);
        }
        if (this.hasTroubleList) {
            this.createTroubleListComposites(this.mainComposites);
        }
        this.stackLayout.topControl = this.exception != null ? this.troubleShootingComposites : this.troubleListComposites;
        return this.mainComposites;
    }

    private void createTroubleShootingComposites(Composite parent) {
        if (this.troubleShootingComposites != null) {
            this.troubleShootingComposites.dispose();
        }
        this.troubleShootingComposites = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 8;
        gridLayout.marginRight = 8;
        gridLayout.marginBottom = 8;
        this.troubleShootingComposites.setLayout(gridLayout);
        this.createMessageComposites(this.troubleShootingComposites);
        this.createButtonComposites(this.troubleShootingComposites);
        this.createLogViewer(this.troubleShootingComposites);
    }

    private void createMessageComposites(Composite parent) {
        String actionMsg;
        this.createTroubleMessageArea(parent, this.exception.getMessage());
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 528);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 426;
        gd.heightHint = 124;
        scrolledComposite.setLayoutData(gd);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite container = new Composite(scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        container.setLayout(gridLayout);
        container.setBackground(Display.getDefault().getSystemColor(1));
        parent.setRedraw(false);
        String causeMsg = this.getCauseMessage(this.exception);
        if (!causeMsg.isEmpty()) {
            this.createCauseMessageArea(container, causeMsg);
        }
        if (!(actionMsg = this.getActionMessage(this.exception)).isEmpty()) {
            this.createActionMessageArea(container, actionMsg);
        }
        scrolledComposite.setContent(container);
        container.setSize(container.computeSize(-1, -1));
        scrolledComposite.setMinSize(container.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    private void createTroubleMessageArea(Composite parent, String message) {
        Composite container = new Composite(parent, 16384);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        gd.heightHint = 48;
        container.setLayoutData(gd);
        container.setBackground(this.uiRsrcHandler.getBackGroundColor());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        container.setLayout(gridLayout);
        Label errorImageLabel = new Label(container, 0);
        gd = new GridData(16384, 128, false, false);
        gd.widthHint = 44;
        gd.heightHint = 44;
        errorImageLabel.setLayoutData(gd);
        if (this.exception != null && this.exception instanceof UMException && ((UMException)this.exception).isCancelException()) {
            errorImageLabel.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_CANCELLED));
        } else {
            errorImageLabel.setImage(this.uiRsrcHandler.getImage(WizardUIResourceHandler.UIImage.IMAGE_FAIL));
        }
        this.textTroubleMessage = new StyledText(container, 16448);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 382;
        this.textTroubleMessage.setLayoutData(gd);
        this.textTroubleMessage.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.textTroubleMessage.setEditable(false);
        this.textTroubleMessage.setEnabled(false);
        this.textTroubleMessage.setBackground(this.uiRsrcHandler.getBackGroundColor());
        this.textTroubleMessage.setText(this.exception.getMessage());
    }

    private void createCauseMessageArea(Composite container, String causeMsg) {
        Composite outerBox = new Composite(container, 16384);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        gd.heightHint = 23;
        outerBox.setLayoutData(gd);
        outerBox.setBackground(new Color(Display.getDefault(), 221, 237, 255));
        outerBox.setLayout(new GridLayout(1, false));
        StyledText titleText = new StyledText(outerBox, 16384);
        titleText.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        titleText.setText("Cause");
        titleText.setEditable(false);
        titleText.setEnabled(false);
        titleText.setBackground(new Color(Display.getDefault(), 221, 237, 255));
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        titleText.setLayoutData(gd);
        this.textCauseMessage = new StyledText(container, 64);
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 426;
        this.textCauseMessage.setLayoutData(gd);
        this.textCauseMessage.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        this.textCauseMessage.setEditable(false);
        this.textCauseMessage.setEnabled(false);
        this.textCauseMessage.setLineSpacing(16 - this.textCauseMessage.getLineHeight());
        this.textCauseMessage.setText(causeMsg);
    }

    private void createActionMessageArea(Composite container, String actionMsg) {
        Composite outerBox = new Composite(container, 16384);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        gd.heightHint = 23;
        outerBox.setLayoutData(gd);
        outerBox.setBackground(new Color(Display.getDefault(), 221, 237, 255));
        outerBox.setLayout(new GridLayout(1, false));
        StyledText titleText = new StyledText(outerBox, 16384);
        titleText.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        titleText.setText("Action");
        titleText.setEditable(false);
        titleText.setEnabled(false);
        titleText.setBackground(new Color(Display.getDefault(), 221, 237, 255));
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        titleText.setLayoutData(gd);
        this.textActionMessage = new StyledText(container, 64);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 426;
        this.textActionMessage.setLayoutData(gd);
        this.textActionMessage.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        this.textActionMessage.setBackground(new Color(Display.getDefault(), 255, 255, 255));
        this.textActionMessage.setEditable(false);
        this.textActionMessage.setEnabled(false);
        this.textActionMessage.setLineSpacing(16 - this.textActionMessage.getLineHeight());
        this.textActionMessage.setCaret(null);
        this.textActionMessage.setText(actionMsg);
    }

    private String getCauseMessage(Exception err) {
        String msg = "";
        if (err instanceof UMException) {
            if (((UMException)err).getAdditionalMessage() != null) {
                if (!msg.isEmpty()) {
                    msg = msg + "\n";
                }
                msg = msg + "* " + ((UMException)this.exception).getAdditionalMessage();
            }
            if (((UMException)err).getCauseMessage() != null) {
                if (!msg.isEmpty()) {
                    msg = msg + "\n";
                }
                msg = msg + ((UMException)err).getErrorCode().getCauseMessage();
            }
        }
        if (err.getCause() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + err.getCause().getMessage();
        }
        return msg;
    }

    private String getActionMessage(Exception err) {
        String msg = "";
        if (err instanceof UMException && ((UMException)err).getActionMessage() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + ((UMException)err).getActionMessage();
        }
        if (err.getCause() != null && err.getCause() instanceof UMException && ((UMException)err.getCause()).getActionMessage() != null) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + ((UMException)err.getCause()).getActionMessage();
        }
        return msg;
    }

    private void createButtonComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 426;
        gd.heightHint = 23;
        gd.verticalIndent = 10;
        container.setLayoutData(gd);
        int gridCount = 3;
        if (this.isRetry) {
            gridCount = 4;
        }
        GridLayout gridLayout = new GridLayout(gridCount, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        if (this.hasTroubleList) {
            this.createBackButton(container);
        } else {
            this.createDetailButton(container);
        }
        Composite dummy = new Composite(container, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 23;
        dummy.setLayoutData(gd);
        if (this.isRetry) {
            Button btnRetry = new Button(container, 8);
            btnRetry.setText("Retry");
            btnRetry.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
            gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = 90;
            gd.heightHint = 23;
            btnRetry.setLayoutData(gd);
            btnRetry.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    InsideTroubleShootingDialog.this.cancelPressed();
                }
            });
        }
        Button btnClose = new Button(container, 8);
        if (this.isRetry) {
            btnClose.setText("Skip");
        } else {
            btnClose.setText("Close");
        }
        btnClose.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        btnClose.setLayoutData(gd);
        btnClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.okPressed();
            }
        });
    }

    private void createDetailButton(Composite parent) {
        this.btnDetail = new Button(parent, 2);
        this.btnDetail.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        GridData gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        gd.horizontalIndent = 0;
        this.btnDetail.setLayoutData(gd);
        this.btnDetail.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Image targetImage = null;
                targetImage = !InsideTroubleShootingDialog.this.btnDetail.getSelection() ? InsideTroubleShootingDialog.this.imgCollapsedDetail : InsideTroubleShootingDialog.this.imgExpandedDetail;
                int imgOffsetY = (event.height - targetImage.getBounds().height) / 2;
                event.gc.drawImage(targetImage, event.x + 8, event.y + imgOffsetY);
                int textOffsetX = 24 + (66 - event.gc.textExtent((String)"Detail").x) / 2;
                int textOffsetY = (event.height - event.gc.textExtent((String)"Detail").y) / 2;
                event.gc.drawText("Detail", event.x + textOffsetX, event.y + textOffsetY, true);
            }
        });
        this.btnDetail.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (InsideTroubleShootingDialog.this.btnDetail.getSelection()) {
                    GridData gd = new GridData(4, 4, true, false);
                    gd.widthHint = 426;
                    gd.heightHint = 176;
                    gd.verticalIndent = 7;
                    InsideTroubleShootingDialog.this.textLog.setLayoutData(gd);
                    InsideTroubleShootingDialog.this.textLog.setVisible(true);
                } else {
                    GridData gd = new GridData(4, 4, true, false);
                    gd.widthHint = 426;
                    gd.heightHint = 0;
                    gd.verticalIndent = 0;
                    InsideTroubleShootingDialog.this.textLog.setLayoutData(gd);
                    InsideTroubleShootingDialog.this.textLog.setVisible(false);
                }
                InsideTroubleShootingDialog.this.btnDetail.getParent().getShell().pack();
            }
        });
        if (this.progressLogs == null) {
            this.btnDetail.setVisible(false);
        }
    }

    private void createBackButton(Composite parent) {
        this.btnBack = new Button(parent, 8);
        this.btnBack.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        GridData gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        gd.horizontalIndent = 0;
        this.btnBack.setLayoutData(gd);
        this.btnBack.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Image targetImage = InsideTroubleShootingDialog.this.imgBackButton;
                int imgOffsetY = (event.height - targetImage.getBounds().height) / 2;
                event.gc.drawImage(targetImage, event.x + 8, event.y + imgOffsetY);
                int textOffsetX = 24 + (66 - event.gc.textExtent((String)"Detail").x) / 2;
                int textOffsetY = (event.height - event.gc.textExtent((String)"Detail").y) / 2;
                event.gc.drawText("Back", event.x + textOffsetX, event.y + textOffsetY, true);
            }
        });
        this.btnBack.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.changeToTroubleListView();
            }
        });
    }

    private void createLogViewer(Composite parent) {
        this.textLog = new StyledText(parent, 2624);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 426;
        gd.heightHint = 0;
        gd.verticalIndent = 0;
        this.textLog.setLayoutData(gd);
        this.textLog.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_SMALL));
        this.textLog.addLineBackgroundListener(new LineBackgroundListener(){

            @Override
            public void lineGetBackground(LineBackgroundEvent event) {
                int line = ((StyledText)event.widget).getLineAtOffset(event.lineOffset);
                if (line < InsideTroubleShootingDialog.this.progressTypes.size() && InsideTroubleShootingDialog.this.progressTypes.get(line) == ProgressLog.LogType.ERROR) {
                    event.lineBackground = InsideTroubleShootingDialog.this.errorColor;
                } else if (line % 2 != 0) {
                    event.lineBackground = InsideTroubleShootingDialog.this.oddRowColor;
                }
            }
        });
        this.textLog.setEditable(false);
        this.textLog.setVisible(false);
        this.textLog.setLineSpacing(16 - this.textLog.getLineHeight());
        if (this.progressLogs != null) {
            this.textLog.setText(this.generateCurrentLogString());
        }
    }

    private String generateCurrentLogString() {
        StringBuilder result = new StringBuilder("");
        for (ProgressLog log : this.progressLogs) {
            String msg = log.getMessage();
            ProgressLog.LogType type = log.getType();
            if (msg.contains("\n")) {
                boolean firstMsg = true;
                for (String splitMsg : msg.split("\n")) {
                    if (firstMsg) {
                        result.append(splitMsg).append("\n");
                        this.progressTypes.add(type);
                        firstMsg = false;
                        continue;
                    }
                    result.append("  ").append(splitMsg).append("\n");
                    this.progressTypes.add(type);
                }
                continue;
            }
            result.append(msg).append("\n");
            this.progressTypes.add(type);
        }
        return result.toString();
    }

    private void createTroubleListComposites(Composite parent) {
        this.troubleListComposites = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 6;
        gridLayout.marginLeft = 8;
        gridLayout.marginRight = 8;
        gridLayout.marginBottom = 8;
        this.troubleListComposites.setLayout(gridLayout);
        this.createFilterSearchBar(this.troubleListComposites);
        this.createToubleListTable(this.troubleListComposites);
        this.createCloseButtonComposites(this.troubleListComposites);
    }

    private void createFilterSearchBar(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 426;
        gd.heightHint = 28;
        container.setLayoutData(gd);
        container.setBackground(Display.getDefault().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        Label searchImgLabel = new Label(container, 0);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 30;
        gd.heightHint = 26;
        searchImgLabel.setLayoutData(gd);
        searchImgLabel.setImage(this.imgSearchIcon);
        searchImgLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.textTroubleFilter = new Text(container, 16900);
        gd = new GridData(4, 0x1000000, true, false);
        this.textTroubleFilter.setLayoutData(gd);
        this.textTroubleFilter.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        this.textTroubleFilter.setEditable(true);
        this.textTroubleFilter.setEnabled(true);
        this.textTroubleFilter.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode != 0x1000050 && arg0.keyCode != 13) {
                    InsideTroubleShootingDialog.this.troubleTableViewer.refresh();
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    private void createToubleListTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 426;
        gd.verticalIndent = 6;
        gd.heightHint = 130;
        container.setLayoutData(gd);
        int style = PlatformUtil.isMacOS() ? 68112 : 68112;
        this.troubleTableViewer = new TableViewer(container, style);
        this.troubleTableViewer.setUseHashlookup(true);
        this.troubleTableViewer.setContentProvider(new TroubleTableContentProvider());
        Table table = this.troubleTableViewer.getTable();
        table.setVisible(true);
        table.setEnabled(true);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.setTableColumn(container);
        this.troubleTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ErrorController.ErrorCode selectedError = (ErrorController.ErrorCode)((Object)selection.getFirstElement());
                if (selectedError != null) {
                    InsideTroubleShootingDialog.this.changeToTroubleShootingView(selectedError);
                }
            }
        });
        this.troubleTableViewer.addFilter(new TroubleSearchFilter(this.textTroubleFilter));
        ArrayList<ErrorController.ErrorCode> input = new ArrayList<ErrorController.ErrorCode>();
        for (ErrorController.ErrorCode err : ErrorController.ErrorCode.values()) {
            if (!err.isTroubleShootingCategory()) continue;
            input.add(err);
        }
        this.troubleTableViewer.setInput(input);
    }

    private void setTableColumn(Composite parent) {
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableViewerColumn troubleClmn = new TableViewerColumn(this.troubleTableViewer, 16384);
        troubleClmn.setLabelProvider(new TroubleColumnLabelProvider());
        troubleClmn.getColumn().setWidth(400);
        columnLayout.setColumnData(troubleClmn.getColumn(), new ColumnWeightData(100, 400));
        parent.setLayout(columnLayout);
    }

    private void createCloseButtonComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = 426;
        gd.heightHint = 23;
        gd.verticalIndent = 10;
        container.setLayoutData(gd);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        container.setLayout(gridLayout);
        Composite dummy = new Composite(container, 0);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 23;
        dummy.setLayoutData(gd);
        Button btnClose = new Button(container, 8);
        btnClose.setText("Close");
        btnClose.setFont(this.uiRsrcHandler.getFont(WizardUIResourceHandler.UIFont.FONT_SIZE_MIDDLE));
        gd = new GridData(4, 0x1000000, false, true);
        gd.widthHint = 90;
        gd.heightHint = 23;
        btnClose.setLayoutData(gd);
        btnClose.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                InsideTroubleShootingDialog.this.okPressed();
            }
        });
    }

    protected void changeToTroubleShootingView(ErrorController.ErrorCode selectedError) {
        this.exception = new UMException(selectedError);
        this.createTroubleShootingComposites(this.mainComposites);
        this.stackLayout.topControl = this.troubleShootingComposites;
        this.mainComposites.layout();
    }

    protected void changeToTroubleListView() {
        this.stackLayout.topControl = this.troubleListComposites;
        this.mainComposites.layout();
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Inside Trouble Shooting");
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

